package
	Schema::ResultSet; # Hide from PAUSE. This is just an example.

use strict;
use warnings;

use base 'DBIx::Class::ResultSet';



# TODO: DENY data access by default
# Descendants will override this with their own condition(s)
# Guard should restrict &create/&update to not create/update not owned data:
# create({ user_id => $another_user, name => ... }) -- here we create something for different user
# update({ user_id => $another_user })              -- our data is owned by different user
sub guard { return shift }



sub internal_columns { return {} }

1;

=encoding utf8

=head1 NAME

Schema::ResultSet - Example base class for DBIx::Class resultsets

=head1 DESCRIPTION

This module is an example base class for resultsets in the shipped example
schema.

It is designed to be overridden by real applications.

=head1 METHODS

=head2 guard

  my $rs = $rs->guard($context);

In this distribution, C<guard> returns the resultset unchanged.

Applications may override it to apply authorization filters based on the given
context (for example, a controller object).

The L<D> helpers call C<guard> when operating in secure mode.

=head2 internal_columns

  my $hashref = $rs->internal_columns;

Return a hashref of column names that should be treated as internal. This is
used by L<D/columns_info> to exclude columns from returned metadata.

=head1 SEE ALSO

L<DBIx::Class::ResultSet>, L<Schema::Result>, L<D>

=cut
