package OpenGL::Modern;

use strict;
use warnings;
use Carp;

use Exporter 'import';

use OpenGL::Modern::Const;

our $VERSION    = '0.0402';
our $XS_VERSION = $VERSION; # capture before strip, as EUMM reads statically in setting version for .xs file
$VERSION =~ tr/_//d;

# OGLM INSERT SEPARATOR
# BEGIN code generated by utils/generate-registry.pl
our @gl_functionscompat = qw(
  glAccum
  glActiveTexture
  glAlphaFunc
  glAreTexturesResident_c
  glAreTexturesResident_p
  glArrayElement
  glAttachShader
  glBegin
  glBeginConditionalRender
  glBeginQuery
  glBeginTransformFeedback
  glBindAttribLocation
  glBindBuffer
  glBindBufferBase
  glBindBufferRange
  glBindFragDataLocation
  glBindFramebuffer
  glBindRenderbuffer
  glBindTexture
  glBindVertexArray
  glBitmap
  glBlendColor
  glBlendEquation
  glBlendEquationSeparate
  glBlendFunc
  glBlendFuncSeparate
  glBlitFramebuffer
  glBufferData_c
  glBufferSubData_c
  glCallList
  glCallLists_c
  glCheckFramebufferStatus
  glClampColor
  glClear
  glClearAccum
  glClearBufferfi
  glClearBufferfv_c
  glClearBufferfv_p
  glClearBufferiv_c
  glClearBufferiv_p
  glClearBufferuiv_c
  glClearBufferuiv_p
  glClearColor
  glClearDepth
  glClearIndex
  glClearStencil
  glClientActiveTexture
  glClipPlane_c
  glClipPlane_p
  glColor3b
  glColor3bv_c
  glColor3bv_p
  glColor3d
  glColor3dv_c
  glColor3dv_p
  glColor3f
  glColor3fv_c
  glColor3fv_p
  glColor3i
  glColor3iv_c
  glColor3iv_p
  glColor3s
  glColor3sv_c
  glColor3sv_p
  glColor3ub
  glColor3ubv_c
  glColor3ubv_p
  glColor3ui
  glColor3uiv_c
  glColor3uiv_p
  glColor3us
  glColor3usv_c
  glColor3usv_p
  glColor4b
  glColor4bv_c
  glColor4bv_p
  glColor4d
  glColor4dv_c
  glColor4dv_p
  glColor4f
  glColor4fv_c
  glColor4fv_p
  glColor4i
  glColor4iv_c
  glColor4iv_p
  glColor4s
  glColor4sv_c
  glColor4sv_p
  glColor4ub
  glColor4ubv_c
  glColor4ubv_p
  glColor4ui
  glColor4uiv_c
  glColor4uiv_p
  glColor4us
  glColor4usv_c
  glColor4usv_p
  glColorMask
  glColorMaski
  glColorMaterial
  glColorPointer_c
  glCompileShader
  glCompressedTexImage1D_c
  glCompressedTexImage2D_c
  glCompressedTexImage3D_c
  glCompressedTexSubImage1D_c
  glCompressedTexSubImage2D_c
  glCompressedTexSubImage3D_c
  glCopyBufferSubData
  glCopyPixels
  glCopyTexImage1D
  glCopyTexImage2D
  glCopyTexSubImage1D
  glCopyTexSubImage2D
  glCopyTexSubImage3D
  glCreateProgram
  glCreateShader
  glCullFace
  glDeleteBuffers_c
  glDeleteBuffers_p
  glDeleteFramebuffers_c
  glDeleteFramebuffers_p
  glDeleteLists
  glDeleteProgram
  glDeleteQueries_c
  glDeleteQueries_p
  glDeleteRenderbuffers_c
  glDeleteRenderbuffers_p
  glDeleteShader
  glDeleteTextures_c
  glDeleteTextures_p
  glDeleteVertexArrays_c
  glDeleteVertexArrays_p
  glDepthFunc
  glDepthMask
  glDepthRange
  glDetachShader
  glDisable
  glDisableClientState
  glDisableVertexAttribArray
  glDisablei
  glDrawArrays
  glDrawArraysInstanced
  glDrawBuffer
  glDrawBuffers_c
  glDrawBuffers_p
  glDrawElementsInstanced_c
  glDrawElements_c
  glDrawPixels_c
  glDrawRangeElements_c
  glEdgeFlag
  glEdgeFlagPointer_c
  glEdgeFlagv_c
  glEdgeFlagv_p
  glEnable
  glEnableClientState
  glEnableVertexAttribArray
  glEnablei
  glEnd
  glEndConditionalRender
  glEndList
  glEndQuery
  glEndTransformFeedback
  glEvalCoord1d
  glEvalCoord1dv_c
  glEvalCoord1dv_p
  glEvalCoord1f
  glEvalCoord1fv_c
  glEvalCoord1fv_p
  glEvalCoord2d
  glEvalCoord2dv_c
  glEvalCoord2dv_p
  glEvalCoord2f
  glEvalCoord2fv_c
  glEvalCoord2fv_p
  glEvalMesh1
  glEvalMesh2
  glEvalPoint1
  glEvalPoint2
  glFeedbackBuffer_c
  glFeedbackBuffer_p
  glFinish
  glFlush
  glFlushMappedBufferRange
  glFogCoordPointer_c
  glFogCoordd
  glFogCoorddv_c
  glFogCoorddv_p
  glFogCoordf
  glFogCoordfv_c
  glFogCoordfv_p
  glFogf
  glFogfv_c
  glFogfv_p
  glFogi
  glFogiv_c
  glFogiv_p
  glFramebufferRenderbuffer
  glFramebufferTexture1D
  glFramebufferTexture2D
  glFramebufferTexture3D
  glFramebufferTextureLayer
  glFrontFace
  glFrustum
  glGenBuffers_c
  glGenBuffers_p
  glGenFramebuffers_c
  glGenFramebuffers_p
  glGenLists
  glGenQueries_c
  glGenQueries_p
  glGenRenderbuffers_c
  glGenRenderbuffers_p
  glGenTextures_c
  glGenTextures_p
  glGenVertexArrays_c
  glGenVertexArrays_p
  glGenerateMipmap
  glGetActiveAttrib_c
  glGetActiveAttrib_p
  glGetActiveUniformBlockName_c
  glGetActiveUniformBlockName_p
  glGetActiveUniformBlockiv_c
  glGetActiveUniformName_c
  glGetActiveUniformName_p
  glGetActiveUniform_c
  glGetActiveUniform_p
  glGetActiveUniformsiv_c
  glGetActiveUniformsiv_p
  glGetAttachedShaders_c
  glGetAttachedShaders_p
  glGetAttribLocation
  glGetBooleani_v_c
  glGetBooleani_v_p
  glGetBooleanv_c
  glGetBooleanv_p
  glGetBufferParameteriv_c
  glGetBufferParameteriv_p
  glGetBufferPointerv_c
  glGetBufferSubData_c
  glGetClipPlane_c
  glGetClipPlane_p
  glGetCompressedTexImage_c
  glGetDoublev_c
  glGetDoublev_p
  glGetError
  glGetFloatv_c
  glGetFloatv_p
  glGetFragDataLocation
  glGetFramebufferAttachmentParameteriv_c
  glGetFramebufferAttachmentParameteriv_p
  glGetIntegeri_v_c
  glGetIntegeri_v_p
  glGetIntegerv_c
  glGetIntegerv_p
  glGetLightfv_c
  glGetLightfv_p
  glGetLightiv_c
  glGetLightiv_p
  glGetMapdv_c
  glGetMapfv_c
  glGetMapiv_c
  glGetMaterialfv_c
  glGetMaterialfv_p
  glGetMaterialiv_c
  glGetMaterialiv_p
  glGetPixelMapfv_c
  glGetPixelMapuiv_c
  glGetPixelMapusv_c
  glGetPointerv_c
  glGetPolygonStipple_c
  glGetProgramInfoLog_c
  glGetProgramInfoLog_p
  glGetProgramiv_c
  glGetProgramiv_p
  glGetQueryObjectiv_c
  glGetQueryObjectiv_p
  glGetQueryObjectuiv_c
  glGetQueryObjectuiv_p
  glGetQueryiv_c
  glGetQueryiv_p
  glGetRenderbufferParameteriv_c
  glGetRenderbufferParameteriv_p
  glGetShaderInfoLog_c
  glGetShaderInfoLog_p
  glGetShaderSource_c
  glGetShaderSource_p
  glGetShaderiv_c
  glGetShaderiv_p
  glGetString
  glGetTexEnvfv_c
  glGetTexEnvfv_p
  glGetTexEnviv_c
  glGetTexEnviv_p
  glGetTexGendv_c
  glGetTexGendv_p
  glGetTexGenfv_c
  glGetTexGenfv_p
  glGetTexGeniv_c
  glGetTexGeniv_p
  glGetTexImage_c
  glGetTexLevelParameterfv_c
  glGetTexLevelParameterfv_p
  glGetTexLevelParameteriv_c
  glGetTexLevelParameteriv_p
  glGetTexParameterIiv_c
  glGetTexParameterIiv_p
  glGetTexParameterIuiv_c
  glGetTexParameterIuiv_p
  glGetTexParameterfv_c
  glGetTexParameterfv_p
  glGetTexParameteriv_c
  glGetTexParameteriv_p
  glGetTransformFeedbackVarying_c
  glGetTransformFeedbackVarying_p
  glGetUniformBlockIndex
  glGetUniformIndices_c
  glGetUniformIndices_p
  glGetUniformLocation
  glGetUniformfv_c
  glGetUniformiv_c
  glGetUniformuiv_c
  glGetVertexAttribIiv_c
  glGetVertexAttribIiv_p
  glGetVertexAttribIuiv_c
  glGetVertexAttribIuiv_p
  glGetVertexAttribPointerv_c
  glGetVertexAttribdv_c
  glGetVertexAttribdv_p
  glGetVertexAttribfv_c
  glGetVertexAttribfv_p
  glGetVertexAttribiv_c
  glGetVertexAttribiv_p
  glHint
  glIndexMask
  glIndexPointer_c
  glIndexd
  glIndexdv_c
  glIndexdv_p
  glIndexf
  glIndexfv_c
  glIndexfv_p
  glIndexi
  glIndexiv_c
  glIndexiv_p
  glIndexs
  glIndexsv_c
  glIndexsv_p
  glIndexub
  glIndexubv_c
  glIndexubv_p
  glInitNames
  glInterleavedArrays_c
  glIsBuffer
  glIsEnabled
  glIsEnabledi
  glIsFramebuffer
  glIsList
  glIsProgram
  glIsQuery
  glIsRenderbuffer
  glIsShader
  glIsTexture
  glIsVertexArray
  glLightModelf
  glLightModelfv_c
  glLightModelfv_p
  glLightModeli
  glLightModeliv_c
  glLightModeliv_p
  glLightf
  glLightfv_c
  glLightfv_p
  glLighti
  glLightiv_c
  glLightiv_p
  glLineStipple
  glLineWidth
  glLinkProgram
  glListBase
  glLoadIdentity
  glLoadMatrixd_c
  glLoadMatrixd_p
  glLoadMatrixf_c
  glLoadMatrixf_p
  glLoadName
  glLoadTransposeMatrixd_c
  glLoadTransposeMatrixd_p
  glLoadTransposeMatrixf_c
  glLoadTransposeMatrixf_p
  glLogicOp
  glMap1d_c
  glMap1f_c
  glMap2d_c
  glMap2f_c
  glMapBufferRange_c
  glMapBuffer_c
  glMapGrid1d
  glMapGrid1f
  glMapGrid2d
  glMapGrid2f
  glMaterialf
  glMaterialfv_c
  glMaterialfv_p
  glMateriali
  glMaterialiv_c
  glMaterialiv_p
  glMatrixMode
  glMultMatrixd_c
  glMultMatrixd_p
  glMultMatrixf_c
  glMultMatrixf_p
  glMultTransposeMatrixd_c
  glMultTransposeMatrixd_p
  glMultTransposeMatrixf_c
  glMultTransposeMatrixf_p
  glMultiDrawArrays_c
  glMultiDrawArrays_p
  glMultiDrawElements_c
  glMultiTexCoord1d
  glMultiTexCoord1dv_c
  glMultiTexCoord1dv_p
  glMultiTexCoord1f
  glMultiTexCoord1fv_c
  glMultiTexCoord1fv_p
  glMultiTexCoord1i
  glMultiTexCoord1iv_c
  glMultiTexCoord1iv_p
  glMultiTexCoord1s
  glMultiTexCoord1sv_c
  glMultiTexCoord1sv_p
  glMultiTexCoord2d
  glMultiTexCoord2dv_c
  glMultiTexCoord2dv_p
  glMultiTexCoord2f
  glMultiTexCoord2fv_c
  glMultiTexCoord2fv_p
  glMultiTexCoord2i
  glMultiTexCoord2iv_c
  glMultiTexCoord2iv_p
  glMultiTexCoord2s
  glMultiTexCoord2sv_c
  glMultiTexCoord2sv_p
  glMultiTexCoord3d
  glMultiTexCoord3dv_c
  glMultiTexCoord3dv_p
  glMultiTexCoord3f
  glMultiTexCoord3fv_c
  glMultiTexCoord3fv_p
  glMultiTexCoord3i
  glMultiTexCoord3iv_c
  glMultiTexCoord3iv_p
  glMultiTexCoord3s
  glMultiTexCoord3sv_c
  glMultiTexCoord3sv_p
  glMultiTexCoord4d
  glMultiTexCoord4dv_c
  glMultiTexCoord4dv_p
  glMultiTexCoord4f
  glMultiTexCoord4fv_c
  glMultiTexCoord4fv_p
  glMultiTexCoord4i
  glMultiTexCoord4iv_c
  glMultiTexCoord4iv_p
  glMultiTexCoord4s
  glMultiTexCoord4sv_c
  glMultiTexCoord4sv_p
  glNewList
  glNormal3b
  glNormal3bv_c
  glNormal3bv_p
  glNormal3d
  glNormal3dv_c
  glNormal3dv_p
  glNormal3f
  glNormal3fv_c
  glNormal3fv_p
  glNormal3i
  glNormal3iv_c
  glNormal3iv_p
  glNormal3s
  glNormal3sv_c
  glNormal3sv_p
  glNormalPointer_c
  glOrtho
  glPassThrough
  glPixelMapfv_c
  glPixelMapfv_p
  glPixelMapuiv_c
  glPixelMapuiv_p
  glPixelMapusv_c
  glPixelMapusv_p
  glPixelStoref
  glPixelStorei
  glPixelTransferf
  glPixelTransferi
  glPixelZoom
  glPointParameterf
  glPointParameterfv_c
  glPointParameterfv_p
  glPointParameteri
  glPointParameteriv_c
  glPointParameteriv_p
  glPointSize
  glPolygonMode
  glPolygonOffset
  glPolygonStipple
  glPopAttrib
  glPopClientAttrib
  glPopMatrix
  glPopName
  glPrimitiveRestartIndex
  glPrioritizeTextures_c
  glPrioritizeTextures_p
  glPushAttrib
  glPushClientAttrib
  glPushMatrix
  glPushName
  glRasterPos2d
  glRasterPos2dv_c
  glRasterPos2dv_p
  glRasterPos2f
  glRasterPos2fv_c
  glRasterPos2fv_p
  glRasterPos2i
  glRasterPos2iv_c
  glRasterPos2iv_p
  glRasterPos2s
  glRasterPos2sv_c
  glRasterPos2sv_p
  glRasterPos3d
  glRasterPos3dv_c
  glRasterPos3dv_p
  glRasterPos3f
  glRasterPos3fv_c
  glRasterPos3fv_p
  glRasterPos3i
  glRasterPos3iv_c
  glRasterPos3iv_p
  glRasterPos3s
  glRasterPos3sv_c
  glRasterPos3sv_p
  glRasterPos4d
  glRasterPos4dv_c
  glRasterPos4dv_p
  glRasterPos4f
  glRasterPos4fv_c
  glRasterPos4fv_p
  glRasterPos4i
  glRasterPos4iv_c
  glRasterPos4iv_p
  glRasterPos4s
  glRasterPos4sv_c
  glRasterPos4sv_p
  glReadBuffer
  glReadPixels_c
  glRectd
  glRectdv_c
  glRectdv_p
  glRectf
  glRectfv_c
  glRectfv_p
  glRecti
  glRectiv_c
  glRectiv_p
  glRects
  glRectsv_c
  glRectsv_p
  glRenderMode
  glRenderbufferStorage
  glRenderbufferStorageMultisample
  glRotated
  glRotatef
  glSampleCoverage
  glScaled
  glScalef
  glScissor
  glSecondaryColor3b
  glSecondaryColor3bv_c
  glSecondaryColor3bv_p
  glSecondaryColor3d
  glSecondaryColor3dv_c
  glSecondaryColor3dv_p
  glSecondaryColor3f
  glSecondaryColor3fv_c
  glSecondaryColor3fv_p
  glSecondaryColor3i
  glSecondaryColor3iv_c
  glSecondaryColor3iv_p
  glSecondaryColor3s
  glSecondaryColor3sv_c
  glSecondaryColor3sv_p
  glSecondaryColor3ub
  glSecondaryColor3ubv_c
  glSecondaryColor3ubv_p
  glSecondaryColor3ui
  glSecondaryColor3uiv_c
  glSecondaryColor3uiv_p
  glSecondaryColor3us
  glSecondaryColor3usv_c
  glSecondaryColor3usv_p
  glSecondaryColorPointer_c
  glSelectBuffer_c
  glSelectBuffer_p
  glShadeModel
  glShaderSource_c
  glShaderSource_p
  glStencilFunc
  glStencilFuncSeparate
  glStencilMask
  glStencilMaskSeparate
  glStencilOp
  glStencilOpSeparate
  glTexBuffer
  glTexCoord1d
  glTexCoord1dv_c
  glTexCoord1dv_p
  glTexCoord1f
  glTexCoord1fv_c
  glTexCoord1fv_p
  glTexCoord1i
  glTexCoord1iv_c
  glTexCoord1iv_p
  glTexCoord1s
  glTexCoord1sv_c
  glTexCoord1sv_p
  glTexCoord2d
  glTexCoord2dv_c
  glTexCoord2dv_p
  glTexCoord2f
  glTexCoord2fv_c
  glTexCoord2fv_p
  glTexCoord2i
  glTexCoord2iv_c
  glTexCoord2iv_p
  glTexCoord2s
  glTexCoord2sv_c
  glTexCoord2sv_p
  glTexCoord3d
  glTexCoord3dv_c
  glTexCoord3dv_p
  glTexCoord3f
  glTexCoord3fv_c
  glTexCoord3fv_p
  glTexCoord3i
  glTexCoord3iv_c
  glTexCoord3iv_p
  glTexCoord3s
  glTexCoord3sv_c
  glTexCoord3sv_p
  glTexCoord4d
  glTexCoord4dv_c
  glTexCoord4dv_p
  glTexCoord4f
  glTexCoord4fv_c
  glTexCoord4fv_p
  glTexCoord4i
  glTexCoord4iv_c
  glTexCoord4iv_p
  glTexCoord4s
  glTexCoord4sv_c
  glTexCoord4sv_p
  glTexCoordPointer_c
  glTexEnvf
  glTexEnvfv_c
  glTexEnvfv_p
  glTexEnvi
  glTexEnviv_c
  glTexEnviv_p
  glTexGend
  glTexGendv_c
  glTexGendv_p
  glTexGenf
  glTexGenfv_c
  glTexGenfv_p
  glTexGeni
  glTexGeniv_c
  glTexGeniv_p
  glTexImage1D_c
  glTexImage2D_c
  glTexImage3D_c
  glTexParameterIiv_c
  glTexParameterIiv_p
  glTexParameterIuiv_c
  glTexParameterIuiv_p
  glTexParameterf
  glTexParameterfv_c
  glTexParameterfv_p
  glTexParameteri
  glTexParameteriv_c
  glTexParameteriv_p
  glTexSubImage1D_c
  glTexSubImage2D_c
  glTexSubImage3D_c
  glTransformFeedbackVaryings_c
  glTransformFeedbackVaryings_p
  glTranslated
  glTranslatef
  glUniform1f
  glUniform1fv_c
  glUniform1fv_p
  glUniform1i
  glUniform1iv_c
  glUniform1iv_p
  glUniform1ui
  glUniform1uiv_c
  glUniform1uiv_p
  glUniform2f
  glUniform2fv_c
  glUniform2fv_p
  glUniform2i
  glUniform2iv_c
  glUniform2iv_p
  glUniform2ui
  glUniform2uiv_c
  glUniform2uiv_p
  glUniform3f
  glUniform3fv_c
  glUniform3fv_p
  glUniform3i
  glUniform3iv_c
  glUniform3iv_p
  glUniform3ui
  glUniform3uiv_c
  glUniform3uiv_p
  glUniform4f
  glUniform4fv_c
  glUniform4fv_p
  glUniform4i
  glUniform4iv_c
  glUniform4iv_p
  glUniform4ui
  glUniform4uiv_c
  glUniform4uiv_p
  glUniformBlockBinding
  glUniformMatrix2fv_c
  glUniformMatrix2fv_p
  glUniformMatrix2x3fv_c
  glUniformMatrix2x3fv_p
  glUniformMatrix2x4fv_c
  glUniformMatrix2x4fv_p
  glUniformMatrix3fv_c
  glUniformMatrix3fv_p
  glUniformMatrix3x2fv_c
  glUniformMatrix3x2fv_p
  glUniformMatrix3x4fv_c
  glUniformMatrix3x4fv_p
  glUniformMatrix4fv_c
  glUniformMatrix4fv_p
  glUniformMatrix4x2fv_c
  glUniformMatrix4x2fv_p
  glUniformMatrix4x3fv_c
  glUniformMatrix4x3fv_p
  glUnmapBuffer
  glUseProgram
  glValidateProgram
  glVertex2d
  glVertex2dv_c
  glVertex2dv_p
  glVertex2f
  glVertex2fv_c
  glVertex2fv_p
  glVertex2i
  glVertex2iv_c
  glVertex2iv_p
  glVertex2s
  glVertex2sv_c
  glVertex2sv_p
  glVertex3d
  glVertex3dv_c
  glVertex3dv_p
  glVertex3f
  glVertex3fv_c
  glVertex3fv_p
  glVertex3i
  glVertex3iv_c
  glVertex3iv_p
  glVertex3s
  glVertex3sv_c
  glVertex3sv_p
  glVertex4d
  glVertex4dv_c
  glVertex4dv_p
  glVertex4f
  glVertex4fv_c
  glVertex4fv_p
  glVertex4i
  glVertex4iv_c
  glVertex4iv_p
  glVertex4s
  glVertex4sv_c
  glVertex4sv_p
  glVertexAttrib1d
  glVertexAttrib1dv_c
  glVertexAttrib1dv_p
  glVertexAttrib1f
  glVertexAttrib1fv_c
  glVertexAttrib1fv_p
  glVertexAttrib1s
  glVertexAttrib1sv_c
  glVertexAttrib1sv_p
  glVertexAttrib2d
  glVertexAttrib2dv_c
  glVertexAttrib2dv_p
  glVertexAttrib2f
  glVertexAttrib2fv_c
  glVertexAttrib2fv_p
  glVertexAttrib2s
  glVertexAttrib2sv_c
  glVertexAttrib2sv_p
  glVertexAttrib3d
  glVertexAttrib3dv_c
  glVertexAttrib3dv_p
  glVertexAttrib3f
  glVertexAttrib3fv_c
  glVertexAttrib3fv_p
  glVertexAttrib3s
  glVertexAttrib3sv_c
  glVertexAttrib3sv_p
  glVertexAttrib4Nbv_c
  glVertexAttrib4Nbv_p
  glVertexAttrib4Niv_c
  glVertexAttrib4Niv_p
  glVertexAttrib4Nsv_c
  glVertexAttrib4Nsv_p
  glVertexAttrib4Nub
  glVertexAttrib4Nubv_c
  glVertexAttrib4Nubv_p
  glVertexAttrib4Nuiv_c
  glVertexAttrib4Nuiv_p
  glVertexAttrib4Nusv_c
  glVertexAttrib4Nusv_p
  glVertexAttrib4bv_c
  glVertexAttrib4bv_p
  glVertexAttrib4d
  glVertexAttrib4dv_c
  glVertexAttrib4dv_p
  glVertexAttrib4f
  glVertexAttrib4fv_c
  glVertexAttrib4fv_p
  glVertexAttrib4iv_c
  glVertexAttrib4iv_p
  glVertexAttrib4s
  glVertexAttrib4sv_c
  glVertexAttrib4sv_p
  glVertexAttrib4ubv_c
  glVertexAttrib4ubv_p
  glVertexAttrib4uiv_c
  glVertexAttrib4uiv_p
  glVertexAttrib4usv_c
  glVertexAttrib4usv_p
  glVertexAttribI1i
  glVertexAttribI1iv_c
  glVertexAttribI1iv_p
  glVertexAttribI1ui
  glVertexAttribI1uiv_c
  glVertexAttribI1uiv_p
  glVertexAttribI2i
  glVertexAttribI2iv_c
  glVertexAttribI2iv_p
  glVertexAttribI2ui
  glVertexAttribI2uiv_c
  glVertexAttribI2uiv_p
  glVertexAttribI3i
  glVertexAttribI3iv_c
  glVertexAttribI3iv_p
  glVertexAttribI3ui
  glVertexAttribI3uiv_c
  glVertexAttribI3uiv_p
  glVertexAttribI4bv_c
  glVertexAttribI4bv_p
  glVertexAttribI4i
  glVertexAttribI4iv_c
  glVertexAttribI4iv_p
  glVertexAttribI4sv_c
  glVertexAttribI4sv_p
  glVertexAttribI4ubv_c
  glVertexAttribI4ubv_p
  glVertexAttribI4ui
  glVertexAttribI4uiv_c
  glVertexAttribI4uiv_p
  glVertexAttribI4usv_c
  glVertexAttribI4usv_p
  glVertexAttribIPointer_c
  glVertexAttribPointer_c
  glVertexPointer_c
  glViewport
  glWindowPos2d
  glWindowPos2dv_c
  glWindowPos2dv_p
  glWindowPos2f
  glWindowPos2fv_c
  glWindowPos2fv_p
  glWindowPos2i
  glWindowPos2iv_c
  glWindowPos2iv_p
  glWindowPos2s
  glWindowPos2sv_c
  glWindowPos2sv_p
  glWindowPos3d
  glWindowPos3dv_c
  glWindowPos3dv_p
  glWindowPos3f
  glWindowPos3fv_c
  glWindowPos3fv_p
  glWindowPos3i
  glWindowPos3iv_c
  glWindowPos3iv_p
  glWindowPos3s
  glWindowPos3sv_c
  glWindowPos3sv_p
);
our @gl_functionsrest = qw(
  glAcquireKeyedMutexWin32EXT
  glActiveProgramEXT
  glActiveShaderProgram
  glActiveStencilFaceEXT
  glActiveTextureARB
  glActiveVaryingNV
  glAddressSpace
  glAddSwapHintRectWIN
  glAllocMPEGPredictorsSGIX_c
  glAlphaFragmentOp1ATI
  glAlphaFragmentOp2ATI
  glAlphaFragmentOp3ATI
  glAlphaFuncQCOM
  glAlphaFuncx
  glAlphaToCoverageDitherControlNV
  glApplyFramebufferAttachmentCMAAINTEL
  glApplyTextureEXT
  glAreProgramsResidentNV_c
  glAreProgramsResidentNV_p
  glAreTexturesResidentEXT_c
  glAreTexturesResidentEXT_p
  glAreVertexArraysResidentSGIX_c
  glArrayElementEXT
  glArrayObjectATI
  glAsyncCopyBufferSubDataNVX_c
  glAsyncCopyBufferSubDataNVX_p
  glAsyncCopyImageSubDataNVX_c
  glAsyncCopyImageSubDataNVX_p
  glAsyncMarkerSGIX
  glAttachObjectARB
  glBeginConditionalRenderNV
  glBeginConditionalRenderNVX
  glBeginFragmentShaderATI
  glBeginOcclusionQueryNV
  glBeginPerfMonitorAMD
  glBeginPerfQueryINTEL
  glBeginQueryANGLE
  glBeginQueryARB
  glBeginQueryEXT
  glBeginQueryIndexed
  glBeginSceneEXT
  glBeginTransformFeedbackEXT
  glBeginTransformFeedbackNV
  glBeginVertexShaderEXT
  glBeginVideoCaptureNV
  glBindArraySetEXT_c
  glBindAttribLocationARB
  glBindBufferARB
  glBindBufferBaseEXT
  glBindBufferBaseNV
  glBindBufferOffsetEXT
  glBindBufferOffsetNV
  glBindBufferRangeEXT
  glBindBufferRangeNV
  glBindBuffersBase_c
  glBindBuffersBase_p
  glBindBuffersRange_c
  glBindFragDataLocationEXT
  glBindFragDataLocationIndexed
  glBindFragDataLocationIndexedEXT
  glBindFragmentShaderATI
  glBindFramebufferEXT
  glBindFramebufferOES
  glBindImageTexture
  glBindImageTextureEXT
  glBindImageTextures_c
  glBindImageTextures_p
  glBindLightParameterEXT
  glBindMaterialParameterEXT
  glBindMultiTextureEXT
  glBindParameterEXT
  glBindProgramARB
  glBindProgramNV
  glBindProgramPipeline
  glBindRenderbufferEXT
  glBindRenderbufferOES
  glBindSampler
  glBindSamplers_c
  glBindSamplers_p
  glBindShadingRateImageNV
  glBindTexGenParameterEXT
  glBindTextureEXT
  glBindTextures_c
  glBindTextures_p
  glBindTextureUnit
  glBindTextureUnitParameterEXT
  glBindTransformFeedback
  glBindTransformFeedbackNV
  glBindVertexArrayAPPLE
  glBindVertexArrayOES
  glBindVertexArraySGIX
  glBindVertexBuffer
  glBindVertexBuffers_c
  glBindVertexShaderEXT
  glBindVideoCaptureStreamBufferNV
  glBindVideoCaptureStreamTextureNV
  glBinormalPointerEXT_c
  glBlendBarrier
  glBlendBarrierKHR
  glBlendBarrierNV
  glBlendColorEXT
  glBlendEquationEXT
  glBlendEquationi
  glBlendEquationiARB
  glBlendEquationiEXT
  glBlendEquationIndexedAMD
  glBlendEquationiOES
  glBlendEquationOES
  glBlendEquationSeparateEXT
  glBlendEquationSeparatei
  glBlendEquationSeparateiARB
  glBlendEquationSeparateiEXT
  glBlendEquationSeparateIndexedAMD
  glBlendEquationSeparateiOES
  glBlendEquationSeparateOES
  glBlendFunci
  glBlendFunciARB
  glBlendFunciEXT
  glBlendFuncIndexedAMD
  glBlendFunciOES
  glBlendFuncSeparateEXT
  glBlendFuncSeparatei
  glBlendFuncSeparateiARB
  glBlendFuncSeparateiEXT
  glBlendFuncSeparateIndexedAMD
  glBlendFuncSeparateINGR
  glBlendFuncSeparateiOES
  glBlendFuncSeparateOES
  glBlendParameteriNV
  glBlitFramebufferANGLE
  glBlitFramebufferEXT
  glBlitFramebufferLayerEXT
  glBlitFramebufferLayersEXT
  glBlitFramebufferNV
  glBlitNamedFramebuffer
  glBufferAddressRangeNV
  glBufferAttachMemoryNV
  glBufferDataARB_c
  glBufferPageCommitmentARB
  glBufferPageCommitmentMemNV
  glBufferParameteriAPPLE
  glBufferRegionEnabled
  glBufferStorageExternalEXT
  glBufferStorageEXT_c
  glBufferStorageMemEXT
  glBufferStorage_c
  glBufferSubDataARB_c
  glCallCommandListNV
  glCheckFramebufferStatusEXT
  glCheckFramebufferStatusOES
  glCheckNamedFramebufferStatus
  glCheckNamedFramebufferStatusEXT
  glClampColorARB
  glClearBufferData_c
  glClearBufferSubData_c
  glClearColorIiEXT
  glClearColorIuiEXT
  glClearColorx
  glClearDepthdNV
  glClearDepthf
  glClearDepthfOES
  glClearDepthx
  glClearNamedBufferDataEXT_c
  glClearNamedBufferData_c
  glClearNamedBufferSubDataEXT_c
  glClearNamedBufferSubData_c
  glClearNamedFramebufferfi
  glClearNamedFramebufferfv_c
  glClearNamedFramebufferfv_p
  glClearNamedFramebufferiv_c
  glClearNamedFramebufferiv_p
  glClearNamedFramebufferuiv_c
  glClearNamedFramebufferuiv_p
  glClearPixelLocalStorageuiEXT_c
  glClearPixelLocalStorageuiEXT_p
  glClearTexImageEXT_c
  glClearTexImage_c
  glClearTexSubImageEXT_c
  glClearTexSubImage_c
  glClientActiveTextureARB
  glClientActiveVertexStreamATI
  glClientAttribDefaultEXT
  glClientWaitSemaphoreui64NVX_c
  glClientWaitSemaphoreui64NVX_p
  glClientWaitSync
  glClientWaitSyncAPPLE
  glClipControl
  glClipControlEXT
  glClipPlanefOES_c
  glClipPlanef_c
  glClipPlanef_p
  glClipPlanex_c
  glClipPlanex_p
  glColor3fVertex3fSUN
  glColor3fVertex3fvSUN_c
  glColor3fVertex3fvSUN_p
  glColor3hNV
  glColor3hvNV_c
  glColor3hvNV_p
  glColor4fNormal3fVertex3fSUN
  glColor4fNormal3fVertex3fvSUN_c
  glColor4fNormal3fVertex3fvSUN_p
  glColor4hNV
  glColor4hvNV_c
  glColor4hvNV_p
  glColor4ubVertex2fSUN
  glColor4ubVertex2fvSUN_c
  glColor4ubVertex2fvSUN_p
  glColor4ubVertex3fSUN
  glColor4ubVertex3fvSUN_c
  glColor4ubVertex3fvSUN_p
  glColor4x
  glColorFormatNV
  glColorFragmentOp1ATI
  glColorFragmentOp2ATI
  glColorFragmentOp3ATI
  glColorMaskiEXT
  glColorMaskIndexedEXT
  glColorMaskiOES
  glColorP3ui
  glColorP3uiv_c
  glColorP3uiv_p
  glColorP4ui
  glColorP4uiv_c
  glColorP4uiv_p
  glColorPointerEXT_c
  glColorPointerListIBM_c
  glColorPointervINTEL_c
  glColorSubTableEXT_c
  glColorSubTable_c
  glColorTableEXT_c
  glColorTableParameterfvSGI_c
  glColorTableParameterfvSGI_p
  glColorTableParameterfv_c
  glColorTableParameterfv_p
  glColorTableParameterivSGI_c
  glColorTableParameterivSGI_p
  glColorTableParameteriv_c
  glColorTableParameteriv_p
  glColorTableSGI_c
  glColorTable_c
  glCombinerInputNV
  glCombinerOutputNV
  glCombinerParameterfNV
  glCombinerParameterfvNV_c
  glCombinerParameteriNV
  glCombinerParameterivNV_c
  glCombinerStageParameterfvNV_c
  glCommandListSegmentsNV
  glCompileCommandListNV
  glCompileShaderARB
  glCompileShaderIncludeARB_c
  glCompileShaderIncludeARB_p
  glCompressedMultiTexImage1DEXT_c
  glCompressedMultiTexImage2DEXT_c
  glCompressedMultiTexImage3DEXT_c
  glCompressedMultiTexSubImage1DEXT_c
  glCompressedMultiTexSubImage2DEXT_c
  glCompressedMultiTexSubImage3DEXT_c
  glCompressedTexImage1DARB_c
  glCompressedTexImage2DARB_c
  glCompressedTexImage3DARB_c
  glCompressedTexImage3DNV_c
  glCompressedTexImage3DOES_c
  glCompressedTexSubImage1DARB_c
  glCompressedTexSubImage2DARB_c
  glCompressedTexSubImage3DARB_c
  glCompressedTexSubImage3DNV_c
  glCompressedTexSubImage3DOES_c
  glCompressedTextureImage1DEXT_c
  glCompressedTextureImage2DEXT_c
  glCompressedTextureImage3DEXT_c
  glCompressedTextureSubImage1DEXT_c
  glCompressedTextureSubImage1D_c
  glCompressedTextureSubImage2DEXT_c
  glCompressedTextureSubImage2D_c
  glCompressedTextureSubImage3DEXT_c
  glCompressedTextureSubImage3D_c
  glConservativeRasterParameterfNV
  glConservativeRasterParameteriNV
  glConvolutionFilter1DEXT_c
  glConvolutionFilter1D_c
  glConvolutionFilter2DEXT_c
  glConvolutionFilter2D_c
  glConvolutionParameterf
  glConvolutionParameterfEXT
  glConvolutionParameterfvEXT_c
  glConvolutionParameterfvEXT_p
  glConvolutionParameterfv_c
  glConvolutionParameterfv_p
  glConvolutionParameteri
  glConvolutionParameteriEXT
  glConvolutionParameterivEXT_c
  glConvolutionParameterivEXT_p
  glConvolutionParameteriv_c
  glConvolutionParameteriv_p
  glCopyBufferSubDataNV
  glCopyColorSubTable
  glCopyColorSubTableEXT
  glCopyColorTable
  glCopyColorTableSGI
  glCopyConvolutionFilter1D
  glCopyConvolutionFilter1DEXT
  glCopyConvolutionFilter2D
  glCopyConvolutionFilter2DEXT
  glCopyImageSubData
  glCopyImageSubDataEXT
  glCopyImageSubDataNV
  glCopyImageSubDataOES
  glCopyMultiTexImage1DEXT
  glCopyMultiTexImage2DEXT
  glCopyMultiTexSubImage1DEXT
  glCopyMultiTexSubImage2DEXT
  glCopyMultiTexSubImage3DEXT
  glCopyNamedBufferSubData
  glCopyPathNV
  glCopyTexImage1DEXT
  glCopyTexImage2DEXT
  glCopyTexSubImage1DEXT
  glCopyTexSubImage2DEXT
  glCopyTexSubImage3DEXT
  glCopyTexSubImage3DNV
  glCopyTexSubImage3DOES
  glCopyTextureImage1DEXT
  glCopyTextureImage2DEXT
  glCopyTextureLevelsAPPLE
  glCopyTextureSubImage1D
  glCopyTextureSubImage1DEXT
  glCopyTextureSubImage2D
  glCopyTextureSubImage2DEXT
  glCopyTextureSubImage3D
  glCopyTextureSubImage3DEXT
  glCoverageModulationNV
  glCoverageModulationTableNV_c
  glCoverageModulationTableNV_p
  glCoverFillPathInstancedNV_c
  glCoverFillPathNV
  glCoverStrokePathInstancedNV_c
  glCoverStrokePathNV
  glCreateBuffers_c
  glCreateBuffers_p
  glCreateCommandListsNV_c
  glCreateCommandListsNV_p
  glCreateFramebuffers_c
  glCreateFramebuffers_p
  glCreateMemoryObjectsEXT_c
  glCreatePerfQueryINTEL_c
  glCreateProgramObjectARB
  glCreateProgramPipelines_c
  glCreateProgramPipelines_p
  glCreateProgressFenceNVX
  glCreateQueries_c
  glCreateQueries_p
  glCreateRenderbuffers_c
  glCreateRenderbuffers_p
  glCreateSamplers_c
  glCreateSamplers_p
  glCreateSemaphoresNV_c
  glCreateSemaphoresNV_p
  glCreateShaderObjectARB
  glCreateShaderProgramEXT
  glCreateShaderProgramv_c
  glCreateShaderProgramv_p
  glCreateStatesNV_c
  glCreateStatesNV_p
  glCreateSyncFromCLeventARB
  glCreateTextures_c
  glCreateTextures_p
  glCreateTransformFeedbacks_c
  glCreateTransformFeedbacks_p
  glCreateVertexArrays_c
  glCreateVertexArrays_p
  glCullParameterdvEXT_c
  glCullParameterdvEXT_p
  glCullParameterfvEXT_c
  glCullParameterfvEXT_p
  glCurrentPaletteMatrixARB
  glCurrentPaletteMatrixOES
  glDataPipe
  glDebugMessageCallbackAMD_c
  glDebugMessageCallbackARB_c
  glDebugMessageCallbackKHR_c
  glDebugMessageCallback_c
  glDebugMessageControlARB_c
  glDebugMessageControlARB_p
  glDebugMessageControlKHR_c
  glDebugMessageControlKHR_p
  glDebugMessageControl_c
  glDebugMessageControl_p
  glDebugMessageEnableAMD_c
  glDebugMessageEnableAMD_p
  glDebugMessageInsert
  glDebugMessageInsertAMD
  glDebugMessageInsertARB
  glDebugMessageInsertKHR
  glDeformSGIX
  glDeleteArraySetsEXT_c
  glDeleteAsyncMarkersSGIX
  glDeleteBufferRegion
  glDeleteBuffersARB_c
  glDeleteBuffersARB_p
  glDeleteCommandListsNV_c
  glDeleteCommandListsNV_p
  glDeleteFencesAPPLE_c
  glDeleteFencesAPPLE_p
  glDeleteFencesNV_c
  glDeleteFencesNV_p
  glDeleteFragmentShaderATI
  glDeleteFramebuffersEXT_c
  glDeleteFramebuffersEXT_p
  glDeleteFramebuffersOES_c
  glDeleteMemoryObjectsEXT_c
  glDeleteMemoryObjectsEXT_p
  glDeleteMPEGPredictorsSGIX_c
  glDeleteNamedStringARB
  glDeleteNamesAMD_c
  glDeleteNamesAMD_p
  glDeleteObjectARB
  glDeleteOcclusionQueriesNV_c
  glDeleteOcclusionQueriesNV_p
  glDeletePathsNV
  glDeletePerfMonitorsAMD_c
  glDeletePerfMonitorsAMD_p
  glDeletePerfQueryINTEL
  glDeleteProgramPipelines_c
  glDeleteProgramPipelines_p
  glDeleteProgramsARB_c
  glDeleteProgramsARB_p
  glDeleteProgramsNV_c
  glDeleteProgramsNV_p
  glDeleteQueriesANGLE_c
  glDeleteQueriesARB_c
  glDeleteQueriesARB_p
  glDeleteQueriesEXT_c
  glDeleteQueriesEXT_p
  glDeleteRenderbuffersEXT_c
  glDeleteRenderbuffersEXT_p
  glDeleteRenderbuffersOES_c
  glDeleteSamplers_c
  glDeleteSamplers_p
  glDeleteSemaphoresEXT_c
  glDeleteSemaphoresEXT_p
  glDeleteStatesNV_c
  glDeleteStatesNV_p
  glDeleteSync
  glDeleteSyncAPPLE
  glDeleteTexturesEXT_c
  glDeleteTexturesEXT_p
  glDeleteTransformFeedbacksNV_c
  glDeleteTransformFeedbacksNV_p
  glDeleteTransformFeedbacks_c
  glDeleteTransformFeedbacks_p
  glDeleteVertexArraysAPPLE_c
  glDeleteVertexArraysAPPLE_p
  glDeleteVertexArraysOES_c
  glDeleteVertexArraysSGIX_c
  glDeleteVertexShaderEXT
  glDepthBoundsdNV
  glDepthBoundsEXT
  glDepthRangeArrayfvNV_c
  glDepthRangeArrayv_c
  glDepthRangeArrayv_p
  glDepthRangedNV
  glDepthRangef
  glDepthRangefOES
  glDepthRangeIndexed
  glDepthRangeIndexedfNV
  glDepthRangex
  glDetachObjectARB
  glDetailTexFuncSGIS_c
  glDetailTexFuncSGIS_p
  glDisableClientStateiEXT
  glDisableClientStateIndexedEXT
  glDisableDriverControlQCOM
  glDisableiEXT
  glDisableIndexedEXT
  glDisableiNV
  glDisableiOES
  glDisableVariantClientStateEXT
  glDisableVertexArrayAttrib
  glDisableVertexArrayAttribEXT
  glDisableVertexArrayEXT
  glDisableVertexAttribAPPLE
  glDisableVertexAttribArrayARB
  glDiscardFramebufferEXT_c
  glDiscardFramebufferEXT_p
  glDispatchCompute
  glDispatchComputeGroupSizeARB
  glDispatchComputeIndirect
  glDrawArraysEXT
  glDrawArraysIndirect_c
  glDrawArraysInstancedANGLE
  glDrawArraysInstancedARB
  glDrawArraysInstancedBaseInstance
  glDrawArraysInstancedBaseInstanceEXT
  glDrawArraysInstancedEXT
  glDrawArraysInstancedNV
  glDrawBufferRegion
  glDrawBuffersARB_c
  glDrawBuffersARB_p
  glDrawBuffersATI_c
  glDrawBuffersATI_p
  glDrawBuffersEXT_c
  glDrawBuffersEXT_p
  glDrawBuffersIndexedEXT_c
  glDrawBuffersIndexedEXT_p
  glDrawBuffersNV_c
  glDrawBuffersNV_p
  glDrawCommandsAddressNV_c
  glDrawCommandsNV_c
  glDrawCommandsStatesAddressNV_c
  glDrawCommandsStatesNV_c
  glDrawElementArrayAPPLE
  glDrawElementArrayATI
  glDrawElementsBaseVertexEXT_c
  glDrawElementsBaseVertex_c
  glDrawElementsIndirect_c
  glDrawElementsInstancedANGLE_c
  glDrawElementsInstancedARB_c
  glDrawElementsInstancedBaseInstanceEXT_c
  glDrawElementsInstancedBaseInstance_c
  glDrawElementsInstancedBaseVertexBaseInstanceEXT_c
  glDrawElementsInstancedBaseVertexBaseInstance_c
  glDrawElementsInstancedBaseVertexEXT_c
  glDrawElementsInstancedBaseVertex_c
  glDrawElementsInstancedEXT_c
  glDrawElementsInstancedNV_c
  glDrawMeshTasksEXT
  glDrawMeshTasksIndirectEXT
  glDrawMeshTasksIndirectNV
  glDrawMeshTasksNV
  glDrawRangeElementArrayAPPLE
  glDrawRangeElementArrayATI
  glDrawRangeElementsBaseVertexEXT_c
  glDrawRangeElementsBaseVertex_c
  glDrawRangeElementsEXT_c
  glDrawTextureNV
  glDrawTransformFeedback
  glDrawTransformFeedbackEXT
  glDrawTransformFeedbackInstanced
  glDrawTransformFeedbackInstancedEXT
  glDrawTransformFeedbackNV
  glDrawTransformFeedbackStream
  glDrawTransformFeedbackStreamInstanced
  glDrawVkImageNV
  glEdgeFlagFormatNV
  glEdgeFlagPointerEXT_c
  glEdgeFlagPointerListIBM_c
  glEGLImageTargetRenderbufferStorageOES
  glEGLImageTargetTexStorageEXT_c
  glEGLImageTargetTexture2DOES
  glEGLImageTargetTextureStorageEXT_c
  glElementPointerAPPLE_c
  glElementPointerATI_c
  glEnableClientStateiEXT
  glEnableClientStateIndexedEXT
  glEnableDriverControlQCOM
  glEnableiEXT
  glEnableIndexedEXT
  glEnableiNV
  glEnableiOES
  glEnableVariantClientStateEXT
  glEnableVertexArrayAttrib
  glEnableVertexArrayAttribEXT
  glEnableVertexArrayEXT
  glEnableVertexAttribAPPLE
  glEnableVertexAttribArrayARB
  glEndConditionalRenderNV
  glEndConditionalRenderNVX
  glEndFragmentShaderATI
  glEndOcclusionQueryNV
  glEndPerfMonitorAMD
  glEndPerfQueryINTEL
  glEndQueryANGLE
  glEndQueryARB
  glEndQueryEXT
  glEndQueryIndexed
  glEndSceneEXT
  glEndTilingQCOM
  glEndTransformFeedbackEXT
  glEndTransformFeedbackNV
  glEndVertexShaderEXT
  glEndVideoCaptureNV
  glEvalMapsNV
  glEvaluateDepthValuesARB
  GLEW_3DFX_multisample
  GLEW_3DFX_tbuffer
  GLEW_3DFX_texture_compression_FXT1
  GLEW_AMD_blend_minmax_factor
  GLEW_AMD_compressed_3DC_texture
  GLEW_AMD_compressed_ATC_texture
  GLEW_AMD_conservative_depth
  GLEW_AMD_debug_output
  GLEW_AMD_depth_clamp_separate
  GLEW_AMD_draw_buffers_blend
  GLEW_AMD_framebuffer_multisample_advanced
  GLEW_AMD_framebuffer_sample_positions
  GLEW_AMD_gcn_shader
  GLEW_AMD_gpu_shader_half_float
  GLEW_AMD_gpu_shader_half_float_fetch
  GLEW_AMD_gpu_shader_int16
  GLEW_AMD_gpu_shader_int64
  GLEW_AMD_interleaved_elements
  GLEW_AMD_multi_draw_indirect
  GLEW_AMD_name_gen_delete
  GLEW_AMD_occlusion_query_event
  GLEW_AMD_performance_monitor
  GLEW_AMD_pinned_memory
  GLEW_AMD_program_binary_Z400
  GLEW_AMD_query_buffer_object
  GLEW_AMD_sample_positions
  GLEW_AMD_seamless_cubemap_per_texture
  GLEW_AMD_shader_atomic_counter_ops
  GLEW_AMD_shader_ballot
  GLEW_AMD_shader_explicit_vertex_parameter
  GLEW_AMD_shader_image_load_store_lod
  GLEW_AMD_shader_stencil_export
  GLEW_AMD_shader_stencil_value_export
  GLEW_AMD_shader_trinary_minmax
  GLEW_AMD_sparse_texture
  GLEW_AMD_stencil_operation_extended
  GLEW_AMD_texture_gather_bias_lod
  GLEW_AMD_texture_texture4
  GLEW_AMD_transform_feedback3_lines_triangles
  GLEW_AMD_transform_feedback4
  GLEW_AMD_vertex_shader_layer
  GLEW_AMD_vertex_shader_tessellator
  GLEW_AMD_vertex_shader_viewport_index
  GLEW_ANDROID_extension_pack_es31a
  GLEW_ANGLE_depth_texture
  GLEW_ANGLE_framebuffer_blit
  GLEW_ANGLE_framebuffer_multisample
  GLEW_ANGLE_instanced_arrays
  GLEW_ANGLE_pack_reverse_row_order
  GLEW_ANGLE_program_binary
  GLEW_ANGLE_texture_compression_dxt1
  GLEW_ANGLE_texture_compression_dxt3
  GLEW_ANGLE_texture_compression_dxt5
  GLEW_ANGLE_texture_usage
  GLEW_ANGLE_timer_query
  GLEW_ANGLE_translated_shader_source
  GLEW_APPLE_aux_depth_stencil
  GLEW_APPLE_client_storage
  GLEW_APPLE_clip_distance
  GLEW_APPLE_color_buffer_packed_float
  GLEW_APPLE_copy_texture_levels
  GLEW_APPLE_element_array
  GLEW_APPLE_fence
  GLEW_APPLE_float_pixels
  GLEW_APPLE_flush_buffer_range
  GLEW_APPLE_framebuffer_multisample
  GLEW_APPLE_object_purgeable
  GLEW_APPLE_pixel_buffer
  GLEW_APPLE_rgb_422
  GLEW_APPLE_row_bytes
  GLEW_APPLE_specular_vector
  GLEW_APPLE_sync
  GLEW_APPLE_texture_2D_limited_npot
  GLEW_APPLE_texture_format_BGRA8888
  GLEW_APPLE_texture_max_level
  GLEW_APPLE_texture_packed_float
  GLEW_APPLE_texture_range
  GLEW_APPLE_transform_hint
  GLEW_APPLE_vertex_array_object
  GLEW_APPLE_vertex_array_range
  GLEW_APPLE_vertex_program_evaluators
  GLEW_APPLE_ycbcr_422
  GLEW_ARB_arrays_of_arrays
  GLEW_ARB_base_instance
  GLEW_ARB_bindless_texture
  GLEW_ARB_blend_func_extended
  GLEW_ARB_buffer_storage
  GLEW_ARB_clear_buffer_object
  GLEW_ARB_clear_texture
  GLEW_ARB_clip_control
  GLEW_ARB_cl_event
  GLEW_ARB_color_buffer_float
  GLEW_ARB_compatibility
  GLEW_ARB_compressed_texture_pixel_storage
  GLEW_ARB_compute_shader
  GLEW_ARB_compute_variable_group_size
  GLEW_ARB_conditional_render_inverted
  GLEW_ARB_conservative_depth
  GLEW_ARB_copy_buffer
  GLEW_ARB_copy_image
  GLEW_ARB_cull_distance
  GLEW_ARB_debug_output
  GLEW_ARB_depth_buffer_float
  GLEW_ARB_depth_clamp
  GLEW_ARB_depth_texture
  GLEW_ARB_derivative_control
  GLEW_ARB_direct_state_access
  GLEW_ARB_draw_buffers
  GLEW_ARB_draw_buffers_blend
  GLEW_ARB_draw_elements_base_vertex
  GLEW_ARB_draw_indirect
  GLEW_ARB_draw_instanced
  GLEW_ARB_enhanced_layouts
  GLEW_ARB_ES2_compatibility
  GLEW_ARB_ES3_1_compatibility
  GLEW_ARB_ES3_2_compatibility
  GLEW_ARB_ES3_compatibility
  GLEW_ARB_explicit_attrib_location
  GLEW_ARB_explicit_uniform_location
  GLEW_ARB_fragment_coord_conventions
  GLEW_ARB_fragment_layer_viewport
  GLEW_ARB_fragment_program
  GLEW_ARB_fragment_program_shadow
  GLEW_ARB_fragment_shader
  GLEW_ARB_fragment_shader_interlock
  GLEW_ARB_framebuffer_no_attachments
  GLEW_ARB_framebuffer_object
  GLEW_ARB_framebuffer_sRGB
  GLEW_ARB_geometry_shader4
  GLEW_ARB_get_program_binary
  GLEW_ARB_get_texture_sub_image
  GLEW_ARB_gl_spirv
  GLEW_ARB_gpu_shader5
  GLEW_ARB_gpu_shader_fp64
  GLEW_ARB_gpu_shader_int64
  GLEW_ARB_half_float_pixel
  GLEW_ARB_half_float_vertex
  GLEW_ARB_imaging
  GLEW_ARB_indirect_parameters
  GLEW_ARB_instanced_arrays
  GLEW_ARB_internalformat_query
  GLEW_ARB_internalformat_query2
  GLEW_ARB_invalidate_subdata
  GLEW_ARB_map_buffer_alignment
  GLEW_ARB_map_buffer_range
  GLEW_ARB_matrix_palette
  GLEW_ARB_multisample
  GLEW_ARB_multitexture
  GLEW_ARB_multi_bind
  GLEW_ARB_multi_draw_indirect
  GLEW_ARB_occlusion_query
  GLEW_ARB_occlusion_query2
  GLEW_ARB_parallel_shader_compile
  GLEW_ARB_pipeline_statistics_query
  GLEW_ARB_pixel_buffer_object
  GLEW_ARB_point_parameters
  GLEW_ARB_point_sprite
  GLEW_ARB_polygon_offset_clamp
  GLEW_ARB_post_depth_coverage
  GLEW_ARB_program_interface_query
  GLEW_ARB_provoking_vertex
  GLEW_ARB_query_buffer_object
  GLEW_ARB_robustness
  GLEW_ARB_robustness_application_isolation
  GLEW_ARB_robustness_share_group_isolation
  GLEW_ARB_robust_buffer_access_behavior
  GLEW_ARB_sampler_objects
  GLEW_ARB_sample_locations
  GLEW_ARB_sample_shading
  GLEW_ARB_seamless_cubemap_per_texture
  GLEW_ARB_seamless_cube_map
  GLEW_ARB_separate_shader_objects
  GLEW_ARB_shader_atomic_counters
  GLEW_ARB_shader_atomic_counter_ops
  GLEW_ARB_shader_ballot
  GLEW_ARB_shader_bit_encoding
  GLEW_ARB_shader_clock
  GLEW_ARB_shader_draw_parameters
  GLEW_ARB_shader_group_vote
  GLEW_ARB_shader_image_load_store
  GLEW_ARB_shader_image_size
  GLEW_ARB_shader_objects
  GLEW_ARB_shader_precision
  GLEW_ARB_shader_stencil_export
  GLEW_ARB_shader_storage_buffer_object
  GLEW_ARB_shader_subroutine
  GLEW_ARB_shader_texture_image_samples
  GLEW_ARB_shader_texture_lod
  GLEW_ARB_shader_viewport_layer_array
  GLEW_ARB_shading_language_100
  GLEW_ARB_shading_language_420pack
  GLEW_ARB_shading_language_include
  GLEW_ARB_shading_language_packing
  GLEW_ARB_shadow
  GLEW_ARB_shadow_ambient
  GLEW_ARB_sparse_buffer
  GLEW_ARB_sparse_texture
  GLEW_ARB_sparse_texture2
  GLEW_ARB_sparse_texture_clamp
  GLEW_ARB_spirv_extensions
  GLEW_ARB_stencil_texturing
  GLEW_ARB_sync
  GLEW_ARB_tessellation_shader
  GLEW_ARB_texture_barrier
  GLEW_ARB_texture_border_clamp
  GLEW_ARB_texture_buffer_object
  GLEW_ARB_texture_buffer_object_rgb32
  GLEW_ARB_texture_buffer_range
  GLEW_ARB_texture_compression
  GLEW_ARB_texture_compression_bptc
  GLEW_ARB_texture_compression_rgtc
  GLEW_ARB_texture_cube_map
  GLEW_ARB_texture_cube_map_array
  GLEW_ARB_texture_env_add
  GLEW_ARB_texture_env_combine
  GLEW_ARB_texture_env_crossbar
  GLEW_ARB_texture_env_dot3
  GLEW_ARB_texture_filter_anisotropic
  GLEW_ARB_texture_filter_minmax
  GLEW_ARB_texture_float
  GLEW_ARB_texture_gather
  GLEW_ARB_texture_mirrored_repeat
  GLEW_ARB_texture_mirror_clamp_to_edge
  GLEW_ARB_texture_multisample
  GLEW_ARB_texture_non_power_of_two
  GLEW_ARB_texture_query_levels
  GLEW_ARB_texture_query_lod
  GLEW_ARB_texture_rectangle
  GLEW_ARB_texture_rg
  GLEW_ARB_texture_rgb10_a2ui
  GLEW_ARB_texture_stencil8
  GLEW_ARB_texture_storage
  GLEW_ARB_texture_storage_multisample
  GLEW_ARB_texture_swizzle
  GLEW_ARB_texture_view
  GLEW_ARB_timer_query
  GLEW_ARB_transform_feedback2
  GLEW_ARB_transform_feedback3
  GLEW_ARB_transform_feedback_instanced
  GLEW_ARB_transform_feedback_overflow_query
  GLEW_ARB_transpose_matrix
  GLEW_ARB_uniform_buffer_object
  GLEW_ARB_vertex_array_bgra
  GLEW_ARB_vertex_array_object
  GLEW_ARB_vertex_attrib_64bit
  GLEW_ARB_vertex_attrib_binding
  GLEW_ARB_vertex_blend
  GLEW_ARB_vertex_buffer_object
  GLEW_ARB_vertex_program
  GLEW_ARB_vertex_shader
  GLEW_ARB_vertex_type_10f_11f_11f_rev
  GLEW_ARB_vertex_type_2_10_10_10_rev
  GLEW_ARB_viewport_array
  GLEW_ARB_window_pos
  GLEW_ARM_mali_program_binary
  GLEW_ARM_mali_shader_binary
  GLEW_ARM_rgba8
  GLEW_ARM_shader_core_properties
  GLEW_ARM_shader_framebuffer_fetch
  GLEW_ARM_shader_framebuffer_fetch_depth_stencil
  GLEW_ARM_texture_unnormalized_coordinates
  GLEW_ATIX_point_sprites
  GLEW_ATIX_texture_env_combine3
  GLEW_ATIX_texture_env_route
  GLEW_ATIX_vertex_shader_output_point_size
  GLEW_ATI_draw_buffers
  GLEW_ATI_element_array
  GLEW_ATI_envmap_bumpmap
  GLEW_ATI_fragment_shader
  GLEW_ATI_map_object_buffer
  GLEW_ATI_meminfo
  GLEW_ATI_pn_triangles
  GLEW_ATI_separate_stencil
  GLEW_ATI_shader_texture_lod
  GLEW_ATI_texture_compression_3dc
  GLEW_ATI_texture_env_combine3
  GLEW_ATI_texture_float
  GLEW_ATI_texture_mirror_once
  GLEW_ATI_text_fragment_shader
  GLEW_ATI_vertex_array_object
  GLEW_ATI_vertex_attrib_array_object
  GLEW_ATI_vertex_streams
  GLEW_DMP_program_binary
  GLEW_DMP_shader_binary
  GLEW_EXT_422_pixels
  GLEW_EXT_abgr
  GLEW_EXT_base_instance
  GLEW_EXT_bgra
  GLEW_EXT_bindable_uniform
  GLEW_EXT_blend_color
  GLEW_EXT_blend_equation_separate
  GLEW_EXT_blend_func_extended
  GLEW_EXT_blend_func_separate
  GLEW_EXT_blend_logic_op
  GLEW_EXT_blend_minmax
  GLEW_EXT_blend_subtract
  GLEW_EXT_buffer_storage
  GLEW_EXT_Cg_shader
  GLEW_EXT_clear_texture
  GLEW_EXT_clip_control
  GLEW_EXT_clip_cull_distance
  GLEW_EXT_clip_volume_hint
  GLEW_EXT_cmyka
  GLEW_EXT_color_buffer_float
  GLEW_EXT_color_buffer_half_float
  GLEW_EXT_color_subtable
  GLEW_EXT_compiled_vertex_array
  GLEW_EXT_compressed_ETC1_RGB8_sub_texture
  GLEW_EXT_conservative_depth
  GLEW_EXT_convolution
  GLEW_EXT_coordinate_frame
  GLEW_EXT_copy_image
  GLEW_EXT_copy_texture
  GLEW_EXT_cull_vertex
  GLEW_EXT_debug_label
  GLEW_EXT_debug_marker
  GLEW_EXT_depth_bounds_test
  GLEW_EXT_depth_clamp
  GLEW_EXT_direct_state_access
  GLEW_EXT_discard_framebuffer
  GLEW_EXT_disjoint_timer_query
  GLEW_EXT_draw_buffers
  GLEW_EXT_draw_buffers2
  GLEW_EXT_draw_buffers_indexed
  GLEW_EXT_draw_elements_base_vertex
  GLEW_EXT_draw_instanced
  GLEW_EXT_draw_range_elements
  GLEW_EXT_draw_transform_feedback
  GLEW_EXT_EGL_image_array
  GLEW_EXT_EGL_image_external_wrap_modes
  GLEW_EXT_EGL_image_storage
  GLEW_EXT_EGL_image_storage_compression
  GLEW_EXT_EGL_sync
  GLEW_EXT_external_buffer
  GLEW_EXT_float_blend
  GLEW_EXT_fog_coord
  GLEW_EXT_fragment_lighting
  GLEW_EXT_fragment_shading_rate
  GLEW_EXT_fragment_shading_rate_attachment
  GLEW_EXT_fragment_shading_rate_primitive
  GLEW_EXT_frag_depth
  GLEW_EXT_framebuffer_blit
  GLEW_EXT_framebuffer_blit_layers
  GLEW_EXT_framebuffer_multisample
  GLEW_EXT_framebuffer_multisample_blit_scaled
  GLEW_EXT_framebuffer_object
  GLEW_EXT_framebuffer_sRGB
  GLEW_EXT_geometry_point_size
  GLEW_EXT_geometry_shader
  GLEW_EXT_geometry_shader4
  GLEW_EXT_gpu_program_parameters
  GLEW_EXT_gpu_shader4
  GLEW_EXT_gpu_shader5
  GLEW_EXT_histogram
  GLEW_EXT_index_array_formats
  GLEW_EXT_index_func
  GLEW_EXT_index_material
  GLEW_EXT_index_texture
  GLEW_EXT_instanced_arrays
  GLEW_EXT_light_texture
  GLEW_EXT_map_buffer_range
  GLEW_EXT_memory_object
  GLEW_EXT_memory_object_fd
  GLEW_EXT_memory_object_win32
  GLEW_EXT_mesh_shader
  GLEW_EXT_misc_attribute
  GLEW_EXT_multiple_textures
  GLEW_EXT_multisample
  GLEW_EXT_multisampled_render_to_texture
  GLEW_EXT_multisampled_render_to_texture2
  GLEW_EXT_multisample_compatibility
  GLEW_EXT_multiview_draw_buffers
  GLEW_EXT_multiview_tessellation_geometry_shader
  GLEW_EXT_multiview_texture_multisample
  GLEW_EXT_multiview_timer_query
  GLEW_EXT_multi_draw_arrays
  GLEW_EXT_multi_draw_indirect
  GLEW_EXT_occlusion_query_boolean
  GLEW_EXT_packed_depth_stencil
  GLEW_EXT_packed_float
  GLEW_EXT_packed_pixels
  GLEW_EXT_paletted_texture
  GLEW_EXT_pixel_buffer_object
  GLEW_EXT_pixel_transform
  GLEW_EXT_pixel_transform_color_table
  GLEW_EXT_point_parameters
  GLEW_EXT_polygon_offset
  GLEW_EXT_polygon_offset_clamp
  GLEW_EXT_post_depth_coverage
  GLEW_EXT_primitive_bounding_box
  GLEW_EXT_protected_textures
  GLEW_EXT_provoking_vertex
  GLEW_EXT_pvrtc_sRGB
  GLEW_EXT_raster_multisample
  GLEW_EXT_read_format_bgra
  GLEW_EXT_render_snorm
  GLEW_EXT_rescale_normal
  GLEW_EXT_robustness
  GLEW_EXT_scene_marker
  GLEW_EXT_secondary_color
  GLEW_EXT_semaphore
  GLEW_EXT_semaphore_fd
  GLEW_EXT_semaphore_win32
  GLEW_EXT_separate_depth_stencil
  GLEW_EXT_separate_shader_objects
  GLEW_EXT_separate_specular_color
  GLEW_EXT_shader_clock
  GLEW_EXT_shader_framebuffer_fetch
  GLEW_EXT_shader_framebuffer_fetch_non_coherent
  GLEW_EXT_shader_group_vote
  GLEW_EXT_shader_image_load_formatted
  GLEW_EXT_shader_image_load_store
  GLEW_EXT_shader_implicit_conversions
  GLEW_EXT_shader_integer_mix
  GLEW_EXT_shader_io_blocks
  GLEW_EXT_shader_non_constant_global_initializers
  GLEW_EXT_shader_pixel_local_storage
  GLEW_EXT_shader_pixel_local_storage2
  GLEW_EXT_shader_realtime_clock
  GLEW_EXT_shader_samples_identical
  GLEW_EXT_shader_texture_lod
  GLEW_EXT_shader_texture_samples
  GLEW_EXT_shadow_funcs
  GLEW_EXT_shadow_samplers
  GLEW_EXT_shared_texture_palette
  GLEW_EXT_sparse_texture
  GLEW_EXT_sparse_texture2
  GLEW_EXT_sRGB
  GLEW_EXT_sRGB_write_control
  GLEW_EXT_static_vertex_array
  GLEW_EXT_stencil_clear_tag
  GLEW_EXT_stencil_two_side
  GLEW_EXT_stencil_wrap
  GLEW_EXT_subtexture
  GLEW_EXT_tessellation_point_size
  GLEW_EXT_tessellation_shader
  GLEW_EXT_texture
  GLEW_EXT_texture3D
  GLEW_EXT_texture_array
  GLEW_EXT_texture_border_clamp
  GLEW_EXT_texture_buffer
  GLEW_EXT_texture_buffer_object
  GLEW_EXT_texture_compression_astc_decode_mode
  GLEW_EXT_texture_compression_astc_decode_mode_rgb9e5
  GLEW_EXT_texture_compression_bptc
  GLEW_EXT_texture_compression_dxt1
  GLEW_EXT_texture_compression_latc
  GLEW_EXT_texture_compression_rgtc
  GLEW_EXT_texture_compression_s3tc
  GLEW_EXT_texture_compression_s3tc_srgb
  GLEW_EXT_texture_cube_map
  GLEW_EXT_texture_cube_map_array
  GLEW_EXT_texture_edge_clamp
  GLEW_EXT_texture_env
  GLEW_EXT_texture_env_add
  GLEW_EXT_texture_env_combine
  GLEW_EXT_texture_env_dot3
  GLEW_EXT_texture_filter_anisotropic
  GLEW_EXT_texture_filter_minmax
  GLEW_EXT_texture_format_BGRA8888
  GLEW_EXT_texture_format_sRGB_override
  GLEW_EXT_texture_integer
  GLEW_EXT_texture_lod_bias
  GLEW_EXT_texture_mirror_clamp
  GLEW_EXT_texture_mirror_clamp_to_edge
  GLEW_EXT_texture_norm16
  GLEW_EXT_texture_object
  GLEW_EXT_texture_perturb_normal
  GLEW_EXT_texture_query_lod
  GLEW_EXT_texture_rectangle
  GLEW_EXT_texture_rg
  GLEW_EXT_texture_shadow_lod
  GLEW_EXT_texture_shared_exponent
  GLEW_EXT_texture_snorm
  GLEW_EXT_texture_sRGB
  GLEW_EXT_texture_sRGB_decode
  GLEW_EXT_texture_sRGB_R8
  GLEW_EXT_texture_sRGB_RG8
  GLEW_EXT_texture_storage
  GLEW_EXT_texture_storage_compression
  GLEW_EXT_texture_swizzle
  GLEW_EXT_texture_type_2_10_10_10_REV
  GLEW_EXT_texture_view
  GLEW_EXT_timer_query
  GLEW_EXT_transform_feedback
  GLEW_EXT_unpack_subimage
  GLEW_EXT_vertex_array
  GLEW_EXT_vertex_array_bgra
  GLEW_EXT_vertex_array_setXXX
  GLEW_EXT_vertex_attrib_64bit
  GLEW_EXT_vertex_shader
  GLEW_EXT_vertex_weighting
  GLEW_EXT_win32_keyed_mutex
  GLEW_EXT_window_rectangles
  GLEW_EXT_x11_sync_object
  GLEW_EXT_YUV_target
  GLEW_FJ_shader_binary_GCCSO
  GLEW_GREMEDY_frame_terminator
  GLEW_GREMEDY_string_marker
  GLEW_HP_convolution_border_modes
  GLEW_HP_image_transform
  GLEW_HP_occlusion_test
  GLEW_HP_texture_lighting
  GLEW_HUAWEI_program_binary
  GLEW_HUAWEI_shader_binary
  GLEW_IBM_cull_vertex
  GLEW_IBM_multimode_draw_arrays
  GLEW_IBM_rasterpos_clip
  GLEW_IBM_static_data
  GLEW_IBM_texture_mirrored_repeat
  GLEW_IBM_vertex_array_lists
  GLEW_IMG_bindless_texture
  GLEW_IMG_framebuffer_downsample
  GLEW_IMG_multisampled_render_to_texture
  GLEW_IMG_program_binary
  GLEW_IMG_pvric_end_to_end_signature
  GLEW_IMG_read_format
  GLEW_IMG_shader_binary
  GLEW_IMG_texture_compression_pvrtc
  GLEW_IMG_texture_compression_pvrtc2
  GLEW_IMG_texture_env_enhanced_fixed_function
  GLEW_IMG_texture_filter_cubic
  GLEW_IMG_tile_region_protection
  GLEW_INGR_color_clamp
  GLEW_INGR_interlace_read
  GLEW_INTEL_blackhole_render
  GLEW_INTEL_conservative_rasterization
  GLEW_INTEL_fragment_shader_ordering
  GLEW_INTEL_framebuffer_CMAA
  GLEW_INTEL_map_texture
  GLEW_INTEL_parallel_arrays
  GLEW_INTEL_performance_query
  GLEW_INTEL_shader_integer_functions2
  GLEW_INTEL_texture_scissor
  GLEW_KHR_blend_equation_advanced
  GLEW_KHR_blend_equation_advanced_coherent
  GLEW_KHR_context_flush_control
  GLEW_KHR_debug
  GLEW_KHR_no_error
  GLEW_KHR_parallel_shader_compile
  GLEW_KHR_robustness
  GLEW_KHR_robust_buffer_access_behavior
  GLEW_KHR_shader_subgroup
  GLEW_KHR_texture_compression_astc_hdr
  GLEW_KHR_texture_compression_astc_ldr
  GLEW_KHR_texture_compression_astc_sliced_3d
  GLEW_KTX_buffer_region
  GLEW_MESAX_texture_stack
  GLEW_MESA_bgra
  GLEW_MESA_framebuffer_flip_x
  GLEW_MESA_framebuffer_flip_y
  GLEW_MESA_framebuffer_swap_xy
  GLEW_MESA_pack_invert
  GLEW_MESA_program_binary_formats
  GLEW_MESA_resize_buffers
  GLEW_MESA_shader_integer_functions
  GLEW_MESA_texture_const_bandwidth
  GLEW_MESA_tile_raster_order
  GLEW_MESA_window_pos
  GLEW_MESA_ycbcr_texture
  GLEW_NVX_blend_equation_advanced_multi_draw_buffers
  GLEW_NVX_conditional_render
  GLEW_NVX_gpu_memory_info
  GLEW_NVX_gpu_multicast2
  GLEW_NVX_linked_gpu_multicast
  GLEW_NVX_progress_fence
  GLEW_NV_3dvision_settings
  GLEW_NV_alpha_to_coverage_dither_control
  GLEW_NV_bgr
  GLEW_NV_bindless_multi_draw_indirect
  GLEW_NV_bindless_multi_draw_indirect_count
  GLEW_NV_bindless_texture
  GLEW_NV_blend_equation_advanced
  GLEW_NV_blend_equation_advanced_coherent
  GLEW_NV_blend_minmax_factor
  GLEW_NV_blend_square
  GLEW_NV_clip_space_w_scaling
  GLEW_NV_command_list
  GLEW_NV_compute_program5
  GLEW_NV_compute_shader_derivatives
  GLEW_NV_conditional_render
  GLEW_NV_conservative_raster
  GLEW_NV_conservative_raster_dilate
  GLEW_NV_conservative_raster_pre_snap
  GLEW_NV_conservative_raster_pre_snap_triangles
  GLEW_NV_conservative_raster_underestimation
  GLEW_NV_copy_buffer
  GLEW_NV_copy_depth_to_color
  GLEW_NV_copy_image
  GLEW_NV_deep_texture3D
  GLEW_NV_depth_buffer_float
  GLEW_NV_depth_clamp
  GLEW_NV_depth_nonlinear
  GLEW_NV_depth_range_unclamped
  GLEW_NV_draw_buffers
  GLEW_NV_draw_instanced
  GLEW_NV_draw_texture
  GLEW_NV_draw_vulkan_image
  GLEW_NV_EGL_stream_consumer_external
  GLEW_NV_evaluators
  GLEW_NV_explicit_attrib_location
  GLEW_NV_explicit_multisample
  GLEW_NV_fbo_color_attachments
  GLEW_NV_fence
  GLEW_NV_fill_rectangle
  GLEW_NV_float_buffer
  GLEW_NV_fog_distance
  GLEW_NV_fragment_coverage_to_color
  GLEW_NV_fragment_program
  GLEW_NV_fragment_program2
  GLEW_NV_fragment_program4
  GLEW_NV_fragment_program_option
  GLEW_NV_fragment_shader_barycentric
  GLEW_NV_fragment_shader_interlock
  GLEW_NV_framebuffer_blit
  GLEW_NV_framebuffer_mixed_samples
  GLEW_NV_framebuffer_multisample
  GLEW_NV_framebuffer_multisample_coverage
  GLEW_NV_generate_mipmap_sRGB
  GLEW_NV_geometry_program4
  GLEW_NV_geometry_shader4
  GLEW_NV_geometry_shader_passthrough
  GLEW_NV_gpu_multicast
  GLEW_NV_gpu_program4
  GLEW_NV_gpu_program5
  GLEW_NV_gpu_program5_mem_extended
  GLEW_NV_gpu_program_fp64
  GLEW_NV_gpu_shader5
  GLEW_NV_half_float
  GLEW_NV_image_formats
  GLEW_NV_instanced_arrays
  GLEW_NV_internalformat_sample_query
  GLEW_NV_light_max_exponent
  GLEW_NV_memory_attachment
  GLEW_NV_memory_object_sparse
  GLEW_NV_mesh_shader
  GLEW_NV_multisample_coverage
  GLEW_NV_multisample_filter_hint
  GLEW_NV_non_square_matrices
  GLEW_NV_occlusion_query
  GLEW_NV_packed_depth_stencil
  GLEW_NV_packed_float
  GLEW_NV_packed_float_linear
  GLEW_NV_pack_subimage
  GLEW_NV_parameter_buffer_object
  GLEW_NV_parameter_buffer_object2
  GLEW_NV_path_rendering
  GLEW_NV_path_rendering_shared_edge
  GLEW_NV_pixel_buffer_object
  GLEW_NV_pixel_data_range
  GLEW_NV_platform_binary
  GLEW_NV_point_sprite
  GLEW_NV_polygon_mode
  GLEW_NV_present_video
  GLEW_NV_primitive_restart
  GLEW_NV_primitive_shading_rate
  GLEW_NV_query_resource_tag
  GLEW_NV_read_buffer
  GLEW_NV_read_buffer_front
  GLEW_NV_read_depth
  GLEW_NV_read_depth_stencil
  GLEW_NV_read_stencil
  GLEW_NV_register_combiners
  GLEW_NV_register_combiners2
  GLEW_NV_representative_fragment_test
  GLEW_NV_robustness_video_memory_purge
  GLEW_NV_sample_locations
  GLEW_NV_sample_mask_override_coverage
  GLEW_NV_scissor_exclusive
  GLEW_NV_shader_atomic_counters
  GLEW_NV_shader_atomic_float
  GLEW_NV_shader_atomic_float64
  GLEW_NV_shader_atomic_fp16_vector
  GLEW_NV_shader_atomic_int64
  GLEW_NV_shader_buffer_load
  GLEW_NV_shader_noperspective_interpolation
  GLEW_NV_shader_storage_buffer_object
  GLEW_NV_shader_subgroup_partitioned
  GLEW_NV_shader_texture_footprint
  GLEW_NV_shader_thread_group
  GLEW_NV_shader_thread_shuffle
  GLEW_NV_shading_rate_image
  GLEW_NV_shadow_samplers_array
  GLEW_NV_shadow_samplers_cube
  GLEW_NV_sRGB_formats
  GLEW_NV_stereo_view_rendering
  GLEW_NV_tessellation_program5
  GLEW_NV_texgen_emboss
  GLEW_NV_texgen_reflection
  GLEW_NV_texture_array
  GLEW_NV_texture_barrier
  GLEW_NV_texture_border_clamp
  GLEW_NV_texture_compression_latc
  GLEW_NV_texture_compression_s3tc
  GLEW_NV_texture_compression_s3tc_update
  GLEW_NV_texture_compression_vtc
  GLEW_NV_texture_env_combine4
  GLEW_NV_texture_expand_normal
  GLEW_NV_texture_multisample
  GLEW_NV_texture_npot_2D_mipmap
  GLEW_NV_texture_rectangle
  GLEW_NV_texture_rectangle_compressed
  GLEW_NV_texture_shader
  GLEW_NV_texture_shader2
  GLEW_NV_texture_shader3
  GLEW_NV_timeline_semaphore
  GLEW_NV_transform_feedback
  GLEW_NV_transform_feedback2
  GLEW_NV_uniform_buffer_std430_layout
  GLEW_NV_uniform_buffer_unified_memory
  GLEW_NV_vdpau_interop
  GLEW_NV_vdpau_interop2
  GLEW_NV_vertex_array_range
  GLEW_NV_vertex_array_range2
  GLEW_NV_vertex_attrib_integer_64bit
  GLEW_NV_vertex_buffer_unified_memory
  GLEW_NV_vertex_program
  GLEW_NV_vertex_program1_1
  GLEW_NV_vertex_program2
  GLEW_NV_vertex_program2_option
  GLEW_NV_vertex_program3
  GLEW_NV_vertex_program4
  GLEW_NV_video_capture
  GLEW_NV_viewport_array
  GLEW_NV_viewport_array2
  GLEW_NV_viewport_swizzle
  GLEW_OES_blend_equation_separate
  GLEW_OES_blend_func_separate
  GLEW_OES_blend_subtract
  GLEW_OES_byte_coordinates
  GLEW_OES_compressed_ETC1_RGB8_texture
  GLEW_OES_compressed_paletted_texture
  GLEW_OES_copy_image
  GLEW_OES_depth24
  GLEW_OES_depth32
  GLEW_OES_depth_texture
  GLEW_OES_depth_texture_cube_map
  GLEW_OES_draw_buffers_indexed
  GLEW_OES_draw_texture
  GLEW_OES_EGL_image
  GLEW_OES_EGL_image_external
  GLEW_OES_EGL_image_external_essl3
  GLEW_OES_element_index_uint
  GLEW_OES_extended_matrix_palette
  GLEW_OES_fbo_render_mipmap
  GLEW_OES_fragment_precision_high
  GLEW_OES_framebuffer_object
  GLEW_OES_geometry_point_size
  GLEW_OES_geometry_shader
  GLEW_OES_get_program_binary
  GLEW_OES_gpu_shader5
  GLEW_OES_mapbuffer
  GLEW_OES_matrix_get
  GLEW_OES_matrix_palette
  GLEW_OES_packed_depth_stencil
  GLEW_OES_point_size_array
  GLEW_OES_point_sprite
  GLEW_OES_read_format
  GLEW_OES_required_internalformat
  GLEW_OES_rgb8_rgba8
  GLEW_OES_sample_shading
  GLEW_OES_sample_variables
  GLEW_OES_shader_image_atomic
  GLEW_OES_shader_io_blocks
  GLEW_OES_shader_multisample_interpolation
  GLEW_OES_single_precision
  GLEW_OES_standard_derivatives
  GLEW_OES_stencil1
  GLEW_OES_stencil4
  GLEW_OES_stencil8
  GLEW_OES_surfaceless_context
  GLEW_OES_tessellation_point_size
  GLEW_OES_tessellation_shader
  GLEW_OES_texture_3D
  GLEW_OES_texture_border_clamp
  GLEW_OES_texture_buffer
  GLEW_OES_texture_compression_astc
  GLEW_OES_texture_cube_map
  GLEW_OES_texture_cube_map_array
  GLEW_OES_texture_env_crossbar
  GLEW_OES_texture_mirrored_repeat
  GLEW_OES_texture_npot
  GLEW_OES_texture_stencil8
  GLEW_OES_texture_storage_multisample_2d_array
  GLEW_OES_texture_view
  GLEW_OES_vertex_array_object
  GLEW_OES_vertex_half_float
  GLEW_OES_vertex_type_10_10_10_2
  GLEW_OML_interlace
  GLEW_OML_resample
  GLEW_OML_subsample
  GLEW_OVR_multiview
  GLEW_OVR_multiview2
  GLEW_OVR_multiview_multisampled_render_to_texture
  GLEW_PGI_misc_hints
  GLEW_PGI_vertex_hints
  GLEW_QCOM_alpha_test
  GLEW_QCOM_binning_control
  GLEW_QCOM_driver_control
  GLEW_QCOM_extended_get
  GLEW_QCOM_extended_get2
  GLEW_QCOM_framebuffer_foveated
  GLEW_QCOM_frame_extrapolation
  GLEW_QCOM_motion_estimation
  GLEW_QCOM_perfmon_global_mode
  GLEW_QCOM_render_shared_exponent
  GLEW_QCOM_render_sRGB_R8_RG8
  GLEW_QCOM_shader_framebuffer_fetch_noncoherent
  GLEW_QCOM_shader_framebuffer_fetch_rate
  GLEW_QCOM_shading_rate
  GLEW_QCOM_texture_foveated
  GLEW_QCOM_texture_foveated2
  GLEW_QCOM_texture_foveated_subsampled_layout
  GLEW_QCOM_texture_lod_bias
  GLEW_QCOM_tiled_rendering
  GLEW_QCOM_writeonly_rendering
  GLEW_QCOM_ycbcr_degamma
  GLEW_QCOM_YUV_texture_gather
  GLEW_REGAL_enable
  GLEW_REGAL_error_string
  GLEW_REGAL_ES1_0_compatibility
  GLEW_REGAL_ES1_1_compatibility
  GLEW_REGAL_extension_query
  GLEW_REGAL_log
  GLEW_REGAL_proc_address
  GLEW_REND_screen_coordinates
  GLEW_S3_s3tc
  GLEW_SGIS_clip_band_hint
  GLEW_SGIS_color_range
  GLEW_SGIS_detail_texture
  GLEW_SGIS_fog_function
  GLEW_SGIS_generate_mipmap
  GLEW_SGIS_line_texgen
  GLEW_SGIS_multisample
  GLEW_SGIS_multitexture
  GLEW_SGIS_pixel_texture
  GLEW_SGIS_point_line_texgen
  GLEW_SGIS_shared_multisample
  GLEW_SGIS_sharpen_texture
  GLEW_SGIS_texture4D
  GLEW_SGIS_texture_border_clamp
  GLEW_SGIS_texture_edge_clamp
  GLEW_SGIS_texture_filter4
  GLEW_SGIS_texture_lod
  GLEW_SGIS_texture_select
  GLEW_SGIX_async
  GLEW_SGIX_async_histogram
  GLEW_SGIX_async_pixel
  GLEW_SGIX_bali_g_instruments
  GLEW_SGIX_bali_r_instruments
  GLEW_SGIX_bali_timer_instruments
  GLEW_SGIX_blend_alpha_minmax
  GLEW_SGIX_blend_cadd
  GLEW_SGIX_blend_cmultiply
  GLEW_SGIX_calligraphic_fragment
  GLEW_SGIX_clipmap
  GLEW_SGIX_color_matrix_accuracy
  GLEW_SGIX_color_table_index_mode
  GLEW_SGIX_complex_polar
  GLEW_SGIX_convolution_accuracy
  GLEW_SGIX_cube_map
  GLEW_SGIX_cylinder_texgen
  GLEW_SGIX_datapipe
  GLEW_SGIX_decimation
  GLEW_SGIX_depth_pass_instrument
  GLEW_SGIX_depth_texture
  GLEW_SGIX_dvc
  GLEW_SGIX_flush_raster
  GLEW_SGIX_fog_blend
  GLEW_SGIX_fog_factor_to_alpha
  GLEW_SGIX_fog_layers
  GLEW_SGIX_fog_offset
  GLEW_SGIX_fog_patchy
  GLEW_SGIX_fog_scale
  GLEW_SGIX_fog_texture
  GLEW_SGIX_fragments_instrument
  GLEW_SGIX_fragment_lighting_space
  GLEW_SGIX_fragment_specular_lighting
  GLEW_SGIX_framezoom
  GLEW_SGIX_icc_texture
  GLEW_SGIX_igloo_interface
  GLEW_SGIX_image_compression
  GLEW_SGIX_impact_pixel_texture
  GLEW_SGIX_instrument_error
  GLEW_SGIX_interlace
  GLEW_SGIX_ir_instrument1
  GLEW_SGIX_line_quality_hint
  GLEW_SGIX_list_priority
  GLEW_SGIX_mpeg1
  GLEW_SGIX_mpeg2
  GLEW_SGIX_nonlinear_lighting_pervertex
  GLEW_SGIX_nurbs_eval
  GLEW_SGIX_occlusion_instrument
  GLEW_SGIX_packed_6bytes
  GLEW_SGIX_pixel_texture
  GLEW_SGIX_pixel_texture_bits
  GLEW_SGIX_pixel_texture_lod
  GLEW_SGIX_pixel_tiles
  GLEW_SGIX_polynomial_ffd
  GLEW_SGIX_quad_mesh
  GLEW_SGIX_reference_plane
  GLEW_SGIX_resample
  GLEW_SGIX_scalebias_hint
  GLEW_SGIX_shadow
  GLEW_SGIX_shadow_ambient
  GLEW_SGIX_slim
  GLEW_SGIX_spotlight_cutoff
  GLEW_SGIX_sprite
  GLEW_SGIX_subdiv_patch
  GLEW_SGIX_subsample
  GLEW_SGIX_tag_sample_buffer
  GLEW_SGIX_texture_add_env
  GLEW_SGIX_texture_coordinate_clamp
  GLEW_SGIX_texture_lod_bias
  GLEW_SGIX_texture_mipmap_anisotropic
  GLEW_SGIX_texture_multi_buffer
  GLEW_SGIX_texture_phase
  GLEW_SGIX_texture_range
  GLEW_SGIX_texture_scale_bias
  GLEW_SGIX_texture_supersample
  GLEW_SGIX_vector_ops
  GLEW_SGIX_vertex_array_object
  GLEW_SGIX_vertex_preclip
  GLEW_SGIX_vertex_preclip_hint
  GLEW_SGIX_ycrcb
  GLEW_SGIX_ycrcba
  GLEW_SGIX_ycrcb_subsample
  GLEW_SGI_color_matrix
  GLEW_SGI_color_table
  GLEW_SGI_complex
  GLEW_SGI_complex_type
  GLEW_SGI_fft
  GLEW_SGI_texture_color_table
  GLEW_SUNX_constant_data
  GLEW_SUN_convolution_border_modes
  GLEW_SUN_global_alpha
  GLEW_SUN_mesh_array
  GLEW_SUN_read_video_pixels
  GLEW_SUN_slice_accum
  GLEW_SUN_triangle_list
  GLEW_SUN_vertex
  GLEW_VERSION_1_1
  GLEW_VERSION_1_2
  GLEW_VERSION_1_2_1
  GLEW_VERSION_1_3
  GLEW_VERSION_1_4
  GLEW_VERSION_1_5
  GLEW_VERSION_2_0
  GLEW_VERSION_2_1
  GLEW_VERSION_3_0
  GLEW_VERSION_3_1
  GLEW_VERSION_3_2
  GLEW_VERSION_3_3
  GLEW_VERSION_4_0
  GLEW_VERSION_4_1
  GLEW_VERSION_4_2
  GLEW_VERSION_4_3
  GLEW_VERSION_4_4
  GLEW_VERSION_4_5
  GLEW_VERSION_4_6
  GLEW_VIV_shader_binary
  GLEW_WIN_phong_shading
  GLEW_WIN_scene_markerXXX
  GLEW_WIN_specular_fog
  GLEW_WIN_swap_hint
  glExecuteProgramNV_c
  glExecuteProgramNV_p
  glExtGetBufferPointervQCOM_c
  glExtGetBuffersQCOM_c
  glExtGetBuffersQCOM_p
  glExtGetFramebuffersQCOM_c
  glExtGetFramebuffersQCOM_p
  glExtGetProgramBinarySourceQCOM_c
  glExtGetProgramsQCOM_c
  glExtGetProgramsQCOM_p
  glExtGetRenderbuffersQCOM_c
  glExtGetRenderbuffersQCOM_p
  glExtGetShadersQCOM_c
  glExtGetShadersQCOM_p
  glExtGetTexLevelParameterivQCOM_c
  glExtGetTexSubImageQCOM_c
  glExtGetTexturesQCOM_c
  glExtIsProgramBinaryQCOM
  glExtractComponentEXT
  glExtrapolateTex2DQCOM
  glExtTexObjectStateOverrideiQCOM
  glFenceSync
  glFenceSyncAPPLE
  glFinalCombinerInputNV
  glFinishAsyncSGIX_c
  glFinishAsyncSGIX_p
  glFinishFenceAPPLE
  glFinishFenceNV
  glFinishObjectAPPLE
  glFinishTextureSUNX
  glFlushMappedBufferRangeAPPLE
  glFlushMappedBufferRangeEXT
  glFlushMappedNamedBufferRange
  glFlushMappedNamedBufferRangeEXT
  glFlushPixelDataRangeNV
  glFlushRasterSGIX
  glFlushVertexArrayRangeAPPLE_c
  glFlushVertexArrayRangeNV
  glFogCoorddEXT
  glFogCoorddvEXT_c
  glFogCoorddvEXT_p
  glFogCoordfEXT
  glFogCoordFormatNV
  glFogCoordfvEXT_c
  glFogCoordfvEXT_p
  glFogCoordhNV
  glFogCoordhvNV_c
  glFogCoordhvNV_p
  glFogCoordPointerEXT_c
  glFogCoordPointerListIBM_c
  glFogFuncSGIS_c
  glFogFuncSGIS_p
  glFogLayersSGIX_c
  glFogx
  glFogxv_c
  glFogxv_p
  glFragmentColorMaterialEXT
  glFragmentColorMaterialSGIX
  glFragmentCoverageColorNV
  glFragmentLightfEXT
  glFragmentLightfSGIX
  glFragmentLightfvEXT_c
  glFragmentLightfvSGIX_c
  glFragmentLightfvSGIX_p
  glFragmentLightiEXT
  glFragmentLightiSGIX
  glFragmentLightivEXT_c
  glFragmentLightivSGIX_c
  glFragmentLightivSGIX_p
  glFragmentLightModelfEXT
  glFragmentLightModelfSGIX
  glFragmentLightModelfvEXT_c
  glFragmentLightModelfvSGIX_c
  glFragmentLightModeliEXT
  glFragmentLightModeliSGIX
  glFragmentLightModelivEXT_c
  glFragmentLightModelivSGIX_c
  glFragmentMaterialfEXT
  glFragmentMaterialfSGIX
  glFragmentMaterialfvEXT_c
  glFragmentMaterialfvSGIX_c
  glFragmentMaterialfvSGIX_p
  glFragmentMaterialiEXT
  glFragmentMaterialiSGIX
  glFragmentMaterialivEXT_c
  glFragmentMaterialivSGIX_c
  glFragmentMaterialivSGIX_p
  glFramebufferDrawBufferEXT
  glFramebufferDrawBuffersEXT_c
  glFramebufferDrawBuffersEXT_p
  glFramebufferFetchBarrierEXT
  glFramebufferFetchBarrierQCOM
  glFramebufferFoveationConfigQCOM_c
  glFramebufferFoveationConfigQCOM_p
  glFramebufferFoveationParametersQCOM
  glFramebufferParameteri
  glFramebufferParameteriMESA
  glFramebufferPixelLocalStorageSizeEXT
  glFramebufferReadBufferEXT
  glFramebufferRenderbufferEXT
  glFramebufferRenderbufferOES
  glFramebufferSampleLocationsfvARB_c
  glFramebufferSampleLocationsfvNV_c
  glFramebufferSamplePositionsfvAMD_c
  glFramebufferShadingRateEXT
  glFramebufferTexture
  glFramebufferTexture1DEXT
  glFramebufferTexture2DDownsampleIMG
  glFramebufferTexture2DEXT
  glFramebufferTexture2DMultisampleEXT
  glFramebufferTexture2DMultisampleIMG
  glFramebufferTexture2DOES
  glFramebufferTexture3DEXT
  glFramebufferTexture3DOES
  glFramebufferTextureARB
  glFramebufferTextureEXT
  glFramebufferTextureFaceARB
  glFramebufferTextureFaceEXT
  glFramebufferTextureLayerARB
  glFramebufferTextureLayerDownsampleIMG
  glFramebufferTextureLayerEXT
  glFramebufferTextureLayerNV
  glFramebufferTextureMultisampleMultiviewOVR
  glFramebufferTextureMultiviewOVR
  glFrameTerminatorGREMEDY
  glFrameZoomSGIX
  glFreeObjectBufferATI
  glFrustumf
  glFrustumfOES
  glFrustumx
  glGenAsyncMarkersSGIX
  glGenBuffersARB_c
  glGenBuffersARB_p
  glGenerateMipmapEXT
  glGenerateMipmapOES
  glGenerateMultiTexMipmapEXT
  glGenerateTextureMipmap
  glGenerateTextureMipmapEXT
  glGenFencesAPPLE_c
  glGenFencesAPPLE_p
  glGenFencesNV_c
  glGenFencesNV_p
  glGenFragmentShadersATI
  glGenFramebuffersEXT_c
  glGenFramebuffersEXT_p
  glGenFramebuffersOES_c
  glGenMPEGPredictorsSGIX_c
  glGenNamesAMD_c
  glGenNamesAMD_p
  glGenOcclusionQueriesNV_c
  glGenOcclusionQueriesNV_p
  glGenPathsNV
  glGenPerfMonitorsAMD_c
  glGenPerfMonitorsAMD_p
  glGenProgramPipelines_c
  glGenProgramPipelines_p
  glGenProgramsARB_c
  glGenProgramsARB_p
  glGenProgramsNV_c
  glGenProgramsNV_p
  glGenQueriesANGLE_c
  glGenQueriesARB_c
  glGenQueriesARB_p
  glGenQueriesEXT_c
  glGenQueriesEXT_p
  glGenRenderbuffersEXT_c
  glGenRenderbuffersEXT_p
  glGenRenderbuffersOES_c
  glGenSamplers_c
  glGenSamplers_p
  glGenSemaphoresEXT_c
  glGenSemaphoresEXT_p
  glGenSymbolsEXT
  glGenTexturesEXT_c
  glGenTexturesEXT_p
  glGenTransformFeedbacksNV_c
  glGenTransformFeedbacksNV_p
  glGenTransformFeedbacks_c
  glGenTransformFeedbacks_p
  glGenVertexArraysAPPLE_c
  glGenVertexArraysAPPLE_p
  glGenVertexArraysOES_c
  glGenVertexArraysSGIX_c
  glGenVertexShadersEXT
  glGetActiveAtomicCounterBufferiv_c
  glGetActiveAtomicCounterBufferiv_p
  glGetActiveAttribARB_c
  glGetActiveAttribARB_p
  glGetActiveSubroutineName_c
  glGetActiveSubroutineName_p
  glGetActiveSubroutineUniformiv_c
  glGetActiveSubroutineUniformiv_p
  glGetActiveSubroutineUniformName_c
  glGetActiveSubroutineUniformName_p
  glGetActiveUniformARB_c
  glGetActiveUniformARB_p
  glGetActiveVaryingNV_c
  glGetActiveVaryingNV_p
  glGetArrayObjectfvATI_c
  glGetArrayObjectfvATI_p
  glGetArrayObjectivATI_c
  glGetArrayObjectivATI_p
  glGetAttachedObjectsARB_c
  glGetAttribLocationARB
  glGetBooleanIndexedvEXT_c
  glGetBooleanIndexedvEXT_p
  glGetBufferParameteri64v_c
  glGetBufferParameteri64v_p
  glGetBufferParameterivARB_c
  glGetBufferParameterivARB_p
  glGetBufferParameterui64vNV_c
  glGetBufferPointervARB_c
  glGetBufferPointervOES_c
  glGetBufferSubDataARB_c
  glGetClipPlanefOES_c
  glGetClipPlanef_c
  glGetClipPlanef_p
  glGetClipPlanex_c
  glGetClipPlanex_p
  glGetColorTableEXT_c
  glGetColorTableParameterfvEXT_c
  glGetColorTableParameterfvEXT_p
  glGetColorTableParameterfvSGI_c
  glGetColorTableParameterfvSGI_p
  glGetColorTableParameterfv_c
  glGetColorTableParameterfv_p
  glGetColorTableParameterivEXT_c
  glGetColorTableParameterivEXT_p
  glGetColorTableParameterivSGI_c
  glGetColorTableParameterivSGI_p
  glGetColorTableParameteriv_c
  glGetColorTableParameteriv_p
  glGetColorTableSGI_c
  glGetColorTable_c
  glGetCombinerInputParameterfvNV_c
  glGetCombinerInputParameterivNV_c
  glGetCombinerOutputParameterfvNV_c
  glGetCombinerOutputParameterivNV_c
  glGetCombinerStageParameterfvNV_c
  glGetCommandHeaderNV
  glGetCompressedMultiTexImageEXT_c
  glGetCompressedTexImageARB_c
  glGetCompressedTextureImageEXT_c
  glGetCompressedTextureImage_c
  glGetCompressedTextureSubImage_c
  glGetConvolutionFilterEXT_c
  glGetConvolutionFilter_c
  glGetConvolutionParameterfvEXT_c
  glGetConvolutionParameterfvEXT_p
  glGetConvolutionParameterfv_c
  glGetConvolutionParameterfv_p
  glGetConvolutionParameterivEXT_c
  glGetConvolutionParameterivEXT_p
  glGetConvolutionParameteriv_c
  glGetConvolutionParameteriv_p
  glGetCoverageModulationTableNV_c
  glGetDebugMessageLogAMD_c
  glGetDebugMessageLogAMD_p
  glGetDebugMessageLogARB_c
  glGetDebugMessageLogARB_p
  glGetDebugMessageLogKHR_c
  glGetDebugMessageLogKHR_p
  glGetDebugMessageLog_c
  glGetDebugMessageLog_p
  glGetDetailTexFuncSGIS_c
  glGetDetailTexFuncSGIS_p
  glGetDoubleIndexedvEXT_c
  glGetDoubleIndexedvEXT_p
  glGetDoublei_vEXT_c
  glGetDoublei_vEXT_p
  glGetDoublei_v_c
  glGetDoublei_v_p
  glGetDriverControlsQCOM_c
  glGetDriverControlStringQCOM_c
  glGetExtensionREGAL
  glGetFenceivNV_c
  glGetFinalCombinerInputParameterfvNV_c
  glGetFinalCombinerInputParameterivNV_c
  glGetFirstPerfQueryIdINTEL_c
  glGetFixedv_c
  glGetFloatIndexedvEXT_c
  glGetFloatIndexedvEXT_p
  glGetFloati_vEXT_c
  glGetFloati_vEXT_p
  glGetFloati_vNV_c
  glGetFloati_vNV_p
  glGetFloati_v_c
  glGetFloati_v_p
  glGetFogFuncSGIS_c
  glGetFogLayersSGIX_c
  glGetFragDataIndex
  glGetFragDataIndexEXT
  glGetFragDataLocationEXT
  glGetFragmentLightfvEXT_c
  glGetFragmentLightfvSGIX_c
  glGetFragmentLightfvSGIX_p
  glGetFragmentLightivEXT_c
  glGetFragmentLightivSGIX_c
  glGetFragmentLightivSGIX_p
  glGetFragmentMaterialfvEXT_c
  glGetFragmentMaterialfvSGIX_c
  glGetFragmentMaterialfvSGIX_p
  glGetFragmentMaterialivEXT_c
  glGetFragmentMaterialivSGIX_c
  glGetFragmentMaterialivSGIX_p
  glGetFragmentShadingRatesEXT_c
  glGetFragmentShadingRatesEXT_p
  glGetFramebufferAttachmentParameterivEXT_c
  glGetFramebufferAttachmentParameterivEXT_p
  glGetFramebufferAttachmentParameterivOES_c
  glGetFramebufferParameterfvAMD_c
  glGetFramebufferParameterivEXT_c
  glGetFramebufferParameterivEXT_p
  glGetFramebufferParameterivMESA_c
  glGetFramebufferParameterivMESA_p
  glGetFramebufferParameteriv_c
  glGetFramebufferParameteriv_p
  glGetFramebufferPixelLocalStorageSizeEXT
  glGetGraphicsResetStatus
  glGetGraphicsResetStatusARB
  glGetGraphicsResetStatusEXT
  glGetGraphicsResetStatusKHR
  glGetHandleARB
  glGetHistogramEXT_c
  glGetHistogramParameterfvEXT_c
  glGetHistogramParameterfvEXT_p
  glGetHistogramParameterfv_c
  glGetHistogramParameterfv_p
  glGetHistogramParameterivEXT_c
  glGetHistogramParameterivEXT_p
  glGetHistogramParameteriv_c
  glGetHistogramParameteriv_p
  glGetHistogram_c
  glGetImageHandleARB
  glGetImageHandleNV
  glGetImageTransformParameterfvHP_c
  glGetImageTransformParameterivHP_c
  glGetInfoLogARB_c
  glGetInfoLogARB_p
  glGetInteger64i_v_c
  glGetInteger64i_v_p
  glGetInteger64vAPPLE_c
  glGetInteger64vAPPLE_p
  glGetInteger64vEXT_c
  glGetInteger64vEXT_p
  glGetInteger64v_c
  glGetInteger64v_p
  glGetIntegerIndexedvEXT_c
  glGetIntegerIndexedvEXT_p
  glGetIntegeri_vEXT_c
  glGetIntegerui64i_vNV_c
  glGetIntegerui64vNV_c
  glGetInternalformati64v_c
  glGetInternalformati64v_p
  glGetInternalformativ_c
  glGetInternalformativ_p
  glGetInternalformatSampleivNV_c
  glGetInternalformatSampleivNV_p
  glGetInvariantBooleanvEXT_c
  glGetInvariantFloatvEXT_c
  glGetInvariantIntegervEXT_c
  glGetLightxv_c
  glGetLightxv_p
  glGetLocalConstantBooleanvEXT_c
  glGetLocalConstantFloatvEXT_c
  glGetLocalConstantIntegervEXT_c
  glGetMapAttribParameterfvNV_c
  glGetMapAttribParameterivNV_c
  glGetMapControlPointsNV_c
  glGetMapParameterfvNV_c
  glGetMapParameterivNV_c
  glGetMaterialxv_c
  glGetMaterialxv_p
  glGetMemoryObjectDetachedResourcesuivNV_c
  glGetMemoryObjectParameterivEXT_c
  glGetMinmaxEXT_c
  glGetMinmaxParameterfvEXT_c
  glGetMinmaxParameterfvEXT_p
  glGetMinmaxParameterfv_c
  glGetMinmaxParameterfv_p
  glGetMinmaxParameterivEXT_c
  glGetMinmaxParameterivEXT_p
  glGetMinmaxParameteriv_c
  glGetMinmaxParameteriv_p
  glGetMinmax_c
  glGetMPEGParameterfvSGIX_c
  glGetMPEGParameterivSGIX_c
  glGetMPEGPredictorSGIX_c
  glGetMPEGQuantTableubv_c
  glGetMultisamplefvNV_c
  glGetMultisamplefvNV_p
  glGetMultisamplefv_c
  glGetMultisamplefv_p
  glGetMultiTexEnvfvEXT_c
  glGetMultiTexEnvfvEXT_p
  glGetMultiTexEnvivEXT_c
  glGetMultiTexEnvivEXT_p
  glGetMultiTexGendvEXT_c
  glGetMultiTexGendvEXT_p
  glGetMultiTexGenfvEXT_c
  glGetMultiTexGenfvEXT_p
  glGetMultiTexGenivEXT_c
  glGetMultiTexGenivEXT_p
  glGetMultiTexImageEXT_c
  glGetMultiTexLevelParameterfvEXT_c
  glGetMultiTexLevelParameterfvEXT_p
  glGetMultiTexLevelParameterivEXT_c
  glGetMultiTexLevelParameterivEXT_p
  glGetMultiTexParameterfvEXT_c
  glGetMultiTexParameterfvEXT_p
  glGetMultiTexParameterIivEXT_c
  glGetMultiTexParameterIivEXT_p
  glGetMultiTexParameterIuivEXT_c
  glGetMultiTexParameterIuivEXT_p
  glGetMultiTexParameterivEXT_c
  glGetMultiTexParameterivEXT_p
  glGetNamedBufferParameteri64v_c
  glGetNamedBufferParameterivEXT_c
  glGetNamedBufferParameterivEXT_p
  glGetNamedBufferParameteriv_c
  glGetNamedBufferParameterui64vNV_c
  glGetNamedBufferParameterui64vNV_p
  glGetNamedBufferPointervEXT_c
  glGetNamedBufferPointerv_c
  glGetNamedBufferSubDataEXT_c
  glGetNamedBufferSubData_c
  glGetNamedFramebufferAttachmentParameterivEXT_c
  glGetNamedFramebufferAttachmentParameterivEXT_p
  glGetNamedFramebufferAttachmentParameteriv_c
  glGetNamedFramebufferParameterfvAMD_c
  glGetNamedFramebufferParameterivEXT_c
  glGetNamedFramebufferParameterivEXT_p
  glGetNamedFramebufferParameteriv_c
  glGetNamedProgramivEXT_c
  glGetNamedProgramivEXT_p
  glGetNamedProgramLocalParameterdvEXT_c
  glGetNamedProgramLocalParameterdvEXT_p
  glGetNamedProgramLocalParameterfvEXT_c
  glGetNamedProgramLocalParameterfvEXT_p
  glGetNamedProgramLocalParameterIivEXT_c
  glGetNamedProgramLocalParameterIivEXT_p
  glGetNamedProgramLocalParameterIuivEXT_c
  glGetNamedProgramLocalParameterIuivEXT_p
  glGetNamedProgramStringEXT_c
  glGetNamedRenderbufferParameterivEXT_c
  glGetNamedRenderbufferParameterivEXT_p
  glGetNamedRenderbufferParameteriv_c
  glGetNamedStringARB_c
  glGetNamedStringARB_p
  glGetNamedStringivARB_c
  glGetnColorTableARB_c
  glGetnCompressedTexImageARB_c
  glGetnCompressedTexImage_c
  glGetnConvolutionFilterARB_c
  glGetNextPerfQueryIdINTEL_c
  glGetnHistogramARB_c
  glGetnMapdvARB_c
  glGetnMapdvARB_p
  glGetnMapfvARB_c
  glGetnMapfvARB_p
  glGetnMapivARB_c
  glGetnMapivARB_p
  glGetnMinmaxARB_c
  glGetNonlinLightfvSGIX_c
  glGetNonlinMaterialfvSGIX_c
  glGetnPixelMapfvARB_c
  glGetnPixelMapfvARB_p
  glGetnPixelMapuivARB_c
  glGetnPixelMapuivARB_p
  glGetnPixelMapusvARB_c
  glGetnPixelMapusvARB_p
  glGetnPolygonStippleARB_c
  glGetnPolygonStippleARB_p
  glGetnSeparableFilterARB_c
  glGetnTexImageARB_c
  glGetnTexImage_c
  glGetnUniformdvARB_c
  glGetnUniformdvARB_p
  glGetnUniformdv_c
  glGetnUniformdv_p
  glGetnUniformfvARB_c
  glGetnUniformfvARB_p
  glGetnUniformfvEXT_c
  glGetnUniformfvEXT_p
  glGetnUniformfvKHR_c
  glGetnUniformfvKHR_p
  glGetnUniformfv_c
  glGetnUniformfv_p
  glGetnUniformi64vARB_c
  glGetnUniformi64vARB_p
  glGetnUniformivARB_c
  glGetnUniformivARB_p
  glGetnUniformivEXT_c
  glGetnUniformivEXT_p
  glGetnUniformivKHR_c
  glGetnUniformivKHR_p
  glGetnUniformiv_c
  glGetnUniformiv_p
  glGetnUniformui64vARB_c
  glGetnUniformui64vARB_p
  glGetnUniformuivARB_c
  glGetnUniformuivARB_p
  glGetnUniformuivKHR_c
  glGetnUniformuivKHR_p
  glGetnUniformuiv_c
  glGetnUniformuiv_p
  glGetObjectBufferfvATI_c
  glGetObjectBufferfvATI_p
  glGetObjectBufferivATI_c
  glGetObjectBufferivATI_p
  glGetObjectLabelEXT_c
  glGetObjectLabelEXT_p
  glGetObjectLabelKHR_c
  glGetObjectLabelKHR_p
  glGetObjectLabel_c
  glGetObjectLabel_p
  glGetObjectParameterfvARB_c
  glGetObjectParameterivAPPLE_c
  glGetObjectParameterivARB_c
  glGetObjectPtrLabelKHR_c
  glGetObjectPtrLabel_c
  glGetOcclusionQueryivNV_c
  glGetOcclusionQueryuivNV_c
  glGetPathColorGenfvNV_c
  glGetPathColorGenivNV_c
  glGetPathCommandsNV_c
  glGetPathCoordsNV_c
  glGetPathDashArrayNV_c
  glGetPathLengthNV
  glGetPathMetricRangeNV_c
  glGetPathMetricsNV_c
  glGetPathParameterfvNV_c
  glGetPathParameterfvNV_p
  glGetPathParameterivNV_c
  glGetPathParameterivNV_p
  glGetPathSpacingNV_c
  glGetPathTexGenfvNV_c
  glGetPathTexGenivNV_c
  glGetPerfCounterInfoINTEL_c
  glGetPerfMonitorCounterDataAMD_c
  glGetPerfMonitorCounterDataAMD_p
  glGetPerfMonitorCounterInfoAMD_c
  glGetPerfMonitorCountersAMD_c
  glGetPerfMonitorCountersAMD_p
  glGetPerfMonitorCounterStringAMD_c
  glGetPerfMonitorCounterStringAMD_p
  glGetPerfMonitorGroupsAMD_c
  glGetPerfMonitorGroupsAMD_p
  glGetPerfMonitorGroupStringAMD_c
  glGetPerfMonitorGroupStringAMD_p
  glGetPerfQueryDataINTEL_c
  glGetPerfQueryIdByNameINTEL_c
  glGetPerfQueryInfoINTEL_c
  glGetPixelTransformParameterfvEXT_c
  glGetPixelTransformParameterfvSGI_c
  glGetPixelTransformParameterivEXT_c
  glGetPixelTransformParameterivSGI_c
  glGetPointerIndexedvEXT_c
  glGetPointeri_vEXT_c
  glGetPointervEXT_c
  glGetPointervKHR_c
  glGetProcAddressREGAL_c
  glGetProgramBinaryOES_c
  glGetProgramBinary_c
  glGetProgramBinary_p
  glGetProgramEnvParameterdvARB_c
  glGetProgramEnvParameterdvARB_p
  glGetProgramEnvParameterfvARB_c
  glGetProgramEnvParameterfvARB_p
  glGetProgramInterfaceiv_c
  glGetProgramInterfaceiv_p
  glGetProgramivARB_c
  glGetProgramivARB_p
  glGetProgramivNV_c
  glGetProgramivNV_p
  glGetProgramLocalParameterdvARB_c
  glGetProgramLocalParameterdvARB_p
  glGetProgramLocalParameterfvARB_c
  glGetProgramLocalParameterfvARB_p
  glGetProgramNamedParameterdvNV_c
  glGetProgramNamedParameterdvNV_p
  glGetProgramNamedParameterfvNV_c
  glGetProgramNamedParameterfvNV_p
  glGetProgramParameterdvNV_c
  glGetProgramParameterdvNV_p
  glGetProgramParameterfvNV_c
  glGetProgramParameterfvNV_p
  glGetProgramPipelineInfoLog_c
  glGetProgramPipelineInfoLog_p
  glGetProgramPipelineiv_c
  glGetProgramPipelineiv_p
  glGetProgramResourcefvNV_c
  glGetProgramResourcefvNV_p
  glGetProgramResourceIndex
  glGetProgramResourceiv_c
  glGetProgramResourceiv_p
  glGetProgramResourceLocation
  glGetProgramResourceLocationIndex
  glGetProgramResourceLocationIndexEXT
  glGetProgramResourceName_c
  glGetProgramResourceName_p
  glGetProgramStageiv_c
  glGetProgramStageiv_p
  glGetProgramStringARB_c
  glGetProgramStringNV_c
  glGetQueryBufferObjecti64v
  glGetQueryBufferObjectiv
  glGetQueryBufferObjectui64v
  glGetQueryBufferObjectuiv
  glGetQueryIndexediv_c
  glGetQueryIndexediv_p
  glGetQueryivANGLE_c
  glGetQueryivARB_c
  glGetQueryivARB_p
  glGetQueryivEXT_c
  glGetQueryivEXT_p
  glGetQueryObjecti64vANGLE_c
  glGetQueryObjecti64vEXT_c
  glGetQueryObjecti64vEXT_p
  glGetQueryObjecti64v_c
  glGetQueryObjecti64v_p
  glGetQueryObjectivANGLE_c
  glGetQueryObjectivARB_c
  glGetQueryObjectivARB_p
  glGetQueryObjectivEXT_c
  glGetQueryObjectivEXT_p
  glGetQueryObjectui64vANGLE_c
  glGetQueryObjectui64vEXT_c
  glGetQueryObjectui64vEXT_p
  glGetQueryObjectui64v_c
  glGetQueryObjectui64v_p
  glGetQueryObjectuivANGLE_c
  glGetQueryObjectuivARB_c
  glGetQueryObjectuivARB_p
  glGetQueryObjectuivEXT_c
  glGetQueryObjectuivEXT_p
  glGetRenderbufferParameterivEXT_c
  glGetRenderbufferParameterivEXT_p
  glGetRenderbufferParameterivOES_c
  glGetSamplerParameterfv_c
  glGetSamplerParameterfv_p
  glGetSamplerParameterIivEXT_c
  glGetSamplerParameterIivEXT_p
  glGetSamplerParameterIivOES_c
  glGetSamplerParameterIiv_c
  glGetSamplerParameterIiv_p
  glGetSamplerParameterIuivEXT_c
  glGetSamplerParameterIuivEXT_p
  glGetSamplerParameterIuivOES_c
  glGetSamplerParameterIuiv_c
  glGetSamplerParameterIuiv_p
  glGetSamplerParameteriv_c
  glGetSamplerParameteriv_p
  glGetSemaphoreParameterivNV_c
  glGetSemaphoreParameterui64vEXT_c
  glGetSeparableFilterEXT_c
  glGetSeparableFilter_c
  glGetShaderPrecisionFormat_c
  glGetShaderPrecisionFormat_p
  glGetShaderSourceARB_c
  glGetShaderSourceARB_p
  glGetShadingRateImagePaletteNV_c
  glGetShadingRateImagePaletteNV_p
  glGetShadingRateSampleLocationivNV_c
  glGetShadingRateSampleLocationivNV_p
  glGetSharpenTexFuncSGIS_c
  glGetSharpenTexFuncSGIS_p
  glGetStageIndexNV
  glGetSubroutineIndex
  glGetSubroutineUniformLocation
  glGetSyncivAPPLE_c
  glGetSyncivAPPLE_p
  glGetSynciv_c
  glGetSynciv_p
  glGetTexBumpParameterfvATI_c
  glGetTexBumpParameterivATI_c
  glGetTexEnvxv_c
  glGetTexEnvxv_p
  glGetTexFilterFuncSGIS_c
  glGetTexGenfvOES_c
  glGetTexGenivOES_c
  glGetTexGenxvOES_c
  glGetTexParameterIivEXT_c
  glGetTexParameterIivEXT_p
  glGetTexParameterIivOES_c
  glGetTexParameterIuivEXT_c
  glGetTexParameterIuivEXT_p
  glGetTexParameterIuivOES_c
  glGetTexParameterPointervAPPLE_c
  glGetTexParameterxv_c
  glGetTexParameterxv_p
  glGetTextureHandleARB
  glGetTextureHandleIMG
  glGetTextureHandleNV
  glGetTextureImageEXT_c
  glGetTextureImage_c
  glGetTextureLevelParameterfvEXT_c
  glGetTextureLevelParameterfvEXT_p
  glGetTextureLevelParameterfv_c
  glGetTextureLevelParameterivEXT_c
  glGetTextureLevelParameterivEXT_p
  glGetTextureLevelParameteriv_c
  glGetTextureParameterfvEXT_c
  glGetTextureParameterfvEXT_p
  glGetTextureParameterfv_c
  glGetTextureParameterIivEXT_c
  glGetTextureParameterIivEXT_p
  glGetTextureParameterIiv_c
  glGetTextureParameterIuivEXT_c
  glGetTextureParameterIuivEXT_p
  glGetTextureParameterIuiv_c
  glGetTextureParameterivEXT_c
  glGetTextureParameterivEXT_p
  glGetTextureParameteriv_c
  glGetTextureSamplerHandleARB
  glGetTextureSamplerHandleIMG
  glGetTextureSamplerHandleNV
  glGetTextureSubImage_c
  glGetTrackMatrixivNV_c
  glGetTrackMatrixivNV_p
  glGetTransformFeedbacki64_v_c
  glGetTransformFeedbackiv_c
  glGetTransformFeedbacki_v_c
  glGetTransformFeedbackVaryingEXT_c
  glGetTransformFeedbackVaryingEXT_p
  glGetTransformFeedbackVaryingNV_c
  glGetTransformFeedbackVaryingNV_p
  glGetTranslatedShaderSourceANGLE_c
  glGetTranslatedShaderSourceANGLE_p
  glGetUniformBufferSizeEXT
  glGetUniformdv_c
  glGetUniformfvARB_c
  glGetUniformi64vARB_c
  glGetUniformi64vNV_c
  glGetUniformivARB_c
  glGetUniformLocationARB
  glGetUniformOffsetEXT
  glGetUniformSubroutineuiv_c
  glGetUniformSubroutineuiv_p
  glGetUniformui64vARB_c
  glGetUniformui64vNV_c
  glGetUniformuivEXT_c
  glGetUnsignedBytei_vEXT_c
  glGetUnsignedBytevEXT_c
  glGetUnsignedBytevEXT_p
  glGetVariantArrayObjectfvATI_c
  glGetVariantArrayObjectfvATI_p
  glGetVariantArrayObjectivATI_c
  glGetVariantArrayObjectivATI_p
  glGetVariantBooleanvEXT_c
  glGetVariantFloatvEXT_c
  glGetVariantIntegervEXT_c
  glGetVariantPointervEXT_c
  glGetVaryingLocationNV
  glGetVectorOperationSGIX
  glGetVertexArrayIndexed64iv_c
  glGetVertexArrayIndexediv_c
  glGetVertexArrayIntegeri_vEXT_c
  glGetVertexArrayIntegervEXT_c
  glGetVertexArrayiv_c
  glGetVertexArrayPointeri_vEXT_c
  glGetVertexArrayPointervEXT_c
  glGetVertexAttribArrayObjectfvATI_c
  glGetVertexAttribArrayObjectfvATI_p
  glGetVertexAttribArrayObjectivATI_c
  glGetVertexAttribArrayObjectivATI_p
  glGetVertexAttribdvARB_c
  glGetVertexAttribdvARB_p
  glGetVertexAttribdvNV_c
  glGetVertexAttribdvNV_p
  glGetVertexAttribfvARB_c
  glGetVertexAttribfvARB_p
  glGetVertexAttribfvNV_c
  glGetVertexAttribfvNV_p
  glGetVertexAttribIivEXT_c
  glGetVertexAttribIivEXT_p
  glGetVertexAttribIuivEXT_c
  glGetVertexAttribIuivEXT_p
  glGetVertexAttribivARB_c
  glGetVertexAttribivARB_p
  glGetVertexAttribivNV_c
  glGetVertexAttribivNV_p
  glGetVertexAttribLdvEXT_c
  glGetVertexAttribLdvEXT_p
  glGetVertexAttribLdv_c
  glGetVertexAttribLdv_p
  glGetVertexAttribLi64vNV_c
  glGetVertexAttribLi64vNV_p
  glGetVertexAttribLui64vARB_c
  glGetVertexAttribLui64vNV_c
  glGetVertexAttribLui64vNV_p
  glGetVertexAttribPointervARB_c
  glGetVertexAttribPointervNV_c
  glGetVideoCaptureivNV_c
  glGetVideoCaptureStreamdvNV_c
  glGetVideoCaptureStreamfvNV_c
  glGetVideoCaptureStreamivNV_c
  glGetVideoi64vNV_c
  glGetVideoivNV_c
  glGetVideoui64vNV_c
  glGetVideouivNV_c
  glGetVkProcAddrNV
  glGlobalAlphaFactorbSUN
  glGlobalAlphaFactordSUN
  glGlobalAlphaFactorfSUN
  glGlobalAlphaFactoriSUN
  glGlobalAlphaFactorsSUN
  glGlobalAlphaFactorubSUN
  glGlobalAlphaFactoruiSUN
  glGlobalAlphaFactorusSUN
  glHistogram
  glHistogramEXT
  glIglooInterfaceSGIX_c
  glImageTransformParameterfHP
  glImageTransformParameterfvHP_c
  glImageTransformParameteriHP
  glImageTransformParameterivHP_c
  glImportMemoryFdEXT
  glImportMemoryWin32HandleEXT_c
  glImportMemoryWin32NameEXT_c
  glImportSemaphoreFdEXT
  glImportSemaphoreWin32HandleEXT_c
  glImportSemaphoreWin32NameEXT_c
  glImportSyncEXT
  glIndexFormatNV
  glIndexFuncEXT
  glIndexMaterialEXT
  glIndexPointerEXT_c
  glIndexPointerListIBM_c
  glInsertComponentEXT
  glInsertEventMarkerEXT
  glInterleavedTextureCoordSetsSGIS
  glInterpolatePathsNV
  glInvalidateBufferData
  glInvalidateBufferSubData
  glInvalidateFramebuffer_c
  glInvalidateFramebuffer_p
  glInvalidateNamedFramebufferData_c
  glInvalidateNamedFramebufferData_p
  glInvalidateNamedFramebufferSubData_c
  glInvalidateNamedFramebufferSubData_p
  glInvalidateSubFramebuffer_c
  glInvalidateSubFramebuffer_p
  glInvalidateTexImage
  glInvalidateTexSubImage
  glIsAsyncMarkerSGIX
  glIsBufferARB
  glIsBufferResidentNV
  glIsCommandListNV
  glIsEnablediEXT
  glIsEnabledIndexedEXT
  glIsEnablediNV
  glIsEnablediOES
  glIsFenceAPPLE
  glIsFenceNV
  glIsFramebufferEXT
  glIsFramebufferOES
  glIsImageHandleResidentARB
  glIsImageHandleResidentNV
  glIsMemoryObjectEXT
  glIsMPEGPredictorSGIX
  glIsNameAMD
  glIsNamedBufferResidentNV
  glIsNamedStringARB
  glIsObjectBufferATI
  glIsOcclusionQueryNV
  glIsPathNV
  glIsPointInFillPathNV
  glIsPointInStrokePathNV
  glIsProgramARB
  glIsProgramNV
  glIsProgramPipeline
  glIsQueryANGLE
  glIsQueryARB
  glIsQueryEXT
  glIsRenderbufferEXT
  glIsRenderbufferOES
  glIsSampler
  glIsSemaphoreEXT
  glIsStateNV
  glIsSupportedREGAL
  glIsSync
  glIsSyncAPPLE
  glIsTextureEXT
  glIsTextureHandleResidentARB
  glIsTextureHandleResidentNV
  glIsTransformFeedback
  glIsTransformFeedbackNV
  glIsVariantEnabledEXT
  glIsVertexArrayAPPLE
  glIsVertexArrayOES
  glIsVertexArraySGIX
  glIsVertexAttribEnabledAPPLE
  glLabelObjectEXT
  glLGPUCopyImageSubDataNVX
  glLGPUInterlockNVX
  glLGPUNamedBufferSubDataNVX_c
  glLightEnviEXT
  glLightModelx
  glLightModelxv_c
  glLightModelxv_p
  glLightx
  glLightxv_c
  glLightxv_p
  glLineWidthx
  glLinkProgramARB
  glListDrawCommandsStatesClientNV_c
  glLoadIdentityDeformationMapSGIX
  glLoadMatrixx_c
  glLoadMatrixx_p
  glLoadPaletteFromModelViewMatrixOES
  glLoadProgramNV
  glLoadTransposeMatrixdARB_c
  glLoadTransposeMatrixdARB_p
  glLoadTransposeMatrixfARB_c
  glLoadTransposeMatrixfARB_p
  glLockArraysEXT
  glLogMessageCallbackREGAL
  glMakeBufferNonResidentNV
  glMakeBufferResidentNV
  glMakeImageHandleNonResidentARB
  glMakeImageHandleNonResidentNV
  glMakeImageHandleResidentARB
  glMakeImageHandleResidentNV
  glMakeNamedBufferNonResidentNV
  glMakeNamedBufferResidentNV
  glMakeTextureHandleNonResidentARB
  glMakeTextureHandleNonResidentNV
  glMakeTextureHandleResidentARB
  glMakeTextureHandleResidentNV
  glMapBufferARB_c
  glMapBufferOES_c
  glMapBufferRangeEXT_c
  glMapControlPointsNV_c
  glMapNamedBufferEXT_c
  glMapNamedBufferRangeEXT_c
  glMapNamedBufferRange_c
  glMapNamedBuffer_c
  glMapObjectBufferATI_c
  glMapParameterfvNV_c
  glMapParameterivNV_c
  glMapTexture2DINTEL_c
  glMapTexture2DINTEL_p
  glMapVertexAttrib1dAPPLE_c
  glMapVertexAttrib1fAPPLE_c
  glMapVertexAttrib2dAPPLE_c
  glMapVertexAttrib2fAPPLE_c
  glMaterialx
  glMaterialxv_c
  glMaterialxv_p
  glMatrixFrustumEXT
  glMatrixIndexPointerARB_c
  glMatrixIndexPointerOES_c
  glMatrixIndexubvARB_c
  glMatrixIndexubvARB_p
  glMatrixIndexuivARB_c
  glMatrixIndexuivARB_p
  glMatrixIndexusvARB_c
  glMatrixIndexusvARB_p
  glMatrixLoad3x2fNV_c
  glMatrixLoad3x3fNV_c
  glMatrixLoaddEXT_c
  glMatrixLoaddEXT_p
  glMatrixLoadfEXT_c
  glMatrixLoadfEXT_p
  glMatrixLoadIdentityEXT
  glMatrixLoadTranspose3x3fNV_c
  glMatrixLoadTransposedEXT_c
  glMatrixLoadTransposedEXT_p
  glMatrixLoadTransposefEXT_c
  glMatrixLoadTransposefEXT_p
  glMatrixMult3x2fNV_c
  glMatrixMult3x3fNV_c
  glMatrixMultdEXT_c
  glMatrixMultdEXT_p
  glMatrixMultfEXT_c
  glMatrixMultfEXT_p
  glMatrixMultTranspose3x3fNV_c
  glMatrixMultTransposedEXT_c
  glMatrixMultTransposedEXT_p
  glMatrixMultTransposefEXT_c
  glMatrixMultTransposefEXT_p
  glMatrixOrthoEXT
  glMatrixPopEXT
  glMatrixPushEXT
  glMatrixRotatedEXT
  glMatrixRotatefEXT
  glMatrixScaledEXT
  glMatrixScalefEXT
  glMatrixTranslatedEXT
  glMatrixTranslatefEXT
  glMaxActiveShaderCoresARM
  glMaxShaderCompilerThreadsARB
  glMaxShaderCompilerThreadsKHR
  glMemoryBarrier
  glMemoryBarrierByRegion
  glMemoryBarrierEXT
  glMemoryObjectParameterivEXT_c
  glMeshBreadthSGIX
  glMeshStrideSGIX
  glMinmax
  glMinmaxEXT
  glMinSampleShading
  glMinSampleShadingARB
  glMinSampleShadingOES
  glMPEGPredictorSGIX_c
  glMPEGQuantTableubv_c
  glMulticastBarrierNV
  glMulticastBlitFramebufferNV
  glMulticastBufferSubDataNV_c
  glMulticastCopyBufferSubDataNV
  glMulticastCopyImageSubDataNV
  glMulticastFramebufferSampleLocationsfvNV_c
  glMulticastGetQueryObjecti64vNV_c
  glMulticastGetQueryObjectivNV_c
  glMulticastGetQueryObjectui64vNV_c
  glMulticastGetQueryObjectuivNV_c
  glMulticastScissorArrayvNVX_c
  glMulticastScissorArrayvNVX_p
  glMulticastViewportArrayvNVX_c
  glMulticastViewportArrayvNVX_p
  glMulticastViewportPositionWScaleNVX
  glMulticastWaitSyncNV
  glMultiDrawArraysEXT_c
  glMultiDrawArraysEXT_p
  glMultiDrawArraysIndirectAMD_c
  glMultiDrawArraysIndirectBindlessCountNV_c
  glMultiDrawArraysIndirectBindlessNV_c
  glMultiDrawArraysIndirectCountARB_c
  glMultiDrawArraysIndirectCount_c
  glMultiDrawArraysIndirectEXT_c
  glMultiDrawArraysIndirect_c
  glMultiDrawElementArrayAPPLE_c
  glMultiDrawElementArrayAPPLE_p
  glMultiDrawElementsBaseVertexEXT_c
  glMultiDrawElementsBaseVertex_c
  glMultiDrawElementsEXT_c
  glMultiDrawElementsIndirectAMD_c
  glMultiDrawElementsIndirectBindlessCountNV_c
  glMultiDrawElementsIndirectBindlessNV_c
  glMultiDrawElementsIndirectCountARB_c
  glMultiDrawElementsIndirectCount_c
  glMultiDrawElementsIndirectEXT_c
  glMultiDrawElementsIndirect_c
  glMultiDrawMeshTasksIndirectCountEXT
  glMultiDrawMeshTasksIndirectCountNV
  glMultiDrawMeshTasksIndirectEXT
  glMultiDrawMeshTasksIndirectNV
  glMultiDrawRangeElementArrayAPPLE_c
  glMultiDrawRangeElementArrayAPPLE_p
  glMultiModeDrawArraysIBM_c
  glMultiModeDrawElementsIBM_c
  glMultisampleSubRectPosSGIS
  glMultiTexBufferEXT
  glMultiTexCoord1dARB
  glMultiTexCoord1dvARB_c
  glMultiTexCoord1dvARB_p
  glMultiTexCoord1fARB
  glMultiTexCoord1fvARB_c
  glMultiTexCoord1fvARB_p
  glMultiTexCoord1hNV
  glMultiTexCoord1hvNV_c
  glMultiTexCoord1hvNV_p
  glMultiTexCoord1iARB
  glMultiTexCoord1ivARB_c
  glMultiTexCoord1ivARB_p
  glMultiTexCoord1sARB
  glMultiTexCoord1svARB_c
  glMultiTexCoord1svARB_p
  glMultiTexCoord2dARB
  glMultiTexCoord2dvARB_c
  glMultiTexCoord2dvARB_p
  glMultiTexCoord2fARB
  glMultiTexCoord2fvARB_c
  glMultiTexCoord2fvARB_p
  glMultiTexCoord2hNV
  glMultiTexCoord2hvNV_c
  glMultiTexCoord2hvNV_p
  glMultiTexCoord2iARB
  glMultiTexCoord2ivARB_c
  glMultiTexCoord2ivARB_p
  glMultiTexCoord2sARB
  glMultiTexCoord2svARB_c
  glMultiTexCoord2svARB_p
  glMultiTexCoord3dARB
  glMultiTexCoord3dvARB_c
  glMultiTexCoord3dvARB_p
  glMultiTexCoord3fARB
  glMultiTexCoord3fvARB_c
  glMultiTexCoord3fvARB_p
  glMultiTexCoord3hNV
  glMultiTexCoord3hvNV_c
  glMultiTexCoord3hvNV_p
  glMultiTexCoord3iARB
  glMultiTexCoord3ivARB_c
  glMultiTexCoord3ivARB_p
  glMultiTexCoord3sARB
  glMultiTexCoord3svARB_c
  glMultiTexCoord3svARB_p
  glMultiTexCoord4dARB
  glMultiTexCoord4dvARB_c
  glMultiTexCoord4dvARB_p
  glMultiTexCoord4fARB
  glMultiTexCoord4fvARB_c
  glMultiTexCoord4fvARB_p
  glMultiTexCoord4hNV
  glMultiTexCoord4hvNV_c
  glMultiTexCoord4hvNV_p
  glMultiTexCoord4iARB
  glMultiTexCoord4ivARB_c
  glMultiTexCoord4ivARB_p
  glMultiTexCoord4sARB
  glMultiTexCoord4svARB_c
  glMultiTexCoord4svARB_p
  glMultiTexCoord4x
  glMultiTexCoordP1ui
  glMultiTexCoordP1uiv_c
  glMultiTexCoordP1uiv_p
  glMultiTexCoordP2ui
  glMultiTexCoordP2uiv_c
  glMultiTexCoordP2uiv_p
  glMultiTexCoordP3ui
  glMultiTexCoordP3uiv_c
  glMultiTexCoordP3uiv_p
  glMultiTexCoordP4ui
  glMultiTexCoordP4uiv_c
  glMultiTexCoordP4uiv_p
  glMultiTexCoordPointerEXT_c
  glMultiTexEnvfEXT
  glMultiTexEnvfvEXT_c
  glMultiTexEnvfvEXT_p
  glMultiTexEnviEXT
  glMultiTexEnvivEXT_c
  glMultiTexEnvivEXT_p
  glMultiTexGendEXT
  glMultiTexGendvEXT_c
  glMultiTexGendvEXT_p
  glMultiTexGenfEXT
  glMultiTexGenfvEXT_c
  glMultiTexGenfvEXT_p
  glMultiTexGeniEXT
  glMultiTexGenivEXT_c
  glMultiTexGenivEXT_p
  glMultiTexImage1DEXT_c
  glMultiTexImage2DEXT_c
  glMultiTexImage3DEXT_c
  glMultiTexParameterfEXT
  glMultiTexParameterfvEXT_c
  glMultiTexParameterfvEXT_p
  glMultiTexParameteriEXT
  glMultiTexParameterIivEXT_c
  glMultiTexParameterIivEXT_p
  glMultiTexParameterIuivEXT_c
  glMultiTexParameterIuivEXT_p
  glMultiTexParameterivEXT_c
  glMultiTexParameterivEXT_p
  glMultiTexRenderbufferEXT
  glMultiTexSubImage1DEXT_c
  glMultiTexSubImage2DEXT_c
  glMultiTexSubImage3DEXT_c
  glMultMatrixx_c
  glMultMatrixx_p
  glMultTransposeMatrixdARB_c
  glMultTransposeMatrixdARB_p
  glMultTransposeMatrixfARB_c
  glMultTransposeMatrixfARB_p
  glNamedBufferAttachMemoryNV
  glNamedBufferDataEXT_c
  glNamedBufferData_c
  glNamedBufferPageCommitmentMemNV
  glNamedBufferStorageExternalEXT
  glNamedBufferStorageEXT_c
  glNamedBufferStorageMemEXT
  glNamedBufferStorage_c
  glNamedBufferSubDataEXT_c
  glNamedBufferSubData_c
  glNamedCopyBufferSubDataEXT
  glNamedFramebufferDrawBuffer
  glNamedFramebufferDrawBuffers_c
  glNamedFramebufferDrawBuffers_p
  glNamedFramebufferParameteri
  glNamedFramebufferParameteriEXT
  glNamedFramebufferReadBuffer
  glNamedFramebufferRenderbuffer
  glNamedFramebufferRenderbufferEXT
  glNamedFramebufferSampleLocationsfvARB_c
  glNamedFramebufferSampleLocationsfvNV_c
  glNamedFramebufferSamplePositionsfvAMD_c
  glNamedFramebufferTexture
  glNamedFramebufferTexture1DEXT
  glNamedFramebufferTexture2DEXT
  glNamedFramebufferTexture3DEXT
  glNamedFramebufferTextureEXT
  glNamedFramebufferTextureFaceEXT
  glNamedFramebufferTextureLayer
  glNamedFramebufferTextureLayerEXT
  glNamedFramebufferTextureMultiviewOVR
  glNamedProgramLocalParameter4dEXT
  glNamedProgramLocalParameter4dvEXT_c
  glNamedProgramLocalParameter4dvEXT_p
  glNamedProgramLocalParameter4fEXT
  glNamedProgramLocalParameter4fvEXT_c
  glNamedProgramLocalParameter4fvEXT_p
  glNamedProgramLocalParameterI4iEXT
  glNamedProgramLocalParameterI4ivEXT_c
  glNamedProgramLocalParameterI4ivEXT_p
  glNamedProgramLocalParameterI4uiEXT
  glNamedProgramLocalParameterI4uivEXT_c
  glNamedProgramLocalParameterI4uivEXT_p
  glNamedProgramLocalParameters4fvEXT_c
  glNamedProgramLocalParameters4fvEXT_p
  glNamedProgramLocalParametersI4ivEXT_c
  glNamedProgramLocalParametersI4ivEXT_p
  glNamedProgramLocalParametersI4uivEXT_c
  glNamedProgramLocalParametersI4uivEXT_p
  glNamedProgramStringEXT_c
  glNamedRenderbufferStorage
  glNamedRenderbufferStorageEXT
  glNamedRenderbufferStorageMultisample
  glNamedRenderbufferStorageMultisampleAdvancedAMD
  glNamedRenderbufferStorageMultisampleCoverageEXT
  glNamedRenderbufferStorageMultisampleEXT
  glNamedStringARB
  glNewBufferRegion
  glNewObjectBufferATI_c
  glNonlinLightfvSGIX_c
  glNonlinMaterialfvSGIX_c
  glNormal3fVertex3fSUN
  glNormal3fVertex3fvSUN_c
  glNormal3fVertex3fvSUN_p
  glNormal3hNV
  glNormal3hvNV_c
  glNormal3hvNV_p
  glNormal3x
  glNormalFormatNV
  glNormalP3ui
  glNormalP3uiv_c
  glNormalP3uiv_p
  glNormalPointerEXT_c
  glNormalPointerListIBM_c
  glNormalPointervINTEL_c
  glNormalStream3bATI
  glNormalStream3bvATI_c
  glNormalStream3bvATI_p
  glNormalStream3dATI
  glNormalStream3dvATI_c
  glNormalStream3dvATI_p
  glNormalStream3fATI
  glNormalStream3fvATI_c
  glNormalStream3fvATI_p
  glNormalStream3iATI
  glNormalStream3ivATI_c
  glNormalStream3ivATI_p
  glNormalStream3sATI
  glNormalStream3svATI_c
  glNormalStream3svATI_p
  glObjectLabel
  glObjectLabelKHR
  glObjectPtrLabelKHR_c
  glObjectPtrLabel_c
  glObjectPurgeableAPPLE
  glObjectUnpurgeableAPPLE
  glOrthof
  glOrthofOES
  glOrthox
  glPassTexCoordATI
  glPatchParameterfv_c
  glPatchParameterfv_p
  glPatchParameteri
  glPatchParameteriEXT
  glPathColorGenNV_c
  glPathCommandsNV_c
  glPathCoordsNV_c
  glPathCoverDepthFuncNV
  glPathDashArrayNV_c
  glPathDashArrayNV_p
  glPathFogGenNV
  glPathGlyphIndexArrayNV_c
  glPathGlyphIndexRangeNV_c
  glPathGlyphIndexRangeNV_p
  glPathGlyphRangeNV_c
  glPathGlyphsNV_c
  glPathMemoryGlyphIndexArrayNV_c
  glPathParameterfNV
  glPathParameterfvNV_c
  glPathParameteriNV
  glPathParameterivNV_c
  glPathStencilDepthOffsetNV
  glPathStencilFuncNV
  glPathStringNV_c
  glPathSubCommandsNV_c
  glPathSubCoordsNV_c
  glPathTexGenNV_c
  glPauseTransformFeedback
  glPauseTransformFeedbackNV
  glPixelDataRangeNV_c
  glPixelTexGenSGIX
  glPixelTransformParameterfEXT
  glPixelTransformParameterfSGI
  glPixelTransformParameterfvEXT_c
  glPixelTransformParameterfvEXT_p
  glPixelTransformParameterfvSGI_c
  glPixelTransformParameteriEXT
  glPixelTransformParameteriSGI
  glPixelTransformParameterivEXT_c
  glPixelTransformParameterivEXT_p
  glPixelTransformParameterivSGI_c
  glPixelTransformSGI
  glPNTrianglesfATI
  glPNTrianglesiATI
  glPointAlongPathNV_c
  glPointAlongPathNV_p
  glPointParameterfARB
  glPointParameterfEXT
  glPointParameterfSGIS
  glPointParameterfvARB_c
  glPointParameterfvARB_p
  glPointParameterfvEXT_c
  glPointParameterfvEXT_p
  glPointParameterfvSGIS_c
  glPointParameterfvSGIS_p
  glPointParameteriNV
  glPointParameterivNV_c
  glPointParameterivNV_p
  glPointParameterx
  glPointParameterxv_c
  glPointParameterxv_p
  glPointSizePointerOES_c
  glPointSizex
  glPollAsyncSGIX_c
  glPollAsyncSGIX_p
  glPolygonModeNV
  glPolygonOffsetClamp
  glPolygonOffsetClampEXT
  glPolygonOffsetEXT
  glPolygonOffsetx
  glPopDebugGroup
  glPopDebugGroupKHR
  glPopGroupMarkerEXT
  glPresentFrameDualFillNV
  glPresentFrameKeyedNV
  glPrimitiveBoundingBox
  glPrimitiveBoundingBoxARB
  glPrimitiveBoundingBoxEXT
  glPrimitiveRestartIndexNV
  glPrimitiveRestartNV
  glPrioritizeTexturesEXT_c
  glPrioritizeTexturesEXT_p
  glPrioritizeVertexArraysSGIX_c
  glProgramBinaryOES_c
  glProgramBinary_c
  glProgramBufferParametersfvNV_c
  glProgramBufferParametersfvNV_p
  glProgramBufferParametersIivNV_c
  glProgramBufferParametersIivNV_p
  glProgramBufferParametersIuivNV_c
  glProgramBufferParametersIuivNV_p
  glProgramEnvParameter4dARB
  glProgramEnvParameter4dvARB_c
  glProgramEnvParameter4dvARB_p
  glProgramEnvParameter4fARB
  glProgramEnvParameter4fvARB_c
  glProgramEnvParameter4fvARB_p
  glProgramEnvParameterI4iNV
  glProgramEnvParameterI4ivNV_c
  glProgramEnvParameterI4ivNV_p
  glProgramEnvParameterI4uiNV
  glProgramEnvParameterI4uivNV_c
  glProgramEnvParameterI4uivNV_p
  glProgramEnvParameters4fvEXT_c
  glProgramEnvParameters4fvEXT_p
  glProgramEnvParametersI4ivNV_c
  glProgramEnvParametersI4ivNV_p
  glProgramEnvParametersI4uivNV_c
  glProgramEnvParametersI4uivNV_p
  glProgramLocalParameter4dARB
  glProgramLocalParameter4dvARB_c
  glProgramLocalParameter4dvARB_p
  glProgramLocalParameter4fARB
  glProgramLocalParameter4fvARB_c
  glProgramLocalParameter4fvARB_p
  glProgramLocalParameterI4iNV
  glProgramLocalParameterI4ivNV_c
  glProgramLocalParameterI4ivNV_p
  glProgramLocalParameterI4uiNV
  glProgramLocalParameterI4uivNV_c
  glProgramLocalParameterI4uivNV_p
  glProgramLocalParameters4fvEXT_c
  glProgramLocalParameters4fvEXT_p
  glProgramLocalParametersI4ivNV_c
  glProgramLocalParametersI4ivNV_p
  glProgramLocalParametersI4uivNV_c
  glProgramLocalParametersI4uivNV_p
  glProgramNamedParameter4dNV
  glProgramNamedParameter4dvNV_c
  glProgramNamedParameter4dvNV_p
  glProgramNamedParameter4fNV
  glProgramNamedParameter4fvNV_c
  glProgramNamedParameter4fvNV_p
  glProgramParameter4dNV
  glProgramParameter4dvNV_c
  glProgramParameter4dvNV_p
  glProgramParameter4fNV
  glProgramParameter4fvNV_c
  glProgramParameter4fvNV_p
  glProgramParameteri
  glProgramParameteriARB
  glProgramParameteriEXT
  glProgramParameters4dvNV_c
  glProgramParameters4dvNV_p
  glProgramParameters4fvNV_c
  glProgramParameters4fvNV_p
  glProgramPathFragmentInputGenNV_c
  glProgramStringARB_c
  glProgramUniform1d
  glProgramUniform1dv_c
  glProgramUniform1dv_p
  glProgramUniform1f
  glProgramUniform1fEXT
  glProgramUniform1fvEXT_c
  glProgramUniform1fvEXT_p
  glProgramUniform1fv_c
  glProgramUniform1fv_p
  glProgramUniform1i
  glProgramUniform1i64ARB
  glProgramUniform1i64NV
  glProgramUniform1i64vARB_c
  glProgramUniform1i64vARB_p
  glProgramUniform1i64vNV_c
  glProgramUniform1i64vNV_p
  glProgramUniform1iEXT
  glProgramUniform1ivEXT_c
  glProgramUniform1ivEXT_p
  glProgramUniform1iv_c
  glProgramUniform1iv_p
  glProgramUniform1ui
  glProgramUniform1ui64ARB
  glProgramUniform1ui64NV
  glProgramUniform1ui64vARB_c
  glProgramUniform1ui64vARB_p
  glProgramUniform1ui64vNV_c
  glProgramUniform1ui64vNV_p
  glProgramUniform1uiEXT
  glProgramUniform1uivEXT_c
  glProgramUniform1uivEXT_p
  glProgramUniform1uiv_c
  glProgramUniform1uiv_p
  glProgramUniform2d
  glProgramUniform2dv_c
  glProgramUniform2dv_p
  glProgramUniform2f
  glProgramUniform2fEXT
  glProgramUniform2fvEXT_c
  glProgramUniform2fvEXT_p
  glProgramUniform2fv_c
  glProgramUniform2fv_p
  glProgramUniform2i
  glProgramUniform2i64ARB
  glProgramUniform2i64NV
  glProgramUniform2i64vARB_c
  glProgramUniform2i64vARB_p
  glProgramUniform2i64vNV_c
  glProgramUniform2i64vNV_p
  glProgramUniform2iEXT
  glProgramUniform2ivEXT_c
  glProgramUniform2ivEXT_p
  glProgramUniform2iv_c
  glProgramUniform2iv_p
  glProgramUniform2ui
  glProgramUniform2ui64ARB
  glProgramUniform2ui64NV
  glProgramUniform2ui64vARB_c
  glProgramUniform2ui64vARB_p
  glProgramUniform2ui64vNV_c
  glProgramUniform2ui64vNV_p
  glProgramUniform2uiEXT
  glProgramUniform2uivEXT_c
  glProgramUniform2uivEXT_p
  glProgramUniform2uiv_c
  glProgramUniform2uiv_p
  glProgramUniform3d
  glProgramUniform3dv_c
  glProgramUniform3dv_p
  glProgramUniform3f
  glProgramUniform3fEXT
  glProgramUniform3fvEXT_c
  glProgramUniform3fvEXT_p
  glProgramUniform3fv_c
  glProgramUniform3fv_p
  glProgramUniform3i
  glProgramUniform3i64ARB
  glProgramUniform3i64NV
  glProgramUniform3i64vARB_c
  glProgramUniform3i64vARB_p
  glProgramUniform3i64vNV_c
  glProgramUniform3i64vNV_p
  glProgramUniform3iEXT
  glProgramUniform3ivEXT_c
  glProgramUniform3ivEXT_p
  glProgramUniform3iv_c
  glProgramUniform3iv_p
  glProgramUniform3ui
  glProgramUniform3ui64ARB
  glProgramUniform3ui64NV
  glProgramUniform3ui64vARB_c
  glProgramUniform3ui64vARB_p
  glProgramUniform3ui64vNV_c
  glProgramUniform3ui64vNV_p
  glProgramUniform3uiEXT
  glProgramUniform3uivEXT_c
  glProgramUniform3uivEXT_p
  glProgramUniform3uiv_c
  glProgramUniform3uiv_p
  glProgramUniform4d
  glProgramUniform4dv_c
  glProgramUniform4dv_p
  glProgramUniform4f
  glProgramUniform4fEXT
  glProgramUniform4fvEXT_c
  glProgramUniform4fvEXT_p
  glProgramUniform4fv_c
  glProgramUniform4fv_p
  glProgramUniform4i
  glProgramUniform4i64ARB
  glProgramUniform4i64NV
  glProgramUniform4i64vARB_c
  glProgramUniform4i64vARB_p
  glProgramUniform4i64vNV_c
  glProgramUniform4i64vNV_p
  glProgramUniform4iEXT
  glProgramUniform4ivEXT_c
  glProgramUniform4ivEXT_p
  glProgramUniform4iv_c
  glProgramUniform4iv_p
  glProgramUniform4ui
  glProgramUniform4ui64ARB
  glProgramUniform4ui64NV
  glProgramUniform4ui64vARB_c
  glProgramUniform4ui64vARB_p
  glProgramUniform4ui64vNV_c
  glProgramUniform4ui64vNV_p
  glProgramUniform4uiEXT
  glProgramUniform4uivEXT_c
  glProgramUniform4uivEXT_p
  glProgramUniform4uiv_c
  glProgramUniform4uiv_p
  glProgramUniformHandleui64ARB
  glProgramUniformHandleui64IMG
  glProgramUniformHandleui64NV
  glProgramUniformHandleui64vARB_c
  glProgramUniformHandleui64vARB_p
  glProgramUniformHandleui64vIMG_c
  glProgramUniformHandleui64vIMG_p
  glProgramUniformHandleui64vNV_c
  glProgramUniformHandleui64vNV_p
  glProgramUniformMatrix2dv_c
  glProgramUniformMatrix2dv_p
  glProgramUniformMatrix2fvEXT_c
  glProgramUniformMatrix2fvEXT_p
  glProgramUniformMatrix2fv_c
  glProgramUniformMatrix2fv_p
  glProgramUniformMatrix2x3dv_c
  glProgramUniformMatrix2x3dv_p
  glProgramUniformMatrix2x3fvEXT_c
  glProgramUniformMatrix2x3fvEXT_p
  glProgramUniformMatrix2x3fv_c
  glProgramUniformMatrix2x3fv_p
  glProgramUniformMatrix2x4dv_c
  glProgramUniformMatrix2x4dv_p
  glProgramUniformMatrix2x4fvEXT_c
  glProgramUniformMatrix2x4fvEXT_p
  glProgramUniformMatrix2x4fv_c
  glProgramUniformMatrix2x4fv_p
  glProgramUniformMatrix3dv_c
  glProgramUniformMatrix3dv_p
  glProgramUniformMatrix3fvEXT_c
  glProgramUniformMatrix3fvEXT_p
  glProgramUniformMatrix3fv_c
  glProgramUniformMatrix3fv_p
  glProgramUniformMatrix3x2dv_c
  glProgramUniformMatrix3x2dv_p
  glProgramUniformMatrix3x2fvEXT_c
  glProgramUniformMatrix3x2fvEXT_p
  glProgramUniformMatrix3x2fv_c
  glProgramUniformMatrix3x2fv_p
  glProgramUniformMatrix3x4dv_c
  glProgramUniformMatrix3x4dv_p
  glProgramUniformMatrix3x4fvEXT_c
  glProgramUniformMatrix3x4fvEXT_p
  glProgramUniformMatrix3x4fv_c
  glProgramUniformMatrix3x4fv_p
  glProgramUniformMatrix4dv_c
  glProgramUniformMatrix4dv_p
  glProgramUniformMatrix4fvEXT_c
  glProgramUniformMatrix4fvEXT_p
  glProgramUniformMatrix4fv_c
  glProgramUniformMatrix4fv_p
  glProgramUniformMatrix4x2dv_c
  glProgramUniformMatrix4x2dv_p
  glProgramUniformMatrix4x2fvEXT_c
  glProgramUniformMatrix4x2fvEXT_p
  glProgramUniformMatrix4x2fv_c
  glProgramUniformMatrix4x2fv_p
  glProgramUniformMatrix4x3dv_c
  glProgramUniformMatrix4x3dv_p
  glProgramUniformMatrix4x3fvEXT_c
  glProgramUniformMatrix4x3fvEXT_p
  glProgramUniformMatrix4x3fv_c
  glProgramUniformMatrix4x3fv_p
  glProgramUniformui64NV
  glProgramUniformui64vNV_c
  glProgramUniformui64vNV_p
  glProgramVertexLimitNV
  glProvokingVertex
  glProvokingVertexEXT
  glPushClientAttribDefaultEXT
  glPushDebugGroup
  glPushDebugGroupKHR
  glPushGroupMarkerEXT
  glQueryCounter
  glQueryCounterANGLE
  glQueryCounterEXT
  glQueryObjectParameteruiAMD
  glRasterSamplesEXT
  glReadBufferIndexedEXT
  glReadBufferNV
  glReadBufferRegion
  glReadnPixelsARB_c
  glReadnPixelsEXT_c
  glReadnPixelsKHR_c
  glReadnPixels_c
  glReadVideoPixelsSUN_c
  glReferencePlaneSGIX_c
  glReferencePlaneSGIX_p
  glReleaseKeyedMutexWin32EXT
  glReleaseShaderCompiler
  glRenderbufferStorageEXT
  glRenderbufferStorageMultisampleAdvancedAMD
  glRenderbufferStorageMultisampleANGLE
  glRenderbufferStorageMultisampleAPPLE
  glRenderbufferStorageMultisampleCoverageNV
  glRenderbufferStorageMultisampleEXT
  glRenderbufferStorageMultisampleIMG
  glRenderbufferStorageMultisampleNV
  glRenderbufferStorageOES
  glRenderGpuMaskNV
  glReplacementCodePointerSUN_c
  glReplacementCodeubSUN
  glReplacementCodeubvSUN_c
  glReplacementCodeuiColor3fVertex3fSUN
  glReplacementCodeuiColor3fVertex3fvSUN_c
  glReplacementCodeuiColor3fVertex3fvSUN_p
  glReplacementCodeuiColor4fNormal3fVertex3fSUN
  glReplacementCodeuiColor4fNormal3fVertex3fvSUN_c
  glReplacementCodeuiColor4fNormal3fVertex3fvSUN_p
  glReplacementCodeuiColor4ubVertex3fSUN
  glReplacementCodeuiColor4ubVertex3fvSUN_c
  glReplacementCodeuiColor4ubVertex3fvSUN_p
  glReplacementCodeuiNormal3fVertex3fSUN
  glReplacementCodeuiNormal3fVertex3fvSUN_c
  glReplacementCodeuiNormal3fVertex3fvSUN_p
  glReplacementCodeuiSUN
  glReplacementCodeuiTexCoord2fColor4fNormal3fVertex3fSUN
  glReplacementCodeuiTexCoord2fColor4fNormal3fVertex3fvSUN_c
  glReplacementCodeuiTexCoord2fColor4fNormal3fVertex3fvSUN_p
  glReplacementCodeuiTexCoord2fNormal3fVertex3fSUN
  glReplacementCodeuiTexCoord2fNormal3fVertex3fvSUN_c
  glReplacementCodeuiTexCoord2fNormal3fVertex3fvSUN_p
  glReplacementCodeuiTexCoord2fVertex3fSUN
  glReplacementCodeuiTexCoord2fVertex3fvSUN_c
  glReplacementCodeuiTexCoord2fVertex3fvSUN_p
  glReplacementCodeuiVertex3fSUN
  glReplacementCodeuiVertex3fvSUN_c
  glReplacementCodeuiVertex3fvSUN_p
  glReplacementCodeuivSUN_c
  glReplacementCodeusSUN
  glReplacementCodeusvSUN_c
  glRequestResidentProgramsNV_c
  glRequestResidentProgramsNV_p
  glResetHistogram
  glResetHistogramEXT
  glResetMemoryObjectParameterNV
  glResetMinmax
  glResetMinmaxEXT
  glResizeBuffersMESA
  glResolveDepthValuesNV
  glResolveMultisampleFramebufferAPPLE
  glResumeTransformFeedback
  glResumeTransformFeedbackNV
  glRotatex
  glSampleCoverageARB
  glSampleCoveragex
  glSampleMapATI
  glSampleMaskEXT
  glSampleMaski
  glSampleMaskIndexedNV
  glSampleMaskSGIS
  glSamplePatternEXT
  glSamplePatternSGIS
  glSamplerParameterf
  glSamplerParameterfv_c
  glSamplerParameterfv_p
  glSamplerParameteri
  glSamplerParameterIivEXT_c
  glSamplerParameterIivEXT_p
  glSamplerParameterIivOES_c
  glSamplerParameterIiv_c
  glSamplerParameterIiv_p
  glSamplerParameterIuivEXT_c
  glSamplerParameterIuivEXT_p
  glSamplerParameterIuivOES_c
  glSamplerParameterIuiv_c
  glSamplerParameterIuiv_p
  glSamplerParameteriv_c
  glSamplerParameteriv_p
  glScalex
  glScissorArrayvNV_c
  glScissorArrayvNV_p
  glScissorArrayv_c
  glScissorArrayv_p
  glScissorExclusiveArrayvNV_c
  glScissorExclusiveArrayvNV_p
  glScissorExclusiveNV
  glScissorIndexed
  glScissorIndexedNV
  glScissorIndexedvNV_c
  glScissorIndexedvNV_p
  glScissorIndexedv_c
  glScissorIndexedv_p
  glSecondaryColor3bEXT
  glSecondaryColor3bvEXT_c
  glSecondaryColor3bvEXT_p
  glSecondaryColor3dEXT
  glSecondaryColor3dvEXT_c
  glSecondaryColor3dvEXT_p
  glSecondaryColor3fEXT
  glSecondaryColor3fvEXT_c
  glSecondaryColor3fvEXT_p
  glSecondaryColor3hNV
  glSecondaryColor3hvNV_c
  glSecondaryColor3hvNV_p
  glSecondaryColor3iEXT
  glSecondaryColor3ivEXT_c
  glSecondaryColor3ivEXT_p
  glSecondaryColor3sEXT
  glSecondaryColor3svEXT_c
  glSecondaryColor3svEXT_p
  glSecondaryColor3ubEXT
  glSecondaryColor3ubvEXT_c
  glSecondaryColor3ubvEXT_p
  glSecondaryColor3uiEXT
  glSecondaryColor3uivEXT_c
  glSecondaryColor3uivEXT_p
  glSecondaryColor3usEXT
  glSecondaryColor3usvEXT_c
  glSecondaryColor3usvEXT_p
  glSecondaryColorFormatNV
  glSecondaryColorP3ui
  glSecondaryColorP3uiv_c
  glSecondaryColorP3uiv_p
  glSecondaryColorPointerEXT_c
  glSecondaryColorPointerListIBM_c
  glSelectPerfMonitorCountersAMD_c
  glSelectPerfMonitorCountersAMD_p
  glSelectTextureCoordSetSGIS
  glSelectTextureSGIS
  glSelectTextureTransformSGIS
  glSemaphoreParameterivNV_c
  glSemaphoreParameterui64vEXT_c
  glSeparableFilter2DEXT_c
  glSeparableFilter2D_c
  glSetFenceAPPLE
  glSetFenceNV
  glSetFragmentShaderConstantATI_c
  glSetFragmentShaderConstantATI_p
  glSetInvariantEXT_c
  glSetLocalConstantEXT_c
  glSetMultisamplefvAMD_c
  glSetMultisamplefvAMD_p
  glShaderBinary_c
  glShaderOp1EXT
  glShaderOp2EXT
  glShaderOp3EXT
  glShaderSourceARB_c
  glShaderSourceARB_p
  glShaderStorageBlockBinding
  glShadingRateCombinerOpsEXT
  glShadingRateEXT
  glShadingRateImageBarrierNV
  glShadingRateImagePaletteNV_c
  glShadingRateImagePaletteNV_p
  glShadingRateQCOM
  glShadingRateSampleOrderCustomNV_c
  glShadingRateSampleOrderNV
  glSharpenTexFuncSGIS_c
  glSharpenTexFuncSGIS_p
  glSignalSemaphoreEXT_c
  glSignalSemaphoreui64NVX_c
  glSignalSemaphoreui64NVX_p
  glSignalVkFenceNV
  glSignalVkSemaphoreNV
  glSpecializeShaderARB_c
  glSpecializeShaderARB_p
  glSpecializeShader_c
  glSpecializeShader_p
  glSpriteParameterfSGIX
  glSpriteParameterfvSGIX_c
  glSpriteParameteriSGIX
  glSpriteParameterivSGIX_c
  glStartTilingQCOM
  glStateCaptureNV
  glStencilFillPathInstancedNV_c
  glStencilFillPathNV
  glStencilFuncSeparateATI
  glStencilOpSeparateATI
  glStencilOpValueAMD
  glStencilStrokePathInstancedNV_c
  glStencilStrokePathNV
  glStencilThenCoverFillPathInstancedNV_c
  glStencilThenCoverFillPathNV
  glStencilThenCoverStrokePathInstancedNV_c
  glStencilThenCoverStrokePathNV
  glStereoParameterfNV
  glStereoParameteriNV
  glStringMarkerGREMEDY_c
  glSubpixelPrecisionBiasNV
  glSwapMPEGPredictorsSGIX
  glSwizzleEXT
  glSyncTextureINTEL
  glTagSampleBufferSGIX
  glTangentPointerEXT_c
  glTbufferMask3DFX
  glTessellationFactorAMD
  glTessellationModeAMD
  glTestFenceAPPLE
  glTestFenceNV
  glTestObjectAPPLE
  glTexAttachMemoryNV
  glTexBufferARB
  glTexBufferEXT
  glTexBufferOES
  glTexBufferRange
  glTexBufferRangeEXT
  glTexBufferRangeOES
  glTexBumpParameterfvATI_c
  glTexBumpParameterivATI_c
  glTexCoord1hNV
  glTexCoord1hvNV_c
  glTexCoord1hvNV_p
  glTexCoord2fColor3fVertex3fSUN
  glTexCoord2fColor3fVertex3fvSUN_c
  glTexCoord2fColor3fVertex3fvSUN_p
  glTexCoord2fColor4fNormal3fVertex3fSUN
  glTexCoord2fColor4fNormal3fVertex3fvSUN_c
  glTexCoord2fColor4fNormal3fVertex3fvSUN_p
  glTexCoord2fColor4ubVertex3fSUN
  glTexCoord2fColor4ubVertex3fvSUN_c
  glTexCoord2fColor4ubVertex3fvSUN_p
  glTexCoord2fNormal3fVertex3fSUN
  glTexCoord2fNormal3fVertex3fvSUN_c
  glTexCoord2fNormal3fVertex3fvSUN_p
  glTexCoord2fVertex3fSUN
  glTexCoord2fVertex3fvSUN_c
  glTexCoord2fVertex3fvSUN_p
  glTexCoord2hNV
  glTexCoord2hvNV_c
  glTexCoord2hvNV_p
  glTexCoord3hNV
  glTexCoord3hvNV_c
  glTexCoord3hvNV_p
  glTexCoord4fColor4fNormal3fVertex4fSUN
  glTexCoord4fColor4fNormal3fVertex4fvSUN_c
  glTexCoord4fColor4fNormal3fVertex4fvSUN_p
  glTexCoord4fVertex4fSUN
  glTexCoord4fVertex4fvSUN_c
  glTexCoord4fVertex4fvSUN_p
  glTexCoord4hNV
  glTexCoord4hvNV_c
  glTexCoord4hvNV_p
  glTexCoordFormatNV
  glTexCoordP1ui
  glTexCoordP1uiv_c
  glTexCoordP1uiv_p
  glTexCoordP2ui
  glTexCoordP2uiv_c
  glTexCoordP2uiv_p
  glTexCoordP3ui
  glTexCoordP3uiv_c
  glTexCoordP3uiv_p
  glTexCoordP4ui
  glTexCoordP4uiv_c
  glTexCoordP4uiv_p
  glTexCoordPointerEXT_c
  glTexCoordPointerListIBM_c
  glTexCoordPointervINTEL_c
  glTexEnvx
  glTexEnvxv_c
  glTexEnvxv_p
  glTexEstimateMotionQCOM
  glTexEstimateMotionRegionsQCOM
  glTexFilterFuncSGIS_c
  glTexFilterFuncSGIS_p
  glTexGenfOES
  glTexGenfvOES_c
  glTexGeniOES
  glTexGenivOES_c
  glTexGenxOES
  glTexGenxvOES_c
  glTexImage2DMultisample
  glTexImage2DMultisampleCoverageNV
  glTexImage3DEXT_c
  glTexImage3DMultisample
  glTexImage3DMultisampleCoverageNV
  glTexImage3DNV_c
  glTexImage3DOES_c
  glTexImage4DSGIS_c
  glTexPageCommitmentARB
  glTexPageCommitmentEXT
  glTexPageCommitmentMemNV
  glTexParameterIivEXT_c
  glTexParameterIivEXT_p
  glTexParameterIivOES_c
  glTexParameterIuivEXT_c
  glTexParameterIuivEXT_p
  glTexParameterIuivOES_c
  glTexParameterx
  glTexParameterxv_c
  glTexParameterxv_p
  glTexRenderbufferNV
  glTexScissorFuncINTEL
  glTexScissorINTEL
  glTexStorage1D
  glTexStorage1DEXT
  glTexStorage2D
  glTexStorage2DEXT
  glTexStorage2DMultisample
  glTexStorage3D
  glTexStorage3DEXT
  glTexStorage3DMultisample
  glTexStorage3DMultisampleOES
  glTexStorageAttribs2DEXT_c
  glTexStorageAttribs3DEXT_c
  glTexStorageMem1DEXT
  glTexStorageMem2DEXT
  glTexStorageMem2DMultisampleEXT
  glTexStorageMem3DEXT
  glTexStorageMem3DMultisampleEXT
  glTexStorageSparseAMD
  glTexSubImage1DEXT_c
  glTexSubImage2DEXT_c
  glTexSubImage3DEXT_c
  glTexSubImage3DNV_c
  glTexSubImage3DOES_c
  glTexSubImage4DSGIS_c
  glTextureAttachMemoryNV
  glTextureBarrier
  glTextureBarrierNV
  glTextureBuffer
  glTextureBufferEXT
  glTextureBufferRange
  glTextureBufferRangeEXT
  glTextureFogSGIX
  glTextureFoveationParametersQCOM
  glTextureImage1DEXT_c
  glTextureImage2DEXT_c
  glTextureImage2DMultisampleCoverageNV
  glTextureImage2DMultisampleNV
  glTextureImage3DEXT_c
  glTextureImage3DMultisampleCoverageNV
  glTextureImage3DMultisampleNV
  glTextureLightEXT
  glTextureMaterialEXT
  glTextureNormalEXT
  glTexturePageCommitmentEXT
  glTexturePageCommitmentMemNV
  glTextureParameterf
  glTextureParameterfEXT
  glTextureParameterfvEXT_c
  glTextureParameterfvEXT_p
  glTextureParameterfv_c
  glTextureParameterfv_p
  glTextureParameteri
  glTextureParameteriEXT
  glTextureParameterIivEXT_c
  glTextureParameterIivEXT_p
  glTextureParameterIiv_c
  glTextureParameterIiv_p
  glTextureParameterIuivEXT_c
  glTextureParameterIuivEXT_p
  glTextureParameterIuiv_c
  glTextureParameterIuiv_p
  glTextureParameterivEXT_c
  glTextureParameterivEXT_p
  glTextureParameteriv_c
  glTextureParameteriv_p
  glTextureRangeAPPLE_c
  glTextureRenderbufferEXT
  glTextureStorage1D
  glTextureStorage1DEXT
  glTextureStorage2D
  glTextureStorage2DEXT
  glTextureStorage2DMultisample
  glTextureStorage2DMultisampleEXT
  glTextureStorage3D
  glTextureStorage3DEXT
  glTextureStorage3DMultisample
  glTextureStorage3DMultisampleEXT
  glTextureStorageMem1DEXT
  glTextureStorageMem2DEXT
  glTextureStorageMem2DMultisampleEXT
  glTextureStorageMem3DEXT
  glTextureStorageMem3DMultisampleEXT
  glTextureStorageSparseAMD
  glTextureSubImage1DEXT_c
  glTextureSubImage1D_c
  glTextureSubImage2DEXT_c
  glTextureSubImage2D_c
  glTextureSubImage3DEXT_c
  glTextureSubImage3D_c
  glTextureView
  glTextureViewEXT
  glTextureViewOES
  glTrackMatrixNV
  glTransformFeedbackAttribsNV_c
  glTransformFeedbackBufferBase
  glTransformFeedbackBufferRange
  glTransformFeedbackVaryingsEXT_c
  glTransformFeedbackVaryingsEXT_p
  glTransformFeedbackVaryingsNV_c
  glTransformFeedbackVaryingsNV_p
  glTransformPathNV_c
  glTranslatex
  glUniform1d
  glUniform1dv_c
  glUniform1dv_p
  glUniform1fARB
  glUniform1fvARB_c
  glUniform1fvARB_p
  glUniform1i64ARB
  glUniform1i64NV
  glUniform1i64vARB_c
  glUniform1i64vARB_p
  glUniform1i64vNV_c
  glUniform1i64vNV_p
  glUniform1iARB
  glUniform1ivARB_c
  glUniform1ivARB_p
  glUniform1ui64ARB
  glUniform1ui64NV
  glUniform1ui64vARB_c
  glUniform1ui64vARB_p
  glUniform1ui64vNV_c
  glUniform1ui64vNV_p
  glUniform1uiEXT
  glUniform1uivEXT_c
  glUniform1uivEXT_p
  glUniform2d
  glUniform2dv_c
  glUniform2dv_p
  glUniform2fARB
  glUniform2fvARB_c
  glUniform2fvARB_p
  glUniform2i64ARB
  glUniform2i64NV
  glUniform2i64vARB_c
  glUniform2i64vARB_p
  glUniform2i64vNV_c
  glUniform2i64vNV_p
  glUniform2iARB
  glUniform2ivARB_c
  glUniform2ivARB_p
  glUniform2ui64ARB
  glUniform2ui64NV
  glUniform2ui64vARB_c
  glUniform2ui64vARB_p
  glUniform2ui64vNV_c
  glUniform2ui64vNV_p
  glUniform2uiEXT
  glUniform2uivEXT_c
  glUniform2uivEXT_p
  glUniform3d
  glUniform3dv_c
  glUniform3dv_p
  glUniform3fARB
  glUniform3fvARB_c
  glUniform3fvARB_p
  glUniform3i64ARB
  glUniform3i64NV
  glUniform3i64vARB_c
  glUniform3i64vARB_p
  glUniform3i64vNV_c
  glUniform3i64vNV_p
  glUniform3iARB
  glUniform3ivARB_c
  glUniform3ivARB_p
  glUniform3ui64ARB
  glUniform3ui64NV
  glUniform3ui64vARB_c
  glUniform3ui64vARB_p
  glUniform3ui64vNV_c
  glUniform3ui64vNV_p
  glUniform3uiEXT
  glUniform3uivEXT_c
  glUniform3uivEXT_p
  glUniform4d
  glUniform4dv_c
  glUniform4dv_p
  glUniform4fARB
  glUniform4fvARB_c
  glUniform4fvARB_p
  glUniform4i64ARB
  glUniform4i64NV
  glUniform4i64vARB_c
  glUniform4i64vARB_p
  glUniform4i64vNV_c
  glUniform4i64vNV_p
  glUniform4iARB
  glUniform4ivARB_c
  glUniform4ivARB_p
  glUniform4ui64ARB
  glUniform4ui64NV
  glUniform4ui64vARB_c
  glUniform4ui64vARB_p
  glUniform4ui64vNV_c
  glUniform4ui64vNV_p
  glUniform4uiEXT
  glUniform4uivEXT_c
  glUniform4uivEXT_p
  glUniformBufferEXT
  glUniformHandleui64ARB
  glUniformHandleui64IMG
  glUniformHandleui64NV
  glUniformHandleui64vARB_c
  glUniformHandleui64vARB_p
  glUniformHandleui64vIMG_c
  glUniformHandleui64vIMG_p
  glUniformHandleui64vNV_c
  glUniformHandleui64vNV_p
  glUniformMatrix2dv_c
  glUniformMatrix2dv_p
  glUniformMatrix2fvARB_c
  glUniformMatrix2fvARB_p
  glUniformMatrix2x3dv_c
  glUniformMatrix2x3dv_p
  glUniformMatrix2x3fvNV_c
  glUniformMatrix2x3fvNV_p
  glUniformMatrix2x4dv_c
  glUniformMatrix2x4dv_p
  glUniformMatrix2x4fvNV_c
  glUniformMatrix2x4fvNV_p
  glUniformMatrix3dv_c
  glUniformMatrix3dv_p
  glUniformMatrix3fvARB_c
  glUniformMatrix3fvARB_p
  glUniformMatrix3x2dv_c
  glUniformMatrix3x2dv_p
  glUniformMatrix3x2fvNV_c
  glUniformMatrix3x2fvNV_p
  glUniformMatrix3x4dv_c
  glUniformMatrix3x4dv_p
  glUniformMatrix3x4fvNV_c
  glUniformMatrix3x4fvNV_p
  glUniformMatrix4dv_c
  glUniformMatrix4dv_p
  glUniformMatrix4fvARB_c
  glUniformMatrix4fvARB_p
  glUniformMatrix4x2dv_c
  glUniformMatrix4x2dv_p
  glUniformMatrix4x2fvNV_c
  glUniformMatrix4x2fvNV_p
  glUniformMatrix4x3dv_c
  glUniformMatrix4x3dv_p
  glUniformMatrix4x3fvNV_c
  glUniformMatrix4x3fvNV_p
  glUniformSubroutinesuiv_c
  glUniformSubroutinesuiv_p
  glUniformui64NV
  glUniformui64vNV_c
  glUniformui64vNV_p
  glUnlockArraysEXT
  glUnmapBufferARB
  glUnmapBufferOES
  glUnmapNamedBuffer
  glUnmapNamedBufferEXT
  glUnmapObjectBufferATI
  glUnmapTexture2DINTEL
  glUpdateObjectBufferATI_c
  glUploadGpuMaskNVX
  glUseProgramObjectARB
  glUseProgramStages
  glUseShaderProgramEXT
  glValidateProgramARB
  glValidateProgramPipeline
  glVariantArrayObjectATI
  glVariantbvEXT_c
  glVariantdvEXT_c
  glVariantfvEXT_c
  glVariantivEXT_c
  glVariantPointerEXT_c
  glVariantsvEXT_c
  glVariantubvEXT_c
  glVariantuivEXT_c
  glVariantusvEXT_c
  glVDPAUFiniNV
  glVDPAUGetSurfaceivNV_c
  glVDPAUInitNV_c
  glVDPAUIsSurfaceNV
  glVDPAUMapSurfacesNV_c
  glVDPAURegisterOutputSurfaceNV_c
  glVDPAURegisterVideoSurfaceNV_c
  glVDPAURegisterVideoSurfaceWithPictureStructureNV_c
  glVDPAUSurfaceAccessNV
  glVDPAUUnmapSurfacesNV_c
  glVDPAUUnregisterSurfaceNV
  glVectorOperationSGIX
  glVertex2hNV
  glVertex2hvNV_c
  glVertex2hvNV_p
  glVertex3hNV
  glVertex3hvNV_c
  glVertex3hvNV_p
  glVertex4hNV
  glVertex4hvNV_c
  glVertex4hvNV_p
  glVertexArrayAttribBinding
  glVertexArrayAttribFormat
  glVertexArrayAttribIFormat
  glVertexArrayAttribLFormat
  glVertexArrayBindingDivisor
  glVertexArrayBindVertexBufferEXT
  glVertexArrayColorOffsetEXT
  glVertexArrayEdgeFlagOffsetEXT
  glVertexArrayElementBuffer
  glVertexArrayFogCoordOffsetEXT
  glVertexArrayIndexOffsetEXT
  glVertexArrayMultiTexCoordOffsetEXT
  glVertexArrayNormalOffsetEXT
  glVertexArrayParameteriAPPLE
  glVertexArrayRangeAPPLE_c
  glVertexArrayRangeNV_c
  glVertexArraySecondaryColorOffsetEXT
  glVertexArrayTexCoordOffsetEXT
  glVertexArrayVertexAttribBindingEXT
  glVertexArrayVertexAttribDivisorEXT
  glVertexArrayVertexAttribFormatEXT
  glVertexArrayVertexAttribIFormatEXT
  glVertexArrayVertexAttribIOffsetEXT
  glVertexArrayVertexAttribLFormatEXT
  glVertexArrayVertexAttribLOffsetEXT
  glVertexArrayVertexAttribOffsetEXT
  glVertexArrayVertexBindingDivisorEXT
  glVertexArrayVertexBuffer
  glVertexArrayVertexBuffers_c
  glVertexArrayVertexOffsetEXT
  glVertexAttrib1dARB
  glVertexAttrib1dNV
  glVertexAttrib1dvARB_c
  glVertexAttrib1dvARB_p
  glVertexAttrib1dvNV_c
  glVertexAttrib1dvNV_p
  glVertexAttrib1fARB
  glVertexAttrib1fNV
  glVertexAttrib1fvARB_c
  glVertexAttrib1fvARB_p
  glVertexAttrib1fvNV_c
  glVertexAttrib1fvNV_p
  glVertexAttrib1hNV
  glVertexAttrib1hvNV_c
  glVertexAttrib1hvNV_p
  glVertexAttrib1sARB
  glVertexAttrib1sNV
  glVertexAttrib1svARB_c
  glVertexAttrib1svARB_p
  glVertexAttrib1svNV_c
  glVertexAttrib1svNV_p
  glVertexAttrib2dARB
  glVertexAttrib2dNV
  glVertexAttrib2dvARB_c
  glVertexAttrib2dvARB_p
  glVertexAttrib2dvNV_c
  glVertexAttrib2dvNV_p
  glVertexAttrib2fARB
  glVertexAttrib2fNV
  glVertexAttrib2fvARB_c
  glVertexAttrib2fvARB_p
  glVertexAttrib2fvNV_c
  glVertexAttrib2fvNV_p
  glVertexAttrib2hNV
  glVertexAttrib2hvNV_c
  glVertexAttrib2hvNV_p
  glVertexAttrib2sARB
  glVertexAttrib2sNV
  glVertexAttrib2svARB_c
  glVertexAttrib2svARB_p
  glVertexAttrib2svNV_c
  glVertexAttrib2svNV_p
  glVertexAttrib3dARB
  glVertexAttrib3dNV
  glVertexAttrib3dvARB_c
  glVertexAttrib3dvARB_p
  glVertexAttrib3dvNV_c
  glVertexAttrib3dvNV_p
  glVertexAttrib3fARB
  glVertexAttrib3fNV
  glVertexAttrib3fvARB_c
  glVertexAttrib3fvARB_p
  glVertexAttrib3fvNV_c
  glVertexAttrib3fvNV_p
  glVertexAttrib3hNV
  glVertexAttrib3hvNV_c
  glVertexAttrib3hvNV_p
  glVertexAttrib3sARB
  glVertexAttrib3sNV
  glVertexAttrib3svARB_c
  glVertexAttrib3svARB_p
  glVertexAttrib3svNV_c
  glVertexAttrib3svNV_p
  glVertexAttrib4bvARB_c
  glVertexAttrib4bvARB_p
  glVertexAttrib4dARB
  glVertexAttrib4dNV
  glVertexAttrib4dvARB_c
  glVertexAttrib4dvARB_p
  glVertexAttrib4dvNV_c
  glVertexAttrib4dvNV_p
  glVertexAttrib4fARB
  glVertexAttrib4fNV
  glVertexAttrib4fvARB_c
  glVertexAttrib4fvARB_p
  glVertexAttrib4fvNV_c
  glVertexAttrib4fvNV_p
  glVertexAttrib4hNV
  glVertexAttrib4hvNV_c
  glVertexAttrib4hvNV_p
  glVertexAttrib4ivARB_c
  glVertexAttrib4ivARB_p
  glVertexAttrib4NbvARB_c
  glVertexAttrib4NbvARB_p
  glVertexAttrib4NivARB_c
  glVertexAttrib4NivARB_p
  glVertexAttrib4NsvARB_c
  glVertexAttrib4NsvARB_p
  glVertexAttrib4NubARB
  glVertexAttrib4NubvARB_c
  glVertexAttrib4NubvARB_p
  glVertexAttrib4NuivARB_c
  glVertexAttrib4NuivARB_p
  glVertexAttrib4NusvARB_c
  glVertexAttrib4NusvARB_p
  glVertexAttrib4sARB
  glVertexAttrib4sNV
  glVertexAttrib4svARB_c
  glVertexAttrib4svARB_p
  glVertexAttrib4svNV_c
  glVertexAttrib4svNV_p
  glVertexAttrib4ubNV
  glVertexAttrib4ubvARB_c
  glVertexAttrib4ubvARB_p
  glVertexAttrib4ubvNV_c
  glVertexAttrib4ubvNV_p
  glVertexAttrib4uivARB_c
  glVertexAttrib4uivARB_p
  glVertexAttrib4usvARB_c
  glVertexAttrib4usvARB_p
  glVertexAttribArrayObjectATI
  glVertexAttribBinding
  glVertexAttribDivisor
  glVertexAttribDivisorANGLE
  glVertexAttribDivisorARB
  glVertexAttribDivisorEXT
  glVertexAttribDivisorNV
  glVertexAttribFormat
  glVertexAttribFormatNV
  glVertexAttribI1iEXT
  glVertexAttribI1ivEXT_c
  glVertexAttribI1ivEXT_p
  glVertexAttribI1uiEXT
  glVertexAttribI1uivEXT_c
  glVertexAttribI1uivEXT_p
  glVertexAttribI2iEXT
  glVertexAttribI2ivEXT_c
  glVertexAttribI2ivEXT_p
  glVertexAttribI2uiEXT
  glVertexAttribI2uivEXT_c
  glVertexAttribI2uivEXT_p
  glVertexAttribI3iEXT
  glVertexAttribI3ivEXT_c
  glVertexAttribI3ivEXT_p
  glVertexAttribI3uiEXT
  glVertexAttribI3uivEXT_c
  glVertexAttribI3uivEXT_p
  glVertexAttribI4bvEXT_c
  glVertexAttribI4bvEXT_p
  glVertexAttribI4iEXT
  glVertexAttribI4ivEXT_c
  glVertexAttribI4ivEXT_p
  glVertexAttribI4svEXT_c
  glVertexAttribI4svEXT_p
  glVertexAttribI4ubvEXT_c
  glVertexAttribI4ubvEXT_p
  glVertexAttribI4uiEXT
  glVertexAttribI4uivEXT_c
  glVertexAttribI4uivEXT_p
  glVertexAttribI4usvEXT_c
  glVertexAttribI4usvEXT_p
  glVertexAttribIFormat
  glVertexAttribIFormatNV
  glVertexAttribIPointerEXT_c
  glVertexAttribL1d
  glVertexAttribL1dEXT
  glVertexAttribL1dvEXT_c
  glVertexAttribL1dvEXT_p
  glVertexAttribL1dv_c
  glVertexAttribL1dv_p
  glVertexAttribL1i64NV
  glVertexAttribL1i64vNV_c
  glVertexAttribL1i64vNV_p
  glVertexAttribL1ui64ARB
  glVertexAttribL1ui64NV
  glVertexAttribL1ui64vARB_c
  glVertexAttribL1ui64vNV_c
  glVertexAttribL1ui64vNV_p
  glVertexAttribL2d
  glVertexAttribL2dEXT
  glVertexAttribL2dvEXT_c
  glVertexAttribL2dvEXT_p
  glVertexAttribL2dv_c
  glVertexAttribL2dv_p
  glVertexAttribL2i64NV
  glVertexAttribL2i64vNV_c
  glVertexAttribL2i64vNV_p
  glVertexAttribL2ui64NV
  glVertexAttribL2ui64vNV_c
  glVertexAttribL2ui64vNV_p
  glVertexAttribL3d
  glVertexAttribL3dEXT
  glVertexAttribL3dvEXT_c
  glVertexAttribL3dvEXT_p
  glVertexAttribL3dv_c
  glVertexAttribL3dv_p
  glVertexAttribL3i64NV
  glVertexAttribL3i64vNV_c
  glVertexAttribL3i64vNV_p
  glVertexAttribL3ui64NV
  glVertexAttribL3ui64vNV_c
  glVertexAttribL3ui64vNV_p
  glVertexAttribL4d
  glVertexAttribL4dEXT
  glVertexAttribL4dvEXT_c
  glVertexAttribL4dvEXT_p
  glVertexAttribL4dv_c
  glVertexAttribL4dv_p
  glVertexAttribL4i64NV
  glVertexAttribL4i64vNV_c
  glVertexAttribL4i64vNV_p
  glVertexAttribL4ui64NV
  glVertexAttribL4ui64vNV_c
  glVertexAttribL4ui64vNV_p
  glVertexAttribLFormat
  glVertexAttribLFormatNV
  glVertexAttribLPointerEXT_c
  glVertexAttribLPointer_c
  glVertexAttribP1ui
  glVertexAttribP1uiv_c
  glVertexAttribP1uiv_p
  glVertexAttribP2ui
  glVertexAttribP2uiv_c
  glVertexAttribP2uiv_p
  glVertexAttribP3ui
  glVertexAttribP3uiv_c
  glVertexAttribP3uiv_p
  glVertexAttribP4ui
  glVertexAttribP4uiv_c
  glVertexAttribP4uiv_p
  glVertexAttribParameteriAMD
  glVertexAttribPointerARB_c
  glVertexAttribPointerNV_c
  glVertexAttribs1dvNV_c
  glVertexAttribs1dvNV_p
  glVertexAttribs1fvNV_c
  glVertexAttribs1fvNV_p
  glVertexAttribs1hvNV_c
  glVertexAttribs1hvNV_p
  glVertexAttribs1svNV_c
  glVertexAttribs1svNV_p
  glVertexAttribs2dvNV_c
  glVertexAttribs2dvNV_p
  glVertexAttribs2fvNV_c
  glVertexAttribs2fvNV_p
  glVertexAttribs2hvNV_c
  glVertexAttribs2hvNV_p
  glVertexAttribs2svNV_c
  glVertexAttribs2svNV_p
  glVertexAttribs3dvNV_c
  glVertexAttribs3dvNV_p
  glVertexAttribs3fvNV_c
  glVertexAttribs3fvNV_p
  glVertexAttribs3hvNV_c
  glVertexAttribs3hvNV_p
  glVertexAttribs3svNV_c
  glVertexAttribs3svNV_p
  glVertexAttribs4dvNV_c
  glVertexAttribs4dvNV_p
  glVertexAttribs4fvNV_c
  glVertexAttribs4fvNV_p
  glVertexAttribs4hvNV_c
  glVertexAttribs4hvNV_p
  glVertexAttribs4svNV_c
  glVertexAttribs4svNV_p
  glVertexAttribs4ubvNV_c
  glVertexAttribs4ubvNV_p
  glVertexBindingDivisor
  glVertexBlendARB
  glVertexBlendEnvfATI
  glVertexBlendEnviATI
  glVertexFormatNV
  glVertexP2ui
  glVertexP2uiv_c
  glVertexP2uiv_p
  glVertexP3ui
  glVertexP3uiv_c
  glVertexP3uiv_p
  glVertexP4ui
  glVertexP4uiv_c
  glVertexP4uiv_p
  glVertexPointerEXT_c
  glVertexPointerListIBM_c
  glVertexPointervINTEL_c
  glVertexStream1dATI
  glVertexStream1dvATI_c
  glVertexStream1dvATI_p
  glVertexStream1fATI
  glVertexStream1fvATI_c
  glVertexStream1fvATI_p
  glVertexStream1iATI
  glVertexStream1ivATI_c
  glVertexStream1ivATI_p
  glVertexStream1sATI
  glVertexStream1svATI_c
  glVertexStream1svATI_p
  glVertexStream2dATI
  glVertexStream2dvATI_c
  glVertexStream2dvATI_p
  glVertexStream2fATI
  glVertexStream2fvATI_c
  glVertexStream2fvATI_p
  glVertexStream2iATI
  glVertexStream2ivATI_c
  glVertexStream2ivATI_p
  glVertexStream2sATI
  glVertexStream2svATI_c
  glVertexStream2svATI_p
  glVertexStream3dATI
  glVertexStream3dvATI_c
  glVertexStream3dvATI_p
  glVertexStream3fATI
  glVertexStream3fvATI_c
  glVertexStream3fvATI_p
  glVertexStream3iATI
  glVertexStream3ivATI_c
  glVertexStream3ivATI_p
  glVertexStream3sATI
  glVertexStream3svATI_c
  glVertexStream3svATI_p
  glVertexStream4dATI
  glVertexStream4dvATI_c
  glVertexStream4dvATI_p
  glVertexStream4fATI
  glVertexStream4fvATI_c
  glVertexStream4fvATI_p
  glVertexStream4iATI
  glVertexStream4ivATI_c
  glVertexStream4ivATI_p
  glVertexStream4sATI
  glVertexStream4svATI_c
  glVertexStream4svATI_p
  glVertexWeightfEXT
  glVertexWeightfvEXT_c
  glVertexWeightfvEXT_p
  glVertexWeighthNV
  glVertexWeighthvNV_c
  glVertexWeighthvNV_p
  glVertexWeightPointerEXT_c
  glVideoCaptureNV_c
  glVideoCaptureStreamParameterdvNV_c
  glVideoCaptureStreamParameterfvNV_c
  glVideoCaptureStreamParameterivNV_c
  glViewportArrayvNV_c
  glViewportArrayvNV_p
  glViewportArrayv_c
  glViewportArrayv_p
  glViewportIndexedf
  glViewportIndexedfNV
  glViewportIndexedfvNV_c
  glViewportIndexedfvNV_p
  glViewportIndexedfv_c
  glViewportIndexedfv_p
  glViewportPositionWScaleNV
  glViewportSwizzleNV
  glWaitSemaphoreEXT_c
  glWaitSemaphoreui64NVX_c
  glWaitSemaphoreui64NVX_p
  glWaitSync
  glWaitSyncAPPLE
  glWaitVkSemaphoreNV
  glWeightbvARB_c
  glWeightbvARB_p
  glWeightdvARB_c
  glWeightdvARB_p
  glWeightfvARB_c
  glWeightfvARB_p
  glWeightivARB_c
  glWeightivARB_p
  glWeightPathsNV_c
  glWeightPathsNV_p
  glWeightPointerARB_c
  glWeightPointerOES_c
  glWeightsvARB_c
  glWeightsvARB_p
  glWeightubvARB_c
  glWeightubvARB_p
  glWeightuivARB_c
  glWeightuivARB_p
  glWeightusvARB_c
  glWeightusvARB_p
  glWindowPos2dARB
  glWindowPos2dMESA
  glWindowPos2dvARB_c
  glWindowPos2dvARB_p
  glWindowPos2dvMESA_c
  glWindowPos2dvMESA_p
  glWindowPos2fARB
  glWindowPos2fMESA
  glWindowPos2fvARB_c
  glWindowPos2fvARB_p
  glWindowPos2fvMESA_c
  glWindowPos2fvMESA_p
  glWindowPos2iARB
  glWindowPos2iMESA
  glWindowPos2ivARB_c
  glWindowPos2ivARB_p
  glWindowPos2ivMESA_c
  glWindowPos2ivMESA_p
  glWindowPos2sARB
  glWindowPos2sMESA
  glWindowPos2svARB_c
  glWindowPos2svARB_p
  glWindowPos2svMESA_c
  glWindowPos2svMESA_p
  glWindowPos3dARB
  glWindowPos3dMESA
  glWindowPos3dvARB_c
  glWindowPos3dvARB_p
  glWindowPos3dvMESA_c
  glWindowPos3dvMESA_p
  glWindowPos3fARB
  glWindowPos3fMESA
  glWindowPos3fvARB_c
  glWindowPos3fvARB_p
  glWindowPos3fvMESA_c
  glWindowPos3fvMESA_p
  glWindowPos3iARB
  glWindowPos3iMESA
  glWindowPos3ivARB_c
  glWindowPos3ivARB_p
  glWindowPos3ivMESA_c
  glWindowPos3ivMESA_p
  glWindowPos3sARB
  glWindowPos3sMESA
  glWindowPos3svARB_c
  glWindowPos3svARB_p
  glWindowPos3svMESA_c
  glWindowPos3svMESA_p
  glWindowPos4dMESA
  glWindowPos4dvMESA_c
  glWindowPos4dvMESA_p
  glWindowPos4fMESA
  glWindowPos4fvMESA_c
  glWindowPos4fvMESA_p
  glWindowPos4iMESA
  glWindowPos4ivMESA_c
  glWindowPos4ivMESA_p
  glWindowPos4sMESA
  glWindowPos4svMESA_c
  glWindowPos4svMESA_p
  glWindowRectanglesEXT_c
  glWindowRectanglesEXT_p
  glWriteMaskEXT
);
our %EXPORT_TAGS_GL = (
  'GL_3DFX_tbuffer' => [
    'glTbufferMask3DFX'
  ],
  'GL_AMD_debug_output' => [
    'glDebugMessageCallbackAMD_c',
    'glDebugMessageEnableAMD_c',
    'glDebugMessageEnableAMD_p',
    'glDebugMessageInsertAMD',
    'glGetDebugMessageLogAMD_c',
    'glGetDebugMessageLogAMD_p'
  ],
  'GL_AMD_draw_buffers_blend' => [
    'glBlendEquationIndexedAMD',
    'glBlendEquationSeparateIndexedAMD',
    'glBlendFuncIndexedAMD',
    'glBlendFuncSeparateIndexedAMD'
  ],
  'GL_AMD_framebuffer_multisample_advanced' => [
    'glNamedRenderbufferStorageMultisampleAdvancedAMD',
    'glRenderbufferStorageMultisampleAdvancedAMD'
  ],
  'GL_AMD_framebuffer_sample_positions' => [
    'glFramebufferSamplePositionsfvAMD_c',
    'glGetFramebufferParameterfvAMD_c',
    'glGetNamedFramebufferParameterfvAMD_c',
    'glNamedFramebufferSamplePositionsfvAMD_c'
  ],
  'GL_AMD_interleaved_elements' => [
    'glVertexAttribParameteriAMD'
  ],
  'GL_AMD_multi_draw_indirect' => [
    'glMultiDrawArraysIndirectAMD_c',
    'glMultiDrawElementsIndirectAMD_c'
  ],
  'GL_AMD_name_gen_delete' => [
    'glDeleteNamesAMD_c',
    'glDeleteNamesAMD_p',
    'glGenNamesAMD_c',
    'glGenNamesAMD_p',
    'glIsNameAMD'
  ],
  'GL_AMD_occlusion_query_event' => [
    'glQueryObjectParameteruiAMD'
  ],
  'GL_AMD_performance_monitor' => [
    'glBeginPerfMonitorAMD',
    'glDeletePerfMonitorsAMD_c',
    'glDeletePerfMonitorsAMD_p',
    'glEndPerfMonitorAMD',
    'glGenPerfMonitorsAMD_c',
    'glGenPerfMonitorsAMD_p',
    'glGetPerfMonitorCounterDataAMD_c',
    'glGetPerfMonitorCounterDataAMD_p',
    'glGetPerfMonitorCounterInfoAMD_c',
    'glGetPerfMonitorCounterStringAMD_c',
    'glGetPerfMonitorCounterStringAMD_p',
    'glGetPerfMonitorCountersAMD_c',
    'glGetPerfMonitorCountersAMD_p',
    'glGetPerfMonitorGroupStringAMD_c',
    'glGetPerfMonitorGroupStringAMD_p',
    'glGetPerfMonitorGroupsAMD_c',
    'glGetPerfMonitorGroupsAMD_p',
    'glSelectPerfMonitorCountersAMD_c',
    'glSelectPerfMonitorCountersAMD_p'
  ],
  'GL_AMD_sample_positions' => [
    'glSetMultisamplefvAMD_c',
    'glSetMultisamplefvAMD_p'
  ],
  'GL_AMD_sparse_texture' => [
    'glTexStorageSparseAMD',
    'glTextureStorageSparseAMD'
  ],
  'GL_AMD_stencil_operation_extended' => [
    'glStencilOpValueAMD'
  ],
  'GL_AMD_vertex_shader_tessellator' => [
    'glTessellationFactorAMD',
    'glTessellationModeAMD'
  ],
  'GL_ANGLE_framebuffer_blit' => [
    'glBlitFramebufferANGLE'
  ],
  'GL_ANGLE_framebuffer_multisample' => [
    'glRenderbufferStorageMultisampleANGLE'
  ],
  'GL_ANGLE_instanced_arrays' => [
    'glDrawArraysInstancedANGLE',
    'glDrawElementsInstancedANGLE_c',
    'glVertexAttribDivisorANGLE'
  ],
  'GL_ANGLE_timer_query' => [
    'glBeginQueryANGLE',
    'glDeleteQueriesANGLE_c',
    'glEndQueryANGLE',
    'glGenQueriesANGLE_c',
    'glGetQueryObjecti64vANGLE_c',
    'glGetQueryObjectivANGLE_c',
    'glGetQueryObjectui64vANGLE_c',
    'glGetQueryObjectuivANGLE_c',
    'glGetQueryivANGLE_c',
    'glIsQueryANGLE',
    'glQueryCounterANGLE'
  ],
  'GL_ANGLE_translated_shader_source' => [
    'glGetTranslatedShaderSourceANGLE_c',
    'glGetTranslatedShaderSourceANGLE_p'
  ],
  'GL_APPLE_copy_texture_levels' => [
    'glCopyTextureLevelsAPPLE'
  ],
  'GL_APPLE_element_array' => [
    'glDrawElementArrayAPPLE',
    'glDrawRangeElementArrayAPPLE',
    'glElementPointerAPPLE_c',
    'glMultiDrawElementArrayAPPLE_c',
    'glMultiDrawElementArrayAPPLE_p',
    'glMultiDrawRangeElementArrayAPPLE_c',
    'glMultiDrawRangeElementArrayAPPLE_p'
  ],
  'GL_APPLE_fence' => [
    'glDeleteFencesAPPLE_c',
    'glDeleteFencesAPPLE_p',
    'glFinishFenceAPPLE',
    'glFinishObjectAPPLE',
    'glGenFencesAPPLE_c',
    'glGenFencesAPPLE_p',
    'glIsFenceAPPLE',
    'glSetFenceAPPLE',
    'glTestFenceAPPLE',
    'glTestObjectAPPLE'
  ],
  'GL_APPLE_flush_buffer_range' => [
    'glBufferParameteriAPPLE',
    'glFlushMappedBufferRangeAPPLE'
  ],
  'GL_APPLE_framebuffer_multisample' => [
    'glRenderbufferStorageMultisampleAPPLE',
    'glResolveMultisampleFramebufferAPPLE'
  ],
  'GL_APPLE_object_purgeable' => [
    'glGetObjectParameterivAPPLE_c',
    'glObjectPurgeableAPPLE',
    'glObjectUnpurgeableAPPLE'
  ],
  'GL_APPLE_sync' => [
    'glClientWaitSyncAPPLE',
    'glDeleteSyncAPPLE',
    'glFenceSyncAPPLE',
    'glGetInteger64vAPPLE_c',
    'glGetInteger64vAPPLE_p',
    'glGetSyncivAPPLE_c',
    'glGetSyncivAPPLE_p',
    'glIsSyncAPPLE',
    'glWaitSyncAPPLE'
  ],
  'GL_APPLE_texture_range' => [
    'glGetTexParameterPointervAPPLE_c',
    'glTextureRangeAPPLE_c'
  ],
  'GL_APPLE_vertex_array_object' => [
    'glBindVertexArrayAPPLE',
    'glDeleteVertexArraysAPPLE_c',
    'glDeleteVertexArraysAPPLE_p',
    'glGenVertexArraysAPPLE_c',
    'glGenVertexArraysAPPLE_p',
    'glIsVertexArrayAPPLE'
  ],
  'GL_APPLE_vertex_array_range' => [
    'glFlushVertexArrayRangeAPPLE_c',
    'glVertexArrayParameteriAPPLE',
    'glVertexArrayRangeAPPLE_c'
  ],
  'GL_APPLE_vertex_program_evaluators' => [
    'glDisableVertexAttribAPPLE',
    'glEnableVertexAttribAPPLE',
    'glIsVertexAttribEnabledAPPLE',
    'glMapVertexAttrib1dAPPLE_c',
    'glMapVertexAttrib1fAPPLE_c',
    'glMapVertexAttrib2dAPPLE_c',
    'glMapVertexAttrib2fAPPLE_c'
  ],
  'GL_ARB_ES2_compatibility' => [
    'glClearDepthf',
    'glDepthRangef',
    'glGetShaderPrecisionFormat_c',
    'glGetShaderPrecisionFormat_p',
    'glReleaseShaderCompiler',
    'glShaderBinary_c'
  ],
  'GL_ARB_ES3_1_compatibility' => [
    'glMemoryBarrierByRegion'
  ],
  'GL_ARB_ES3_2_compatibility' => [
    'glPrimitiveBoundingBox',
    'glPrimitiveBoundingBoxARB',
    'glPrimitiveBoundingBoxEXT'
  ],
  'GL_ARB_base_instance' => [
    'glDrawArraysInstancedBaseInstance',
    'glDrawElementsInstancedBaseInstance_c',
    'glDrawElementsInstancedBaseVertexBaseInstance_c'
  ],
  'GL_ARB_bindless_texture' => [
    'glGetImageHandleARB',
    'glGetTextureHandleARB',
    'glGetTextureSamplerHandleARB',
    'glGetVertexAttribLui64vARB_c',
    'glIsImageHandleResidentARB',
    'glIsTextureHandleResidentARB',
    'glMakeImageHandleNonResidentARB',
    'glMakeImageHandleResidentARB',
    'glMakeTextureHandleNonResidentARB',
    'glMakeTextureHandleResidentARB',
    'glProgramUniformHandleui64ARB',
    'glProgramUniformHandleui64vARB_c',
    'glProgramUniformHandleui64vARB_p',
    'glUniformHandleui64ARB',
    'glUniformHandleui64vARB_c',
    'glUniformHandleui64vARB_p',
    'glVertexAttribL1ui64ARB',
    'glVertexAttribL1ui64vARB_c'
  ],
  'GL_ARB_blend_func_extended' => [
    'glBindFragDataLocationIndexed',
    'glGetFragDataIndex'
  ],
  'GL_ARB_buffer_storage' => [
    'glBufferStorage_c'
  ],
  'GL_ARB_cl_event' => [
    'glCreateSyncFromCLeventARB'
  ],
  'GL_ARB_clear_buffer_object' => [
    'glClearBufferData_c',
    'glClearBufferSubData_c',
    'glClearNamedBufferDataEXT_c',
    'glClearNamedBufferSubDataEXT_c'
  ],
  'GL_ARB_clear_texture' => [
    'glClearTexImage_c',
    'glClearTexSubImage_c'
  ],
  'GL_ARB_clip_control' => [
    'glClipControl'
  ],
  'GL_ARB_color_buffer_float' => [
    'glClampColorARB'
  ],
  'GL_ARB_compute_shader' => [
    'glDispatchCompute',
    'glDispatchComputeIndirect'
  ],
  'GL_ARB_compute_variable_group_size' => [
    'glDispatchComputeGroupSizeARB'
  ],
  'GL_ARB_copy_buffer' => [
    'glCopyBufferSubData'
  ],
  'GL_ARB_copy_image' => [
    'glCopyImageSubData'
  ],
  'GL_ARB_debug_output' => [
    'glDebugMessageCallbackARB_c',
    'glDebugMessageControlARB_c',
    'glDebugMessageControlARB_p',
    'glDebugMessageInsertARB',
    'glGetDebugMessageLogARB_c',
    'glGetDebugMessageLogARB_p'
  ],
  'GL_ARB_direct_state_access' => [
    'glBindTextureUnit',
    'glBlitNamedFramebuffer',
    'glCheckNamedFramebufferStatus',
    'glClearNamedBufferData_c',
    'glClearNamedBufferSubData_c',
    'glClearNamedFramebufferfi',
    'glClearNamedFramebufferfv_c',
    'glClearNamedFramebufferfv_p',
    'glClearNamedFramebufferiv_c',
    'glClearNamedFramebufferiv_p',
    'glClearNamedFramebufferuiv_c',
    'glClearNamedFramebufferuiv_p',
    'glCompressedTextureSubImage1D_c',
    'glCompressedTextureSubImage2D_c',
    'glCompressedTextureSubImage3D_c',
    'glCopyNamedBufferSubData',
    'glCopyTextureSubImage1D',
    'glCopyTextureSubImage2D',
    'glCopyTextureSubImage3D',
    'glCreateBuffers_c',
    'glCreateBuffers_p',
    'glCreateFramebuffers_c',
    'glCreateFramebuffers_p',
    'glCreateProgramPipelines_c',
    'glCreateProgramPipelines_p',
    'glCreateQueries_c',
    'glCreateQueries_p',
    'glCreateRenderbuffers_c',
    'glCreateRenderbuffers_p',
    'glCreateSamplers_c',
    'glCreateSamplers_p',
    'glCreateTextures_c',
    'glCreateTextures_p',
    'glCreateTransformFeedbacks_c',
    'glCreateTransformFeedbacks_p',
    'glCreateVertexArrays_c',
    'glCreateVertexArrays_p',
    'glDisableVertexArrayAttrib',
    'glEnableVertexArrayAttrib',
    'glFlushMappedNamedBufferRange',
    'glGenerateTextureMipmap',
    'glGetCompressedTextureImage_c',
    'glGetNamedBufferParameteri64v_c',
    'glGetNamedBufferParameteriv_c',
    'glGetNamedBufferPointerv_c',
    'glGetNamedBufferSubData_c',
    'glGetNamedFramebufferAttachmentParameteriv_c',
    'glGetNamedFramebufferParameteriv_c',
    'glGetNamedRenderbufferParameteriv_c',
    'glGetQueryBufferObjecti64v',
    'glGetQueryBufferObjectiv',
    'glGetQueryBufferObjectui64v',
    'glGetQueryBufferObjectuiv',
    'glGetTextureImage_c',
    'glGetTextureLevelParameterfv_c',
    'glGetTextureLevelParameteriv_c',
    'glGetTextureParameterIiv_c',
    'glGetTextureParameterIuiv_c',
    'glGetTextureParameterfv_c',
    'glGetTextureParameteriv_c',
    'glGetTransformFeedbacki64_v_c',
    'glGetTransformFeedbacki_v_c',
    'glGetTransformFeedbackiv_c',
    'glGetVertexArrayIndexed64iv_c',
    'glGetVertexArrayIndexediv_c',
    'glGetVertexArrayiv_c',
    'glInvalidateNamedFramebufferData_c',
    'glInvalidateNamedFramebufferData_p',
    'glInvalidateNamedFramebufferSubData_c',
    'glInvalidateNamedFramebufferSubData_p',
    'glMapNamedBufferRange_c',
    'glMapNamedBuffer_c',
    'glNamedBufferData_c',
    'glNamedBufferStorage_c',
    'glNamedBufferSubData_c',
    'glNamedFramebufferDrawBuffer',
    'glNamedFramebufferDrawBuffers_c',
    'glNamedFramebufferDrawBuffers_p',
    'glNamedFramebufferParameteri',
    'glNamedFramebufferReadBuffer',
    'glNamedFramebufferRenderbuffer',
    'glNamedFramebufferTexture',
    'glNamedFramebufferTextureLayer',
    'glNamedRenderbufferStorage',
    'glNamedRenderbufferStorageMultisample',
    'glTextureBuffer',
    'glTextureBufferRange',
    'glTextureParameterIiv_c',
    'glTextureParameterIiv_p',
    'glTextureParameterIuiv_c',
    'glTextureParameterIuiv_p',
    'glTextureParameterf',
    'glTextureParameterfv_c',
    'glTextureParameterfv_p',
    'glTextureParameteri',
    'glTextureParameteriv_c',
    'glTextureParameteriv_p',
    'glTextureStorage1D',
    'glTextureStorage2D',
    'glTextureStorage2DMultisample',
    'glTextureStorage3D',
    'glTextureStorage3DMultisample',
    'glTextureSubImage1D_c',
    'glTextureSubImage2D_c',
    'glTextureSubImage3D_c',
    'glTransformFeedbackBufferBase',
    'glTransformFeedbackBufferRange',
    'glUnmapNamedBuffer',
    'glVertexArrayAttribBinding',
    'glVertexArrayAttribFormat',
    'glVertexArrayAttribIFormat',
    'glVertexArrayAttribLFormat',
    'glVertexArrayBindingDivisor',
    'glVertexArrayElementBuffer',
    'glVertexArrayVertexBuffer',
    'glVertexArrayVertexBuffers_c'
  ],
  'GL_ARB_draw_buffers' => [
    'glDrawBuffersARB_c',
    'glDrawBuffersARB_p'
  ],
  'GL_ARB_draw_buffers_blend' => [
    'glBlendEquationSeparateiARB',
    'glBlendEquationiARB',
    'glBlendFuncSeparateiARB',
    'glBlendFunciARB'
  ],
  'GL_ARB_draw_elements_base_vertex' => [
    'glDrawElementsBaseVertex_c',
    'glDrawElementsInstancedBaseVertex_c',
    'glDrawRangeElementsBaseVertex_c',
    'glMultiDrawElementsBaseVertex_c'
  ],
  'GL_ARB_draw_indirect' => [
    'glDrawArraysIndirect_c',
    'glDrawElementsIndirect_c'
  ],
  'GL_ARB_framebuffer_no_attachments' => [
    'glFramebufferParameteri',
    'glGetFramebufferParameteriv_c',
    'glGetFramebufferParameteriv_p',
    'glGetNamedFramebufferParameterivEXT_c',
    'glGetNamedFramebufferParameterivEXT_p',
    'glNamedFramebufferParameteriEXT'
  ],
  'GL_ARB_framebuffer_object' => [
    'glBindFramebuffer',
    'glBindRenderbuffer',
    'glBlitFramebuffer',
    'glCheckFramebufferStatus',
    'glDeleteFramebuffers_c',
    'glDeleteFramebuffers_p',
    'glDeleteRenderbuffers_c',
    'glDeleteRenderbuffers_p',
    'glFramebufferRenderbuffer',
    'glFramebufferTexture1D',
    'glFramebufferTexture2D',
    'glFramebufferTexture3D',
    'glFramebufferTextureLayer',
    'glGenFramebuffers_c',
    'glGenFramebuffers_p',
    'glGenRenderbuffers_c',
    'glGenRenderbuffers_p',
    'glGenerateMipmap',
    'glGetFramebufferAttachmentParameteriv_c',
    'glGetFramebufferAttachmentParameteriv_p',
    'glGetRenderbufferParameteriv_c',
    'glGetRenderbufferParameteriv_p',
    'glIsFramebuffer',
    'glIsRenderbuffer',
    'glRenderbufferStorage',
    'glRenderbufferStorageMultisample'
  ],
  'GL_ARB_geometry_shader4' => [
    'glFramebufferTextureARB',
    'glFramebufferTextureFaceARB',
    'glFramebufferTextureLayerARB',
    'glProgramParameteriARB'
  ],
  'GL_ARB_get_program_binary' => [
    'glGetProgramBinary_c',
    'glGetProgramBinary_p',
    'glProgramBinary_c',
    'glProgramParameteri'
  ],
  'GL_ARB_get_texture_sub_image' => [
    'glGetCompressedTextureSubImage_c',
    'glGetTextureSubImage_c'
  ],
  'GL_ARB_gl_spirv' => [
    'glSpecializeShaderARB_c',
    'glSpecializeShaderARB_p'
  ],
  'GL_ARB_gpu_shader_fp64' => [
    'glGetUniformdv_c',
    'glUniform1d',
    'glUniform1dv_c',
    'glUniform1dv_p',
    'glUniform2d',
    'glUniform2dv_c',
    'glUniform2dv_p',
    'glUniform3d',
    'glUniform3dv_c',
    'glUniform3dv_p',
    'glUniform4d',
    'glUniform4dv_c',
    'glUniform4dv_p',
    'glUniformMatrix2dv_c',
    'glUniformMatrix2dv_p',
    'glUniformMatrix2x3dv_c',
    'glUniformMatrix2x3dv_p',
    'glUniformMatrix2x4dv_c',
    'glUniformMatrix2x4dv_p',
    'glUniformMatrix3dv_c',
    'glUniformMatrix3dv_p',
    'glUniformMatrix3x2dv_c',
    'glUniformMatrix3x2dv_p',
    'glUniformMatrix3x4dv_c',
    'glUniformMatrix3x4dv_p',
    'glUniformMatrix4dv_c',
    'glUniformMatrix4dv_p',
    'glUniformMatrix4x2dv_c',
    'glUniformMatrix4x2dv_p',
    'glUniformMatrix4x3dv_c',
    'glUniformMatrix4x3dv_p'
  ],
  'GL_ARB_gpu_shader_int64' => [
    'glGetUniformi64vARB_c',
    'glGetUniformui64vARB_c',
    'glGetnUniformi64vARB_c',
    'glGetnUniformi64vARB_p',
    'glGetnUniformui64vARB_c',
    'glGetnUniformui64vARB_p',
    'glProgramUniform1i64ARB',
    'glProgramUniform1i64vARB_c',
    'glProgramUniform1i64vARB_p',
    'glProgramUniform1ui64ARB',
    'glProgramUniform1ui64vARB_c',
    'glProgramUniform1ui64vARB_p',
    'glProgramUniform2i64ARB',
    'glProgramUniform2i64vARB_c',
    'glProgramUniform2i64vARB_p',
    'glProgramUniform2ui64ARB',
    'glProgramUniform2ui64vARB_c',
    'glProgramUniform2ui64vARB_p',
    'glProgramUniform3i64ARB',
    'glProgramUniform3i64vARB_c',
    'glProgramUniform3i64vARB_p',
    'glProgramUniform3ui64ARB',
    'glProgramUniform3ui64vARB_c',
    'glProgramUniform3ui64vARB_p',
    'glProgramUniform4i64ARB',
    'glProgramUniform4i64vARB_c',
    'glProgramUniform4i64vARB_p',
    'glProgramUniform4ui64ARB',
    'glProgramUniform4ui64vARB_c',
    'glProgramUniform4ui64vARB_p',
    'glUniform1i64ARB',
    'glUniform1i64vARB_c',
    'glUniform1i64vARB_p',
    'glUniform1ui64ARB',
    'glUniform1ui64vARB_c',
    'glUniform1ui64vARB_p',
    'glUniform2i64ARB',
    'glUniform2i64vARB_c',
    'glUniform2i64vARB_p',
    'glUniform2ui64ARB',
    'glUniform2ui64vARB_c',
    'glUniform2ui64vARB_p',
    'glUniform3i64ARB',
    'glUniform3i64vARB_c',
    'glUniform3i64vARB_p',
    'glUniform3ui64ARB',
    'glUniform3ui64vARB_c',
    'glUniform3ui64vARB_p',
    'glUniform4i64ARB',
    'glUniform4i64vARB_c',
    'glUniform4i64vARB_p',
    'glUniform4ui64ARB',
    'glUniform4ui64vARB_c',
    'glUniform4ui64vARB_p'
  ],
  'GL_ARB_imaging' => [
    'glColorSubTable_c',
    'glColorTableParameterfv_c',
    'glColorTableParameterfv_p',
    'glColorTableParameteriv_c',
    'glColorTableParameteriv_p',
    'glColorTable_c',
    'glConvolutionFilter1D_c',
    'glConvolutionFilter2D_c',
    'glConvolutionParameterf',
    'glConvolutionParameterfv_c',
    'glConvolutionParameterfv_p',
    'glConvolutionParameteri',
    'glConvolutionParameteriv_c',
    'glConvolutionParameteriv_p',
    'glCopyColorSubTable',
    'glCopyColorTable',
    'glCopyConvolutionFilter1D',
    'glCopyConvolutionFilter2D',
    'glGetColorTableParameterfv_c',
    'glGetColorTableParameterfv_p',
    'glGetColorTableParameteriv_c',
    'glGetColorTableParameteriv_p',
    'glGetColorTable_c',
    'glGetConvolutionFilter_c',
    'glGetConvolutionParameterfv_c',
    'glGetConvolutionParameterfv_p',
    'glGetConvolutionParameteriv_c',
    'glGetConvolutionParameteriv_p',
    'glGetHistogramParameterfv_c',
    'glGetHistogramParameterfv_p',
    'glGetHistogramParameteriv_c',
    'glGetHistogramParameteriv_p',
    'glGetHistogram_c',
    'glGetMinmaxParameterfv_c',
    'glGetMinmaxParameterfv_p',
    'glGetMinmaxParameteriv_c',
    'glGetMinmaxParameteriv_p',
    'glGetMinmax_c',
    'glGetSeparableFilter_c',
    'glHistogram',
    'glMinmax',
    'glResetHistogram',
    'glResetMinmax',
    'glSeparableFilter2D_c'
  ],
  'GL_ARB_indirect_parameters' => [
    'glMultiDrawArraysIndirectCountARB_c',
    'glMultiDrawElementsIndirectCountARB_c'
  ],
  'GL_ARB_instanced_arrays' => [
    'glDrawArraysInstancedARB',
    'glDrawElementsInstancedARB_c',
    'glVertexAttribDivisorARB'
  ],
  'GL_ARB_internalformat_query' => [
    'glGetInternalformativ_c',
    'glGetInternalformativ_p'
  ],
  'GL_ARB_internalformat_query2' => [
    'glGetInternalformati64v_c',
    'glGetInternalformati64v_p'
  ],
  'GL_ARB_invalidate_subdata' => [
    'glInvalidateBufferData',
    'glInvalidateBufferSubData',
    'glInvalidateFramebuffer_c',
    'glInvalidateFramebuffer_p',
    'glInvalidateSubFramebuffer_c',
    'glInvalidateSubFramebuffer_p',
    'glInvalidateTexImage',
    'glInvalidateTexSubImage'
  ],
  'GL_ARB_map_buffer_range' => [
    'glFlushMappedBufferRange',
    'glMapBufferRange_c'
  ],
  'GL_ARB_matrix_palette' => [
    'glCurrentPaletteMatrixARB',
    'glMatrixIndexPointerARB_c',
    'glMatrixIndexubvARB_c',
    'glMatrixIndexubvARB_p',
    'glMatrixIndexuivARB_c',
    'glMatrixIndexuivARB_p',
    'glMatrixIndexusvARB_c',
    'glMatrixIndexusvARB_p'
  ],
  'GL_ARB_multi_bind' => [
    'glBindBuffersBase_c',
    'glBindBuffersBase_p',
    'glBindBuffersRange_c',
    'glBindImageTextures_c',
    'glBindImageTextures_p',
    'glBindSamplers_c',
    'glBindSamplers_p',
    'glBindTextures_c',
    'glBindTextures_p',
    'glBindVertexBuffers_c'
  ],
  'GL_ARB_multi_draw_indirect' => [
    'glMultiDrawArraysIndirect_c',
    'glMultiDrawElementsIndirect_c'
  ],
  'GL_ARB_multisample' => [
    'glSampleCoverageARB'
  ],
  'GL_ARB_multitexture' => [
    'glActiveTextureARB',
    'glClientActiveTextureARB',
    'glMultiTexCoord1dARB',
    'glMultiTexCoord1dvARB_c',
    'glMultiTexCoord1dvARB_p',
    'glMultiTexCoord1fARB',
    'glMultiTexCoord1fvARB_c',
    'glMultiTexCoord1fvARB_p',
    'glMultiTexCoord1iARB',
    'glMultiTexCoord1ivARB_c',
    'glMultiTexCoord1ivARB_p',
    'glMultiTexCoord1sARB',
    'glMultiTexCoord1svARB_c',
    'glMultiTexCoord1svARB_p',
    'glMultiTexCoord2dARB',
    'glMultiTexCoord2dvARB_c',
    'glMultiTexCoord2dvARB_p',
    'glMultiTexCoord2fARB',
    'glMultiTexCoord2fvARB_c',
    'glMultiTexCoord2fvARB_p',
    'glMultiTexCoord2iARB',
    'glMultiTexCoord2ivARB_c',
    'glMultiTexCoord2ivARB_p',
    'glMultiTexCoord2sARB',
    'glMultiTexCoord2svARB_c',
    'glMultiTexCoord2svARB_p',
    'glMultiTexCoord3dARB',
    'glMultiTexCoord3dvARB_c',
    'glMultiTexCoord3dvARB_p',
    'glMultiTexCoord3fARB',
    'glMultiTexCoord3fvARB_c',
    'glMultiTexCoord3fvARB_p',
    'glMultiTexCoord3iARB',
    'glMultiTexCoord3ivARB_c',
    'glMultiTexCoord3ivARB_p',
    'glMultiTexCoord3sARB',
    'glMultiTexCoord3svARB_c',
    'glMultiTexCoord3svARB_p',
    'glMultiTexCoord4dARB',
    'glMultiTexCoord4dvARB_c',
    'glMultiTexCoord4dvARB_p',
    'glMultiTexCoord4fARB',
    'glMultiTexCoord4fvARB_c',
    'glMultiTexCoord4fvARB_p',
    'glMultiTexCoord4iARB',
    'glMultiTexCoord4ivARB_c',
    'glMultiTexCoord4ivARB_p',
    'glMultiTexCoord4sARB',
    'glMultiTexCoord4svARB_c',
    'glMultiTexCoord4svARB_p'
  ],
  'GL_ARB_occlusion_query' => [
    'glBeginQueryARB',
    'glDeleteQueriesARB_c',
    'glDeleteQueriesARB_p',
    'glEndQueryARB',
    'glGenQueriesARB_c',
    'glGenQueriesARB_p',
    'glGetQueryObjectivARB_c',
    'glGetQueryObjectivARB_p',
    'glGetQueryObjectuivARB_c',
    'glGetQueryObjectuivARB_p',
    'glGetQueryivARB_c',
    'glGetQueryivARB_p',
    'glIsQueryARB'
  ],
  'GL_ARB_parallel_shader_compile' => [
    'glMaxShaderCompilerThreadsARB'
  ],
  'GL_ARB_point_parameters' => [
    'glPointParameterfARB',
    'glPointParameterfvARB_c',
    'glPointParameterfvARB_p'
  ],
  'GL_ARB_polygon_offset_clamp' => [
    'glPolygonOffsetClamp'
  ],
  'GL_ARB_program_interface_query' => [
    'glGetProgramInterfaceiv_c',
    'glGetProgramInterfaceiv_p',
    'glGetProgramResourceIndex',
    'glGetProgramResourceLocation',
    'glGetProgramResourceLocationIndex',
    'glGetProgramResourceName_c',
    'glGetProgramResourceName_p',
    'glGetProgramResourceiv_c',
    'glGetProgramResourceiv_p'
  ],
  'GL_ARB_provoking_vertex' => [
    'glProvokingVertex'
  ],
  'GL_ARB_robustness' => [
    'glGetGraphicsResetStatusARB',
    'glGetnColorTableARB_c',
    'glGetnCompressedTexImageARB_c',
    'glGetnConvolutionFilterARB_c',
    'glGetnHistogramARB_c',
    'glGetnMapdvARB_c',
    'glGetnMapdvARB_p',
    'glGetnMapfvARB_c',
    'glGetnMapfvARB_p',
    'glGetnMapivARB_c',
    'glGetnMapivARB_p',
    'glGetnMinmaxARB_c',
    'glGetnPixelMapfvARB_c',
    'glGetnPixelMapfvARB_p',
    'glGetnPixelMapuivARB_c',
    'glGetnPixelMapuivARB_p',
    'glGetnPixelMapusvARB_c',
    'glGetnPixelMapusvARB_p',
    'glGetnPolygonStippleARB_c',
    'glGetnPolygonStippleARB_p',
    'glGetnSeparableFilterARB_c',
    'glGetnTexImageARB_c',
    'glGetnUniformdvARB_c',
    'glGetnUniformdvARB_p',
    'glGetnUniformfvARB_c',
    'glGetnUniformfvARB_p',
    'glGetnUniformivARB_c',
    'glGetnUniformivARB_p',
    'glGetnUniformuivARB_c',
    'glGetnUniformuivARB_p',
    'glReadnPixelsARB_c'
  ],
  'GL_ARB_sample_locations' => [
    'glEvaluateDepthValuesARB',
    'glFramebufferSampleLocationsfvARB_c',
    'glNamedFramebufferSampleLocationsfvARB_c'
  ],
  'GL_ARB_sample_shading' => [
    'glMinSampleShadingARB'
  ],
  'GL_ARB_sampler_objects' => [
    'glBindSampler',
    'glDeleteSamplers_c',
    'glDeleteSamplers_p',
    'glGenSamplers_c',
    'glGenSamplers_p',
    'glGetSamplerParameterIiv_c',
    'glGetSamplerParameterIiv_p',
    'glGetSamplerParameterIuiv_c',
    'glGetSamplerParameterIuiv_p',
    'glGetSamplerParameterfv_c',
    'glGetSamplerParameterfv_p',
    'glGetSamplerParameteriv_c',
    'glGetSamplerParameteriv_p',
    'glIsSampler',
    'glSamplerParameterIiv_c',
    'glSamplerParameterIiv_p',
    'glSamplerParameterIuiv_c',
    'glSamplerParameterIuiv_p',
    'glSamplerParameterf',
    'glSamplerParameterfv_c',
    'glSamplerParameterfv_p',
    'glSamplerParameteri',
    'glSamplerParameteriv_c',
    'glSamplerParameteriv_p'
  ],
  'GL_ARB_separate_shader_objects' => [
    'glActiveShaderProgram',
    'glBindProgramPipeline',
    'glCreateShaderProgramv_c',
    'glCreateShaderProgramv_p',
    'glDeleteProgramPipelines_c',
    'glDeleteProgramPipelines_p',
    'glGenProgramPipelines_c',
    'glGenProgramPipelines_p',
    'glGetProgramPipelineInfoLog_c',
    'glGetProgramPipelineInfoLog_p',
    'glGetProgramPipelineiv_c',
    'glGetProgramPipelineiv_p',
    'glIsProgramPipeline',
    'glProgramUniform1d',
    'glProgramUniform1dv_c',
    'glProgramUniform1dv_p',
    'glProgramUniform1f',
    'glProgramUniform1fv_c',
    'glProgramUniform1fv_p',
    'glProgramUniform1i',
    'glProgramUniform1iv_c',
    'glProgramUniform1iv_p',
    'glProgramUniform1ui',
    'glProgramUniform1uiv_c',
    'glProgramUniform1uiv_p',
    'glProgramUniform2d',
    'glProgramUniform2dv_c',
    'glProgramUniform2dv_p',
    'glProgramUniform2f',
    'glProgramUniform2fv_c',
    'glProgramUniform2fv_p',
    'glProgramUniform2i',
    'glProgramUniform2iv_c',
    'glProgramUniform2iv_p',
    'glProgramUniform2ui',
    'glProgramUniform2uiv_c',
    'glProgramUniform2uiv_p',
    'glProgramUniform3d',
    'glProgramUniform3dv_c',
    'glProgramUniform3dv_p',
    'glProgramUniform3f',
    'glProgramUniform3fv_c',
    'glProgramUniform3fv_p',
    'glProgramUniform3i',
    'glProgramUniform3iv_c',
    'glProgramUniform3iv_p',
    'glProgramUniform3ui',
    'glProgramUniform3uiv_c',
    'glProgramUniform3uiv_p',
    'glProgramUniform4d',
    'glProgramUniform4dv_c',
    'glProgramUniform4dv_p',
    'glProgramUniform4f',
    'glProgramUniform4fv_c',
    'glProgramUniform4fv_p',
    'glProgramUniform4i',
    'glProgramUniform4iv_c',
    'glProgramUniform4iv_p',
    'glProgramUniform4ui',
    'glProgramUniform4uiv_c',
    'glProgramUniform4uiv_p',
    'glProgramUniformMatrix2dv_c',
    'glProgramUniformMatrix2dv_p',
    'glProgramUniformMatrix2fv_c',
    'glProgramUniformMatrix2fv_p',
    'glProgramUniformMatrix2x3dv_c',
    'glProgramUniformMatrix2x3dv_p',
    'glProgramUniformMatrix2x3fv_c',
    'glProgramUniformMatrix2x3fv_p',
    'glProgramUniformMatrix2x4dv_c',
    'glProgramUniformMatrix2x4dv_p',
    'glProgramUniformMatrix2x4fv_c',
    'glProgramUniformMatrix2x4fv_p',
    'glProgramUniformMatrix3dv_c',
    'glProgramUniformMatrix3dv_p',
    'glProgramUniformMatrix3fv_c',
    'glProgramUniformMatrix3fv_p',
    'glProgramUniformMatrix3x2dv_c',
    'glProgramUniformMatrix3x2dv_p',
    'glProgramUniformMatrix3x2fv_c',
    'glProgramUniformMatrix3x2fv_p',
    'glProgramUniformMatrix3x4dv_c',
    'glProgramUniformMatrix3x4dv_p',
    'glProgramUniformMatrix3x4fv_c',
    'glProgramUniformMatrix3x4fv_p',
    'glProgramUniformMatrix4dv_c',
    'glProgramUniformMatrix4dv_p',
    'glProgramUniformMatrix4fv_c',
    'glProgramUniformMatrix4fv_p',
    'glProgramUniformMatrix4x2dv_c',
    'glProgramUniformMatrix4x2dv_p',
    'glProgramUniformMatrix4x2fv_c',
    'glProgramUniformMatrix4x2fv_p',
    'glProgramUniformMatrix4x3dv_c',
    'glProgramUniformMatrix4x3dv_p',
    'glProgramUniformMatrix4x3fv_c',
    'glProgramUniformMatrix4x3fv_p',
    'glUseProgramStages',
    'glValidateProgramPipeline'
  ],
  'GL_ARB_shader_atomic_counters' => [
    'glGetActiveAtomicCounterBufferiv_c',
    'glGetActiveAtomicCounterBufferiv_p'
  ],
  'GL_ARB_shader_image_load_store' => [
    'glBindImageTexture',
    'glMemoryBarrier'
  ],
  'GL_ARB_shader_objects' => [
    'glAttachObjectARB',
    'glCompileShaderARB',
    'glCreateProgramObjectARB',
    'glCreateShaderObjectARB',
    'glDeleteObjectARB',
    'glDetachObjectARB',
    'glGetActiveUniformARB_c',
    'glGetActiveUniformARB_p',
    'glGetAttachedObjectsARB_c',
    'glGetHandleARB',
    'glGetInfoLogARB_c',
    'glGetInfoLogARB_p',
    'glGetObjectParameterfvARB_c',
    'glGetObjectParameterivARB_c',
    'glGetShaderSourceARB_c',
    'glGetShaderSourceARB_p',
    'glGetUniformLocationARB',
    'glGetUniformfvARB_c',
    'glGetUniformivARB_c',
    'glLinkProgramARB',
    'glShaderSourceARB_c',
    'glShaderSourceARB_p',
    'glUniform1fARB',
    'glUniform1fvARB_c',
    'glUniform1fvARB_p',
    'glUniform1iARB',
    'glUniform1ivARB_c',
    'glUniform1ivARB_p',
    'glUniform2fARB',
    'glUniform2fvARB_c',
    'glUniform2fvARB_p',
    'glUniform2iARB',
    'glUniform2ivARB_c',
    'glUniform2ivARB_p',
    'glUniform3fARB',
    'glUniform3fvARB_c',
    'glUniform3fvARB_p',
    'glUniform3iARB',
    'glUniform3ivARB_c',
    'glUniform3ivARB_p',
    'glUniform4fARB',
    'glUniform4fvARB_c',
    'glUniform4fvARB_p',
    'glUniform4iARB',
    'glUniform4ivARB_c',
    'glUniform4ivARB_p',
    'glUniformMatrix2fvARB_c',
    'glUniformMatrix2fvARB_p',
    'glUniformMatrix3fvARB_c',
    'glUniformMatrix3fvARB_p',
    'glUniformMatrix4fvARB_c',
    'glUniformMatrix4fvARB_p',
    'glUseProgramObjectARB',
    'glValidateProgramARB'
  ],
  'GL_ARB_shader_storage_buffer_object' => [
    'glShaderStorageBlockBinding'
  ],
  'GL_ARB_shader_subroutine' => [
    'glGetActiveSubroutineName_c',
    'glGetActiveSubroutineName_p',
    'glGetActiveSubroutineUniformName_c',
    'glGetActiveSubroutineUniformName_p',
    'glGetActiveSubroutineUniformiv_c',
    'glGetActiveSubroutineUniformiv_p',
    'glGetProgramStageiv_c',
    'glGetProgramStageiv_p',
    'glGetSubroutineIndex',
    'glGetSubroutineUniformLocation',
    'glGetUniformSubroutineuiv_c',
    'glGetUniformSubroutineuiv_p',
    'glUniformSubroutinesuiv_c',
    'glUniformSubroutinesuiv_p'
  ],
  'GL_ARB_shading_language_include' => [
    'glCompileShaderIncludeARB_c',
    'glCompileShaderIncludeARB_p',
    'glDeleteNamedStringARB',
    'glGetNamedStringARB_c',
    'glGetNamedStringARB_p',
    'glGetNamedStringivARB_c',
    'glIsNamedStringARB',
    'glNamedStringARB'
  ],
  'GL_ARB_sparse_buffer' => [
    'glBufferPageCommitmentARB'
  ],
  'GL_ARB_sparse_texture' => [
    'glTexPageCommitmentARB'
  ],
  'GL_ARB_sync' => [
    'glClientWaitSync',
    'glDeleteSync',
    'glFenceSync',
    'glGetInteger64v_c',
    'glGetInteger64v_p',
    'glGetSynciv_c',
    'glGetSynciv_p',
    'glIsSync',
    'glWaitSync'
  ],
  'GL_ARB_tessellation_shader' => [
    'glPatchParameterfv_c',
    'glPatchParameterfv_p',
    'glPatchParameteri'
  ],
  'GL_ARB_texture_barrier' => [
    'glTextureBarrier'
  ],
  'GL_ARB_texture_buffer_object' => [
    'glTexBufferARB'
  ],
  'GL_ARB_texture_buffer_range' => [
    'glTexBufferRange',
    'glTextureBufferRangeEXT'
  ],
  'GL_ARB_texture_compression' => [
    'glCompressedTexImage1DARB_c',
    'glCompressedTexImage2DARB_c',
    'glCompressedTexImage3DARB_c',
    'glCompressedTexSubImage1DARB_c',
    'glCompressedTexSubImage2DARB_c',
    'glCompressedTexSubImage3DARB_c',
    'glGetCompressedTexImageARB_c'
  ],
  'GL_ARB_texture_multisample' => [
    'glGetMultisamplefv_c',
    'glGetMultisamplefv_p',
    'glSampleMaski',
    'glTexImage2DMultisample',
    'glTexImage3DMultisample'
  ],
  'GL_ARB_texture_storage' => [
    'glTexStorage1D',
    'glTexStorage2D',
    'glTexStorage3D'
  ],
  'GL_ARB_texture_storage_multisample' => [
    'glTexStorage2DMultisample',
    'glTexStorage3DMultisample',
    'glTextureStorage2DMultisampleEXT',
    'glTextureStorage3DMultisampleEXT'
  ],
  'GL_ARB_texture_view' => [
    'glTextureView'
  ],
  'GL_ARB_timer_query' => [
    'glGetQueryObjecti64v_c',
    'glGetQueryObjecti64v_p',
    'glGetQueryObjectui64v_c',
    'glGetQueryObjectui64v_p',
    'glQueryCounter'
  ],
  'GL_ARB_transform_feedback2' => [
    'glBindTransformFeedback',
    'glDeleteTransformFeedbacks_c',
    'glDeleteTransformFeedbacks_p',
    'glDrawTransformFeedback',
    'glGenTransformFeedbacks_c',
    'glGenTransformFeedbacks_p',
    'glIsTransformFeedback',
    'glPauseTransformFeedback',
    'glResumeTransformFeedback'
  ],
  'GL_ARB_transform_feedback3' => [
    'glBeginQueryIndexed',
    'glDrawTransformFeedbackStream',
    'glEndQueryIndexed',
    'glGetQueryIndexediv_c',
    'glGetQueryIndexediv_p'
  ],
  'GL_ARB_transform_feedback_instanced' => [
    'glDrawTransformFeedbackInstanced',
    'glDrawTransformFeedbackStreamInstanced'
  ],
  'GL_ARB_transpose_matrix' => [
    'glLoadTransposeMatrixdARB_c',
    'glLoadTransposeMatrixdARB_p',
    'glLoadTransposeMatrixfARB_c',
    'glLoadTransposeMatrixfARB_p',
    'glMultTransposeMatrixdARB_c',
    'glMultTransposeMatrixdARB_p',
    'glMultTransposeMatrixfARB_c',
    'glMultTransposeMatrixfARB_p'
  ],
  'GL_ARB_uniform_buffer_object' => [
    'glBindBufferBase',
    'glBindBufferRange',
    'glGetActiveUniformBlockName_c',
    'glGetActiveUniformBlockName_p',
    'glGetActiveUniformBlockiv_c',
    'glGetActiveUniformName_c',
    'glGetActiveUniformName_p',
    'glGetActiveUniformsiv_c',
    'glGetActiveUniformsiv_p',
    'glGetIntegeri_v_c',
    'glGetIntegeri_v_p',
    'glGetUniformBlockIndex',
    'glGetUniformIndices_c',
    'glGetUniformIndices_p',
    'glUniformBlockBinding'
  ],
  'GL_ARB_vertex_array_object' => [
    'glBindVertexArray',
    'glDeleteVertexArrays_c',
    'glDeleteVertexArrays_p',
    'glGenVertexArrays_c',
    'glGenVertexArrays_p',
    'glIsVertexArray'
  ],
  'GL_ARB_vertex_attrib_64bit' => [
    'glGetVertexAttribLdv_c',
    'glGetVertexAttribLdv_p',
    'glVertexAttribL1d',
    'glVertexAttribL1dv_c',
    'glVertexAttribL1dv_p',
    'glVertexAttribL2d',
    'glVertexAttribL2dv_c',
    'glVertexAttribL2dv_p',
    'glVertexAttribL3d',
    'glVertexAttribL3dv_c',
    'glVertexAttribL3dv_p',
    'glVertexAttribL4d',
    'glVertexAttribL4dv_c',
    'glVertexAttribL4dv_p',
    'glVertexAttribLPointer_c'
  ],
  'GL_ARB_vertex_attrib_binding' => [
    'glBindVertexBuffer',
    'glVertexArrayBindVertexBufferEXT',
    'glVertexArrayVertexAttribBindingEXT',
    'glVertexArrayVertexAttribFormatEXT',
    'glVertexArrayVertexAttribIFormatEXT',
    'glVertexArrayVertexAttribLFormatEXT',
    'glVertexArrayVertexBindingDivisorEXT',
    'glVertexAttribBinding',
    'glVertexAttribFormat',
    'glVertexAttribIFormat',
    'glVertexAttribLFormat',
    'glVertexBindingDivisor'
  ],
  'GL_ARB_vertex_blend' => [
    'glVertexBlendARB',
    'glWeightPointerARB_c',
    'glWeightbvARB_c',
    'glWeightbvARB_p',
    'glWeightdvARB_c',
    'glWeightdvARB_p',
    'glWeightfvARB_c',
    'glWeightfvARB_p',
    'glWeightivARB_c',
    'glWeightivARB_p',
    'glWeightsvARB_c',
    'glWeightsvARB_p',
    'glWeightubvARB_c',
    'glWeightubvARB_p',
    'glWeightuivARB_c',
    'glWeightuivARB_p',
    'glWeightusvARB_c',
    'glWeightusvARB_p'
  ],
  'GL_ARB_vertex_buffer_object' => [
    'glBindBufferARB',
    'glBufferDataARB_c',
    'glBufferSubDataARB_c',
    'glDeleteBuffersARB_c',
    'glDeleteBuffersARB_p',
    'glGenBuffersARB_c',
    'glGenBuffersARB_p',
    'glGetBufferParameterivARB_c',
    'glGetBufferParameterivARB_p',
    'glGetBufferPointervARB_c',
    'glGetBufferSubDataARB_c',
    'glIsBufferARB',
    'glMapBufferARB_c',
    'glUnmapBufferARB'
  ],
  'GL_ARB_vertex_program' => [
    'glBindProgramARB',
    'glDeleteProgramsARB_c',
    'glDeleteProgramsARB_p',
    'glDisableVertexAttribArrayARB',
    'glEnableVertexAttribArrayARB',
    'glGenProgramsARB_c',
    'glGenProgramsARB_p',
    'glGetProgramEnvParameterdvARB_c',
    'glGetProgramEnvParameterdvARB_p',
    'glGetProgramEnvParameterfvARB_c',
    'glGetProgramEnvParameterfvARB_p',
    'glGetProgramLocalParameterdvARB_c',
    'glGetProgramLocalParameterdvARB_p',
    'glGetProgramLocalParameterfvARB_c',
    'glGetProgramLocalParameterfvARB_p',
    'glGetProgramStringARB_c',
    'glGetProgramivARB_c',
    'glGetProgramivARB_p',
    'glGetVertexAttribPointervARB_c',
    'glGetVertexAttribdvARB_c',
    'glGetVertexAttribdvARB_p',
    'glGetVertexAttribfvARB_c',
    'glGetVertexAttribfvARB_p',
    'glGetVertexAttribivARB_c',
    'glGetVertexAttribivARB_p',
    'glIsProgramARB',
    'glProgramEnvParameter4dARB',
    'glProgramEnvParameter4dvARB_c',
    'glProgramEnvParameter4dvARB_p',
    'glProgramEnvParameter4fARB',
    'glProgramEnvParameter4fvARB_c',
    'glProgramEnvParameter4fvARB_p',
    'glProgramLocalParameter4dARB',
    'glProgramLocalParameter4dvARB_c',
    'glProgramLocalParameter4dvARB_p',
    'glProgramLocalParameter4fARB',
    'glProgramLocalParameter4fvARB_c',
    'glProgramLocalParameter4fvARB_p',
    'glProgramStringARB_c',
    'glVertexAttrib1dARB',
    'glVertexAttrib1dvARB_c',
    'glVertexAttrib1dvARB_p',
    'glVertexAttrib1fARB',
    'glVertexAttrib1fvARB_c',
    'glVertexAttrib1fvARB_p',
    'glVertexAttrib1sARB',
    'glVertexAttrib1svARB_c',
    'glVertexAttrib1svARB_p',
    'glVertexAttrib2dARB',
    'glVertexAttrib2dvARB_c',
    'glVertexAttrib2dvARB_p',
    'glVertexAttrib2fARB',
    'glVertexAttrib2fvARB_c',
    'glVertexAttrib2fvARB_p',
    'glVertexAttrib2sARB',
    'glVertexAttrib2svARB_c',
    'glVertexAttrib2svARB_p',
    'glVertexAttrib3dARB',
    'glVertexAttrib3dvARB_c',
    'glVertexAttrib3dvARB_p',
    'glVertexAttrib3fARB',
    'glVertexAttrib3fvARB_c',
    'glVertexAttrib3fvARB_p',
    'glVertexAttrib3sARB',
    'glVertexAttrib3svARB_c',
    'glVertexAttrib3svARB_p',
    'glVertexAttrib4NbvARB_c',
    'glVertexAttrib4NbvARB_p',
    'glVertexAttrib4NivARB_c',
    'glVertexAttrib4NivARB_p',
    'glVertexAttrib4NsvARB_c',
    'glVertexAttrib4NsvARB_p',
    'glVertexAttrib4NubARB',
    'glVertexAttrib4NubvARB_c',
    'glVertexAttrib4NubvARB_p',
    'glVertexAttrib4NuivARB_c',
    'glVertexAttrib4NuivARB_p',
    'glVertexAttrib4NusvARB_c',
    'glVertexAttrib4NusvARB_p',
    'glVertexAttrib4bvARB_c',
    'glVertexAttrib4bvARB_p',
    'glVertexAttrib4dARB',
    'glVertexAttrib4dvARB_c',
    'glVertexAttrib4dvARB_p',
    'glVertexAttrib4fARB',
    'glVertexAttrib4fvARB_c',
    'glVertexAttrib4fvARB_p',
    'glVertexAttrib4ivARB_c',
    'glVertexAttrib4ivARB_p',
    'glVertexAttrib4sARB',
    'glVertexAttrib4svARB_c',
    'glVertexAttrib4svARB_p',
    'glVertexAttrib4ubvARB_c',
    'glVertexAttrib4ubvARB_p',
    'glVertexAttrib4uivARB_c',
    'glVertexAttrib4uivARB_p',
    'glVertexAttrib4usvARB_c',
    'glVertexAttrib4usvARB_p',
    'glVertexAttribPointerARB_c'
  ],
  'GL_ARB_vertex_shader' => [
    'glBindAttribLocationARB',
    'glGetActiveAttribARB_c',
    'glGetActiveAttribARB_p',
    'glGetAttribLocationARB'
  ],
  'GL_ARB_vertex_type_2_10_10_10_rev' => [
    'glColorP3ui',
    'glColorP3uiv_c',
    'glColorP3uiv_p',
    'glColorP4ui',
    'glColorP4uiv_c',
    'glColorP4uiv_p',
    'glMultiTexCoordP1ui',
    'glMultiTexCoordP1uiv_c',
    'glMultiTexCoordP1uiv_p',
    'glMultiTexCoordP2ui',
    'glMultiTexCoordP2uiv_c',
    'glMultiTexCoordP2uiv_p',
    'glMultiTexCoordP3ui',
    'glMultiTexCoordP3uiv_c',
    'glMultiTexCoordP3uiv_p',
    'glMultiTexCoordP4ui',
    'glMultiTexCoordP4uiv_c',
    'glMultiTexCoordP4uiv_p',
    'glNormalP3ui',
    'glNormalP3uiv_c',
    'glNormalP3uiv_p',
    'glSecondaryColorP3ui',
    'glSecondaryColorP3uiv_c',
    'glSecondaryColorP3uiv_p',
    'glTexCoordP1ui',
    'glTexCoordP1uiv_c',
    'glTexCoordP1uiv_p',
    'glTexCoordP2ui',
    'glTexCoordP2uiv_c',
    'glTexCoordP2uiv_p',
    'glTexCoordP3ui',
    'glTexCoordP3uiv_c',
    'glTexCoordP3uiv_p',
    'glTexCoordP4ui',
    'glTexCoordP4uiv_c',
    'glTexCoordP4uiv_p',
    'glVertexAttribP1ui',
    'glVertexAttribP1uiv_c',
    'glVertexAttribP1uiv_p',
    'glVertexAttribP2ui',
    'glVertexAttribP2uiv_c',
    'glVertexAttribP2uiv_p',
    'glVertexAttribP3ui',
    'glVertexAttribP3uiv_c',
    'glVertexAttribP3uiv_p',
    'glVertexAttribP4ui',
    'glVertexAttribP4uiv_c',
    'glVertexAttribP4uiv_p',
    'glVertexP2ui',
    'glVertexP2uiv_c',
    'glVertexP2uiv_p',
    'glVertexP3ui',
    'glVertexP3uiv_c',
    'glVertexP3uiv_p',
    'glVertexP4ui',
    'glVertexP4uiv_c',
    'glVertexP4uiv_p'
  ],
  'GL_ARB_viewport_array' => [
    'glDepthRangeArrayv_c',
    'glDepthRangeArrayv_p',
    'glDepthRangeIndexed',
    'glGetDoublei_v_c',
    'glGetDoublei_v_p',
    'glGetFloati_v_c',
    'glGetFloati_v_p',
    'glScissorArrayv_c',
    'glScissorArrayv_p',
    'glScissorIndexed',
    'glScissorIndexedv_c',
    'glScissorIndexedv_p',
    'glViewportArrayv_c',
    'glViewportArrayv_p',
    'glViewportIndexedf',
    'glViewportIndexedfv_c',
    'glViewportIndexedfv_p'
  ],
  'GL_ARB_window_pos' => [
    'glWindowPos2dARB',
    'glWindowPos2dvARB_c',
    'glWindowPos2dvARB_p',
    'glWindowPos2fARB',
    'glWindowPos2fvARB_c',
    'glWindowPos2fvARB_p',
    'glWindowPos2iARB',
    'glWindowPos2ivARB_c',
    'glWindowPos2ivARB_p',
    'glWindowPos2sARB',
    'glWindowPos2svARB_c',
    'glWindowPos2svARB_p',
    'glWindowPos3dARB',
    'glWindowPos3dvARB_c',
    'glWindowPos3dvARB_p',
    'glWindowPos3fARB',
    'glWindowPos3fvARB_c',
    'glWindowPos3fvARB_p',
    'glWindowPos3iARB',
    'glWindowPos3ivARB_c',
    'glWindowPos3ivARB_p',
    'glWindowPos3sARB',
    'glWindowPos3svARB_c',
    'glWindowPos3svARB_p'
  ],
  'GL_ARM_shader_core_properties' => [
    'glMaxActiveShaderCoresARM'
  ],
  'GL_ATI_draw_buffers' => [
    'glDrawBuffersATI_c',
    'glDrawBuffersATI_p'
  ],
  'GL_ATI_element_array' => [
    'glDrawElementArrayATI',
    'glDrawRangeElementArrayATI',
    'glElementPointerATI_c'
  ],
  'GL_ATI_envmap_bumpmap' => [
    'glGetTexBumpParameterfvATI_c',
    'glGetTexBumpParameterivATI_c',
    'glTexBumpParameterfvATI_c',
    'glTexBumpParameterivATI_c'
  ],
  'GL_ATI_fragment_shader' => [
    'glAlphaFragmentOp1ATI',
    'glAlphaFragmentOp2ATI',
    'glAlphaFragmentOp3ATI',
    'glBeginFragmentShaderATI',
    'glBindFragmentShaderATI',
    'glColorFragmentOp1ATI',
    'glColorFragmentOp2ATI',
    'glColorFragmentOp3ATI',
    'glDeleteFragmentShaderATI',
    'glEndFragmentShaderATI',
    'glGenFragmentShadersATI',
    'glPassTexCoordATI',
    'glSampleMapATI',
    'glSetFragmentShaderConstantATI_c',
    'glSetFragmentShaderConstantATI_p'
  ],
  'GL_ATI_map_object_buffer' => [
    'glMapObjectBufferATI_c',
    'glUnmapObjectBufferATI'
  ],
  'GL_ATI_pn_triangles' => [
    'glPNTrianglesfATI',
    'glPNTrianglesiATI'
  ],
  'GL_ATI_separate_stencil' => [
    'glStencilFuncSeparateATI',
    'glStencilOpSeparateATI'
  ],
  'GL_ATI_vertex_array_object' => [
    'glArrayObjectATI',
    'glFreeObjectBufferATI',
    'glGetArrayObjectfvATI_c',
    'glGetArrayObjectfvATI_p',
    'glGetArrayObjectivATI_c',
    'glGetArrayObjectivATI_p',
    'glGetObjectBufferfvATI_c',
    'glGetObjectBufferfvATI_p',
    'glGetObjectBufferivATI_c',
    'glGetObjectBufferivATI_p',
    'glGetVariantArrayObjectfvATI_c',
    'glGetVariantArrayObjectfvATI_p',
    'glGetVariantArrayObjectivATI_c',
    'glGetVariantArrayObjectivATI_p',
    'glIsObjectBufferATI',
    'glNewObjectBufferATI_c',
    'glUpdateObjectBufferATI_c',
    'glVariantArrayObjectATI'
  ],
  'GL_ATI_vertex_attrib_array_object' => [
    'glGetVertexAttribArrayObjectfvATI_c',
    'glGetVertexAttribArrayObjectfvATI_p',
    'glGetVertexAttribArrayObjectivATI_c',
    'glGetVertexAttribArrayObjectivATI_p',
    'glVertexAttribArrayObjectATI'
  ],
  'GL_ATI_vertex_streams' => [
    'glClientActiveVertexStreamATI',
    'glNormalStream3bATI',
    'glNormalStream3bvATI_c',
    'glNormalStream3bvATI_p',
    'glNormalStream3dATI',
    'glNormalStream3dvATI_c',
    'glNormalStream3dvATI_p',
    'glNormalStream3fATI',
    'glNormalStream3fvATI_c',
    'glNormalStream3fvATI_p',
    'glNormalStream3iATI',
    'glNormalStream3ivATI_c',
    'glNormalStream3ivATI_p',
    'glNormalStream3sATI',
    'glNormalStream3svATI_c',
    'glNormalStream3svATI_p',
    'glVertexBlendEnvfATI',
    'glVertexBlendEnviATI',
    'glVertexStream1dATI',
    'glVertexStream1dvATI_c',
    'glVertexStream1dvATI_p',
    'glVertexStream1fATI',
    'glVertexStream1fvATI_c',
    'glVertexStream1fvATI_p',
    'glVertexStream1iATI',
    'glVertexStream1ivATI_c',
    'glVertexStream1ivATI_p',
    'glVertexStream1sATI',
    'glVertexStream1svATI_c',
    'glVertexStream1svATI_p',
    'glVertexStream2dATI',
    'glVertexStream2dvATI_c',
    'glVertexStream2dvATI_p',
    'glVertexStream2fATI',
    'glVertexStream2fvATI_c',
    'glVertexStream2fvATI_p',
    'glVertexStream2iATI',
    'glVertexStream2ivATI_c',
    'glVertexStream2ivATI_p',
    'glVertexStream2sATI',
    'glVertexStream2svATI_c',
    'glVertexStream2svATI_p',
    'glVertexStream3dATI',
    'glVertexStream3dvATI_c',
    'glVertexStream3dvATI_p',
    'glVertexStream3fATI',
    'glVertexStream3fvATI_c',
    'glVertexStream3fvATI_p',
    'glVertexStream3iATI',
    'glVertexStream3ivATI_c',
    'glVertexStream3ivATI_p',
    'glVertexStream3sATI',
    'glVertexStream3svATI_c',
    'glVertexStream3svATI_p',
    'glVertexStream4dATI',
    'glVertexStream4dvATI_c',
    'glVertexStream4dvATI_p',
    'glVertexStream4fATI',
    'glVertexStream4fvATI_c',
    'glVertexStream4fvATI_p',
    'glVertexStream4iATI',
    'glVertexStream4ivATI_c',
    'glVertexStream4ivATI_p',
    'glVertexStream4sATI',
    'glVertexStream4svATI_c',
    'glVertexStream4svATI_p'
  ],
  'GL_EXT_EGL_image_storage' => [
    'glEGLImageTargetTexStorageEXT_c',
    'glEGLImageTargetTextureStorageEXT_c'
  ],
  'GL_EXT_base_instance' => [
    'glDrawArraysInstancedBaseInstanceEXT',
    'glDrawElementsInstancedBaseInstanceEXT_c',
    'glDrawElementsInstancedBaseVertexBaseInstanceEXT_c'
  ],
  'GL_EXT_bindable_uniform' => [
    'glGetUniformBufferSizeEXT',
    'glGetUniformOffsetEXT',
    'glUniformBufferEXT'
  ],
  'GL_EXT_blend_color' => [
    'glBlendColorEXT'
  ],
  'GL_EXT_blend_equation_separate' => [
    'glBlendEquationSeparateEXT'
  ],
  'GL_EXT_blend_func_extended' => [
    'glBindFragDataLocationIndexedEXT',
    'glGetFragDataIndexEXT',
    'glGetProgramResourceLocationIndexEXT'
  ],
  'GL_EXT_blend_func_separate' => [
    'glBlendFuncSeparateEXT'
  ],
  'GL_EXT_blend_minmax' => [
    'glBlendEquationEXT'
  ],
  'GL_EXT_buffer_storage' => [
    'glBufferStorageEXT_c'
  ],
  'GL_EXT_clear_texture' => [
    'glClearTexImageEXT_c',
    'glClearTexSubImageEXT_c'
  ],
  'GL_EXT_clip_control' => [
    'glClipControlEXT'
  ],
  'GL_EXT_color_subtable' => [
    'glColorSubTableEXT_c',
    'glCopyColorSubTableEXT'
  ],
  'GL_EXT_compiled_vertex_array' => [
    'glLockArraysEXT',
    'glUnlockArraysEXT'
  ],
  'GL_EXT_convolution' => [
    'glConvolutionFilter1DEXT_c',
    'glConvolutionFilter2DEXT_c',
    'glConvolutionParameterfEXT',
    'glConvolutionParameterfvEXT_c',
    'glConvolutionParameterfvEXT_p',
    'glConvolutionParameteriEXT',
    'glConvolutionParameterivEXT_c',
    'glConvolutionParameterivEXT_p',
    'glCopyConvolutionFilter1DEXT',
    'glCopyConvolutionFilter2DEXT',
    'glGetConvolutionFilterEXT_c',
    'glGetConvolutionParameterfvEXT_c',
    'glGetConvolutionParameterfvEXT_p',
    'glGetConvolutionParameterivEXT_c',
    'glGetConvolutionParameterivEXT_p',
    'glGetSeparableFilterEXT_c',
    'glSeparableFilter2DEXT_c'
  ],
  'GL_EXT_coordinate_frame' => [
    'glBinormalPointerEXT_c',
    'glTangentPointerEXT_c'
  ],
  'GL_EXT_copy_image' => [
    'glCopyImageSubDataEXT'
  ],
  'GL_EXT_copy_texture' => [
    'glCopyTexImage1DEXT',
    'glCopyTexImage2DEXT',
    'glCopyTexSubImage1DEXT',
    'glCopyTexSubImage2DEXT',
    'glCopyTexSubImage3DEXT'
  ],
  'GL_EXT_cull_vertex' => [
    'glCullParameterdvEXT_c',
    'glCullParameterdvEXT_p',
    'glCullParameterfvEXT_c',
    'glCullParameterfvEXT_p'
  ],
  'GL_EXT_debug_label' => [
    'glGetObjectLabelEXT_c',
    'glGetObjectLabelEXT_p',
    'glLabelObjectEXT'
  ],
  'GL_EXT_debug_marker' => [
    'glInsertEventMarkerEXT',
    'glPopGroupMarkerEXT',
    'glPushGroupMarkerEXT'
  ],
  'GL_EXT_depth_bounds_test' => [
    'glDepthBoundsEXT'
  ],
  'GL_EXT_direct_state_access' => [
    'glBindMultiTextureEXT',
    'glCheckNamedFramebufferStatusEXT',
    'glClientAttribDefaultEXT',
    'glCompressedMultiTexImage1DEXT_c',
    'glCompressedMultiTexImage2DEXT_c',
    'glCompressedMultiTexImage3DEXT_c',
    'glCompressedMultiTexSubImage1DEXT_c',
    'glCompressedMultiTexSubImage2DEXT_c',
    'glCompressedMultiTexSubImage3DEXT_c',
    'glCompressedTextureImage1DEXT_c',
    'glCompressedTextureImage2DEXT_c',
    'glCompressedTextureImage3DEXT_c',
    'glCompressedTextureSubImage1DEXT_c',
    'glCompressedTextureSubImage2DEXT_c',
    'glCompressedTextureSubImage3DEXT_c',
    'glCopyMultiTexImage1DEXT',
    'glCopyMultiTexImage2DEXT',
    'glCopyMultiTexSubImage1DEXT',
    'glCopyMultiTexSubImage2DEXT',
    'glCopyMultiTexSubImage3DEXT',
    'glCopyTextureImage1DEXT',
    'glCopyTextureImage2DEXT',
    'glCopyTextureSubImage1DEXT',
    'glCopyTextureSubImage2DEXT',
    'glCopyTextureSubImage3DEXT',
    'glDisableClientStateIndexedEXT',
    'glDisableClientStateiEXT',
    'glDisableVertexArrayAttribEXT',
    'glDisableVertexArrayEXT',
    'glEnableClientStateIndexedEXT',
    'glEnableClientStateiEXT',
    'glEnableVertexArrayAttribEXT',
    'glEnableVertexArrayEXT',
    'glFlushMappedNamedBufferRangeEXT',
    'glFramebufferDrawBufferEXT',
    'glFramebufferDrawBuffersEXT_c',
    'glFramebufferDrawBuffersEXT_p',
    'glFramebufferReadBufferEXT',
    'glGenerateMultiTexMipmapEXT',
    'glGenerateTextureMipmapEXT',
    'glGetCompressedMultiTexImageEXT_c',
    'glGetCompressedTextureImageEXT_c',
    'glGetDoubleIndexedvEXT_c',
    'glGetDoubleIndexedvEXT_p',
    'glGetDoublei_vEXT_c',
    'glGetDoublei_vEXT_p',
    'glGetFloatIndexedvEXT_c',
    'glGetFloatIndexedvEXT_p',
    'glGetFloati_vEXT_c',
    'glGetFloati_vEXT_p',
    'glGetFramebufferParameterivEXT_c',
    'glGetFramebufferParameterivEXT_p',
    'glGetMultiTexEnvfvEXT_c',
    'glGetMultiTexEnvfvEXT_p',
    'glGetMultiTexEnvivEXT_c',
    'glGetMultiTexEnvivEXT_p',
    'glGetMultiTexGendvEXT_c',
    'glGetMultiTexGendvEXT_p',
    'glGetMultiTexGenfvEXT_c',
    'glGetMultiTexGenfvEXT_p',
    'glGetMultiTexGenivEXT_c',
    'glGetMultiTexGenivEXT_p',
    'glGetMultiTexImageEXT_c',
    'glGetMultiTexLevelParameterfvEXT_c',
    'glGetMultiTexLevelParameterfvEXT_p',
    'glGetMultiTexLevelParameterivEXT_c',
    'glGetMultiTexLevelParameterivEXT_p',
    'glGetMultiTexParameterIivEXT_c',
    'glGetMultiTexParameterIivEXT_p',
    'glGetMultiTexParameterIuivEXT_c',
    'glGetMultiTexParameterIuivEXT_p',
    'glGetMultiTexParameterfvEXT_c',
    'glGetMultiTexParameterfvEXT_p',
    'glGetMultiTexParameterivEXT_c',
    'glGetMultiTexParameterivEXT_p',
    'glGetNamedBufferParameterivEXT_c',
    'glGetNamedBufferParameterivEXT_p',
    'glGetNamedBufferPointervEXT_c',
    'glGetNamedBufferSubDataEXT_c',
    'glGetNamedFramebufferAttachmentParameterivEXT_c',
    'glGetNamedFramebufferAttachmentParameterivEXT_p',
    'glGetNamedProgramLocalParameterIivEXT_c',
    'glGetNamedProgramLocalParameterIivEXT_p',
    'glGetNamedProgramLocalParameterIuivEXT_c',
    'glGetNamedProgramLocalParameterIuivEXT_p',
    'glGetNamedProgramLocalParameterdvEXT_c',
    'glGetNamedProgramLocalParameterdvEXT_p',
    'glGetNamedProgramLocalParameterfvEXT_c',
    'glGetNamedProgramLocalParameterfvEXT_p',
    'glGetNamedProgramStringEXT_c',
    'glGetNamedProgramivEXT_c',
    'glGetNamedProgramivEXT_p',
    'glGetNamedRenderbufferParameterivEXT_c',
    'glGetNamedRenderbufferParameterivEXT_p',
    'glGetPointerIndexedvEXT_c',
    'glGetPointeri_vEXT_c',
    'glGetTextureImageEXT_c',
    'glGetTextureLevelParameterfvEXT_c',
    'glGetTextureLevelParameterfvEXT_p',
    'glGetTextureLevelParameterivEXT_c',
    'glGetTextureLevelParameterivEXT_p',
    'glGetTextureParameterIivEXT_c',
    'glGetTextureParameterIivEXT_p',
    'glGetTextureParameterIuivEXT_c',
    'glGetTextureParameterIuivEXT_p',
    'glGetTextureParameterfvEXT_c',
    'glGetTextureParameterfvEXT_p',
    'glGetTextureParameterivEXT_c',
    'glGetTextureParameterivEXT_p',
    'glGetVertexArrayIntegeri_vEXT_c',
    'glGetVertexArrayIntegervEXT_c',
    'glGetVertexArrayPointeri_vEXT_c',
    'glGetVertexArrayPointervEXT_c',
    'glMapNamedBufferEXT_c',
    'glMapNamedBufferRangeEXT_c',
    'glMatrixFrustumEXT',
    'glMatrixLoadIdentityEXT',
    'glMatrixLoadTransposedEXT_c',
    'glMatrixLoadTransposedEXT_p',
    'glMatrixLoadTransposefEXT_c',
    'glMatrixLoadTransposefEXT_p',
    'glMatrixLoaddEXT_c',
    'glMatrixLoaddEXT_p',
    'glMatrixLoadfEXT_c',
    'glMatrixLoadfEXT_p',
    'glMatrixMultTransposedEXT_c',
    'glMatrixMultTransposedEXT_p',
    'glMatrixMultTransposefEXT_c',
    'glMatrixMultTransposefEXT_p',
    'glMatrixMultdEXT_c',
    'glMatrixMultdEXT_p',
    'glMatrixMultfEXT_c',
    'glMatrixMultfEXT_p',
    'glMatrixOrthoEXT',
    'glMatrixPopEXT',
    'glMatrixPushEXT',
    'glMatrixRotatedEXT',
    'glMatrixRotatefEXT',
    'glMatrixScaledEXT',
    'glMatrixScalefEXT',
    'glMatrixTranslatedEXT',
    'glMatrixTranslatefEXT',
    'glMultiTexBufferEXT',
    'glMultiTexCoordPointerEXT_c',
    'glMultiTexEnvfEXT',
    'glMultiTexEnvfvEXT_c',
    'glMultiTexEnvfvEXT_p',
    'glMultiTexEnviEXT',
    'glMultiTexEnvivEXT_c',
    'glMultiTexEnvivEXT_p',
    'glMultiTexGendEXT',
    'glMultiTexGendvEXT_c',
    'glMultiTexGendvEXT_p',
    'glMultiTexGenfEXT',
    'glMultiTexGenfvEXT_c',
    'glMultiTexGenfvEXT_p',
    'glMultiTexGeniEXT',
    'glMultiTexGenivEXT_c',
    'glMultiTexGenivEXT_p',
    'glMultiTexImage1DEXT_c',
    'glMultiTexImage2DEXT_c',
    'glMultiTexImage3DEXT_c',
    'glMultiTexParameterIivEXT_c',
    'glMultiTexParameterIivEXT_p',
    'glMultiTexParameterIuivEXT_c',
    'glMultiTexParameterIuivEXT_p',
    'glMultiTexParameterfEXT',
    'glMultiTexParameterfvEXT_c',
    'glMultiTexParameterfvEXT_p',
    'glMultiTexParameteriEXT',
    'glMultiTexParameterivEXT_c',
    'glMultiTexParameterivEXT_p',
    'glMultiTexRenderbufferEXT',
    'glMultiTexSubImage1DEXT_c',
    'glMultiTexSubImage2DEXT_c',
    'glMultiTexSubImage3DEXT_c',
    'glNamedBufferDataEXT_c',
    'glNamedBufferStorageEXT_c',
    'glNamedBufferSubDataEXT_c',
    'glNamedCopyBufferSubDataEXT',
    'glNamedFramebufferRenderbufferEXT',
    'glNamedFramebufferTexture1DEXT',
    'glNamedFramebufferTexture2DEXT',
    'glNamedFramebufferTexture3DEXT',
    'glNamedFramebufferTextureEXT',
    'glNamedFramebufferTextureFaceEXT',
    'glNamedFramebufferTextureLayerEXT',
    'glNamedProgramLocalParameter4dEXT',
    'glNamedProgramLocalParameter4dvEXT_c',
    'glNamedProgramLocalParameter4dvEXT_p',
    'glNamedProgramLocalParameter4fEXT',
    'glNamedProgramLocalParameter4fvEXT_c',
    'glNamedProgramLocalParameter4fvEXT_p',
    'glNamedProgramLocalParameterI4iEXT',
    'glNamedProgramLocalParameterI4ivEXT_c',
    'glNamedProgramLocalParameterI4ivEXT_p',
    'glNamedProgramLocalParameterI4uiEXT',
    'glNamedProgramLocalParameterI4uivEXT_c',
    'glNamedProgramLocalParameterI4uivEXT_p',
    'glNamedProgramLocalParameters4fvEXT_c',
    'glNamedProgramLocalParameters4fvEXT_p',
    'glNamedProgramLocalParametersI4ivEXT_c',
    'glNamedProgramLocalParametersI4ivEXT_p',
    'glNamedProgramLocalParametersI4uivEXT_c',
    'glNamedProgramLocalParametersI4uivEXT_p',
    'glNamedProgramStringEXT_c',
    'glNamedRenderbufferStorageEXT',
    'glNamedRenderbufferStorageMultisampleCoverageEXT',
    'glNamedRenderbufferStorageMultisampleEXT',
    'glProgramUniform1fEXT',
    'glProgramUniform1fvEXT_c',
    'glProgramUniform1fvEXT_p',
    'glProgramUniform1iEXT',
    'glProgramUniform1ivEXT_c',
    'glProgramUniform1ivEXT_p',
    'glProgramUniform1uiEXT',
    'glProgramUniform1uivEXT_c',
    'glProgramUniform1uivEXT_p',
    'glProgramUniform2fEXT',
    'glProgramUniform2fvEXT_c',
    'glProgramUniform2fvEXT_p',
    'glProgramUniform2iEXT',
    'glProgramUniform2ivEXT_c',
    'glProgramUniform2ivEXT_p',
    'glProgramUniform2uiEXT',
    'glProgramUniform2uivEXT_c',
    'glProgramUniform2uivEXT_p',
    'glProgramUniform3fEXT',
    'glProgramUniform3fvEXT_c',
    'glProgramUniform3fvEXT_p',
    'glProgramUniform3iEXT',
    'glProgramUniform3ivEXT_c',
    'glProgramUniform3ivEXT_p',
    'glProgramUniform3uiEXT',
    'glProgramUniform3uivEXT_c',
    'glProgramUniform3uivEXT_p',
    'glProgramUniform4fEXT',
    'glProgramUniform4fvEXT_c',
    'glProgramUniform4fvEXT_p',
    'glProgramUniform4iEXT',
    'glProgramUniform4ivEXT_c',
    'glProgramUniform4ivEXT_p',
    'glProgramUniform4uiEXT',
    'glProgramUniform4uivEXT_c',
    'glProgramUniform4uivEXT_p',
    'glProgramUniformMatrix2fvEXT_c',
    'glProgramUniformMatrix2fvEXT_p',
    'glProgramUniformMatrix2x3fvEXT_c',
    'glProgramUniformMatrix2x3fvEXT_p',
    'glProgramUniformMatrix2x4fvEXT_c',
    'glProgramUniformMatrix2x4fvEXT_p',
    'glProgramUniformMatrix3fvEXT_c',
    'glProgramUniformMatrix3fvEXT_p',
    'glProgramUniformMatrix3x2fvEXT_c',
    'glProgramUniformMatrix3x2fvEXT_p',
    'glProgramUniformMatrix3x4fvEXT_c',
    'glProgramUniformMatrix3x4fvEXT_p',
    'glProgramUniformMatrix4fvEXT_c',
    'glProgramUniformMatrix4fvEXT_p',
    'glProgramUniformMatrix4x2fvEXT_c',
    'glProgramUniformMatrix4x2fvEXT_p',
    'glProgramUniformMatrix4x3fvEXT_c',
    'glProgramUniformMatrix4x3fvEXT_p',
    'glPushClientAttribDefaultEXT',
    'glTextureBufferEXT',
    'glTextureImage1DEXT_c',
    'glTextureImage2DEXT_c',
    'glTextureImage3DEXT_c',
    'glTexturePageCommitmentEXT',
    'glTextureParameterIivEXT_c',
    'glTextureParameterIivEXT_p',
    'glTextureParameterIuivEXT_c',
    'glTextureParameterIuivEXT_p',
    'glTextureParameterfEXT',
    'glTextureParameterfvEXT_c',
    'glTextureParameterfvEXT_p',
    'glTextureParameteriEXT',
    'glTextureParameterivEXT_c',
    'glTextureParameterivEXT_p',
    'glTextureRenderbufferEXT',
    'glTextureSubImage1DEXT_c',
    'glTextureSubImage2DEXT_c',
    'glTextureSubImage3DEXT_c',
    'glUnmapNamedBufferEXT',
    'glVertexArrayColorOffsetEXT',
    'glVertexArrayEdgeFlagOffsetEXT',
    'glVertexArrayFogCoordOffsetEXT',
    'glVertexArrayIndexOffsetEXT',
    'glVertexArrayMultiTexCoordOffsetEXT',
    'glVertexArrayNormalOffsetEXT',
    'glVertexArraySecondaryColorOffsetEXT',
    'glVertexArrayTexCoordOffsetEXT',
    'glVertexArrayVertexAttribDivisorEXT',
    'glVertexArrayVertexAttribIOffsetEXT',
    'glVertexArrayVertexAttribOffsetEXT',
    'glVertexArrayVertexOffsetEXT'
  ],
  'GL_EXT_discard_framebuffer' => [
    'glDiscardFramebufferEXT_c',
    'glDiscardFramebufferEXT_p'
  ],
  'GL_EXT_disjoint_timer_query' => [
    'glBeginQueryEXT',
    'glDeleteQueriesEXT_c',
    'glDeleteQueriesEXT_p',
    'glEndQueryEXT',
    'glGenQueriesEXT_c',
    'glGenQueriesEXT_p',
    'glGetInteger64vEXT_c',
    'glGetInteger64vEXT_p',
    'glGetQueryObjectivEXT_c',
    'glGetQueryObjectivEXT_p',
    'glGetQueryObjectuivEXT_c',
    'glGetQueryObjectuivEXT_p',
    'glGetQueryivEXT_c',
    'glGetQueryivEXT_p',
    'glIsQueryEXT',
    'glQueryCounterEXT'
  ],
  'GL_EXT_draw_buffers' => [
    'glDrawBuffersEXT_c',
    'glDrawBuffersEXT_p'
  ],
  'GL_EXT_draw_buffers2' => [
    'glColorMaskIndexedEXT',
    'glDisableIndexedEXT',
    'glEnableIndexedEXT',
    'glGetBooleanIndexedvEXT_c',
    'glGetBooleanIndexedvEXT_p',
    'glGetIntegerIndexedvEXT_c',
    'glGetIntegerIndexedvEXT_p',
    'glIsEnabledIndexedEXT'
  ],
  'GL_EXT_draw_buffers_indexed' => [
    'glBlendEquationSeparateiEXT',
    'glBlendEquationiEXT',
    'glBlendFuncSeparateiEXT',
    'glBlendFunciEXT',
    'glColorMaskiEXT',
    'glDisableiEXT',
    'glEnableiEXT',
    'glIsEnablediEXT'
  ],
  'GL_EXT_draw_elements_base_vertex' => [
    'glDrawElementsBaseVertexEXT_c',
    'glDrawElementsInstancedBaseVertexEXT_c',
    'glDrawRangeElementsBaseVertexEXT_c',
    'glMultiDrawElementsBaseVertexEXT_c'
  ],
  'GL_EXT_draw_instanced' => [
    'glDrawArraysInstancedEXT',
    'glDrawElementsInstancedEXT_c'
  ],
  'GL_EXT_draw_range_elements' => [
    'glDrawRangeElementsEXT_c'
  ],
  'GL_EXT_draw_transform_feedback' => [
    'glDrawTransformFeedbackEXT',
    'glDrawTransformFeedbackInstancedEXT'
  ],
  'GL_EXT_external_buffer' => [
    'glBufferStorageExternalEXT',
    'glNamedBufferStorageExternalEXT'
  ],
  'GL_EXT_fog_coord' => [
    'glFogCoordPointerEXT_c',
    'glFogCoorddEXT',
    'glFogCoorddvEXT_c',
    'glFogCoorddvEXT_p',
    'glFogCoordfEXT',
    'glFogCoordfvEXT_c',
    'glFogCoordfvEXT_p'
  ],
  'GL_EXT_fragment_lighting' => [
    'glFragmentColorMaterialEXT',
    'glFragmentLightModelfEXT',
    'glFragmentLightModelfvEXT_c',
    'glFragmentLightModeliEXT',
    'glFragmentLightModelivEXT_c',
    'glFragmentLightfEXT',
    'glFragmentLightfvEXT_c',
    'glFragmentLightiEXT',
    'glFragmentLightivEXT_c',
    'glFragmentMaterialfEXT',
    'glFragmentMaterialfvEXT_c',
    'glFragmentMaterialiEXT',
    'glFragmentMaterialivEXT_c',
    'glGetFragmentLightfvEXT_c',
    'glGetFragmentLightivEXT_c',
    'glGetFragmentMaterialfvEXT_c',
    'glGetFragmentMaterialivEXT_c',
    'glLightEnviEXT'
  ],
  'GL_EXT_fragment_shading_rate' => [
    'glFramebufferShadingRateEXT',
    'glGetFragmentShadingRatesEXT_c',
    'glGetFragmentShadingRatesEXT_p',
    'glShadingRateCombinerOpsEXT',
    'glShadingRateEXT'
  ],
  'GL_EXT_framebuffer_blit' => [
    'glBlitFramebufferEXT'
  ],
  'GL_EXT_framebuffer_blit_layers' => [
    'glBlitFramebufferLayerEXT',
    'glBlitFramebufferLayersEXT'
  ],
  'GL_EXT_framebuffer_multisample' => [
    'glRenderbufferStorageMultisampleEXT'
  ],
  'GL_EXT_framebuffer_object' => [
    'glBindFramebufferEXT',
    'glBindRenderbufferEXT',
    'glCheckFramebufferStatusEXT',
    'glDeleteFramebuffersEXT_c',
    'glDeleteFramebuffersEXT_p',
    'glDeleteRenderbuffersEXT_c',
    'glDeleteRenderbuffersEXT_p',
    'glFramebufferRenderbufferEXT',
    'glFramebufferTexture1DEXT',
    'glFramebufferTexture2DEXT',
    'glFramebufferTexture3DEXT',
    'glGenFramebuffersEXT_c',
    'glGenFramebuffersEXT_p',
    'glGenRenderbuffersEXT_c',
    'glGenRenderbuffersEXT_p',
    'glGenerateMipmapEXT',
    'glGetFramebufferAttachmentParameterivEXT_c',
    'glGetFramebufferAttachmentParameterivEXT_p',
    'glGetRenderbufferParameterivEXT_c',
    'glGetRenderbufferParameterivEXT_p',
    'glIsFramebufferEXT',
    'glIsRenderbufferEXT',
    'glRenderbufferStorageEXT'
  ],
  'GL_EXT_geometry_shader4' => [
    'glFramebufferTextureEXT',
    'glFramebufferTextureFaceEXT',
    'glProgramParameteriEXT'
  ],
  'GL_EXT_gpu_program_parameters' => [
    'glProgramEnvParameters4fvEXT_c',
    'glProgramEnvParameters4fvEXT_p',
    'glProgramLocalParameters4fvEXT_c',
    'glProgramLocalParameters4fvEXT_p'
  ],
  'GL_EXT_gpu_shader4' => [
    'glBindFragDataLocationEXT',
    'glGetFragDataLocationEXT',
    'glGetUniformuivEXT_c',
    'glGetVertexAttribIivEXT_c',
    'glGetVertexAttribIivEXT_p',
    'glGetVertexAttribIuivEXT_c',
    'glGetVertexAttribIuivEXT_p',
    'glUniform1uiEXT',
    'glUniform1uivEXT_c',
    'glUniform1uivEXT_p',
    'glUniform2uiEXT',
    'glUniform2uivEXT_c',
    'glUniform2uivEXT_p',
    'glUniform3uiEXT',
    'glUniform3uivEXT_c',
    'glUniform3uivEXT_p',
    'glUniform4uiEXT',
    'glUniform4uivEXT_c',
    'glUniform4uivEXT_p',
    'glVertexAttribI1iEXT',
    'glVertexAttribI1ivEXT_c',
    'glVertexAttribI1ivEXT_p',
    'glVertexAttribI1uiEXT',
    'glVertexAttribI1uivEXT_c',
    'glVertexAttribI1uivEXT_p',
    'glVertexAttribI2iEXT',
    'glVertexAttribI2ivEXT_c',
    'glVertexAttribI2ivEXT_p',
    'glVertexAttribI2uiEXT',
    'glVertexAttribI2uivEXT_c',
    'glVertexAttribI2uivEXT_p',
    'glVertexAttribI3iEXT',
    'glVertexAttribI3ivEXT_c',
    'glVertexAttribI3ivEXT_p',
    'glVertexAttribI3uiEXT',
    'glVertexAttribI3uivEXT_c',
    'glVertexAttribI3uivEXT_p',
    'glVertexAttribI4bvEXT_c',
    'glVertexAttribI4bvEXT_p',
    'glVertexAttribI4iEXT',
    'glVertexAttribI4ivEXT_c',
    'glVertexAttribI4ivEXT_p',
    'glVertexAttribI4svEXT_c',
    'glVertexAttribI4svEXT_p',
    'glVertexAttribI4ubvEXT_c',
    'glVertexAttribI4ubvEXT_p',
    'glVertexAttribI4uiEXT',
    'glVertexAttribI4uivEXT_c',
    'glVertexAttribI4uivEXT_p',
    'glVertexAttribI4usvEXT_c',
    'glVertexAttribI4usvEXT_p',
    'glVertexAttribIPointerEXT_c'
  ],
  'GL_EXT_histogram' => [
    'glGetHistogramEXT_c',
    'glGetHistogramParameterfvEXT_c',
    'glGetHistogramParameterfvEXT_p',
    'glGetHistogramParameterivEXT_c',
    'glGetHistogramParameterivEXT_p',
    'glGetMinmaxEXT_c',
    'glGetMinmaxParameterfvEXT_c',
    'glGetMinmaxParameterfvEXT_p',
    'glGetMinmaxParameterivEXT_c',
    'glGetMinmaxParameterivEXT_p',
    'glHistogramEXT',
    'glMinmaxEXT',
    'glResetHistogramEXT',
    'glResetMinmaxEXT'
  ],
  'GL_EXT_index_func' => [
    'glIndexFuncEXT'
  ],
  'GL_EXT_index_material' => [
    'glIndexMaterialEXT'
  ],
  'GL_EXT_instanced_arrays' => [
    'glVertexAttribDivisorEXT'
  ],
  'GL_EXT_light_texture' => [
    'glApplyTextureEXT',
    'glTextureLightEXT',
    'glTextureMaterialEXT'
  ],
  'GL_EXT_map_buffer_range' => [
    'glFlushMappedBufferRangeEXT',
    'glMapBufferRangeEXT_c'
  ],
  'GL_EXT_memory_object' => [
    'glBufferStorageMemEXT',
    'glCreateMemoryObjectsEXT_c',
    'glDeleteMemoryObjectsEXT_c',
    'glDeleteMemoryObjectsEXT_p',
    'glGetMemoryObjectParameterivEXT_c',
    'glGetUnsignedBytei_vEXT_c',
    'glGetUnsignedBytevEXT_c',
    'glGetUnsignedBytevEXT_p',
    'glIsMemoryObjectEXT',
    'glMemoryObjectParameterivEXT_c',
    'glNamedBufferStorageMemEXT',
    'glTexStorageMem1DEXT',
    'glTexStorageMem2DEXT',
    'glTexStorageMem2DMultisampleEXT',
    'glTexStorageMem3DEXT',
    'glTexStorageMem3DMultisampleEXT',
    'glTextureStorageMem1DEXT',
    'glTextureStorageMem2DEXT',
    'glTextureStorageMem2DMultisampleEXT',
    'glTextureStorageMem3DEXT',
    'glTextureStorageMem3DMultisampleEXT'
  ],
  'GL_EXT_memory_object_fd' => [
    'glImportMemoryFdEXT'
  ],
  'GL_EXT_memory_object_win32' => [
    'glImportMemoryWin32HandleEXT_c',
    'glImportMemoryWin32NameEXT_c'
  ],
  'GL_EXT_mesh_shader' => [
    'glDrawMeshTasksEXT',
    'glDrawMeshTasksIndirectEXT',
    'glMultiDrawMeshTasksIndirectCountEXT',
    'glMultiDrawMeshTasksIndirectEXT'
  ],
  'GL_EXT_multi_draw_arrays' => [
    'glMultiDrawArraysEXT_c',
    'glMultiDrawArraysEXT_p',
    'glMultiDrawElementsEXT_c'
  ],
  'GL_EXT_multi_draw_indirect' => [
    'glMultiDrawArraysIndirectEXT_c',
    'glMultiDrawElementsIndirectEXT_c'
  ],
  'GL_EXT_multisample' => [
    'glSampleMaskEXT',
    'glSamplePatternEXT'
  ],
  'GL_EXT_multisampled_render_to_texture' => [
    'glFramebufferTexture2DMultisampleEXT'
  ],
  'GL_EXT_multiview_draw_buffers' => [
    'glDrawBuffersIndexedEXT_c',
    'glDrawBuffersIndexedEXT_p',
    'glGetIntegeri_vEXT_c',
    'glReadBufferIndexedEXT'
  ],
  'GL_EXT_paletted_texture' => [
    'glColorTableEXT_c',
    'glGetColorTableEXT_c',
    'glGetColorTableParameterfvEXT_c',
    'glGetColorTableParameterfvEXT_p',
    'glGetColorTableParameterivEXT_c',
    'glGetColorTableParameterivEXT_p'
  ],
  'GL_EXT_pixel_transform' => [
    'glGetPixelTransformParameterfvEXT_c',
    'glGetPixelTransformParameterivEXT_c',
    'glPixelTransformParameterfEXT',
    'glPixelTransformParameterfvEXT_c',
    'glPixelTransformParameterfvEXT_p',
    'glPixelTransformParameteriEXT',
    'glPixelTransformParameterivEXT_c',
    'glPixelTransformParameterivEXT_p'
  ],
  'GL_EXT_point_parameters' => [
    'glPointParameterfEXT',
    'glPointParameterfvEXT_c',
    'glPointParameterfvEXT_p'
  ],
  'GL_EXT_polygon_offset' => [
    'glPolygonOffsetEXT'
  ],
  'GL_EXT_polygon_offset_clamp' => [
    'glPolygonOffsetClampEXT'
  ],
  'GL_EXT_primitive_bounding_box' => [
    'glPrimitiveBoundingBoxEXT'
  ],
  'GL_EXT_provoking_vertex' => [
    'glProvokingVertexEXT'
  ],
  'GL_EXT_raster_multisample' => [
    'glCoverageModulationNV',
    'glCoverageModulationTableNV_c',
    'glCoverageModulationTableNV_p',
    'glGetCoverageModulationTableNV_c',
    'glRasterSamplesEXT'
  ],
  'GL_EXT_robustness' => [
    'glGetGraphicsResetStatusEXT',
    'glGetnUniformfvEXT_c',
    'glGetnUniformfvEXT_p',
    'glGetnUniformivEXT_c',
    'glGetnUniformivEXT_p',
    'glReadnPixelsEXT_c'
  ],
  'GL_EXT_scene_marker' => [
    'glBeginSceneEXT',
    'glEndSceneEXT'
  ],
  'GL_EXT_secondary_color' => [
    'glSecondaryColor3bEXT',
    'glSecondaryColor3bvEXT_c',
    'glSecondaryColor3bvEXT_p',
    'glSecondaryColor3dEXT',
    'glSecondaryColor3dvEXT_c',
    'glSecondaryColor3dvEXT_p',
    'glSecondaryColor3fEXT',
    'glSecondaryColor3fvEXT_c',
    'glSecondaryColor3fvEXT_p',
    'glSecondaryColor3iEXT',
    'glSecondaryColor3ivEXT_c',
    'glSecondaryColor3ivEXT_p',
    'glSecondaryColor3sEXT',
    'glSecondaryColor3svEXT_c',
    'glSecondaryColor3svEXT_p',
    'glSecondaryColor3ubEXT',
    'glSecondaryColor3ubvEXT_c',
    'glSecondaryColor3ubvEXT_p',
    'glSecondaryColor3uiEXT',
    'glSecondaryColor3uivEXT_c',
    'glSecondaryColor3uivEXT_p',
    'glSecondaryColor3usEXT',
    'glSecondaryColor3usvEXT_c',
    'glSecondaryColor3usvEXT_p',
    'glSecondaryColorPointerEXT_c'
  ],
  'GL_EXT_semaphore' => [
    'glDeleteSemaphoresEXT_c',
    'glDeleteSemaphoresEXT_p',
    'glGenSemaphoresEXT_c',
    'glGenSemaphoresEXT_p',
    'glGetSemaphoreParameterui64vEXT_c',
    'glIsSemaphoreEXT',
    'glSemaphoreParameterui64vEXT_c',
    'glSignalSemaphoreEXT_c',
    'glWaitSemaphoreEXT_c'
  ],
  'GL_EXT_semaphore_fd' => [
    'glImportSemaphoreFdEXT'
  ],
  'GL_EXT_semaphore_win32' => [
    'glImportSemaphoreWin32HandleEXT_c',
    'glImportSemaphoreWin32NameEXT_c'
  ],
  'GL_EXT_separate_shader_objects' => [
    'glActiveProgramEXT',
    'glCreateShaderProgramEXT',
    'glUseShaderProgramEXT'
  ],
  'GL_EXT_shader_framebuffer_fetch' => [
    'glFramebufferFetchBarrierEXT'
  ],
  'GL_EXT_shader_image_load_store' => [
    'glBindImageTextureEXT',
    'glMemoryBarrierEXT'
  ],
  'GL_EXT_shader_pixel_local_storage2' => [
    'glClearPixelLocalStorageuiEXT_c',
    'glClearPixelLocalStorageuiEXT_p',
    'glFramebufferPixelLocalStorageSizeEXT',
    'glGetFramebufferPixelLocalStorageSizeEXT'
  ],
  'GL_EXT_sparse_texture' => [
    'glTexPageCommitmentEXT'
  ],
  'GL_EXT_stencil_two_side' => [
    'glActiveStencilFaceEXT'
  ],
  'GL_EXT_subtexture' => [
    'glTexSubImage1DEXT_c',
    'glTexSubImage2DEXT_c',
    'glTexSubImage3DEXT_c'
  ],
  'GL_EXT_tessellation_point_size' => [
    'glPatchParameteriEXT'
  ],
  'GL_EXT_texture3D' => [
    'glTexImage3DEXT_c'
  ],
  'GL_EXT_texture_array' => [
    'glFramebufferTextureLayerEXT'
  ],
  'GL_EXT_texture_border_clamp' => [
    'glGetSamplerParameterIivEXT_c',
    'glGetSamplerParameterIivEXT_p',
    'glGetSamplerParameterIuivEXT_c',
    'glGetSamplerParameterIuivEXT_p',
    'glSamplerParameterIivEXT_c',
    'glSamplerParameterIivEXT_p',
    'glSamplerParameterIuivEXT_c',
    'glSamplerParameterIuivEXT_p'
  ],
  'GL_EXT_texture_buffer_object' => [
    'glTexBufferEXT'
  ],
  'GL_EXT_texture_integer' => [
    'glClearColorIiEXT',
    'glClearColorIuiEXT',
    'glGetTexParameterIivEXT_c',
    'glGetTexParameterIivEXT_p',
    'glGetTexParameterIuivEXT_c',
    'glGetTexParameterIuivEXT_p',
    'glTexParameterIivEXT_c',
    'glTexParameterIivEXT_p',
    'glTexParameterIuivEXT_c',
    'glTexParameterIuivEXT_p'
  ],
  'GL_EXT_texture_object' => [
    'glAreTexturesResidentEXT_c',
    'glAreTexturesResidentEXT_p',
    'glBindTextureEXT',
    'glDeleteTexturesEXT_c',
    'glDeleteTexturesEXT_p',
    'glGenTexturesEXT_c',
    'glGenTexturesEXT_p',
    'glIsTextureEXT',
    'glPrioritizeTexturesEXT_c',
    'glPrioritizeTexturesEXT_p'
  ],
  'GL_EXT_texture_perturb_normal' => [
    'glTextureNormalEXT'
  ],
  'GL_EXT_texture_storage' => [
    'glTexStorage1DEXT',
    'glTexStorage2DEXT',
    'glTexStorage3DEXT',
    'glTextureStorage1DEXT',
    'glTextureStorage2DEXT',
    'glTextureStorage3DEXT'
  ],
  'GL_EXT_texture_storage_compression' => [
    'glTexStorageAttribs2DEXT_c',
    'glTexStorageAttribs3DEXT_c'
  ],
  'GL_EXT_texture_view' => [
    'glTextureViewEXT'
  ],
  'GL_EXT_timer_query' => [
    'glGetQueryObjecti64vEXT_c',
    'glGetQueryObjecti64vEXT_p',
    'glGetQueryObjectui64vEXT_c',
    'glGetQueryObjectui64vEXT_p'
  ],
  'GL_EXT_transform_feedback' => [
    'glBeginTransformFeedbackEXT',
    'glBindBufferBaseEXT',
    'glBindBufferOffsetEXT',
    'glBindBufferRangeEXT',
    'glEndTransformFeedbackEXT',
    'glGetTransformFeedbackVaryingEXT_c',
    'glGetTransformFeedbackVaryingEXT_p',
    'glTransformFeedbackVaryingsEXT_c',
    'glTransformFeedbackVaryingsEXT_p'
  ],
  'GL_EXT_vertex_array' => [
    'glArrayElementEXT',
    'glColorPointerEXT_c',
    'glDrawArraysEXT',
    'glEdgeFlagPointerEXT_c',
    'glIndexPointerEXT_c',
    'glNormalPointerEXT_c',
    'glTexCoordPointerEXT_c',
    'glVertexPointerEXT_c'
  ],
  'GL_EXT_vertex_array_setXXX' => [
    'glBindArraySetEXT_c',
    'glDeleteArraySetsEXT_c'
  ],
  'GL_EXT_vertex_attrib_64bit' => [
    'glGetVertexAttribLdvEXT_c',
    'glGetVertexAttribLdvEXT_p',
    'glVertexArrayVertexAttribLOffsetEXT',
    'glVertexAttribL1dEXT',
    'glVertexAttribL1dvEXT_c',
    'glVertexAttribL1dvEXT_p',
    'glVertexAttribL2dEXT',
    'glVertexAttribL2dvEXT_c',
    'glVertexAttribL2dvEXT_p',
    'glVertexAttribL3dEXT',
    'glVertexAttribL3dvEXT_c',
    'glVertexAttribL3dvEXT_p',
    'glVertexAttribL4dEXT',
    'glVertexAttribL4dvEXT_c',
    'glVertexAttribL4dvEXT_p',
    'glVertexAttribLPointerEXT_c'
  ],
  'GL_EXT_vertex_shader' => [
    'glBeginVertexShaderEXT',
    'glBindLightParameterEXT',
    'glBindMaterialParameterEXT',
    'glBindParameterEXT',
    'glBindTexGenParameterEXT',
    'glBindTextureUnitParameterEXT',
    'glBindVertexShaderEXT',
    'glDeleteVertexShaderEXT',
    'glDisableVariantClientStateEXT',
    'glEnableVariantClientStateEXT',
    'glEndVertexShaderEXT',
    'glExtractComponentEXT',
    'glGenSymbolsEXT',
    'glGenVertexShadersEXT',
    'glGetInvariantBooleanvEXT_c',
    'glGetInvariantFloatvEXT_c',
    'glGetInvariantIntegervEXT_c',
    'glGetLocalConstantBooleanvEXT_c',
    'glGetLocalConstantFloatvEXT_c',
    'glGetLocalConstantIntegervEXT_c',
    'glGetVariantBooleanvEXT_c',
    'glGetVariantFloatvEXT_c',
    'glGetVariantIntegervEXT_c',
    'glGetVariantPointervEXT_c',
    'glInsertComponentEXT',
    'glIsVariantEnabledEXT',
    'glSetInvariantEXT_c',
    'glSetLocalConstantEXT_c',
    'glShaderOp1EXT',
    'glShaderOp2EXT',
    'glShaderOp3EXT',
    'glSwizzleEXT',
    'glVariantPointerEXT_c',
    'glVariantbvEXT_c',
    'glVariantdvEXT_c',
    'glVariantfvEXT_c',
    'glVariantivEXT_c',
    'glVariantsvEXT_c',
    'glVariantubvEXT_c',
    'glVariantuivEXT_c',
    'glVariantusvEXT_c',
    'glWriteMaskEXT'
  ],
  'GL_EXT_vertex_weighting' => [
    'glVertexWeightPointerEXT_c',
    'glVertexWeightfEXT',
    'glVertexWeightfvEXT_c',
    'glVertexWeightfvEXT_p'
  ],
  'GL_EXT_win32_keyed_mutex' => [
    'glAcquireKeyedMutexWin32EXT',
    'glReleaseKeyedMutexWin32EXT'
  ],
  'GL_EXT_window_rectangles' => [
    'glWindowRectanglesEXT_c',
    'glWindowRectanglesEXT_p'
  ],
  'GL_EXT_x11_sync_object' => [
    'glImportSyncEXT'
  ],
  'GL_GREMEDY_frame_terminator' => [
    'glFrameTerminatorGREMEDY'
  ],
  'GL_GREMEDY_string_marker' => [
    'glStringMarkerGREMEDY_c'
  ],
  'GL_HP_image_transform' => [
    'glGetImageTransformParameterfvHP_c',
    'glGetImageTransformParameterivHP_c',
    'glImageTransformParameterfHP',
    'glImageTransformParameterfvHP_c',
    'glImageTransformParameteriHP',
    'glImageTransformParameterivHP_c'
  ],
  'GL_IBM_multimode_draw_arrays' => [
    'glMultiModeDrawArraysIBM_c',
    'glMultiModeDrawElementsIBM_c'
  ],
  'GL_IBM_vertex_array_lists' => [
    'glColorPointerListIBM_c',
    'glEdgeFlagPointerListIBM_c',
    'glFogCoordPointerListIBM_c',
    'glIndexPointerListIBM_c',
    'glNormalPointerListIBM_c',
    'glSecondaryColorPointerListIBM_c',
    'glTexCoordPointerListIBM_c',
    'glVertexPointerListIBM_c'
  ],
  'GL_IMG_bindless_texture' => [
    'glGetTextureHandleIMG',
    'glGetTextureSamplerHandleIMG',
    'glProgramUniformHandleui64IMG',
    'glProgramUniformHandleui64vIMG_c',
    'glProgramUniformHandleui64vIMG_p',
    'glUniformHandleui64IMG',
    'glUniformHandleui64vIMG_c',
    'glUniformHandleui64vIMG_p'
  ],
  'GL_IMG_framebuffer_downsample' => [
    'glFramebufferTexture2DDownsampleIMG',
    'glFramebufferTextureLayerDownsampleIMG'
  ],
  'GL_IMG_multisampled_render_to_texture' => [
    'glFramebufferTexture2DMultisampleIMG',
    'glRenderbufferStorageMultisampleIMG'
  ],
  'GL_INTEL_framebuffer_CMAA' => [
    'glApplyFramebufferAttachmentCMAAINTEL'
  ],
  'GL_INTEL_parallel_arrays' => [
    'glColorPointervINTEL_c',
    'glNormalPointervINTEL_c',
    'glTexCoordPointervINTEL_c',
    'glVertexPointervINTEL_c'
  ],
  'GL_INTEL_performance_query' => [
    'glBeginPerfQueryINTEL',
    'glCreatePerfQueryINTEL_c',
    'glDeletePerfQueryINTEL',
    'glEndPerfQueryINTEL',
    'glGetFirstPerfQueryIdINTEL_c',
    'glGetNextPerfQueryIdINTEL_c',
    'glGetPerfCounterInfoINTEL_c',
    'glGetPerfQueryDataINTEL_c',
    'glGetPerfQueryIdByNameINTEL_c',
    'glGetPerfQueryInfoINTEL_c'
  ],
  'GL_INTEL_texture_scissor' => [
    'glTexScissorFuncINTEL',
    'glTexScissorINTEL'
  ],
  'GL_KHR_blend_equation_advanced' => [
    'glBlendBarrier',
    'glBlendBarrierKHR',
    'glBlendBarrierNV'
  ],
  'GL_KHR_debug' => [
    'glDebugMessageCallback_c',
    'glDebugMessageControl_c',
    'glDebugMessageControl_p',
    'glDebugMessageInsert',
    'glGetDebugMessageLog_c',
    'glGetDebugMessageLog_p',
    'glGetObjectLabel_c',
    'glGetObjectLabel_p',
    'glGetObjectPtrLabel_c',
    'glObjectLabel',
    'glObjectPtrLabel_c',
    'glPopDebugGroup',
    'glPushDebugGroup'
  ],
  'GL_KHR_parallel_shader_compile' => [
    'glMaxShaderCompilerThreadsKHR'
  ],
  'GL_KHR_robustness' => [
    'glGetnUniformfv_c',
    'glGetnUniformfv_p',
    'glGetnUniformiv_c',
    'glGetnUniformiv_p',
    'glGetnUniformuiv_c',
    'glGetnUniformuiv_p',
    'glReadnPixels_c'
  ],
  'GL_KTX_buffer_region' => [
    'glBufferRegionEnabled',
    'glDeleteBufferRegion',
    'glDrawBufferRegion',
    'glNewBufferRegion',
    'glReadBufferRegion'
  ],
  'GL_LAYOUT_LINEAR_INTEL' => [
    'glMapTexture2DINTEL_c',
    'glMapTexture2DINTEL_p',
    'glSyncTextureINTEL',
    'glUnmapTexture2DINTEL'
  ],
  'GL_MESA_framebuffer_flip_y' => [
    'glFramebufferParameteriMESA',
    'glGetFramebufferParameterivMESA_c',
    'glGetFramebufferParameterivMESA_p'
  ],
  'GL_MESA_resize_buffers' => [
    'glResizeBuffersMESA'
  ],
  'GL_MESA_window_pos' => [
    'glWindowPos2dMESA',
    'glWindowPos2dvMESA_c',
    'glWindowPos2dvMESA_p',
    'glWindowPos2fMESA',
    'glWindowPos2fvMESA_c',
    'glWindowPos2fvMESA_p',
    'glWindowPos2iMESA',
    'glWindowPos2ivMESA_c',
    'glWindowPos2ivMESA_p',
    'glWindowPos2sMESA',
    'glWindowPos2svMESA_c',
    'glWindowPos2svMESA_p',
    'glWindowPos3dMESA',
    'glWindowPos3dvMESA_c',
    'glWindowPos3dvMESA_p',
    'glWindowPos3fMESA',
    'glWindowPos3fvMESA_c',
    'glWindowPos3fvMESA_p',
    'glWindowPos3iMESA',
    'glWindowPos3ivMESA_c',
    'glWindowPos3ivMESA_p',
    'glWindowPos3sMESA',
    'glWindowPos3svMESA_c',
    'glWindowPos3svMESA_p',
    'glWindowPos4dMESA',
    'glWindowPos4dvMESA_c',
    'glWindowPos4dvMESA_p',
    'glWindowPos4fMESA',
    'glWindowPos4fvMESA_c',
    'glWindowPos4fvMESA_p',
    'glWindowPos4iMESA',
    'glWindowPos4ivMESA_c',
    'glWindowPos4ivMESA_p',
    'glWindowPos4sMESA',
    'glWindowPos4svMESA_c',
    'glWindowPos4svMESA_p'
  ],
  'GL_NVX_conditional_render' => [
    'glBeginConditionalRenderNVX',
    'glEndConditionalRenderNVX'
  ],
  'GL_NVX_gpu_multicast2' => [
    'glAsyncCopyBufferSubDataNVX_c',
    'glAsyncCopyBufferSubDataNVX_p',
    'glAsyncCopyImageSubDataNVX_c',
    'glAsyncCopyImageSubDataNVX_p',
    'glMulticastScissorArrayvNVX_c',
    'glMulticastScissorArrayvNVX_p',
    'glMulticastViewportArrayvNVX_c',
    'glMulticastViewportArrayvNVX_p',
    'glMulticastViewportPositionWScaleNVX',
    'glUploadGpuMaskNVX'
  ],
  'GL_NVX_linked_gpu_multicast' => [
    'glLGPUCopyImageSubDataNVX',
    'glLGPUInterlockNVX',
    'glLGPUNamedBufferSubDataNVX_c'
  ],
  'GL_NVX_progress_fence' => [
    'glClientWaitSemaphoreui64NVX_c',
    'glClientWaitSemaphoreui64NVX_p',
    'glCreateProgressFenceNVX',
    'glSignalSemaphoreui64NVX_c',
    'glSignalSemaphoreui64NVX_p',
    'glWaitSemaphoreui64NVX_c',
    'glWaitSemaphoreui64NVX_p'
  ],
  'GL_NV_3dvision_settings' => [
    'glStereoParameterfNV',
    'glStereoParameteriNV'
  ],
  'GL_NV_alpha_to_coverage_dither_control' => [
    'glAlphaToCoverageDitherControlNV'
  ],
  'GL_NV_bindless_multi_draw_indirect' => [
    'glMultiDrawArraysIndirectBindlessNV_c',
    'glMultiDrawElementsIndirectBindlessNV_c'
  ],
  'GL_NV_bindless_multi_draw_indirect_count' => [
    'glMultiDrawArraysIndirectBindlessCountNV_c',
    'glMultiDrawElementsIndirectBindlessCountNV_c'
  ],
  'GL_NV_bindless_texture' => [
    'glGetImageHandleNV',
    'glGetTextureHandleNV',
    'glGetTextureSamplerHandleNV',
    'glIsImageHandleResidentNV',
    'glIsTextureHandleResidentNV',
    'glMakeImageHandleNonResidentNV',
    'glMakeImageHandleResidentNV',
    'glMakeTextureHandleNonResidentNV',
    'glMakeTextureHandleResidentNV',
    'glProgramUniformHandleui64NV',
    'glProgramUniformHandleui64vNV_c',
    'glProgramUniformHandleui64vNV_p',
    'glUniformHandleui64NV',
    'glUniformHandleui64vNV_c',
    'glUniformHandleui64vNV_p'
  ],
  'GL_NV_blend_equation_advanced' => [
    'glBlendBarrierNV',
    'glBlendParameteriNV'
  ],
  'GL_NV_clip_space_w_scaling' => [
    'glViewportPositionWScaleNV'
  ],
  'GL_NV_command_list' => [
    'glCallCommandListNV',
    'glCommandListSegmentsNV',
    'glCompileCommandListNV',
    'glCreateCommandListsNV_c',
    'glCreateCommandListsNV_p',
    'glCreateStatesNV_c',
    'glCreateStatesNV_p',
    'glDeleteCommandListsNV_c',
    'glDeleteCommandListsNV_p',
    'glDeleteStatesNV_c',
    'glDeleteStatesNV_p',
    'glDrawCommandsAddressNV_c',
    'glDrawCommandsNV_c',
    'glDrawCommandsStatesAddressNV_c',
    'glDrawCommandsStatesNV_c',
    'glGetCommandHeaderNV',
    'glGetStageIndexNV',
    'glIsCommandListNV',
    'glIsStateNV',
    'glListDrawCommandsStatesClientNV_c',
    'glStateCaptureNV'
  ],
  'GL_NV_conditional_render' => [
    'glBeginConditionalRenderNV',
    'glEndConditionalRenderNV',
    'glEndConditionalRenderNVX'
  ],
  'GL_NV_conservative_raster' => [
    'glSubpixelPrecisionBiasNV'
  ],
  'GL_NV_conservative_raster_dilate' => [
    'glConservativeRasterParameterfNV'
  ],
  'GL_NV_conservative_raster_pre_snap_triangles' => [
    'glConservativeRasterParameteriNV'
  ],
  'GL_NV_copy_buffer' => [
    'glCopyBufferSubDataNV'
  ],
  'GL_NV_copy_image' => [
    'glCopyImageSubDataNV'
  ],
  'GL_NV_depth_buffer_float' => [
    'glClearDepthdNV',
    'glDepthBoundsdNV',
    'glDepthRangedNV'
  ],
  'GL_NV_draw_buffers' => [
    'glDrawBuffersNV_c',
    'glDrawBuffersNV_p'
  ],
  'GL_NV_draw_instanced' => [
    'glDrawArraysInstancedNV',
    'glDrawElementsInstancedNV_c'
  ],
  'GL_NV_draw_texture' => [
    'glDrawTextureNV'
  ],
  'GL_NV_draw_vulkan_image' => [
    'glDrawVkImageNV',
    'glGetVkProcAddrNV',
    'glSignalVkFenceNV',
    'glSignalVkSemaphoreNV',
    'glWaitVkSemaphoreNV'
  ],
  'GL_NV_evaluators' => [
    'glEvalMapsNV',
    'glGetMapAttribParameterfvNV_c',
    'glGetMapAttribParameterivNV_c',
    'glGetMapControlPointsNV_c',
    'glGetMapParameterfvNV_c',
    'glGetMapParameterivNV_c',
    'glMapControlPointsNV_c',
    'glMapParameterfvNV_c',
    'glMapParameterivNV_c'
  ],
  'GL_NV_explicit_multisample' => [
    'glGetMultisamplefvNV_c',
    'glGetMultisamplefvNV_p',
    'glSampleMaskIndexedNV',
    'glTexRenderbufferNV'
  ],
  'GL_NV_fence' => [
    'glDeleteFencesNV_c',
    'glDeleteFencesNV_p',
    'glFinishFenceNV',
    'glGenFencesNV_c',
    'glGenFencesNV_p',
    'glGetFenceivNV_c',
    'glIsFenceNV',
    'glSetFenceNV',
    'glTestFenceNV'
  ],
  'GL_NV_fragment_coverage_to_color' => [
    'glFragmentCoverageColorNV'
  ],
  'GL_NV_fragment_program' => [
    'glGetProgramNamedParameterdvNV_c',
    'glGetProgramNamedParameterdvNV_p',
    'glGetProgramNamedParameterfvNV_c',
    'glGetProgramNamedParameterfvNV_p',
    'glProgramNamedParameter4dNV',
    'glProgramNamedParameter4dvNV_c',
    'glProgramNamedParameter4dvNV_p',
    'glProgramNamedParameter4fNV',
    'glProgramNamedParameter4fvNV_c',
    'glProgramNamedParameter4fvNV_p'
  ],
  'GL_NV_framebuffer_blit' => [
    'glBlitFramebufferNV'
  ],
  'GL_NV_framebuffer_multisample' => [
    'glRenderbufferStorageMultisampleNV'
  ],
  'GL_NV_framebuffer_multisample_coverage' => [
    'glRenderbufferStorageMultisampleCoverageNV'
  ],
  'GL_NV_geometry_program4' => [
    'glProgramVertexLimitNV'
  ],
  'GL_NV_gpu_multicast' => [
    'glMulticastBarrierNV',
    'glMulticastBlitFramebufferNV',
    'glMulticastBufferSubDataNV_c',
    'glMulticastCopyBufferSubDataNV',
    'glMulticastCopyImageSubDataNV',
    'glMulticastFramebufferSampleLocationsfvNV_c',
    'glMulticastGetQueryObjecti64vNV_c',
    'glMulticastGetQueryObjectivNV_c',
    'glMulticastGetQueryObjectui64vNV_c',
    'glMulticastGetQueryObjectuivNV_c',
    'glMulticastWaitSyncNV',
    'glRenderGpuMaskNV'
  ],
  'GL_NV_gpu_program4' => [
    'glProgramEnvParameterI4iNV',
    'glProgramEnvParameterI4ivNV_c',
    'glProgramEnvParameterI4ivNV_p',
    'glProgramEnvParameterI4uiNV',
    'glProgramEnvParameterI4uivNV_c',
    'glProgramEnvParameterI4uivNV_p',
    'glProgramEnvParametersI4ivNV_c',
    'glProgramEnvParametersI4ivNV_p',
    'glProgramEnvParametersI4uivNV_c',
    'glProgramEnvParametersI4uivNV_p',
    'glProgramLocalParameterI4iNV',
    'glProgramLocalParameterI4ivNV_c',
    'glProgramLocalParameterI4ivNV_p',
    'glProgramLocalParameterI4uiNV',
    'glProgramLocalParameterI4uivNV_c',
    'glProgramLocalParameterI4uivNV_p',
    'glProgramLocalParametersI4ivNV_c',
    'glProgramLocalParametersI4ivNV_p',
    'glProgramLocalParametersI4uivNV_c',
    'glProgramLocalParametersI4uivNV_p'
  ],
  'GL_NV_gpu_shader5' => [
    'glGetUniformi64vNV_c',
    'glGetUniformui64vNV_c',
    'glProgramUniform1i64NV',
    'glProgramUniform1i64vNV_c',
    'glProgramUniform1i64vNV_p',
    'glProgramUniform1ui64NV',
    'glProgramUniform1ui64vNV_c',
    'glProgramUniform1ui64vNV_p',
    'glProgramUniform2i64NV',
    'glProgramUniform2i64vNV_c',
    'glProgramUniform2i64vNV_p',
    'glProgramUniform2ui64NV',
    'glProgramUniform2ui64vNV_c',
    'glProgramUniform2ui64vNV_p',
    'glProgramUniform3i64NV',
    'glProgramUniform3i64vNV_c',
    'glProgramUniform3i64vNV_p',
    'glProgramUniform3ui64NV',
    'glProgramUniform3ui64vNV_c',
    'glProgramUniform3ui64vNV_p',
    'glProgramUniform4i64NV',
    'glProgramUniform4i64vNV_c',
    'glProgramUniform4i64vNV_p',
    'glProgramUniform4ui64NV',
    'glProgramUniform4ui64vNV_c',
    'glProgramUniform4ui64vNV_p',
    'glUniform1i64NV',
    'glUniform1i64vNV_c',
    'glUniform1i64vNV_p',
    'glUniform1ui64NV',
    'glUniform1ui64vNV_c',
    'glUniform1ui64vNV_p',
    'glUniform2i64NV',
    'glUniform2i64vNV_c',
    'glUniform2i64vNV_p',
    'glUniform2ui64NV',
    'glUniform2ui64vNV_c',
    'glUniform2ui64vNV_p',
    'glUniform3i64NV',
    'glUniform3i64vNV_c',
    'glUniform3i64vNV_p',
    'glUniform3ui64NV',
    'glUniform3ui64vNV_c',
    'glUniform3ui64vNV_p',
    'glUniform4i64NV',
    'glUniform4i64vNV_c',
    'glUniform4i64vNV_p',
    'glUniform4ui64NV',
    'glUniform4ui64vNV_c',
    'glUniform4ui64vNV_p'
  ],
  'GL_NV_half_float' => [
    'glColor3hNV',
    'glColor3hvNV_c',
    'glColor3hvNV_p',
    'glColor4hNV',
    'glColor4hvNV_c',
    'glColor4hvNV_p',
    'glFogCoordhNV',
    'glFogCoordhvNV_c',
    'glFogCoordhvNV_p',
    'glMultiTexCoord1hNV',
    'glMultiTexCoord1hvNV_c',
    'glMultiTexCoord1hvNV_p',
    'glMultiTexCoord2hNV',
    'glMultiTexCoord2hvNV_c',
    'glMultiTexCoord2hvNV_p',
    'glMultiTexCoord3hNV',
    'glMultiTexCoord3hvNV_c',
    'glMultiTexCoord3hvNV_p',
    'glMultiTexCoord4hNV',
    'glMultiTexCoord4hvNV_c',
    'glMultiTexCoord4hvNV_p',
    'glNormal3hNV',
    'glNormal3hvNV_c',
    'glNormal3hvNV_p',
    'glSecondaryColor3hNV',
    'glSecondaryColor3hvNV_c',
    'glSecondaryColor3hvNV_p',
    'glTexCoord1hNV',
    'glTexCoord1hvNV_c',
    'glTexCoord1hvNV_p',
    'glTexCoord2hNV',
    'glTexCoord2hvNV_c',
    'glTexCoord2hvNV_p',
    'glTexCoord3hNV',
    'glTexCoord3hvNV_c',
    'glTexCoord3hvNV_p',
    'glTexCoord4hNV',
    'glTexCoord4hvNV_c',
    'glTexCoord4hvNV_p',
    'glVertex2hNV',
    'glVertex2hvNV_c',
    'glVertex2hvNV_p',
    'glVertex3hNV',
    'glVertex3hvNV_c',
    'glVertex3hvNV_p',
    'glVertex4hNV',
    'glVertex4hvNV_c',
    'glVertex4hvNV_p',
    'glVertexAttrib1hNV',
    'glVertexAttrib1hvNV_c',
    'glVertexAttrib1hvNV_p',
    'glVertexAttrib2hNV',
    'glVertexAttrib2hvNV_c',
    'glVertexAttrib2hvNV_p',
    'glVertexAttrib3hNV',
    'glVertexAttrib3hvNV_c',
    'glVertexAttrib3hvNV_p',
    'glVertexAttrib4hNV',
    'glVertexAttrib4hvNV_c',
    'glVertexAttrib4hvNV_p',
    'glVertexAttribs1hvNV_c',
    'glVertexAttribs1hvNV_p',
    'glVertexAttribs2hvNV_c',
    'glVertexAttribs2hvNV_p',
    'glVertexAttribs3hvNV_c',
    'glVertexAttribs3hvNV_p',
    'glVertexAttribs4hvNV_c',
    'glVertexAttribs4hvNV_p',
    'glVertexWeighthNV',
    'glVertexWeighthvNV_c',
    'glVertexWeighthvNV_p'
  ],
  'GL_NV_instanced_arrays' => [
    'glVertexAttribDivisorNV'
  ],
  'GL_NV_internalformat_sample_query' => [
    'glGetInternalformatSampleivNV_c',
    'glGetInternalformatSampleivNV_p'
  ],
  'GL_NV_memory_attachment' => [
    'glBufferAttachMemoryNV',
    'glGetMemoryObjectDetachedResourcesuivNV_c',
    'glNamedBufferAttachMemoryNV',
    'glResetMemoryObjectParameterNV',
    'glTexAttachMemoryNV',
    'glTextureAttachMemoryNV'
  ],
  'GL_NV_memory_object_sparse' => [
    'glBufferPageCommitmentMemNV',
    'glNamedBufferPageCommitmentMemNV',
    'glTexPageCommitmentMemNV',
    'glTexturePageCommitmentMemNV'
  ],
  'GL_NV_mesh_shader' => [
    'glDrawMeshTasksIndirectNV',
    'glDrawMeshTasksNV',
    'glMultiDrawMeshTasksIndirectCountNV',
    'glMultiDrawMeshTasksIndirectNV'
  ],
  'GL_NV_non_square_matrices' => [
    'glUniformMatrix2x3fvNV_c',
    'glUniformMatrix2x3fvNV_p',
    'glUniformMatrix2x4fvNV_c',
    'glUniformMatrix2x4fvNV_p',
    'glUniformMatrix3x2fvNV_c',
    'glUniformMatrix3x2fvNV_p',
    'glUniformMatrix3x4fvNV_c',
    'glUniformMatrix3x4fvNV_p',
    'glUniformMatrix4x2fvNV_c',
    'glUniformMatrix4x2fvNV_p',
    'glUniformMatrix4x3fvNV_c',
    'glUniformMatrix4x3fvNV_p'
  ],
  'GL_NV_occlusion_query' => [
    'glBeginOcclusionQueryNV',
    'glDeleteOcclusionQueriesNV_c',
    'glDeleteOcclusionQueriesNV_p',
    'glEndOcclusionQueryNV',
    'glGenOcclusionQueriesNV_c',
    'glGenOcclusionQueriesNV_p',
    'glGetOcclusionQueryivNV_c',
    'glGetOcclusionQueryuivNV_c',
    'glIsOcclusionQueryNV'
  ],
  'GL_NV_parameter_buffer_object' => [
    'glProgramBufferParametersIivNV_c',
    'glProgramBufferParametersIivNV_p',
    'glProgramBufferParametersIuivNV_c',
    'glProgramBufferParametersIuivNV_p',
    'glProgramBufferParametersfvNV_c',
    'glProgramBufferParametersfvNV_p'
  ],
  'GL_NV_path_rendering' => [
    'glCopyPathNV',
    'glCoverFillPathInstancedNV_c',
    'glCoverFillPathNV',
    'glCoverStrokePathInstancedNV_c',
    'glCoverStrokePathNV',
    'glDeletePathsNV',
    'glGenPathsNV',
    'glGetPathColorGenfvNV_c',
    'glGetPathColorGenivNV_c',
    'glGetPathCommandsNV_c',
    'glGetPathCoordsNV_c',
    'glGetPathDashArrayNV_c',
    'glGetPathLengthNV',
    'glGetPathMetricRangeNV_c',
    'glGetPathMetricsNV_c',
    'glGetPathParameterfvNV_c',
    'glGetPathParameterfvNV_p',
    'glGetPathParameterivNV_c',
    'glGetPathParameterivNV_p',
    'glGetPathSpacingNV_c',
    'glGetPathTexGenfvNV_c',
    'glGetPathTexGenivNV_c',
    'glGetProgramResourcefvNV_c',
    'glGetProgramResourcefvNV_p',
    'glInterpolatePathsNV',
    'glIsPathNV',
    'glIsPointInFillPathNV',
    'glIsPointInStrokePathNV',
    'glMatrixLoad3x2fNV_c',
    'glMatrixLoad3x3fNV_c',
    'glMatrixLoadTranspose3x3fNV_c',
    'glMatrixMult3x2fNV_c',
    'glMatrixMult3x3fNV_c',
    'glMatrixMultTranspose3x3fNV_c',
    'glPathColorGenNV_c',
    'glPathCommandsNV_c',
    'glPathCoordsNV_c',
    'glPathCoverDepthFuncNV',
    'glPathDashArrayNV_c',
    'glPathDashArrayNV_p',
    'glPathFogGenNV',
    'glPathGlyphIndexArrayNV_c',
    'glPathGlyphIndexRangeNV_c',
    'glPathGlyphIndexRangeNV_p',
    'glPathGlyphRangeNV_c',
    'glPathGlyphsNV_c',
    'glPathMemoryGlyphIndexArrayNV_c',
    'glPathParameterfNV',
    'glPathParameterfvNV_c',
    'glPathParameteriNV',
    'glPathParameterivNV_c',
    'glPathStencilDepthOffsetNV',
    'glPathStencilFuncNV',
    'glPathStringNV_c',
    'glPathSubCommandsNV_c',
    'glPathSubCoordsNV_c',
    'glPathTexGenNV_c',
    'glPointAlongPathNV_c',
    'glPointAlongPathNV_p',
    'glProgramPathFragmentInputGenNV_c',
    'glStencilFillPathInstancedNV_c',
    'glStencilFillPathNV',
    'glStencilStrokePathInstancedNV_c',
    'glStencilStrokePathNV',
    'glStencilThenCoverFillPathInstancedNV_c',
    'glStencilThenCoverFillPathNV',
    'glStencilThenCoverStrokePathInstancedNV_c',
    'glStencilThenCoverStrokePathNV',
    'glTransformPathNV_c',
    'glWeightPathsNV_c',
    'glWeightPathsNV_p'
  ],
  'GL_NV_pixel_data_range' => [
    'glFlushPixelDataRangeNV',
    'glPixelDataRangeNV_c'
  ],
  'GL_NV_point_sprite' => [
    'glPointParameteriNV',
    'glPointParameterivNV_c',
    'glPointParameterivNV_p'
  ],
  'GL_NV_polygon_mode' => [
    'glPolygonModeNV'
  ],
  'GL_NV_present_video' => [
    'glGetVideoi64vNV_c',
    'glGetVideoivNV_c',
    'glGetVideoui64vNV_c',
    'glGetVideouivNV_c',
    'glPresentFrameDualFillNV',
    'glPresentFrameKeyedNV'
  ],
  'GL_NV_primitive_restart' => [
    'glPrimitiveRestartIndexNV',
    'glPrimitiveRestartNV'
  ],
  'GL_NV_read_buffer' => [
    'glReadBufferNV'
  ],
  'GL_NV_register_combiners' => [
    'glCombinerInputNV',
    'glCombinerOutputNV',
    'glCombinerParameterfNV',
    'glCombinerParameterfvNV_c',
    'glCombinerParameteriNV',
    'glCombinerParameterivNV_c',
    'glFinalCombinerInputNV',
    'glGetCombinerInputParameterfvNV_c',
    'glGetCombinerInputParameterivNV_c',
    'glGetCombinerOutputParameterfvNV_c',
    'glGetCombinerOutputParameterivNV_c',
    'glGetFinalCombinerInputParameterfvNV_c',
    'glGetFinalCombinerInputParameterivNV_c'
  ],
  'GL_NV_register_combiners2' => [
    'glCombinerStageParameterfvNV_c',
    'glGetCombinerStageParameterfvNV_c'
  ],
  'GL_NV_sample_locations' => [
    'glFramebufferSampleLocationsfvNV_c',
    'glNamedFramebufferSampleLocationsfvNV_c',
    'glResolveDepthValuesNV'
  ],
  'GL_NV_scissor_exclusive' => [
    'glScissorExclusiveArrayvNV_c',
    'glScissorExclusiveArrayvNV_p',
    'glScissorExclusiveNV'
  ],
  'GL_NV_shader_buffer_load' => [
    'glGetBufferParameterui64vNV_c',
    'glGetIntegerui64vNV_c',
    'glGetNamedBufferParameterui64vNV_c',
    'glGetNamedBufferParameterui64vNV_p',
    'glIsBufferResidentNV',
    'glIsNamedBufferResidentNV',
    'glMakeBufferNonResidentNV',
    'glMakeBufferResidentNV',
    'glMakeNamedBufferNonResidentNV',
    'glMakeNamedBufferResidentNV',
    'glProgramUniformui64NV',
    'glProgramUniformui64vNV_c',
    'glProgramUniformui64vNV_p',
    'glUniformui64NV',
    'glUniformui64vNV_c',
    'glUniformui64vNV_p'
  ],
  'GL_NV_shading_rate_image' => [
    'glBindShadingRateImageNV',
    'glGetShadingRateImagePaletteNV_c',
    'glGetShadingRateImagePaletteNV_p',
    'glGetShadingRateSampleLocationivNV_c',
    'glGetShadingRateSampleLocationivNV_p',
    'glShadingRateImageBarrierNV',
    'glShadingRateImagePaletteNV_c',
    'glShadingRateImagePaletteNV_p',
    'glShadingRateSampleOrderCustomNV_c',
    'glShadingRateSampleOrderNV'
  ],
  'GL_NV_texture_array' => [
    'glCompressedTexImage3DNV_c',
    'glCompressedTexSubImage3DNV_c',
    'glCopyTexSubImage3DNV',
    'glFramebufferTextureLayerNV',
    'glTexImage3DNV_c',
    'glTexSubImage3DNV_c'
  ],
  'GL_NV_texture_barrier' => [
    'glTextureBarrierNV'
  ],
  'GL_NV_texture_multisample' => [
    'glTexImage2DMultisampleCoverageNV',
    'glTexImage3DMultisampleCoverageNV',
    'glTextureImage2DMultisampleCoverageNV',
    'glTextureImage2DMultisampleNV',
    'glTextureImage3DMultisampleCoverageNV',
    'glTextureImage3DMultisampleNV'
  ],
  'GL_NV_timeline_semaphore' => [
    'glCreateSemaphoresNV_c',
    'glCreateSemaphoresNV_p',
    'glGetSemaphoreParameterivNV_c',
    'glSemaphoreParameterivNV_c'
  ],
  'GL_NV_transform_feedback' => [
    'glActiveVaryingNV',
    'glBeginTransformFeedbackNV',
    'glBindBufferBaseNV',
    'glBindBufferOffsetNV',
    'glBindBufferRangeNV',
    'glEndTransformFeedbackNV',
    'glGetActiveVaryingNV_c',
    'glGetActiveVaryingNV_p',
    'glGetTransformFeedbackVaryingNV_c',
    'glGetTransformFeedbackVaryingNV_p',
    'glGetVaryingLocationNV',
    'glTransformFeedbackAttribsNV_c',
    'glTransformFeedbackVaryingsNV_c',
    'glTransformFeedbackVaryingsNV_p'
  ],
  'GL_NV_transform_feedback2' => [
    'glBindTransformFeedbackNV',
    'glDeleteTransformFeedbacksNV_c',
    'glDeleteTransformFeedbacksNV_p',
    'glDrawTransformFeedbackNV',
    'glGenTransformFeedbacksNV_c',
    'glGenTransformFeedbacksNV_p',
    'glIsTransformFeedbackNV',
    'glPauseTransformFeedbackNV',
    'glResumeTransformFeedbackNV'
  ],
  'GL_NV_vdpau_interop' => [
    'glVDPAUFiniNV',
    'glVDPAUGetSurfaceivNV_c',
    'glVDPAUInitNV_c',
    'glVDPAUIsSurfaceNV',
    'glVDPAUMapSurfacesNV_c',
    'glVDPAURegisterOutputSurfaceNV_c',
    'glVDPAURegisterVideoSurfaceNV_c',
    'glVDPAUSurfaceAccessNV',
    'glVDPAUUnmapSurfacesNV_c',
    'glVDPAUUnregisterSurfaceNV'
  ],
  'GL_NV_vdpau_interop2' => [
    'glVDPAURegisterVideoSurfaceWithPictureStructureNV_c'
  ],
  'GL_NV_vertex_array_range' => [
    'glFlushVertexArrayRangeNV',
    'glVertexArrayRangeNV_c'
  ],
  'GL_NV_vertex_attrib_integer_64bit' => [
    'glGetVertexAttribLi64vNV_c',
    'glGetVertexAttribLi64vNV_p',
    'glGetVertexAttribLui64vNV_c',
    'glGetVertexAttribLui64vNV_p',
    'glVertexAttribL1i64NV',
    'glVertexAttribL1i64vNV_c',
    'glVertexAttribL1i64vNV_p',
    'glVertexAttribL1ui64NV',
    'glVertexAttribL1ui64vNV_c',
    'glVertexAttribL1ui64vNV_p',
    'glVertexAttribL2i64NV',
    'glVertexAttribL2i64vNV_c',
    'glVertexAttribL2i64vNV_p',
    'glVertexAttribL2ui64NV',
    'glVertexAttribL2ui64vNV_c',
    'glVertexAttribL2ui64vNV_p',
    'glVertexAttribL3i64NV',
    'glVertexAttribL3i64vNV_c',
    'glVertexAttribL3i64vNV_p',
    'glVertexAttribL3ui64NV',
    'glVertexAttribL3ui64vNV_c',
    'glVertexAttribL3ui64vNV_p',
    'glVertexAttribL4i64NV',
    'glVertexAttribL4i64vNV_c',
    'glVertexAttribL4i64vNV_p',
    'glVertexAttribL4ui64NV',
    'glVertexAttribL4ui64vNV_c',
    'glVertexAttribL4ui64vNV_p',
    'glVertexAttribLFormatNV'
  ],
  'GL_NV_vertex_buffer_unified_memory' => [
    'glBufferAddressRangeNV',
    'glColorFormatNV',
    'glEdgeFlagFormatNV',
    'glFogCoordFormatNV',
    'glGetIntegerui64i_vNV_c',
    'glIndexFormatNV',
    'glNormalFormatNV',
    'glSecondaryColorFormatNV',
    'glTexCoordFormatNV',
    'glVertexAttribFormatNV',
    'glVertexAttribIFormatNV',
    'glVertexFormatNV'
  ],
  'GL_NV_vertex_program' => [
    'glAreProgramsResidentNV_c',
    'glAreProgramsResidentNV_p',
    'glBindProgramNV',
    'glDeleteProgramsNV_c',
    'glDeleteProgramsNV_p',
    'glExecuteProgramNV_c',
    'glExecuteProgramNV_p',
    'glGenProgramsNV_c',
    'glGenProgramsNV_p',
    'glGetProgramParameterdvNV_c',
    'glGetProgramParameterdvNV_p',
    'glGetProgramParameterfvNV_c',
    'glGetProgramParameterfvNV_p',
    'glGetProgramStringNV_c',
    'glGetProgramivNV_c',
    'glGetProgramivNV_p',
    'glGetTrackMatrixivNV_c',
    'glGetTrackMatrixivNV_p',
    'glGetVertexAttribPointervNV_c',
    'glGetVertexAttribdvNV_c',
    'glGetVertexAttribdvNV_p',
    'glGetVertexAttribfvNV_c',
    'glGetVertexAttribfvNV_p',
    'glGetVertexAttribivNV_c',
    'glGetVertexAttribivNV_p',
    'glIsProgramNV',
    'glLoadProgramNV',
    'glProgramParameter4dNV',
    'glProgramParameter4dvNV_c',
    'glProgramParameter4dvNV_p',
    'glProgramParameter4fNV',
    'glProgramParameter4fvNV_c',
    'glProgramParameter4fvNV_p',
    'glProgramParameters4dvNV_c',
    'glProgramParameters4dvNV_p',
    'glProgramParameters4fvNV_c',
    'glProgramParameters4fvNV_p',
    'glRequestResidentProgramsNV_c',
    'glRequestResidentProgramsNV_p',
    'glTrackMatrixNV',
    'glVertexAttrib1dNV',
    'glVertexAttrib1dvNV_c',
    'glVertexAttrib1dvNV_p',
    'glVertexAttrib1fNV',
    'glVertexAttrib1fvNV_c',
    'glVertexAttrib1fvNV_p',
    'glVertexAttrib1sNV',
    'glVertexAttrib1svNV_c',
    'glVertexAttrib1svNV_p',
    'glVertexAttrib2dNV',
    'glVertexAttrib2dvNV_c',
    'glVertexAttrib2dvNV_p',
    'glVertexAttrib2fNV',
    'glVertexAttrib2fvNV_c',
    'glVertexAttrib2fvNV_p',
    'glVertexAttrib2sNV',
    'glVertexAttrib2svNV_c',
    'glVertexAttrib2svNV_p',
    'glVertexAttrib3dNV',
    'glVertexAttrib3dvNV_c',
    'glVertexAttrib3dvNV_p',
    'glVertexAttrib3fNV',
    'glVertexAttrib3fvNV_c',
    'glVertexAttrib3fvNV_p',
    'glVertexAttrib3sNV',
    'glVertexAttrib3svNV_c',
    'glVertexAttrib3svNV_p',
    'glVertexAttrib4dNV',
    'glVertexAttrib4dvNV_c',
    'glVertexAttrib4dvNV_p',
    'glVertexAttrib4fNV',
    'glVertexAttrib4fvNV_c',
    'glVertexAttrib4fvNV_p',
    'glVertexAttrib4sNV',
    'glVertexAttrib4svNV_c',
    'glVertexAttrib4svNV_p',
    'glVertexAttrib4ubNV',
    'glVertexAttrib4ubvNV_c',
    'glVertexAttrib4ubvNV_p',
    'glVertexAttribPointerNV_c',
    'glVertexAttribs1dvNV_c',
    'glVertexAttribs1dvNV_p',
    'glVertexAttribs1fvNV_c',
    'glVertexAttribs1fvNV_p',
    'glVertexAttribs1svNV_c',
    'glVertexAttribs1svNV_p',
    'glVertexAttribs2dvNV_c',
    'glVertexAttribs2dvNV_p',
    'glVertexAttribs2fvNV_c',
    'glVertexAttribs2fvNV_p',
    'glVertexAttribs2svNV_c',
    'glVertexAttribs2svNV_p',
    'glVertexAttribs3dvNV_c',
    'glVertexAttribs3dvNV_p',
    'glVertexAttribs3fvNV_c',
    'glVertexAttribs3fvNV_p',
    'glVertexAttribs3svNV_c',
    'glVertexAttribs3svNV_p',
    'glVertexAttribs4dvNV_c',
    'glVertexAttribs4dvNV_p',
    'glVertexAttribs4fvNV_c',
    'glVertexAttribs4fvNV_p',
    'glVertexAttribs4svNV_c',
    'glVertexAttribs4svNV_p',
    'glVertexAttribs4ubvNV_c',
    'glVertexAttribs4ubvNV_p'
  ],
  'GL_NV_video_capture' => [
    'glBeginVideoCaptureNV',
    'glBindVideoCaptureStreamBufferNV',
    'glBindVideoCaptureStreamTextureNV',
    'glEndVideoCaptureNV',
    'glGetVideoCaptureStreamdvNV_c',
    'glGetVideoCaptureStreamfvNV_c',
    'glGetVideoCaptureStreamivNV_c',
    'glGetVideoCaptureivNV_c',
    'glVideoCaptureNV_c',
    'glVideoCaptureStreamParameterdvNV_c',
    'glVideoCaptureStreamParameterfvNV_c',
    'glVideoCaptureStreamParameterivNV_c'
  ],
  'GL_NV_viewport_array' => [
    'glDepthRangeArrayfvNV_c',
    'glDepthRangeIndexedfNV',
    'glDisableiNV',
    'glEnableiNV',
    'glGetFloati_vNV_c',
    'glGetFloati_vNV_p',
    'glIsEnablediNV',
    'glScissorArrayvNV_c',
    'glScissorArrayvNV_p',
    'glScissorIndexedNV',
    'glScissorIndexedvNV_c',
    'glScissorIndexedvNV_p',
    'glViewportArrayvNV_c',
    'glViewportArrayvNV_p',
    'glViewportIndexedfNV',
    'glViewportIndexedfvNV_c',
    'glViewportIndexedfvNV_p'
  ],
  'GL_NV_viewport_swizzle' => [
    'glViewportSwizzleNV'
  ],
  'GL_OES_EGL_image' => [
    'glEGLImageTargetRenderbufferStorageOES',
    'glEGLImageTargetTexture2DOES'
  ],
  'GL_OES_blend_equation_separate' => [
    'glBlendEquationSeparateOES'
  ],
  'GL_OES_blend_func_separate' => [
    'glBlendFuncSeparateOES'
  ],
  'GL_OES_blend_subtract' => [
    'glBlendEquationOES'
  ],
  'GL_OES_copy_image' => [
    'glCopyImageSubDataOES'
  ],
  'GL_OES_draw_buffers_indexed' => [
    'glBlendEquationSeparateiOES',
    'glBlendEquationiOES',
    'glBlendFuncSeparateiOES',
    'glBlendFunciOES',
    'glColorMaskiOES',
    'glDisableiOES',
    'glEnableiOES',
    'glIsEnablediOES'
  ],
  'GL_OES_framebuffer_object' => [
    'glBindFramebufferOES',
    'glBindRenderbufferOES',
    'glCheckFramebufferStatusOES',
    'glDeleteFramebuffersOES_c',
    'glDeleteRenderbuffersOES_c',
    'glFramebufferRenderbufferOES',
    'glFramebufferTexture2DOES',
    'glGenFramebuffersOES_c',
    'glGenRenderbuffersOES_c',
    'glGenerateMipmapOES',
    'glGetFramebufferAttachmentParameterivOES_c',
    'glGetRenderbufferParameterivOES_c',
    'glIsFramebufferOES',
    'glIsRenderbufferOES',
    'glRenderbufferStorageOES'
  ],
  'GL_OES_get_program_binary' => [
    'glGetProgramBinaryOES_c',
    'glProgramBinaryOES_c'
  ],
  'GL_OES_mapbuffer' => [
    'glGetBufferPointervOES_c',
    'glMapBufferOES_c',
    'glUnmapBufferOES'
  ],
  'GL_OES_matrix_palette' => [
    'glCurrentPaletteMatrixOES',
    'glLoadPaletteFromModelViewMatrixOES',
    'glMatrixIndexPointerOES_c',
    'glWeightPointerOES_c'
  ],
  'GL_OES_sample_shading' => [
    'glMinSampleShadingOES'
  ],
  'GL_OES_single_precision' => [
    'glClearDepthfOES',
    'glClipPlanefOES_c',
    'glDepthRangefOES',
    'glFrustumfOES',
    'glGetClipPlanefOES_c',
    'glOrthofOES'
  ],
  'GL_OES_texture_3D' => [
    'glCompressedTexImage3DOES_c',
    'glCompressedTexSubImage3DOES_c',
    'glCopyTexSubImage3DOES',
    'glFramebufferTexture3DOES',
    'glTexImage3DOES_c',
    'glTexSubImage3DOES_c'
  ],
  'GL_OES_texture_border_clamp' => [
    'glGetSamplerParameterIivOES_c',
    'glGetSamplerParameterIuivOES_c',
    'glGetTexParameterIivOES_c',
    'glGetTexParameterIuivOES_c',
    'glSamplerParameterIivOES_c',
    'glSamplerParameterIuivOES_c',
    'glTexParameterIivOES_c',
    'glTexParameterIuivOES_c'
  ],
  'GL_OES_texture_buffer' => [
    'glTexBufferOES',
    'glTexBufferRangeOES'
  ],
  'GL_OES_texture_cube_map' => [
    'glGetTexGenfvOES_c',
    'glGetTexGenivOES_c',
    'glGetTexGenxvOES_c',
    'glTexGenfOES',
    'glTexGenfvOES_c',
    'glTexGeniOES',
    'glTexGenivOES_c',
    'glTexGenxOES',
    'glTexGenxvOES_c'
  ],
  'GL_OES_texture_storage_multisample_2d_array' => [
    'glTexStorage3DMultisampleOES'
  ],
  'GL_OES_texture_view' => [
    'glTextureViewOES'
  ],
  'GL_OES_vertex_array_object' => [
    'glBindVertexArrayOES',
    'glDeleteVertexArraysOES_c',
    'glGenVertexArraysOES_c',
    'glIsVertexArrayOES'
  ],
  'GL_OVR_multiview' => [
    'glFramebufferTextureMultiviewOVR',
    'glNamedFramebufferTextureMultiviewOVR'
  ],
  'GL_OVR_multiview_multisampled_render_to_texture' => [
    'glFramebufferTextureMultisampleMultiviewOVR'
  ],
  'GL_QCOM_alpha_test' => [
    'glAlphaFuncQCOM'
  ],
  'GL_QCOM_driver_control' => [
    'glDisableDriverControlQCOM',
    'glEnableDriverControlQCOM',
    'glGetDriverControlStringQCOM_c',
    'glGetDriverControlsQCOM_c'
  ],
  'GL_QCOM_extended_get' => [
    'glExtGetBufferPointervQCOM_c',
    'glExtGetBuffersQCOM_c',
    'glExtGetBuffersQCOM_p',
    'glExtGetFramebuffersQCOM_c',
    'glExtGetFramebuffersQCOM_p',
    'glExtGetRenderbuffersQCOM_c',
    'glExtGetRenderbuffersQCOM_p',
    'glExtGetTexLevelParameterivQCOM_c',
    'glExtGetTexSubImageQCOM_c',
    'glExtGetTexturesQCOM_c',
    'glExtTexObjectStateOverrideiQCOM'
  ],
  'GL_QCOM_extended_get2' => [
    'glExtGetProgramBinarySourceQCOM_c',
    'glExtGetProgramsQCOM_c',
    'glExtGetProgramsQCOM_p',
    'glExtGetShadersQCOM_c',
    'glExtGetShadersQCOM_p',
    'glExtIsProgramBinaryQCOM'
  ],
  'GL_QCOM_frame_extrapolation' => [
    'glExtrapolateTex2DQCOM'
  ],
  'GL_QCOM_framebuffer_foveated' => [
    'glFramebufferFoveationConfigQCOM_c',
    'glFramebufferFoveationConfigQCOM_p',
    'glFramebufferFoveationParametersQCOM'
  ],
  'GL_QCOM_motion_estimation' => [
    'glTexEstimateMotionQCOM',
    'glTexEstimateMotionRegionsQCOM'
  ],
  'GL_QCOM_shader_framebuffer_fetch_noncoherent' => [
    'glFramebufferFetchBarrierQCOM'
  ],
  'GL_QCOM_shading_rate' => [
    'glShadingRateQCOM'
  ],
  'GL_QCOM_texture_foveated' => [
    'glTextureFoveationParametersQCOM'
  ],
  'GL_QCOM_tiled_rendering' => [
    'glEndTilingQCOM',
    'glStartTilingQCOM'
  ],
  'GL_REGAL_ES1_0_compatibility' => [
    'glAlphaFuncx',
    'glClearColorx',
    'glClearDepthx',
    'glColor4x',
    'glDepthRangex',
    'glFogx',
    'glFogxv_c',
    'glFogxv_p',
    'glFrustumf',
    'glFrustumx',
    'glLightModelx',
    'glLightModelxv_c',
    'glLightModelxv_p',
    'glLightx',
    'glLightxv_c',
    'glLightxv_p',
    'glLineWidthx',
    'glLoadMatrixx_c',
    'glLoadMatrixx_p',
    'glMaterialx',
    'glMaterialxv_c',
    'glMaterialxv_p',
    'glMultMatrixx_c',
    'glMultMatrixx_p',
    'glMultiTexCoord4x',
    'glNormal3x',
    'glOrthof',
    'glOrthox',
    'glPointSizex',
    'glPolygonOffsetx',
    'glRotatex',
    'glSampleCoveragex',
    'glScalex',
    'glTexEnvx',
    'glTexEnvxv_c',
    'glTexEnvxv_p',
    'glTexParameterx',
    'glTranslatex'
  ],
  'GL_REGAL_ES1_1_compatibility' => [
    'glClipPlanef_c',
    'glClipPlanef_p',
    'glClipPlanex_c',
    'glClipPlanex_p',
    'glGetClipPlanef_c',
    'glGetClipPlanef_p',
    'glGetClipPlanex_c',
    'glGetClipPlanex_p',
    'glGetFixedv_c',
    'glGetLightxv_c',
    'glGetLightxv_p',
    'glGetMaterialxv_c',
    'glGetMaterialxv_p',
    'glGetTexEnvxv_c',
    'glGetTexEnvxv_p',
    'glGetTexParameterxv_c',
    'glGetTexParameterxv_p',
    'glPointParameterx',
    'glPointParameterxv_c',
    'glPointParameterxv_p',
    'glPointSizePointerOES_c',
    'glTexParameterxv_c',
    'glTexParameterxv_p'
  ],
  'GL_REGAL_extension_query' => [
    'glGetExtensionREGAL',
    'glIsSupportedREGAL'
  ],
  'GL_REGAL_log' => [
    'glLogMessageCallbackREGAL'
  ],
  'GL_REGAL_proc_address' => [
    'glGetProcAddressREGAL_c'
  ],
  'GL_SGIS_detail_texture' => [
    'glDetailTexFuncSGIS_c',
    'glDetailTexFuncSGIS_p',
    'glGetDetailTexFuncSGIS_c',
    'glGetDetailTexFuncSGIS_p'
  ],
  'GL_SGIS_fog_function' => [
    'glFogFuncSGIS_c',
    'glFogFuncSGIS_p',
    'glGetFogFuncSGIS_c'
  ],
  'GL_SGIS_multisample' => [
    'glSampleMaskSGIS',
    'glSamplePatternSGIS'
  ],
  'GL_SGIS_multitexture' => [
    'glInterleavedTextureCoordSetsSGIS',
    'glSelectTextureCoordSetSGIS',
    'glSelectTextureSGIS',
    'glSelectTextureTransformSGIS'
  ],
  'GL_SGIS_shared_multisample' => [
    'glMultisampleSubRectPosSGIS'
  ],
  'GL_SGIS_sharpen_texture' => [
    'glGetSharpenTexFuncSGIS_c',
    'glGetSharpenTexFuncSGIS_p',
    'glSharpenTexFuncSGIS_c',
    'glSharpenTexFuncSGIS_p'
  ],
  'GL_SGIS_texture4D' => [
    'glTexImage4DSGIS_c',
    'glTexSubImage4DSGIS_c'
  ],
  'GL_SGIS_texture_filter4' => [
    'glGetTexFilterFuncSGIS_c',
    'glTexFilterFuncSGIS_c',
    'glTexFilterFuncSGIS_p'
  ],
  'GL_SGIX_async' => [
    'glAsyncMarkerSGIX',
    'glDeleteAsyncMarkersSGIX',
    'glFinishAsyncSGIX_c',
    'glFinishAsyncSGIX_p',
    'glGenAsyncMarkersSGIX',
    'glIsAsyncMarkerSGIX',
    'glPollAsyncSGIX_c',
    'glPollAsyncSGIX_p'
  ],
  'GL_SGIX_datapipe' => [
    'glAddressSpace',
    'glDataPipe'
  ],
  'GL_SGIX_flush_raster' => [
    'glFlushRasterSGIX'
  ],
  'GL_SGIX_fog_layers' => [
    'glFogLayersSGIX_c',
    'glGetFogLayersSGIX_c'
  ],
  'GL_SGIX_fog_texture' => [
    'glTextureFogSGIX'
  ],
  'GL_SGIX_fragment_specular_lighting' => [
    'glFragmentColorMaterialSGIX',
    'glFragmentLightModelfSGIX',
    'glFragmentLightModelfvSGIX_c',
    'glFragmentLightModeliSGIX',
    'glFragmentLightModelivSGIX_c',
    'glFragmentLightfSGIX',
    'glFragmentLightfvSGIX_c',
    'glFragmentLightfvSGIX_p',
    'glFragmentLightiSGIX',
    'glFragmentLightivSGIX_c',
    'glFragmentLightivSGIX_p',
    'glFragmentMaterialfSGIX',
    'glFragmentMaterialfvSGIX_c',
    'glFragmentMaterialfvSGIX_p',
    'glFragmentMaterialiSGIX',
    'glFragmentMaterialivSGIX_c',
    'glFragmentMaterialivSGIX_p',
    'glGetFragmentLightfvSGIX_c',
    'glGetFragmentLightfvSGIX_p',
    'glGetFragmentLightivSGIX_c',
    'glGetFragmentLightivSGIX_p',
    'glGetFragmentMaterialfvSGIX_c',
    'glGetFragmentMaterialfvSGIX_p',
    'glGetFragmentMaterialivSGIX_c',
    'glGetFragmentMaterialivSGIX_p'
  ],
  'GL_SGIX_framezoom' => [
    'glFrameZoomSGIX'
  ],
  'GL_SGIX_igloo_interface' => [
    'glIglooInterfaceSGIX_c'
  ],
  'GL_SGIX_mpeg1' => [
    'glAllocMPEGPredictorsSGIX_c',
    'glDeleteMPEGPredictorsSGIX_c',
    'glGenMPEGPredictorsSGIX_c',
    'glGetMPEGParameterfvSGIX_c',
    'glGetMPEGParameterivSGIX_c',
    'glGetMPEGPredictorSGIX_c',
    'glGetMPEGQuantTableubv_c',
    'glIsMPEGPredictorSGIX',
    'glMPEGPredictorSGIX_c',
    'glMPEGQuantTableubv_c',
    'glSwapMPEGPredictorsSGIX'
  ],
  'GL_SGIX_nonlinear_lighting_pervertex' => [
    'glGetNonlinLightfvSGIX_c',
    'glGetNonlinMaterialfvSGIX_c',
    'glNonlinLightfvSGIX_c',
    'glNonlinMaterialfvSGIX_c'
  ],
  'GL_SGIX_pixel_texture' => [
    'glPixelTexGenSGIX'
  ],
  'GL_SGIX_polynomial_ffd' => [
    'glDeformSGIX',
    'glLoadIdentityDeformationMapSGIX'
  ],
  'GL_SGIX_quad_mesh' => [
    'glMeshBreadthSGIX',
    'glMeshStrideSGIX'
  ],
  'GL_SGIX_reference_plane' => [
    'glReferencePlaneSGIX_c',
    'glReferencePlaneSGIX_p'
  ],
  'GL_SGIX_sprite' => [
    'glSpriteParameterfSGIX',
    'glSpriteParameterfvSGIX_c',
    'glSpriteParameteriSGIX',
    'glSpriteParameterivSGIX_c'
  ],
  'GL_SGIX_tag_sample_buffer' => [
    'glTagSampleBufferSGIX'
  ],
  'GL_SGIX_vector_ops' => [
    'glGetVectorOperationSGIX',
    'glVectorOperationSGIX'
  ],
  'GL_SGIX_vertex_array_object' => [
    'glAreVertexArraysResidentSGIX_c',
    'glBindVertexArraySGIX',
    'glDeleteVertexArraysSGIX_c',
    'glGenVertexArraysSGIX_c',
    'glIsVertexArraySGIX',
    'glPrioritizeVertexArraysSGIX_c'
  ],
  'GL_SGI_color_table' => [
    'glColorTableParameterfvSGI_c',
    'glColorTableParameterfvSGI_p',
    'glColorTableParameterivSGI_c',
    'glColorTableParameterivSGI_p',
    'glColorTableSGI_c',
    'glCopyColorTableSGI',
    'glGetColorTableParameterfvSGI_c',
    'glGetColorTableParameterfvSGI_p',
    'glGetColorTableParameterivSGI_c',
    'glGetColorTableParameterivSGI_p',
    'glGetColorTableSGI_c'
  ],
  'GL_SGI_fft' => [
    'glGetPixelTransformParameterfvSGI_c',
    'glGetPixelTransformParameterivSGI_c',
    'glPixelTransformParameterfSGI',
    'glPixelTransformParameterfvSGI_c',
    'glPixelTransformParameteriSGI',
    'glPixelTransformParameterivSGI_c',
    'glPixelTransformSGI'
  ],
  'GL_SUNX_constant_data' => [
    'glFinishTextureSUNX'
  ],
  'GL_SUN_global_alpha' => [
    'glGlobalAlphaFactorbSUN',
    'glGlobalAlphaFactordSUN',
    'glGlobalAlphaFactorfSUN',
    'glGlobalAlphaFactoriSUN',
    'glGlobalAlphaFactorsSUN',
    'glGlobalAlphaFactorubSUN',
    'glGlobalAlphaFactoruiSUN',
    'glGlobalAlphaFactorusSUN'
  ],
  'GL_SUN_read_video_pixels' => [
    'glReadVideoPixelsSUN_c'
  ],
  'GL_SUN_triangle_list' => [
    'glReplacementCodePointerSUN_c',
    'glReplacementCodeubSUN',
    'glReplacementCodeubvSUN_c',
    'glReplacementCodeuiSUN',
    'glReplacementCodeuivSUN_c',
    'glReplacementCodeusSUN',
    'glReplacementCodeusvSUN_c'
  ],
  'GL_SUN_vertex' => [
    'glColor3fVertex3fSUN',
    'glColor3fVertex3fvSUN_c',
    'glColor3fVertex3fvSUN_p',
    'glColor4fNormal3fVertex3fSUN',
    'glColor4fNormal3fVertex3fvSUN_c',
    'glColor4fNormal3fVertex3fvSUN_p',
    'glColor4ubVertex2fSUN',
    'glColor4ubVertex2fvSUN_c',
    'glColor4ubVertex2fvSUN_p',
    'glColor4ubVertex3fSUN',
    'glColor4ubVertex3fvSUN_c',
    'glColor4ubVertex3fvSUN_p',
    'glNormal3fVertex3fSUN',
    'glNormal3fVertex3fvSUN_c',
    'glNormal3fVertex3fvSUN_p',
    'glReplacementCodeuiColor3fVertex3fSUN',
    'glReplacementCodeuiColor3fVertex3fvSUN_c',
    'glReplacementCodeuiColor3fVertex3fvSUN_p',
    'glReplacementCodeuiColor4fNormal3fVertex3fSUN',
    'glReplacementCodeuiColor4fNormal3fVertex3fvSUN_c',
    'glReplacementCodeuiColor4fNormal3fVertex3fvSUN_p',
    'glReplacementCodeuiColor4ubVertex3fSUN',
    'glReplacementCodeuiColor4ubVertex3fvSUN_c',
    'glReplacementCodeuiColor4ubVertex3fvSUN_p',
    'glReplacementCodeuiNormal3fVertex3fSUN',
    'glReplacementCodeuiNormal3fVertex3fvSUN_c',
    'glReplacementCodeuiNormal3fVertex3fvSUN_p',
    'glReplacementCodeuiTexCoord2fColor4fNormal3fVertex3fSUN',
    'glReplacementCodeuiTexCoord2fColor4fNormal3fVertex3fvSUN_c',
    'glReplacementCodeuiTexCoord2fColor4fNormal3fVertex3fvSUN_p',
    'glReplacementCodeuiTexCoord2fNormal3fVertex3fSUN',
    'glReplacementCodeuiTexCoord2fNormal3fVertex3fvSUN_c',
    'glReplacementCodeuiTexCoord2fNormal3fVertex3fvSUN_p',
    'glReplacementCodeuiTexCoord2fVertex3fSUN',
    'glReplacementCodeuiTexCoord2fVertex3fvSUN_c',
    'glReplacementCodeuiTexCoord2fVertex3fvSUN_p',
    'glReplacementCodeuiVertex3fSUN',
    'glReplacementCodeuiVertex3fvSUN_c',
    'glReplacementCodeuiVertex3fvSUN_p',
    'glTexCoord2fColor3fVertex3fSUN',
    'glTexCoord2fColor3fVertex3fvSUN_c',
    'glTexCoord2fColor3fVertex3fvSUN_p',
    'glTexCoord2fColor4fNormal3fVertex3fSUN',
    'glTexCoord2fColor4fNormal3fVertex3fvSUN_c',
    'glTexCoord2fColor4fNormal3fVertex3fvSUN_p',
    'glTexCoord2fColor4ubVertex3fSUN',
    'glTexCoord2fColor4ubVertex3fvSUN_c',
    'glTexCoord2fColor4ubVertex3fvSUN_p',
    'glTexCoord2fNormal3fVertex3fSUN',
    'glTexCoord2fNormal3fVertex3fvSUN_c',
    'glTexCoord2fNormal3fVertex3fvSUN_p',
    'glTexCoord2fVertex3fSUN',
    'glTexCoord2fVertex3fvSUN_c',
    'glTexCoord2fVertex3fvSUN_p',
    'glTexCoord4fColor4fNormal3fVertex4fSUN',
    'glTexCoord4fColor4fNormal3fVertex4fvSUN_c',
    'glTexCoord4fColor4fNormal3fVertex4fvSUN_p',
    'glTexCoord4fVertex4fSUN',
    'glTexCoord4fVertex4fvSUN_c',
    'glTexCoord4fVertex4fvSUN_p'
  ],
  'GL_VERSION_1_1' => [
    'glAccum',
    'glAlphaFunc',
    'glAreTexturesResident_c',
    'glAreTexturesResident_p',
    'glArrayElement',
    'glBegin',
    'glBindTexture',
    'glBitmap',
    'glBlendFunc',
    'glCallList',
    'glCallLists_c',
    'glClear',
    'glClearAccum',
    'glClearColor',
    'glClearDepth',
    'glClearIndex',
    'glClearStencil',
    'glClipPlane_c',
    'glClipPlane_p',
    'glColor3b',
    'glColor3bv_c',
    'glColor3bv_p',
    'glColor3d',
    'glColor3dv_c',
    'glColor3dv_p',
    'glColor3f',
    'glColor3fv_c',
    'glColor3fv_p',
    'glColor3i',
    'glColor3iv_c',
    'glColor3iv_p',
    'glColor3s',
    'glColor3sv_c',
    'glColor3sv_p',
    'glColor3ub',
    'glColor3ubv_c',
    'glColor3ubv_p',
    'glColor3ui',
    'glColor3uiv_c',
    'glColor3uiv_p',
    'glColor3us',
    'glColor3usv_c',
    'glColor3usv_p',
    'glColor4b',
    'glColor4bv_c',
    'glColor4bv_p',
    'glColor4d',
    'glColor4dv_c',
    'glColor4dv_p',
    'glColor4f',
    'glColor4fv_c',
    'glColor4fv_p',
    'glColor4i',
    'glColor4iv_c',
    'glColor4iv_p',
    'glColor4s',
    'glColor4sv_c',
    'glColor4sv_p',
    'glColor4ub',
    'glColor4ubv_c',
    'glColor4ubv_p',
    'glColor4ui',
    'glColor4uiv_c',
    'glColor4uiv_p',
    'glColor4us',
    'glColor4usv_c',
    'glColor4usv_p',
    'glColorMask',
    'glColorMaterial',
    'glColorPointer_c',
    'glCopyPixels',
    'glCopyTexImage1D',
    'glCopyTexImage2D',
    'glCopyTexSubImage1D',
    'glCopyTexSubImage2D',
    'glCullFace',
    'glDeleteLists',
    'glDeleteTextures_c',
    'glDeleteTextures_p',
    'glDepthFunc',
    'glDepthMask',
    'glDepthRange',
    'glDisable',
    'glDisableClientState',
    'glDrawArrays',
    'glDrawBuffer',
    'glDrawElements_c',
    'glDrawPixels_c',
    'glEdgeFlag',
    'glEdgeFlagPointer_c',
    'glEdgeFlagv_c',
    'glEdgeFlagv_p',
    'glEnable',
    'glEnableClientState',
    'glEnd',
    'glEndList',
    'glEvalCoord1d',
    'glEvalCoord1dv_c',
    'glEvalCoord1dv_p',
    'glEvalCoord1f',
    'glEvalCoord1fv_c',
    'glEvalCoord1fv_p',
    'glEvalCoord2d',
    'glEvalCoord2dv_c',
    'glEvalCoord2dv_p',
    'glEvalCoord2f',
    'glEvalCoord2fv_c',
    'glEvalCoord2fv_p',
    'glEvalMesh1',
    'glEvalMesh2',
    'glEvalPoint1',
    'glEvalPoint2',
    'glFeedbackBuffer_c',
    'glFeedbackBuffer_p',
    'glFinish',
    'glFlush',
    'glFogf',
    'glFogfv_c',
    'glFogfv_p',
    'glFogi',
    'glFogiv_c',
    'glFogiv_p',
    'glFrontFace',
    'glFrustum',
    'glGenLists',
    'glGenTextures_c',
    'glGenTextures_p',
    'glGetBooleanv_c',
    'glGetBooleanv_p',
    'glGetClipPlane_c',
    'glGetClipPlane_p',
    'glGetDoublev_c',
    'glGetDoublev_p',
    'glGetError',
    'glGetFloatv_c',
    'glGetFloatv_p',
    'glGetIntegerv_c',
    'glGetIntegerv_p',
    'glGetLightfv_c',
    'glGetLightfv_p',
    'glGetLightiv_c',
    'glGetLightiv_p',
    'glGetMapdv_c',
    'glGetMapfv_c',
    'glGetMapiv_c',
    'glGetMaterialfv_c',
    'glGetMaterialfv_p',
    'glGetMaterialiv_c',
    'glGetMaterialiv_p',
    'glGetPixelMapfv_c',
    'glGetPixelMapuiv_c',
    'glGetPixelMapusv_c',
    'glGetPointerv_c',
    'glGetPolygonStipple_c',
    'glGetString',
    'glGetTexEnvfv_c',
    'glGetTexEnvfv_p',
    'glGetTexEnviv_c',
    'glGetTexEnviv_p',
    'glGetTexGendv_c',
    'glGetTexGendv_p',
    'glGetTexGenfv_c',
    'glGetTexGenfv_p',
    'glGetTexGeniv_c',
    'glGetTexGeniv_p',
    'glGetTexImage_c',
    'glGetTexLevelParameterfv_c',
    'glGetTexLevelParameterfv_p',
    'glGetTexLevelParameteriv_c',
    'glGetTexLevelParameteriv_p',
    'glGetTexParameterfv_c',
    'glGetTexParameterfv_p',
    'glGetTexParameteriv_c',
    'glGetTexParameteriv_p',
    'glHint',
    'glIndexMask',
    'glIndexPointer_c',
    'glIndexd',
    'glIndexdv_c',
    'glIndexdv_p',
    'glIndexf',
    'glIndexfv_c',
    'glIndexfv_p',
    'glIndexi',
    'glIndexiv_c',
    'glIndexiv_p',
    'glIndexs',
    'glIndexsv_c',
    'glIndexsv_p',
    'glIndexub',
    'glIndexubv_c',
    'glIndexubv_p',
    'glInitNames',
    'glInterleavedArrays_c',
    'glIsEnabled',
    'glIsList',
    'glIsTexture',
    'glLightModelf',
    'glLightModelfv_c',
    'glLightModelfv_p',
    'glLightModeli',
    'glLightModeliv_c',
    'glLightModeliv_p',
    'glLightf',
    'glLightfv_c',
    'glLightfv_p',
    'glLighti',
    'glLightiv_c',
    'glLightiv_p',
    'glLineStipple',
    'glLineWidth',
    'glListBase',
    'glLoadIdentity',
    'glLoadMatrixd_c',
    'glLoadMatrixd_p',
    'glLoadMatrixf_c',
    'glLoadMatrixf_p',
    'glLoadName',
    'glLogicOp',
    'glMap1d_c',
    'glMap1f_c',
    'glMap2d_c',
    'glMap2f_c',
    'glMapGrid1d',
    'glMapGrid1f',
    'glMapGrid2d',
    'glMapGrid2f',
    'glMaterialf',
    'glMaterialfv_c',
    'glMaterialfv_p',
    'glMateriali',
    'glMaterialiv_c',
    'glMaterialiv_p',
    'glMatrixMode',
    'glMultMatrixd_c',
    'glMultMatrixd_p',
    'glMultMatrixf_c',
    'glMultMatrixf_p',
    'glNewList',
    'glNormal3b',
    'glNormal3bv_c',
    'glNormal3bv_p',
    'glNormal3d',
    'glNormal3dv_c',
    'glNormal3dv_p',
    'glNormal3f',
    'glNormal3fv_c',
    'glNormal3fv_p',
    'glNormal3i',
    'glNormal3iv_c',
    'glNormal3iv_p',
    'glNormal3s',
    'glNormal3sv_c',
    'glNormal3sv_p',
    'glNormalPointer_c',
    'glOrtho',
    'glPassThrough',
    'glPixelMapfv_c',
    'glPixelMapfv_p',
    'glPixelMapuiv_c',
    'glPixelMapuiv_p',
    'glPixelMapusv_c',
    'glPixelMapusv_p',
    'glPixelStoref',
    'glPixelStorei',
    'glPixelTransferf',
    'glPixelTransferi',
    'glPixelZoom',
    'glPointSize',
    'glPolygonMode',
    'glPolygonOffset',
    'glPolygonStipple',
    'glPopAttrib',
    'glPopClientAttrib',
    'glPopMatrix',
    'glPopName',
    'glPrioritizeTextures_c',
    'glPrioritizeTextures_p',
    'glPushAttrib',
    'glPushClientAttrib',
    'glPushMatrix',
    'glPushName',
    'glRasterPos2d',
    'glRasterPos2dv_c',
    'glRasterPos2dv_p',
    'glRasterPos2f',
    'glRasterPos2fv_c',
    'glRasterPos2fv_p',
    'glRasterPos2i',
    'glRasterPos2iv_c',
    'glRasterPos2iv_p',
    'glRasterPos2s',
    'glRasterPos2sv_c',
    'glRasterPos2sv_p',
    'glRasterPos3d',
    'glRasterPos3dv_c',
    'glRasterPos3dv_p',
    'glRasterPos3f',
    'glRasterPos3fv_c',
    'glRasterPos3fv_p',
    'glRasterPos3i',
    'glRasterPos3iv_c',
    'glRasterPos3iv_p',
    'glRasterPos3s',
    'glRasterPos3sv_c',
    'glRasterPos3sv_p',
    'glRasterPos4d',
    'glRasterPos4dv_c',
    'glRasterPos4dv_p',
    'glRasterPos4f',
    'glRasterPos4fv_c',
    'glRasterPos4fv_p',
    'glRasterPos4i',
    'glRasterPos4iv_c',
    'glRasterPos4iv_p',
    'glRasterPos4s',
    'glRasterPos4sv_c',
    'glRasterPos4sv_p',
    'glReadBuffer',
    'glReadPixels_c',
    'glRectd',
    'glRectdv_c',
    'glRectdv_p',
    'glRectf',
    'glRectfv_c',
    'glRectfv_p',
    'glRecti',
    'glRectiv_c',
    'glRectiv_p',
    'glRects',
    'glRectsv_c',
    'glRectsv_p',
    'glRenderMode',
    'glRotated',
    'glRotatef',
    'glScaled',
    'glScalef',
    'glScissor',
    'glSelectBuffer_c',
    'glSelectBuffer_p',
    'glShadeModel',
    'glStencilFunc',
    'glStencilMask',
    'glStencilOp',
    'glTexCoord1d',
    'glTexCoord1dv_c',
    'glTexCoord1dv_p',
    'glTexCoord1f',
    'glTexCoord1fv_c',
    'glTexCoord1fv_p',
    'glTexCoord1i',
    'glTexCoord1iv_c',
    'glTexCoord1iv_p',
    'glTexCoord1s',
    'glTexCoord1sv_c',
    'glTexCoord1sv_p',
    'glTexCoord2d',
    'glTexCoord2dv_c',
    'glTexCoord2dv_p',
    'glTexCoord2f',
    'glTexCoord2fv_c',
    'glTexCoord2fv_p',
    'glTexCoord2i',
    'glTexCoord2iv_c',
    'glTexCoord2iv_p',
    'glTexCoord2s',
    'glTexCoord2sv_c',
    'glTexCoord2sv_p',
    'glTexCoord3d',
    'glTexCoord3dv_c',
    'glTexCoord3dv_p',
    'glTexCoord3f',
    'glTexCoord3fv_c',
    'glTexCoord3fv_p',
    'glTexCoord3i',
    'glTexCoord3iv_c',
    'glTexCoord3iv_p',
    'glTexCoord3s',
    'glTexCoord3sv_c',
    'glTexCoord3sv_p',
    'glTexCoord4d',
    'glTexCoord4dv_c',
    'glTexCoord4dv_p',
    'glTexCoord4f',
    'glTexCoord4fv_c',
    'glTexCoord4fv_p',
    'glTexCoord4i',
    'glTexCoord4iv_c',
    'glTexCoord4iv_p',
    'glTexCoord4s',
    'glTexCoord4sv_c',
    'glTexCoord4sv_p',
    'glTexCoordPointer_c',
    'glTexEnvf',
    'glTexEnvfv_c',
    'glTexEnvfv_p',
    'glTexEnvi',
    'glTexEnviv_c',
    'glTexEnviv_p',
    'glTexGend',
    'glTexGendv_c',
    'glTexGendv_p',
    'glTexGenf',
    'glTexGenfv_c',
    'glTexGenfv_p',
    'glTexGeni',
    'glTexGeniv_c',
    'glTexGeniv_p',
    'glTexImage1D_c',
    'glTexImage2D_c',
    'glTexParameterf',
    'glTexParameterfv_c',
    'glTexParameterfv_p',
    'glTexParameteri',
    'glTexParameteriv_c',
    'glTexParameteriv_p',
    'glTexSubImage1D_c',
    'glTexSubImage2D_c',
    'glTranslated',
    'glTranslatef',
    'glVertex2d',
    'glVertex2dv_c',
    'glVertex2dv_p',
    'glVertex2f',
    'glVertex2fv_c',
    'glVertex2fv_p',
    'glVertex2i',
    'glVertex2iv_c',
    'glVertex2iv_p',
    'glVertex2s',
    'glVertex2sv_c',
    'glVertex2sv_p',
    'glVertex3d',
    'glVertex3dv_c',
    'glVertex3dv_p',
    'glVertex3f',
    'glVertex3fv_c',
    'glVertex3fv_p',
    'glVertex3i',
    'glVertex3iv_c',
    'glVertex3iv_p',
    'glVertex3s',
    'glVertex3sv_c',
    'glVertex3sv_p',
    'glVertex4d',
    'glVertex4dv_c',
    'glVertex4dv_p',
    'glVertex4f',
    'glVertex4fv_c',
    'glVertex4fv_p',
    'glVertex4i',
    'glVertex4iv_c',
    'glVertex4iv_p',
    'glVertex4s',
    'glVertex4sv_c',
    'glVertex4sv_p',
    'glVertexPointer_c',
    'glViewport'
  ],
  'GL_VERSION_1_2' => [
    'glCopyTexSubImage3D',
    'glDrawRangeElements_c',
    'glTexImage3D_c',
    'glTexSubImage3D_c'
  ],
  'GL_VERSION_1_3' => [
    'glActiveTexture',
    'glClientActiveTexture',
    'glCompressedTexImage1D_c',
    'glCompressedTexImage2D_c',
    'glCompressedTexImage3D_c',
    'glCompressedTexSubImage1D_c',
    'glCompressedTexSubImage2D_c',
    'glCompressedTexSubImage3D_c',
    'glGetCompressedTexImage_c',
    'glLoadTransposeMatrixd_c',
    'glLoadTransposeMatrixd_p',
    'glLoadTransposeMatrixf_c',
    'glLoadTransposeMatrixf_p',
    'glMultTransposeMatrixd_c',
    'glMultTransposeMatrixd_p',
    'glMultTransposeMatrixf_c',
    'glMultTransposeMatrixf_p',
    'glMultiTexCoord1d',
    'glMultiTexCoord1dv_c',
    'glMultiTexCoord1dv_p',
    'glMultiTexCoord1f',
    'glMultiTexCoord1fv_c',
    'glMultiTexCoord1fv_p',
    'glMultiTexCoord1i',
    'glMultiTexCoord1iv_c',
    'glMultiTexCoord1iv_p',
    'glMultiTexCoord1s',
    'glMultiTexCoord1sv_c',
    'glMultiTexCoord1sv_p',
    'glMultiTexCoord2d',
    'glMultiTexCoord2dv_c',
    'glMultiTexCoord2dv_p',
    'glMultiTexCoord2f',
    'glMultiTexCoord2fv_c',
    'glMultiTexCoord2fv_p',
    'glMultiTexCoord2i',
    'glMultiTexCoord2iv_c',
    'glMultiTexCoord2iv_p',
    'glMultiTexCoord2s',
    'glMultiTexCoord2sv_c',
    'glMultiTexCoord2sv_p',
    'glMultiTexCoord3d',
    'glMultiTexCoord3dv_c',
    'glMultiTexCoord3dv_p',
    'glMultiTexCoord3f',
    'glMultiTexCoord3fv_c',
    'glMultiTexCoord3fv_p',
    'glMultiTexCoord3i',
    'glMultiTexCoord3iv_c',
    'glMultiTexCoord3iv_p',
    'glMultiTexCoord3s',
    'glMultiTexCoord3sv_c',
    'glMultiTexCoord3sv_p',
    'glMultiTexCoord4d',
    'glMultiTexCoord4dv_c',
    'glMultiTexCoord4dv_p',
    'glMultiTexCoord4f',
    'glMultiTexCoord4fv_c',
    'glMultiTexCoord4fv_p',
    'glMultiTexCoord4i',
    'glMultiTexCoord4iv_c',
    'glMultiTexCoord4iv_p',
    'glMultiTexCoord4s',
    'glMultiTexCoord4sv_c',
    'glMultiTexCoord4sv_p',
    'glSampleCoverage'
  ],
  'GL_VERSION_1_4' => [
    'glBlendColor',
    'glBlendEquation',
    'glBlendFuncSeparate',
    'glFogCoordPointer_c',
    'glFogCoordd',
    'glFogCoorddv_c',
    'glFogCoorddv_p',
    'glFogCoordf',
    'glFogCoordfv_c',
    'glFogCoordfv_p',
    'glMultiDrawArrays_c',
    'glMultiDrawArrays_p',
    'glMultiDrawElements_c',
    'glPointParameterf',
    'glPointParameterfv_c',
    'glPointParameterfv_p',
    'glPointParameteri',
    'glPointParameteriv_c',
    'glPointParameteriv_p',
    'glSecondaryColor3b',
    'glSecondaryColor3bv_c',
    'glSecondaryColor3bv_p',
    'glSecondaryColor3d',
    'glSecondaryColor3dv_c',
    'glSecondaryColor3dv_p',
    'glSecondaryColor3f',
    'glSecondaryColor3fv_c',
    'glSecondaryColor3fv_p',
    'glSecondaryColor3i',
    'glSecondaryColor3iv_c',
    'glSecondaryColor3iv_p',
    'glSecondaryColor3s',
    'glSecondaryColor3sv_c',
    'glSecondaryColor3sv_p',
    'glSecondaryColor3ub',
    'glSecondaryColor3ubv_c',
    'glSecondaryColor3ubv_p',
    'glSecondaryColor3ui',
    'glSecondaryColor3uiv_c',
    'glSecondaryColor3uiv_p',
    'glSecondaryColor3us',
    'glSecondaryColor3usv_c',
    'glSecondaryColor3usv_p',
    'glSecondaryColorPointer_c',
    'glWindowPos2d',
    'glWindowPos2dv_c',
    'glWindowPos2dv_p',
    'glWindowPos2f',
    'glWindowPos2fv_c',
    'glWindowPos2fv_p',
    'glWindowPos2i',
    'glWindowPos2iv_c',
    'glWindowPos2iv_p',
    'glWindowPos2s',
    'glWindowPos2sv_c',
    'glWindowPos2sv_p',
    'glWindowPos3d',
    'glWindowPos3dv_c',
    'glWindowPos3dv_p',
    'glWindowPos3f',
    'glWindowPos3fv_c',
    'glWindowPos3fv_p',
    'glWindowPos3i',
    'glWindowPos3iv_c',
    'glWindowPos3iv_p',
    'glWindowPos3s',
    'glWindowPos3sv_c',
    'glWindowPos3sv_p'
  ],
  'GL_VERSION_1_5' => [
    'glBeginQuery',
    'glBindBuffer',
    'glBufferData_c',
    'glBufferSubData_c',
    'glDeleteBuffers_c',
    'glDeleteBuffers_p',
    'glDeleteQueries_c',
    'glDeleteQueries_p',
    'glEndQuery',
    'glGenBuffers_c',
    'glGenBuffers_p',
    'glGenQueries_c',
    'glGenQueries_p',
    'glGetBufferParameteriv_c',
    'glGetBufferParameteriv_p',
    'glGetBufferPointerv_c',
    'glGetBufferSubData_c',
    'glGetQueryObjectiv_c',
    'glGetQueryObjectiv_p',
    'glGetQueryObjectuiv_c',
    'glGetQueryObjectuiv_p',
    'glGetQueryiv_c',
    'glGetQueryiv_p',
    'glIsBuffer',
    'glIsQuery',
    'glMapBuffer_c',
    'glUnmapBuffer'
  ],
  'GL_VERSION_2_0' => [
    'glAttachShader',
    'glBindAttribLocation',
    'glBlendEquationSeparate',
    'glCompileShader',
    'glCreateProgram',
    'glCreateShader',
    'glDeleteProgram',
    'glDeleteShader',
    'glDetachShader',
    'glDisableVertexAttribArray',
    'glDrawBuffers_c',
    'glDrawBuffers_p',
    'glEnableVertexAttribArray',
    'glGetActiveAttrib_c',
    'glGetActiveAttrib_p',
    'glGetActiveUniform_c',
    'glGetActiveUniform_p',
    'glGetAttachedShaders_c',
    'glGetAttachedShaders_p',
    'glGetAttribLocation',
    'glGetProgramInfoLog_c',
    'glGetProgramInfoLog_p',
    'glGetProgramiv_c',
    'glGetProgramiv_p',
    'glGetShaderInfoLog_c',
    'glGetShaderInfoLog_p',
    'glGetShaderSource_c',
    'glGetShaderSource_p',
    'glGetShaderiv_c',
    'glGetShaderiv_p',
    'glGetUniformLocation',
    'glGetUniformfv_c',
    'glGetUniformiv_c',
    'glGetVertexAttribPointerv_c',
    'glGetVertexAttribdv_c',
    'glGetVertexAttribdv_p',
    'glGetVertexAttribfv_c',
    'glGetVertexAttribfv_p',
    'glGetVertexAttribiv_c',
    'glGetVertexAttribiv_p',
    'glIsProgram',
    'glIsShader',
    'glLinkProgram',
    'glShaderSource_c',
    'glShaderSource_p',
    'glStencilFuncSeparate',
    'glStencilMaskSeparate',
    'glStencilOpSeparate',
    'glUniform1f',
    'glUniform1fv_c',
    'glUniform1fv_p',
    'glUniform1i',
    'glUniform1iv_c',
    'glUniform1iv_p',
    'glUniform2f',
    'glUniform2fv_c',
    'glUniform2fv_p',
    'glUniform2i',
    'glUniform2iv_c',
    'glUniform2iv_p',
    'glUniform3f',
    'glUniform3fv_c',
    'glUniform3fv_p',
    'glUniform3i',
    'glUniform3iv_c',
    'glUniform3iv_p',
    'glUniform4f',
    'glUniform4fv_c',
    'glUniform4fv_p',
    'glUniform4i',
    'glUniform4iv_c',
    'glUniform4iv_p',
    'glUniformMatrix2fv_c',
    'glUniformMatrix2fv_p',
    'glUniformMatrix3fv_c',
    'glUniformMatrix3fv_p',
    'glUniformMatrix4fv_c',
    'glUniformMatrix4fv_p',
    'glUseProgram',
    'glValidateProgram',
    'glVertexAttrib1d',
    'glVertexAttrib1dv_c',
    'glVertexAttrib1dv_p',
    'glVertexAttrib1f',
    'glVertexAttrib1fv_c',
    'glVertexAttrib1fv_p',
    'glVertexAttrib1s',
    'glVertexAttrib1sv_c',
    'glVertexAttrib1sv_p',
    'glVertexAttrib2d',
    'glVertexAttrib2dv_c',
    'glVertexAttrib2dv_p',
    'glVertexAttrib2f',
    'glVertexAttrib2fv_c',
    'glVertexAttrib2fv_p',
    'glVertexAttrib2s',
    'glVertexAttrib2sv_c',
    'glVertexAttrib2sv_p',
    'glVertexAttrib3d',
    'glVertexAttrib3dv_c',
    'glVertexAttrib3dv_p',
    'glVertexAttrib3f',
    'glVertexAttrib3fv_c',
    'glVertexAttrib3fv_p',
    'glVertexAttrib3s',
    'glVertexAttrib3sv_c',
    'glVertexAttrib3sv_p',
    'glVertexAttrib4Nbv_c',
    'glVertexAttrib4Nbv_p',
    'glVertexAttrib4Niv_c',
    'glVertexAttrib4Niv_p',
    'glVertexAttrib4Nsv_c',
    'glVertexAttrib4Nsv_p',
    'glVertexAttrib4Nub',
    'glVertexAttrib4Nubv_c',
    'glVertexAttrib4Nubv_p',
    'glVertexAttrib4Nuiv_c',
    'glVertexAttrib4Nuiv_p',
    'glVertexAttrib4Nusv_c',
    'glVertexAttrib4Nusv_p',
    'glVertexAttrib4bv_c',
    'glVertexAttrib4bv_p',
    'glVertexAttrib4d',
    'glVertexAttrib4dv_c',
    'glVertexAttrib4dv_p',
    'glVertexAttrib4f',
    'glVertexAttrib4fv_c',
    'glVertexAttrib4fv_p',
    'glVertexAttrib4iv_c',
    'glVertexAttrib4iv_p',
    'glVertexAttrib4s',
    'glVertexAttrib4sv_c',
    'glVertexAttrib4sv_p',
    'glVertexAttrib4ubv_c',
    'glVertexAttrib4ubv_p',
    'glVertexAttrib4uiv_c',
    'glVertexAttrib4uiv_p',
    'glVertexAttrib4usv_c',
    'glVertexAttrib4usv_p',
    'glVertexAttribPointer_c'
  ],
  'GL_VERSION_2_1' => [
    'glUniformMatrix2x3fv_c',
    'glUniformMatrix2x3fv_p',
    'glUniformMatrix2x4fv_c',
    'glUniformMatrix2x4fv_p',
    'glUniformMatrix3x2fv_c',
    'glUniformMatrix3x2fv_p',
    'glUniformMatrix3x4fv_c',
    'glUniformMatrix3x4fv_p',
    'glUniformMatrix4x2fv_c',
    'glUniformMatrix4x2fv_p',
    'glUniformMatrix4x3fv_c',
    'glUniformMatrix4x3fv_p'
  ],
  'GL_VERSION_3_0' => [
    'glBeginConditionalRender',
    'glBeginTransformFeedback',
    'glBindFragDataLocation',
    'glBindFramebuffer',
    'glBindRenderbuffer',
    'glBindVertexArray',
    'glBlitFramebuffer',
    'glCheckFramebufferStatus',
    'glClampColor',
    'glClearBufferfi',
    'glClearBufferfv_c',
    'glClearBufferfv_p',
    'glClearBufferiv_c',
    'glClearBufferiv_p',
    'glClearBufferuiv_c',
    'glClearBufferuiv_p',
    'glColorMaski',
    'glDeleteFramebuffers_c',
    'glDeleteFramebuffers_p',
    'glDeleteRenderbuffers_c',
    'glDeleteRenderbuffers_p',
    'glDeleteVertexArrays_c',
    'glDeleteVertexArrays_p',
    'glDisablei',
    'glEnablei',
    'glEndConditionalRender',
    'glEndTransformFeedback',
    'glFlushMappedBufferRange',
    'glFramebufferRenderbuffer',
    'glFramebufferTexture1D',
    'glFramebufferTexture2D',
    'glFramebufferTexture3D',
    'glFramebufferTextureLayer',
    'glGenFramebuffers_c',
    'glGenFramebuffers_p',
    'glGenRenderbuffers_c',
    'glGenRenderbuffers_p',
    'glGenVertexArrays_c',
    'glGenVertexArrays_p',
    'glGenerateMipmap',
    'glGetBooleani_v_c',
    'glGetBooleani_v_p',
    'glGetFragDataLocation',
    'glGetFramebufferAttachmentParameteriv_c',
    'glGetFramebufferAttachmentParameteriv_p',
    'glGetRenderbufferParameteriv_c',
    'glGetRenderbufferParameteriv_p',
    'glGetTexParameterIiv_c',
    'glGetTexParameterIiv_p',
    'glGetTexParameterIuiv_c',
    'glGetTexParameterIuiv_p',
    'glGetTransformFeedbackVarying_c',
    'glGetTransformFeedbackVarying_p',
    'glGetUniformuiv_c',
    'glGetVertexAttribIiv_c',
    'glGetVertexAttribIiv_p',
    'glGetVertexAttribIuiv_c',
    'glGetVertexAttribIuiv_p',
    'glIsEnabledi',
    'glIsFramebuffer',
    'glIsRenderbuffer',
    'glIsVertexArray',
    'glMapBufferRange_c',
    'glRenderbufferStorage',
    'glRenderbufferStorageMultisample',
    'glTexParameterIiv_c',
    'glTexParameterIiv_p',
    'glTexParameterIuiv_c',
    'glTexParameterIuiv_p',
    'glTransformFeedbackVaryings_c',
    'glTransformFeedbackVaryings_p',
    'glUniform1ui',
    'glUniform1uiv_c',
    'glUniform1uiv_p',
    'glUniform2ui',
    'glUniform2uiv_c',
    'glUniform2uiv_p',
    'glUniform3ui',
    'glUniform3uiv_c',
    'glUniform3uiv_p',
    'glUniform4ui',
    'glUniform4uiv_c',
    'glUniform4uiv_p',
    'glVertexAttribI1i',
    'glVertexAttribI1iv_c',
    'glVertexAttribI1iv_p',
    'glVertexAttribI1ui',
    'glVertexAttribI1uiv_c',
    'glVertexAttribI1uiv_p',
    'glVertexAttribI2i',
    'glVertexAttribI2iv_c',
    'glVertexAttribI2iv_p',
    'glVertexAttribI2ui',
    'glVertexAttribI2uiv_c',
    'glVertexAttribI2uiv_p',
    'glVertexAttribI3i',
    'glVertexAttribI3iv_c',
    'glVertexAttribI3iv_p',
    'glVertexAttribI3ui',
    'glVertexAttribI3uiv_c',
    'glVertexAttribI3uiv_p',
    'glVertexAttribI4bv_c',
    'glVertexAttribI4bv_p',
    'glVertexAttribI4i',
    'glVertexAttribI4iv_c',
    'glVertexAttribI4iv_p',
    'glVertexAttribI4sv_c',
    'glVertexAttribI4sv_p',
    'glVertexAttribI4ubv_c',
    'glVertexAttribI4ubv_p',
    'glVertexAttribI4ui',
    'glVertexAttribI4uiv_c',
    'glVertexAttribI4uiv_p',
    'glVertexAttribI4usv_c',
    'glVertexAttribI4usv_p',
    'glVertexAttribIPointer_c'
  ],
  'GL_VERSION_3_1' => [
    'glBindBufferBase',
    'glBindBufferRange',
    'glCopyBufferSubData',
    'glDrawArraysInstanced',
    'glDrawElementsInstanced_c',
    'glGetActiveUniformBlockName_c',
    'glGetActiveUniformBlockName_p',
    'glGetActiveUniformBlockiv_c',
    'glGetActiveUniformName_c',
    'glGetActiveUniformName_p',
    'glGetActiveUniformsiv_c',
    'glGetActiveUniformsiv_p',
    'glGetIntegeri_v_c',
    'glGetIntegeri_v_p',
    'glGetUniformBlockIndex',
    'glGetUniformIndices_c',
    'glGetUniformIndices_p',
    'glPrimitiveRestartIndex',
    'glTexBuffer',
    'glUniformBlockBinding'
  ],
  'GL_VERSION_3_2' => [
    'glClientWaitSync',
    'glDeleteSync',
    'glDrawElementsBaseVertex_c',
    'glDrawElementsInstancedBaseVertex_c',
    'glDrawRangeElementsBaseVertex_c',
    'glFenceSync',
    'glFramebufferTexture',
    'glGetBufferParameteri64v_c',
    'glGetBufferParameteri64v_p',
    'glGetInteger64i_v_c',
    'glGetInteger64i_v_p',
    'glGetInteger64v_c',
    'glGetInteger64v_p',
    'glGetMultisamplefv_c',
    'glGetMultisamplefv_p',
    'glGetSynciv_c',
    'glGetSynciv_p',
    'glIsSync',
    'glMultiDrawElementsBaseVertex_c',
    'glProvokingVertex',
    'glSampleMaski',
    'glTexImage2DMultisample',
    'glTexImage3DMultisample',
    'glWaitSync'
  ],
  'GL_VERSION_3_3' => [
    'glBindFragDataLocationIndexed',
    'glBindSampler',
    'glColorP3ui',
    'glColorP3uiv_c',
    'glColorP3uiv_p',
    'glColorP4ui',
    'glColorP4uiv_c',
    'glColorP4uiv_p',
    'glDeleteSamplers_c',
    'glDeleteSamplers_p',
    'glGenSamplers_c',
    'glGenSamplers_p',
    'glGetFragDataIndex',
    'glGetQueryObjecti64v_c',
    'glGetQueryObjecti64v_p',
    'glGetQueryObjectui64v_c',
    'glGetQueryObjectui64v_p',
    'glGetSamplerParameterIiv_c',
    'glGetSamplerParameterIiv_p',
    'glGetSamplerParameterIuiv_c',
    'glGetSamplerParameterIuiv_p',
    'glGetSamplerParameterfv_c',
    'glGetSamplerParameterfv_p',
    'glGetSamplerParameteriv_c',
    'glGetSamplerParameteriv_p',
    'glIsSampler',
    'glMultiTexCoordP1ui',
    'glMultiTexCoordP1uiv_c',
    'glMultiTexCoordP1uiv_p',
    'glMultiTexCoordP2ui',
    'glMultiTexCoordP2uiv_c',
    'glMultiTexCoordP2uiv_p',
    'glMultiTexCoordP3ui',
    'glMultiTexCoordP3uiv_c',
    'glMultiTexCoordP3uiv_p',
    'glMultiTexCoordP4ui',
    'glMultiTexCoordP4uiv_c',
    'glMultiTexCoordP4uiv_p',
    'glNormalP3ui',
    'glNormalP3uiv_c',
    'glNormalP3uiv_p',
    'glQueryCounter',
    'glSamplerParameterIiv_c',
    'glSamplerParameterIiv_p',
    'glSamplerParameterIuiv_c',
    'glSamplerParameterIuiv_p',
    'glSamplerParameterf',
    'glSamplerParameterfv_c',
    'glSamplerParameterfv_p',
    'glSamplerParameteri',
    'glSamplerParameteriv_c',
    'glSamplerParameteriv_p',
    'glSecondaryColorP3ui',
    'glSecondaryColorP3uiv_c',
    'glSecondaryColorP3uiv_p',
    'glTexCoordP1ui',
    'glTexCoordP1uiv_c',
    'glTexCoordP1uiv_p',
    'glTexCoordP2ui',
    'glTexCoordP2uiv_c',
    'glTexCoordP2uiv_p',
    'glTexCoordP3ui',
    'glTexCoordP3uiv_c',
    'glTexCoordP3uiv_p',
    'glTexCoordP4ui',
    'glTexCoordP4uiv_c',
    'glTexCoordP4uiv_p',
    'glVertexAttribDivisor',
    'glVertexAttribP1ui',
    'glVertexAttribP1uiv_c',
    'glVertexAttribP1uiv_p',
    'glVertexAttribP2ui',
    'glVertexAttribP2uiv_c',
    'glVertexAttribP2uiv_p',
    'glVertexAttribP3ui',
    'glVertexAttribP3uiv_c',
    'glVertexAttribP3uiv_p',
    'glVertexAttribP4ui',
    'glVertexAttribP4uiv_c',
    'glVertexAttribP4uiv_p',
    'glVertexP2ui',
    'glVertexP2uiv_c',
    'glVertexP2uiv_p',
    'glVertexP3ui',
    'glVertexP3uiv_c',
    'glVertexP3uiv_p',
    'glVertexP4ui',
    'glVertexP4uiv_c',
    'glVertexP4uiv_p'
  ],
  'GL_VERSION_4_0' => [
    'glBeginQueryIndexed',
    'glBindTransformFeedback',
    'glBlendEquationSeparatei',
    'glBlendEquationi',
    'glBlendFuncSeparatei',
    'glBlendFunci',
    'glDeleteTransformFeedbacks_c',
    'glDeleteTransformFeedbacks_p',
    'glDrawArraysIndirect_c',
    'glDrawElementsIndirect_c',
    'glDrawTransformFeedback',
    'glDrawTransformFeedbackStream',
    'glEndQueryIndexed',
    'glGenTransformFeedbacks_c',
    'glGenTransformFeedbacks_p',
    'glGetActiveSubroutineName_c',
    'glGetActiveSubroutineName_p',
    'glGetActiveSubroutineUniformName_c',
    'glGetActiveSubroutineUniformName_p',
    'glGetActiveSubroutineUniformiv_c',
    'glGetActiveSubroutineUniformiv_p',
    'glGetProgramStageiv_c',
    'glGetProgramStageiv_p',
    'glGetQueryIndexediv_c',
    'glGetQueryIndexediv_p',
    'glGetSubroutineIndex',
    'glGetSubroutineUniformLocation',
    'glGetUniformSubroutineuiv_c',
    'glGetUniformSubroutineuiv_p',
    'glGetUniformdv_c',
    'glIsTransformFeedback',
    'glMinSampleShading',
    'glPatchParameterfv_c',
    'glPatchParameterfv_p',
    'glPatchParameteri',
    'glPauseTransformFeedback',
    'glResumeTransformFeedback',
    'glUniform1d',
    'glUniform1dv_c',
    'glUniform1dv_p',
    'glUniform2d',
    'glUniform2dv_c',
    'glUniform2dv_p',
    'glUniform3d',
    'glUniform3dv_c',
    'glUniform3dv_p',
    'glUniform4d',
    'glUniform4dv_c',
    'glUniform4dv_p',
    'glUniformMatrix2dv_c',
    'glUniformMatrix2dv_p',
    'glUniformMatrix2x3dv_c',
    'glUniformMatrix2x3dv_p',
    'glUniformMatrix2x4dv_c',
    'glUniformMatrix2x4dv_p',
    'glUniformMatrix3dv_c',
    'glUniformMatrix3dv_p',
    'glUniformMatrix3x2dv_c',
    'glUniformMatrix3x2dv_p',
    'glUniformMatrix3x4dv_c',
    'glUniformMatrix3x4dv_p',
    'glUniformMatrix4dv_c',
    'glUniformMatrix4dv_p',
    'glUniformMatrix4x2dv_c',
    'glUniformMatrix4x2dv_p',
    'glUniformMatrix4x3dv_c',
    'glUniformMatrix4x3dv_p',
    'glUniformSubroutinesuiv_c',
    'glUniformSubroutinesuiv_p'
  ],
  'GL_VERSION_4_1' => [
    'glActiveShaderProgram',
    'glBindProgramPipeline',
    'glClearDepthf',
    'glCreateShaderProgramv_c',
    'glCreateShaderProgramv_p',
    'glDeleteProgramPipelines_c',
    'glDeleteProgramPipelines_p',
    'glDepthRangeArrayv_c',
    'glDepthRangeArrayv_p',
    'glDepthRangeIndexed',
    'glDepthRangef',
    'glGenProgramPipelines_c',
    'glGenProgramPipelines_p',
    'glGetDoublei_v_c',
    'glGetDoublei_v_p',
    'glGetFloati_v_c',
    'glGetFloati_v_p',
    'glGetProgramBinary_c',
    'glGetProgramBinary_p',
    'glGetProgramPipelineInfoLog_c',
    'glGetProgramPipelineInfoLog_p',
    'glGetProgramPipelineiv_c',
    'glGetProgramPipelineiv_p',
    'glGetShaderPrecisionFormat_c',
    'glGetShaderPrecisionFormat_p',
    'glGetVertexAttribLdv_c',
    'glGetVertexAttribLdv_p',
    'glIsProgramPipeline',
    'glProgramBinary_c',
    'glProgramParameteri',
    'glProgramUniform1d',
    'glProgramUniform1dv_c',
    'glProgramUniform1dv_p',
    'glProgramUniform1f',
    'glProgramUniform1fv_c',
    'glProgramUniform1fv_p',
    'glProgramUniform1i',
    'glProgramUniform1iv_c',
    'glProgramUniform1iv_p',
    'glProgramUniform1ui',
    'glProgramUniform1uiv_c',
    'glProgramUniform1uiv_p',
    'glProgramUniform2d',
    'glProgramUniform2dv_c',
    'glProgramUniform2dv_p',
    'glProgramUniform2f',
    'glProgramUniform2fv_c',
    'glProgramUniform2fv_p',
    'glProgramUniform2i',
    'glProgramUniform2iv_c',
    'glProgramUniform2iv_p',
    'glProgramUniform2ui',
    'glProgramUniform2uiv_c',
    'glProgramUniform2uiv_p',
    'glProgramUniform3d',
    'glProgramUniform3dv_c',
    'glProgramUniform3dv_p',
    'glProgramUniform3f',
    'glProgramUniform3fv_c',
    'glProgramUniform3fv_p',
    'glProgramUniform3i',
    'glProgramUniform3iv_c',
    'glProgramUniform3iv_p',
    'glProgramUniform3ui',
    'glProgramUniform3uiv_c',
    'glProgramUniform3uiv_p',
    'glProgramUniform4d',
    'glProgramUniform4dv_c',
    'glProgramUniform4dv_p',
    'glProgramUniform4f',
    'glProgramUniform4fv_c',
    'glProgramUniform4fv_p',
    'glProgramUniform4i',
    'glProgramUniform4iv_c',
    'glProgramUniform4iv_p',
    'glProgramUniform4ui',
    'glProgramUniform4uiv_c',
    'glProgramUniform4uiv_p',
    'glProgramUniformMatrix2dv_c',
    'glProgramUniformMatrix2dv_p',
    'glProgramUniformMatrix2fv_c',
    'glProgramUniformMatrix2fv_p',
    'glProgramUniformMatrix2x3dv_c',
    'glProgramUniformMatrix2x3dv_p',
    'glProgramUniformMatrix2x3fv_c',
    'glProgramUniformMatrix2x3fv_p',
    'glProgramUniformMatrix2x4dv_c',
    'glProgramUniformMatrix2x4dv_p',
    'glProgramUniformMatrix2x4fv_c',
    'glProgramUniformMatrix2x4fv_p',
    'glProgramUniformMatrix3dv_c',
    'glProgramUniformMatrix3dv_p',
    'glProgramUniformMatrix3fv_c',
    'glProgramUniformMatrix3fv_p',
    'glProgramUniformMatrix3x2dv_c',
    'glProgramUniformMatrix3x2dv_p',
    'glProgramUniformMatrix3x2fv_c',
    'glProgramUniformMatrix3x2fv_p',
    'glProgramUniformMatrix3x4dv_c',
    'glProgramUniformMatrix3x4dv_p',
    'glProgramUniformMatrix3x4fv_c',
    'glProgramUniformMatrix3x4fv_p',
    'glProgramUniformMatrix4dv_c',
    'glProgramUniformMatrix4dv_p',
    'glProgramUniformMatrix4fv_c',
    'glProgramUniformMatrix4fv_p',
    'glProgramUniformMatrix4x2dv_c',
    'glProgramUniformMatrix4x2dv_p',
    'glProgramUniformMatrix4x2fv_c',
    'glProgramUniformMatrix4x2fv_p',
    'glProgramUniformMatrix4x3dv_c',
    'glProgramUniformMatrix4x3dv_p',
    'glProgramUniformMatrix4x3fv_c',
    'glProgramUniformMatrix4x3fv_p',
    'glReleaseShaderCompiler',
    'glScissorArrayv_c',
    'glScissorArrayv_p',
    'glScissorIndexed',
    'glScissorIndexedv_c',
    'glScissorIndexedv_p',
    'glShaderBinary_c',
    'glUseProgramStages',
    'glValidateProgramPipeline',
    'glVertexAttribL1d',
    'glVertexAttribL1dv_c',
    'glVertexAttribL1dv_p',
    'glVertexAttribL2d',
    'glVertexAttribL2dv_c',
    'glVertexAttribL2dv_p',
    'glVertexAttribL3d',
    'glVertexAttribL3dv_c',
    'glVertexAttribL3dv_p',
    'glVertexAttribL4d',
    'glVertexAttribL4dv_c',
    'glVertexAttribL4dv_p',
    'glVertexAttribLPointer_c',
    'glViewportArrayv_c',
    'glViewportArrayv_p',
    'glViewportIndexedf',
    'glViewportIndexedfv_c',
    'glViewportIndexedfv_p'
  ],
  'GL_VERSION_4_2' => [
    'glBindImageTexture',
    'glDrawArraysInstancedBaseInstance',
    'glDrawElementsInstancedBaseInstance_c',
    'glDrawElementsInstancedBaseVertexBaseInstance_c',
    'glDrawTransformFeedbackInstanced',
    'glDrawTransformFeedbackStreamInstanced',
    'glGetActiveAtomicCounterBufferiv_c',
    'glGetActiveAtomicCounterBufferiv_p',
    'glGetInternalformativ_c',
    'glGetInternalformativ_p',
    'glMemoryBarrier',
    'glTexStorage1D',
    'glTexStorage2D',
    'glTexStorage3D'
  ],
  'GL_VERSION_4_3' => [
    'glBindVertexBuffer',
    'glClearBufferData_c',
    'glClearBufferSubData_c',
    'glClearNamedBufferDataEXT_c',
    'glClearNamedBufferSubDataEXT_c',
    'glCopyImageSubData',
    'glDebugMessageCallback_c',
    'glDebugMessageControl_c',
    'glDebugMessageControl_p',
    'glDebugMessageInsert',
    'glDispatchCompute',
    'glDispatchComputeIndirect',
    'glFramebufferParameteri',
    'glGetDebugMessageLog_c',
    'glGetDebugMessageLog_p',
    'glGetFramebufferParameteriv_c',
    'glGetFramebufferParameteriv_p',
    'glGetInternalformati64v_c',
    'glGetInternalformati64v_p',
    'glGetNamedFramebufferParameterivEXT_c',
    'glGetNamedFramebufferParameterivEXT_p',
    'glGetObjectLabel_c',
    'glGetObjectLabel_p',
    'glGetObjectPtrLabel_c',
    'glGetProgramInterfaceiv_c',
    'glGetProgramInterfaceiv_p',
    'glGetProgramResourceIndex',
    'glGetProgramResourceLocation',
    'glGetProgramResourceLocationIndex',
    'glGetProgramResourceName_c',
    'glGetProgramResourceName_p',
    'glGetProgramResourceiv_c',
    'glGetProgramResourceiv_p',
    'glInvalidateBufferData',
    'glInvalidateBufferSubData',
    'glInvalidateFramebuffer_c',
    'glInvalidateFramebuffer_p',
    'glInvalidateSubFramebuffer_c',
    'glInvalidateSubFramebuffer_p',
    'glInvalidateTexImage',
    'glInvalidateTexSubImage',
    'glMultiDrawArraysIndirect_c',
    'glMultiDrawElementsIndirect_c',
    'glNamedFramebufferParameteriEXT',
    'glObjectLabel',
    'glObjectPtrLabel_c',
    'glPopDebugGroup',
    'glPushDebugGroup',
    'glShaderStorageBlockBinding',
    'glTexBufferRange',
    'glTexStorage2DMultisample',
    'glTexStorage3DMultisample',
    'glTextureBufferRangeEXT',
    'glTextureStorage2DMultisampleEXT',
    'glTextureStorage3DMultisampleEXT',
    'glTextureView',
    'glVertexArrayBindVertexBufferEXT',
    'glVertexArrayVertexAttribBindingEXT',
    'glVertexArrayVertexAttribFormatEXT',
    'glVertexArrayVertexAttribIFormatEXT',
    'glVertexArrayVertexAttribLFormatEXT',
    'glVertexArrayVertexBindingDivisorEXT',
    'glVertexAttribBinding',
    'glVertexAttribFormat',
    'glVertexAttribIFormat',
    'glVertexAttribLFormat',
    'glVertexBindingDivisor'
  ],
  'GL_VERSION_4_4' => [
    'glBindBuffersBase_c',
    'glBindBuffersBase_p',
    'glBindBuffersRange_c',
    'glBindImageTextures_c',
    'glBindImageTextures_p',
    'glBindSamplers_c',
    'glBindSamplers_p',
    'glBindTextures_c',
    'glBindTextures_p',
    'glBindVertexBuffers_c',
    'glBufferStorage_c',
    'glClearTexImage_c',
    'glClearTexSubImage_c'
  ],
  'GL_VERSION_4_5' => [
    'glBindTextureUnit',
    'glBlitNamedFramebuffer',
    'glCheckNamedFramebufferStatus',
    'glClearNamedBufferData_c',
    'glClearNamedBufferSubData_c',
    'glClearNamedFramebufferfi',
    'glClearNamedFramebufferfv_c',
    'glClearNamedFramebufferfv_p',
    'glClearNamedFramebufferiv_c',
    'glClearNamedFramebufferiv_p',
    'glClearNamedFramebufferuiv_c',
    'glClearNamedFramebufferuiv_p',
    'glClipControl',
    'glCompressedTextureSubImage1D_c',
    'glCompressedTextureSubImage2D_c',
    'glCompressedTextureSubImage3D_c',
    'glCopyNamedBufferSubData',
    'glCopyTextureSubImage1D',
    'glCopyTextureSubImage2D',
    'glCopyTextureSubImage3D',
    'glCreateBuffers_c',
    'glCreateBuffers_p',
    'glCreateFramebuffers_c',
    'glCreateFramebuffers_p',
    'glCreateProgramPipelines_c',
    'glCreateProgramPipelines_p',
    'glCreateQueries_c',
    'glCreateQueries_p',
    'glCreateRenderbuffers_c',
    'glCreateRenderbuffers_p',
    'glCreateSamplers_c',
    'glCreateSamplers_p',
    'glCreateTextures_c',
    'glCreateTextures_p',
    'glCreateTransformFeedbacks_c',
    'glCreateTransformFeedbacks_p',
    'glCreateVertexArrays_c',
    'glCreateVertexArrays_p',
    'glDisableVertexArrayAttrib',
    'glEnableVertexArrayAttrib',
    'glFlushMappedNamedBufferRange',
    'glGenerateTextureMipmap',
    'glGetCompressedTextureImage_c',
    'glGetCompressedTextureSubImage_c',
    'glGetGraphicsResetStatus',
    'glGetGraphicsResetStatusARB',
    'glGetNamedBufferParameteri64v_c',
    'glGetNamedBufferParameteriv_c',
    'glGetNamedBufferPointerv_c',
    'glGetNamedBufferSubData_c',
    'glGetNamedFramebufferAttachmentParameteriv_c',
    'glGetNamedFramebufferParameteriv_c',
    'glGetNamedRenderbufferParameteriv_c',
    'glGetQueryBufferObjecti64v',
    'glGetQueryBufferObjectiv',
    'glGetQueryBufferObjectui64v',
    'glGetQueryBufferObjectuiv',
    'glGetTextureImage_c',
    'glGetTextureLevelParameterfv_c',
    'glGetTextureLevelParameteriv_c',
    'glGetTextureParameterIiv_c',
    'glGetTextureParameterIuiv_c',
    'glGetTextureParameterfv_c',
    'glGetTextureParameteriv_c',
    'glGetTextureSubImage_c',
    'glGetTransformFeedbacki64_v_c',
    'glGetTransformFeedbacki_v_c',
    'glGetTransformFeedbackiv_c',
    'glGetVertexArrayIndexed64iv_c',
    'glGetVertexArrayIndexediv_c',
    'glGetVertexArrayiv_c',
    'glGetnColorTableARB_c',
    'glGetnCompressedTexImageARB_c',
    'glGetnCompressedTexImage_c',
    'glGetnConvolutionFilterARB_c',
    'glGetnHistogramARB_c',
    'glGetnMapdvARB_c',
    'glGetnMapdvARB_p',
    'glGetnMapfvARB_c',
    'glGetnMapfvARB_p',
    'glGetnMapivARB_c',
    'glGetnMapivARB_p',
    'glGetnMinmaxARB_c',
    'glGetnPixelMapfvARB_c',
    'glGetnPixelMapfvARB_p',
    'glGetnPixelMapuivARB_c',
    'glGetnPixelMapuivARB_p',
    'glGetnPixelMapusvARB_c',
    'glGetnPixelMapusvARB_p',
    'glGetnPolygonStippleARB_c',
    'glGetnPolygonStippleARB_p',
    'glGetnSeparableFilterARB_c',
    'glGetnTexImageARB_c',
    'glGetnTexImage_c',
    'glGetnUniformdvARB_c',
    'glGetnUniformdvARB_p',
    'glGetnUniformdv_c',
    'glGetnUniformdv_p',
    'glGetnUniformfvARB_c',
    'glGetnUniformfvARB_p',
    'glGetnUniformivARB_c',
    'glGetnUniformivARB_p',
    'glGetnUniformuivARB_c',
    'glGetnUniformuivARB_p',
    'glInvalidateNamedFramebufferData_c',
    'glInvalidateNamedFramebufferData_p',
    'glInvalidateNamedFramebufferSubData_c',
    'glInvalidateNamedFramebufferSubData_p',
    'glMapNamedBufferRange_c',
    'glMapNamedBuffer_c',
    'glMemoryBarrierByRegion',
    'glNamedBufferData_c',
    'glNamedBufferStorage_c',
    'glNamedBufferSubData_c',
    'glNamedFramebufferDrawBuffer',
    'glNamedFramebufferDrawBuffers_c',
    'glNamedFramebufferDrawBuffers_p',
    'glNamedFramebufferParameteri',
    'glNamedFramebufferReadBuffer',
    'glNamedFramebufferRenderbuffer',
    'glNamedFramebufferTexture',
    'glNamedFramebufferTextureLayer',
    'glNamedRenderbufferStorage',
    'glNamedRenderbufferStorageMultisample',
    'glTextureBarrier',
    'glTextureBuffer',
    'glTextureBufferRange',
    'glTextureParameterIiv_c',
    'glTextureParameterIiv_p',
    'glTextureParameterIuiv_c',
    'glTextureParameterIuiv_p',
    'glTextureParameterf',
    'glTextureParameterfv_c',
    'glTextureParameterfv_p',
    'glTextureParameteri',
    'glTextureParameteriv_c',
    'glTextureParameteriv_p',
    'glTextureStorage1D',
    'glTextureStorage2D',
    'glTextureStorage2DMultisample',
    'glTextureStorage3D',
    'glTextureStorage3DMultisample',
    'glTextureSubImage1D_c',
    'glTextureSubImage2D_c',
    'glTextureSubImage3D_c',
    'glTransformFeedbackBufferBase',
    'glTransformFeedbackBufferRange',
    'glUnmapNamedBuffer',
    'glVertexArrayAttribBinding',
    'glVertexArrayAttribFormat',
    'glVertexArrayAttribIFormat',
    'glVertexArrayAttribLFormat',
    'glVertexArrayBindingDivisor',
    'glVertexArrayElementBuffer',
    'glVertexArrayVertexBuffer',
    'glVertexArrayVertexBuffers_c'
  ],
  'GL_VERSION_4_6' => [
    'glMultiDrawArraysIndirectCount_c',
    'glMultiDrawElementsIndirectCount_c',
    'glPolygonOffsetClamp',
    'glSpecializeShader_c',
    'glSpecializeShader_p'
  ],
  'GL_WIN_swap_hint' => [
    'glAddSwapHintRectWIN'
  ]
);
our @gl_constants = qw(
  GLEW_ERROR_GLX_VERSION_11_ONLY
  GLEW_ERROR_GL_VERSION_10_ONLY
  GLEW_ERROR_NO_GLX_DISPLAY
  GLEW_ERROR_NO_GL_VERSION
  GLEW_NO_ERROR
  GLEW_OK
  GLEW_VERSION_MAJOR
  GLEW_VERSION_MICRO
  GLEW_VERSION_MINOR
  GL_1PASS_EXT
  GL_1PASS_SGIS
  GL_2D
  GL_2PASS_0_EXT
  GL_2PASS_0_SGIS
  GL_2PASS_1_EXT
  GL_2PASS_1_SGIS
  GL_2X_BIT_ATI
  GL_2_BYTES
  GL_3D
  GL_3DC_XY_AMD
  GL_3DC_X_AMD
  GL_3DVISION_STEREO_NV
  GL_3D_COLOR
  GL_3D_COLOR_TEXTURE
  GL_3_BYTES
  GL_422_AVERAGE_EXT
  GL_422_EXT
  GL_422_REV_AVERAGE_EXT
  GL_422_REV_EXT
  GL_4D_COLOR_TEXTURE
  GL_4PASS_0_EXT
  GL_4PASS_0_SGIS
  GL_4PASS_1_EXT
  GL_4PASS_1_SGIS
  GL_4PASS_2_EXT
  GL_4PASS_2_SGIS
  GL_4PASS_3_EXT
  GL_4PASS_3_SGIS
  GL_4X_BIT_ATI
  GL_4_BYTES
  GL_8X_BIT_ATI
  GL_ABGR_EXT
  GL_ACCUM
  GL_ACCUM_ADJACENT_PAIRS_NV
  GL_ACCUM_ALPHA_BITS
  GL_ACCUM_BLUE_BITS
  GL_ACCUM_BUFFER_BIT
  GL_ACCUM_CLEAR_VALUE
  GL_ACCUM_GREEN_BITS
  GL_ACCUM_RED_BITS
  GL_ACTIVE_ATOMIC_COUNTER_BUFFERS
  GL_ACTIVE_ATTRIBUTES
  GL_ACTIVE_ATTRIBUTE_MAX_LENGTH
  GL_ACTIVE_PROGRAM
  GL_ACTIVE_PROGRAM_EXT
  GL_ACTIVE_RESOURCES
  GL_ACTIVE_STENCIL_FACE_EXT
  GL_ACTIVE_SUBROUTINES
  GL_ACTIVE_SUBROUTINE_MAX_LENGTH
  GL_ACTIVE_SUBROUTINE_UNIFORMS
  GL_ACTIVE_SUBROUTINE_UNIFORM_LOCATIONS
  GL_ACTIVE_SUBROUTINE_UNIFORM_MAX_LENGTH
  GL_ACTIVE_TEXTURE
  GL_ACTIVE_TEXTURE_ARB
  GL_ACTIVE_UNIFORMS
  GL_ACTIVE_UNIFORM_BLOCKS
  GL_ACTIVE_UNIFORM_BLOCK_MAX_NAME_LENGTH
  GL_ACTIVE_UNIFORM_MAX_LENGTH
  GL_ACTIVE_VARIABLES
  GL_ACTIVE_VARYINGS_NV
  GL_ACTIVE_VARYING_MAX_LENGTH_NV
  GL_ACTIVE_VERTEX_UNITS_ARB
  GL_ADD
  GL_ADD_ATI
  GL_ADD_BLEND_IMG
  GL_ADD_SIGNED
  GL_ADD_SIGNED_ARB
  GL_ADD_SIGNED_EXT
  GL_ADJACENT_PAIRS_NV
  GL_AFFINE_2D_NV
  GL_AFFINE_3D_NV
  GL_ALIASED_LINE_WIDTH_RANGE
  GL_ALIASED_POINT_SIZE_RANGE
  GL_ALLOW_DRAW_FRG_HINT_PGI
  GL_ALLOW_DRAW_MEM_HINT_PGI
  GL_ALLOW_DRAW_OBJ_HINT_PGI
  GL_ALLOW_DRAW_WIN_HINT_PGI
  GL_ALL_ATTRIB_BITS
  GL_ALL_BARRIER_BITS
  GL_ALL_BARRIER_BITS_EXT
  GL_ALL_COMPLETED_NV
  GL_ALL_PIXELS_AMD
  GL_ALL_SHADER_BITS
  GL_ALL_STATIC_DATA_IBM
  GL_ALPHA
  GL_ALPHA12
  GL_ALPHA12_EXT
  GL_ALPHA16
  GL_ALPHA16F_ARB
  GL_ALPHA16F_EXT
  GL_ALPHA16I_EXT
  GL_ALPHA16UI_EXT
  GL_ALPHA16_EXT
  GL_ALPHA16_EXTENDED_RANGE_SGIX
  GL_ALPHA16_ICC_SGIX
  GL_ALPHA16_SIGNED_SGIX
  GL_ALPHA16_SNORM
  GL_ALPHA32F_ARB
  GL_ALPHA32F_EXT
  GL_ALPHA32I_EXT
  GL_ALPHA32UI_EXT
  GL_ALPHA4
  GL_ALPHA4_EXT
  GL_ALPHA8
  GL_ALPHA8I_EXT
  GL_ALPHA8UI_EXT
  GL_ALPHA8_EXT
  GL_ALPHA8_OES
  GL_ALPHA8_SNORM
  GL_ALPHA_BIAS
  GL_ALPHA_BITS
  GL_ALPHA_EXTENDED_RANGE_SGIX
  GL_ALPHA_FLOAT16_APPLE
  GL_ALPHA_FLOAT16_ATI
  GL_ALPHA_FLOAT32_APPLE
  GL_ALPHA_FLOAT32_ATI
  GL_ALPHA_ICC_SGIX
  GL_ALPHA_INTEGER
  GL_ALPHA_INTEGER_EXT
  GL_ALPHA_MAX_CLAMP_INGR
  GL_ALPHA_MAX_SGIX
  GL_ALPHA_MIN_CLAMP_INGR
  GL_ALPHA_MIN_SGIX
  GL_ALPHA_REF_COMMAND_NV
  GL_ALPHA_SCALE
  GL_ALPHA_SIGNED_SGIX
  GL_ALPHA_SNORM
  GL_ALPHA_TEST
  GL_ALPHA_TEST_FUNC
  GL_ALPHA_TEST_FUNC_QCOM
  GL_ALPHA_TEST_QCOM
  GL_ALPHA_TEST_REF
  GL_ALPHA_TEST_REF_QCOM
  GL_ALPHA_TO_COVERAGE_DITHER_DEFAULT_NV
  GL_ALPHA_TO_COVERAGE_DITHER_DISABLE_NV
  GL_ALPHA_TO_COVERAGE_DITHER_ENABLE_NV
  GL_ALPHA_TO_COVERAGE_DITHER_MODE_NV
  GL_ALREADY_SIGNALED
  GL_ALREADY_SIGNALED_APPLE
  GL_ALWAYS
  GL_ALWAYS_FAST_HINT_PGI
  GL_ALWAYS_SOFT_HINT_PGI
  GL_AMBIENT
  GL_AMBIENT_AND_DIFFUSE
  GL_AND
  GL_AND_INVERTED
  GL_AND_REVERSE
  GL_ANY_SAMPLES_PASSED
  GL_ANY_SAMPLES_PASSED_CONSERVATIVE
  GL_ANY_SAMPLES_PASSED_CONSERVATIVE_EXT
  GL_ANY_SAMPLES_PASSED_EXT
  GL_ARC_TO_NV
  GL_ARRAY_BUFFER
  GL_ARRAY_BUFFER_ARB
  GL_ARRAY_BUFFER_BINDING
  GL_ARRAY_BUFFER_BINDING_ARB
  GL_ARRAY_ELEMENT_LOCK_COUNT_EXT
  GL_ARRAY_ELEMENT_LOCK_FIRST_EXT
  GL_ARRAY_OBJECT_BUFFER_ATI
  GL_ARRAY_OBJECT_OFFSET_ATI
  GL_ARRAY_SIZE
  GL_ARRAY_STRIDE
  GL_ASYNC_DRAW_PIXELS_SGIX
  GL_ASYNC_HISTOGRAM_SGIX
  GL_ASYNC_MARKER_SGIX
  GL_ASYNC_READ_PIXELS_SGIX
  GL_ASYNC_TEX_IMAGE_SGIX
  GL_ATC_RGBA_EXPLICIT_ALPHA_AMD
  GL_ATC_RGBA_INTERPOLATED_ALPHA_AMD
  GL_ATC_RGB_AMD
  GL_ATOMIC_COUNTER_BARRIER_BIT
  GL_ATOMIC_COUNTER_BARRIER_BIT_EXT
  GL_ATOMIC_COUNTER_BUFFER
  GL_ATOMIC_COUNTER_BUFFER_ACTIVE_ATOMIC_COUNTERS
  GL_ATOMIC_COUNTER_BUFFER_ACTIVE_ATOMIC_COUNTER_INDICES
  GL_ATOMIC_COUNTER_BUFFER_BINDING
  GL_ATOMIC_COUNTER_BUFFER_DATA_SIZE
  GL_ATOMIC_COUNTER_BUFFER_INDEX
  GL_ATOMIC_COUNTER_BUFFER_REFERENCED_BY_COMPUTE_SHADER
  GL_ATOMIC_COUNTER_BUFFER_REFERENCED_BY_FRAGMENT_SHADER
  GL_ATOMIC_COUNTER_BUFFER_REFERENCED_BY_GEOMETRY_SHADER
  GL_ATOMIC_COUNTER_BUFFER_REFERENCED_BY_MESH_SHADER_EXT
  GL_ATOMIC_COUNTER_BUFFER_REFERENCED_BY_MESH_SHADER_NV
  GL_ATOMIC_COUNTER_BUFFER_REFERENCED_BY_TASK_SHADER_EXT
  GL_ATOMIC_COUNTER_BUFFER_REFERENCED_BY_TASK_SHADER_NV
  GL_ATOMIC_COUNTER_BUFFER_REFERENCED_BY_TESS_CONTROL_SHADER
  GL_ATOMIC_COUNTER_BUFFER_REFERENCED_BY_TESS_EVALUATION_SHADER
  GL_ATOMIC_COUNTER_BUFFER_REFERENCED_BY_VERTEX_SHADER
  GL_ATOMIC_COUNTER_BUFFER_SIZE
  GL_ATOMIC_COUNTER_BUFFER_START
  GL_ATTACHED_MEMORY_OBJECT_NV
  GL_ATTACHED_MEMORY_OFFSET_NV
  GL_ATTACHED_SHADERS
  GL_ATTENUATION_EXT
  GL_ATTRIBUTE_ADDRESS_COMMAND_NV
  GL_ATTRIB_ARRAY_POINTER_NV
  GL_ATTRIB_ARRAY_SIZE_NV
  GL_ATTRIB_ARRAY_STRIDE_NV
  GL_ATTRIB_ARRAY_TYPE_NV
  GL_ATTRIB_STACK_DEPTH
  GL_AUTO_GENERATE_MIPMAP
  GL_AUTO_NORMAL
  GL_AUX0
  GL_AUX1
  GL_AUX2
  GL_AUX3
  GL_AUX_BUFFERS
  GL_AUX_DEPTH_STENCIL_APPLE
  GL_AVERAGE_EXT
  GL_BACK
  GL_BACK_LEFT
  GL_BACK_NORMALS_HINT_PGI
  GL_BACK_PRIMARY_COLOR_NV
  GL_BACK_RIGHT
  GL_BACK_SECONDARY_COLOR_NV
  GL_BALI_DEPTH_PASS_INSTRUMENT
  GL_BALI_FRAGMENTS_GENERATED_INSTRUMENT
  GL_BALI_NUM_PRIMS_CLIPPED_INSTRUMENT
  GL_BALI_NUM_PRIMS_CLIP_RESULT_INSTRUMENT
  GL_BALI_NUM_PRIMS_REJECT_INSTRUMENT
  GL_BALI_NUM_TRIS_CULLED_INSTRUMENT
  GL_BALI_R_CHIP_COUNT
  GL_BEVEL_NV
  GL_BGR
  GL_BGRA
  GL_BGRA8_EXT
  GL_BGRA_EXT
  GL_BGRA_IMG
  GL_BGRA_INTEGER
  GL_BGRA_INTEGER_EXT
  GL_BGR_EXT
  GL_BGR_INTEGER
  GL_BGR_INTEGER_EXT
  GL_BGR_NV
  GL_BIAS_BIT_ATI
  GL_BIAS_BY_NEGATIVE_ONE_HALF_NV
  GL_BINNING_CONTROL_HINT_QCOM
  GL_BINORMAL_ARRAY_EXT
  GL_BINORMAL_ARRAY_POINTER_EXT
  GL_BINORMAL_ARRAY_STRIDE_EXT
  GL_BINORMAL_ARRAY_TYPE_EXT
  GL_BITMAP
  GL_BITMAP_TOKEN
  GL_BLACKHOLE_RENDER_INTEL
  GL_BLEND
  GL_BLEND_ADVANCED_COHERENT_KHR
  GL_BLEND_ADVANCED_COHERENT_NV
  GL_BLEND_COLOR
  GL_BLEND_COLOR_COMMAND_NV
  GL_BLEND_COLOR_EXT
  GL_BLEND_DST
  GL_BLEND_DST_ALPHA
  GL_BLEND_DST_ALPHA_EXT
  GL_BLEND_DST_ALPHA_OES
  GL_BLEND_DST_RGB
  GL_BLEND_DST_RGB_EXT
  GL_BLEND_DST_RGB_OES
  GL_BLEND_EQUATION
  GL_BLEND_EQUATION_ALPHA
  GL_BLEND_EQUATION_ALPHA_EXT
  GL_BLEND_EQUATION_ALPHA_OES
  GL_BLEND_EQUATION_EXT
  GL_BLEND_EQUATION_OES
  GL_BLEND_EQUATION_RGB
  GL_BLEND_EQUATION_RGB_EXT
  GL_BLEND_EQUATION_RGB_OES
  GL_BLEND_OVERLAP_NV
  GL_BLEND_PREMULTIPLIED_SRC_NV
  GL_BLEND_SRC
  GL_BLEND_SRC_ALPHA
  GL_BLEND_SRC_ALPHA_EXT
  GL_BLEND_SRC_ALPHA_OES
  GL_BLEND_SRC_RGB
  GL_BLEND_SRC_RGB_EXT
  GL_BLEND_SRC_RGB_OES
  GL_BLOCK_INDEX
  GL_BLUE
  GL_BLUE_BIAS
  GL_BLUE_BITS
  GL_BLUE_BIT_ATI
  GL_BLUE_INTEGER
  GL_BLUE_INTEGER_EXT
  GL_BLUE_MAX_CLAMP_INGR
  GL_BLUE_MIN_CLAMP_INGR
  GL_BLUE_NV
  GL_BLUE_SCALE
  GL_BOLD_BIT_NV
  GL_BOOL
  GL_BOOL_ARB
  GL_BOOL_VEC2
  GL_BOOL_VEC2_ARB
  GL_BOOL_VEC3
  GL_BOOL_VEC3_ARB
  GL_BOOL_VEC4
  GL_BOOL_VEC4_ARB
  GL_BOUNDING_BOX_NV
  GL_BOUNDING_BOX_OF_BOUNDING_BOXES_NV
  GL_BUFFER
  GL_BUFFER_ACCESS
  GL_BUFFER_ACCESS_ARB
  GL_BUFFER_ACCESS_FLAGS
  GL_BUFFER_ACCESS_OES
  GL_BUFFER_BINDING
  GL_BUFFER_DATA_SIZE
  GL_BUFFER_FLUSHING_UNMAP_APPLE
  GL_BUFFER_GPU_ADDRESS_NV
  GL_BUFFER_IMMUTABLE_STORAGE
  GL_BUFFER_IMMUTABLE_STORAGE_EXT
  GL_BUFFER_MAPPED
  GL_BUFFER_MAPPED_ARB
  GL_BUFFER_MAPPED_OES
  GL_BUFFER_MAP_LENGTH
  GL_BUFFER_MAP_OFFSET
  GL_BUFFER_MAP_POINTER
  GL_BUFFER_MAP_POINTER_ARB
  GL_BUFFER_MAP_POINTER_OES
  GL_BUFFER_OBJECT_APPLE
  GL_BUFFER_OBJECT_EXT
  GL_BUFFER_SERIALIZED_MODIFY_APPLE
  GL_BUFFER_SIZE
  GL_BUFFER_SIZE_ARB
  GL_BUFFER_STORAGE_FLAGS
  GL_BUFFER_STORAGE_FLAGS_EXT
  GL_BUFFER_UPDATE_BARRIER_BIT
  GL_BUFFER_UPDATE_BARRIER_BIT_EXT
  GL_BUFFER_USAGE
  GL_BUFFER_USAGE_ARB
  GL_BUFFER_VARIABLE
  GL_BUMP_ENVMAP_ATI
  GL_BUMP_NUM_TEX_UNITS_ATI
  GL_BUMP_ROT_MATRIX_ATI
  GL_BUMP_ROT_MATRIX_SIZE_ATI
  GL_BUMP_TARGET_ATI
  GL_BUMP_TEX_UNITS_ATI
  GL_BYTE
  GL_C3F_V3F
  GL_C4F_N3F_V3F
  GL_C4UB_V2F
  GL_C4UB_V3F
  GL_CACHE_REGAL
  GL_CAVEAT_SUPPORT
  GL_CCW
  GL_CG_FRAGMENT_SHADER_EXT
  GL_CG_VERTEX_SHADER_EXT
  GL_CIRCULAR_CCW_ARC_TO_NV
  GL_CIRCULAR_CW_ARC_TO_NV
  GL_CIRCULAR_TANGENT_ARC_TO_NV
  GL_CLAMP
  GL_CLAMP_FRAGMENT_COLOR
  GL_CLAMP_FRAGMENT_COLOR_ARB
  GL_CLAMP_READ_COLOR
  GL_CLAMP_READ_COLOR_ARB
  GL_CLAMP_TO_BORDER
  GL_CLAMP_TO_BORDER_ARB
  GL_CLAMP_TO_BORDER_EXT
  GL_CLAMP_TO_BORDER_NV
  GL_CLAMP_TO_BORDER_OES
  GL_CLAMP_TO_BORDER_SGIS
  GL_CLAMP_TO_EDGE
  GL_CLAMP_TO_EDGE_EXT
  GL_CLAMP_TO_EDGE_SGIS
  GL_CLAMP_VERTEX_COLOR
  GL_CLAMP_VERTEX_COLOR_ARB
  GL_CLEAR
  GL_CLEAR_BUFFER
  GL_CLEAR_TEXTURE
  GL_CLIENT_ACTIVE_TEXTURE
  GL_CLIENT_ACTIVE_TEXTURE_ARB
  GL_CLIENT_ALL_ATTRIB_BITS
  GL_CLIENT_ATTRIB_STACK_DEPTH
  GL_CLIENT_MAPPED_BUFFER_BARRIER_BIT
  GL_CLIENT_MAPPED_BUFFER_BARRIER_BIT_EXT
  GL_CLIENT_PIXEL_STORE_BIT
  GL_CLIENT_STORAGE_BIT
  GL_CLIENT_STORAGE_BIT_EXT
  GL_CLIENT_VERTEX_ARRAY_BIT
  GL_CLIPPING_INPUT_PRIMITIVES
  GL_CLIPPING_INPUT_PRIMITIVES_ARB
  GL_CLIPPING_OUTPUT_PRIMITIVES
  GL_CLIPPING_OUTPUT_PRIMITIVES_ARB
  GL_CLIP_DEPTH_MODE
  GL_CLIP_DEPTH_MODE_EXT
  GL_CLIP_DISTANCE0
  GL_CLIP_DISTANCE0_APPLE
  GL_CLIP_DISTANCE0_EXT
  GL_CLIP_DISTANCE1
  GL_CLIP_DISTANCE1_APPLE
  GL_CLIP_DISTANCE1_EXT
  GL_CLIP_DISTANCE2
  GL_CLIP_DISTANCE2_APPLE
  GL_CLIP_DISTANCE2_EXT
  GL_CLIP_DISTANCE3
  GL_CLIP_DISTANCE3_APPLE
  GL_CLIP_DISTANCE3_EXT
  GL_CLIP_DISTANCE4
  GL_CLIP_DISTANCE4_APPLE
  GL_CLIP_DISTANCE4_EXT
  GL_CLIP_DISTANCE5
  GL_CLIP_DISTANCE5_APPLE
  GL_CLIP_DISTANCE5_EXT
  GL_CLIP_DISTANCE6_APPLE
  GL_CLIP_DISTANCE6_EXT
  GL_CLIP_DISTANCE7_APPLE
  GL_CLIP_DISTANCE7_EXT
  GL_CLIP_DISTANCE_NV
  GL_CLIP_FAR_HINT_PGI
  GL_CLIP_NEAR_HINT_PGI
  GL_CLIP_ORIGIN
  GL_CLIP_ORIGIN_EXT
  GL_CLIP_PLANE0
  GL_CLIP_PLANE1
  GL_CLIP_PLANE2
  GL_CLIP_PLANE3
  GL_CLIP_PLANE4
  GL_CLIP_PLANE5
  GL_CLIP_VOLUME_CLIPPING_HINT_EXT
  GL_CLOSE_PATH_NV
  GL_CMYKA_EXT
  GL_CMYK_EXT
  GL_CND0_ATI
  GL_CND_ATI
  GL_CODE_REGAL
  GL_COEFF
  GL_COLOR
  GL_COLOR3_BIT_PGI
  GL_COLOR4_BIT_PGI
  GL_COLORBURN_KHR
  GL_COLORBURN_NV
  GL_COLORDODGE_KHR
  GL_COLORDODGE_NV
  GL_COLOR_ALPHA_PAIRING_ATI
  GL_COLOR_ARRAY
  GL_COLOR_ARRAY_ADDRESS_NV
  GL_COLOR_ARRAY_BUFFER_BINDING
  GL_COLOR_ARRAY_BUFFER_BINDING_ARB
  GL_COLOR_ARRAY_COUNT_EXT
  GL_COLOR_ARRAY_EXT
  GL_COLOR_ARRAY_LENGTH_NV
  GL_COLOR_ARRAY_LIST_IBM
  GL_COLOR_ARRAY_LIST_STRIDE_IBM
  GL_COLOR_ARRAY_PARALLEL_POINTERS_INTEL
  GL_COLOR_ARRAY_POINTER
  GL_COLOR_ARRAY_POINTER_EXT
  GL_COLOR_ARRAY_SIZE
  GL_COLOR_ARRAY_SIZE_EXT
  GL_COLOR_ARRAY_STRIDE
  GL_COLOR_ARRAY_STRIDE_EXT
  GL_COLOR_ARRAY_TYPE
  GL_COLOR_ARRAY_TYPE_EXT
  GL_COLOR_ATTACHMENT0
  GL_COLOR_ATTACHMENT0_EXT
  GL_COLOR_ATTACHMENT0_NV
  GL_COLOR_ATTACHMENT0_OES
  GL_COLOR_ATTACHMENT1
  GL_COLOR_ATTACHMENT10
  GL_COLOR_ATTACHMENT10_EXT
  GL_COLOR_ATTACHMENT10_NV
  GL_COLOR_ATTACHMENT11
  GL_COLOR_ATTACHMENT11_EXT
  GL_COLOR_ATTACHMENT11_NV
  GL_COLOR_ATTACHMENT12
  GL_COLOR_ATTACHMENT12_EXT
  GL_COLOR_ATTACHMENT12_NV
  GL_COLOR_ATTACHMENT13
  GL_COLOR_ATTACHMENT13_EXT
  GL_COLOR_ATTACHMENT13_NV
  GL_COLOR_ATTACHMENT14
  GL_COLOR_ATTACHMENT14_EXT
  GL_COLOR_ATTACHMENT14_NV
  GL_COLOR_ATTACHMENT15
  GL_COLOR_ATTACHMENT15_EXT
  GL_COLOR_ATTACHMENT15_NV
  GL_COLOR_ATTACHMENT1_EXT
  GL_COLOR_ATTACHMENT1_NV
  GL_COLOR_ATTACHMENT2
  GL_COLOR_ATTACHMENT2_EXT
  GL_COLOR_ATTACHMENT2_NV
  GL_COLOR_ATTACHMENT3
  GL_COLOR_ATTACHMENT3_EXT
  GL_COLOR_ATTACHMENT3_NV
  GL_COLOR_ATTACHMENT4
  GL_COLOR_ATTACHMENT4_EXT
  GL_COLOR_ATTACHMENT4_NV
  GL_COLOR_ATTACHMENT5
  GL_COLOR_ATTACHMENT5_EXT
  GL_COLOR_ATTACHMENT5_NV
  GL_COLOR_ATTACHMENT6
  GL_COLOR_ATTACHMENT6_EXT
  GL_COLOR_ATTACHMENT6_NV
  GL_COLOR_ATTACHMENT7
  GL_COLOR_ATTACHMENT7_EXT
  GL_COLOR_ATTACHMENT7_NV
  GL_COLOR_ATTACHMENT8
  GL_COLOR_ATTACHMENT8_EXT
  GL_COLOR_ATTACHMENT8_NV
  GL_COLOR_ATTACHMENT9
  GL_COLOR_ATTACHMENT9_EXT
  GL_COLOR_ATTACHMENT9_NV
  GL_COLOR_ATTACHMENT_EXT
  GL_COLOR_BUFFER_BIT
  GL_COLOR_BUFFER_BIT0_QCOM
  GL_COLOR_BUFFER_BIT1_QCOM
  GL_COLOR_BUFFER_BIT2_QCOM
  GL_COLOR_BUFFER_BIT3_QCOM
  GL_COLOR_BUFFER_BIT4_QCOM
  GL_COLOR_BUFFER_BIT5_QCOM
  GL_COLOR_BUFFER_BIT6_QCOM
  GL_COLOR_BUFFER_BIT7_QCOM
  GL_COLOR_CLEAR_VALUE
  GL_COLOR_COMPONENTS
  GL_COLOR_ENCODING
  GL_COLOR_EXT
  GL_COLOR_FLOAT_APPLE
  GL_COLOR_INDEX
  GL_COLOR_INDEX12_EXT
  GL_COLOR_INDEX16_EXT
  GL_COLOR_INDEX1_EXT
  GL_COLOR_INDEX2_EXT
  GL_COLOR_INDEX4_EXT
  GL_COLOR_INDEX8_EXT
  GL_COLOR_INDEXES
  GL_COLOR_LOGIC_OP
  GL_COLOR_MATERIAL
  GL_COLOR_MATERIAL_FACE
  GL_COLOR_MATERIAL_PARAMETER
  GL_COLOR_MATRIX
  GL_COLOR_MATRIX_HINT
  GL_COLOR_MATRIX_SGI
  GL_COLOR_MATRIX_STACK_DEPTH
  GL_COLOR_MATRIX_STACK_DEPTH_SGI
  GL_COLOR_RENDERABLE
  GL_COLOR_SAMPLES_NV
  GL_COLOR_SUM
  GL_COLOR_SUM_ARB
  GL_COLOR_SUM_CLAMP_NV
  GL_COLOR_SUM_EXT
  GL_COLOR_TABLE
  GL_COLOR_TABLE_ALPHA_SIZE
  GL_COLOR_TABLE_ALPHA_SIZE_EXT
  GL_COLOR_TABLE_ALPHA_SIZE_SGI
  GL_COLOR_TABLE_BIAS
  GL_COLOR_TABLE_BIAS_SGI
  GL_COLOR_TABLE_BLUE_SIZE
  GL_COLOR_TABLE_BLUE_SIZE_EXT
  GL_COLOR_TABLE_BLUE_SIZE_SGI
  GL_COLOR_TABLE_FORMAT
  GL_COLOR_TABLE_FORMAT_EXT
  GL_COLOR_TABLE_FORMAT_SGI
  GL_COLOR_TABLE_GREEN_SIZE
  GL_COLOR_TABLE_GREEN_SIZE_EXT
  GL_COLOR_TABLE_GREEN_SIZE_SGI
  GL_COLOR_TABLE_INTENSITY_SIZE
  GL_COLOR_TABLE_INTENSITY_SIZE_EXT
  GL_COLOR_TABLE_INTENSITY_SIZE_SGI
  GL_COLOR_TABLE_LUMINANCE_SIZE
  GL_COLOR_TABLE_LUMINANCE_SIZE_EXT
  GL_COLOR_TABLE_LUMINANCE_SIZE_SGI
  GL_COLOR_TABLE_RED_SIZE
  GL_COLOR_TABLE_RED_SIZE_EXT
  GL_COLOR_TABLE_RED_SIZE_SGI
  GL_COLOR_TABLE_SCALE
  GL_COLOR_TABLE_SCALE_SGI
  GL_COLOR_TABLE_SGI
  GL_COLOR_TABLE_WIDTH
  GL_COLOR_TABLE_WIDTH_EXT
  GL_COLOR_TABLE_WIDTH_SGI
  GL_COLOR_WRITEMASK
  GL_COMBINE
  GL_COMBINE4_NV
  GL_COMBINER0_NV
  GL_COMBINER1_NV
  GL_COMBINER2_NV
  GL_COMBINER3_NV
  GL_COMBINER4_NV
  GL_COMBINER5_NV
  GL_COMBINER6_NV
  GL_COMBINER7_NV
  GL_COMBINER_AB_DOT_PRODUCT_NV
  GL_COMBINER_AB_OUTPUT_NV
  GL_COMBINER_BIAS_NV
  GL_COMBINER_CD_DOT_PRODUCT_NV
  GL_COMBINER_CD_OUTPUT_NV
  GL_COMBINER_COMPONENT_USAGE_NV
  GL_COMBINER_INPUT_NV
  GL_COMBINER_MAPPING_NV
  GL_COMBINER_MUX_SUM_NV
  GL_COMBINER_SCALE_NV
  GL_COMBINER_SUM_OUTPUT_NV
  GL_COMBINE_ALPHA
  GL_COMBINE_ALPHA_ARB
  GL_COMBINE_ALPHA_EXT
  GL_COMBINE_ARB
  GL_COMBINE_EXT
  GL_COMBINE_RGB
  GL_COMBINE_RGB_ARB
  GL_COMBINE_RGB_EXT
  GL_COMMAND_BARRIER_BIT
  GL_COMMAND_BARRIER_BIT_EXT
  GL_COMPARE_REF_DEPTH_TO_TEXTURE_EXT
  GL_COMPARE_REF_TO_TEXTURE
  GL_COMPARE_REF_TO_TEXTURE_EXT
  GL_COMPARE_R_TO_TEXTURE
  GL_COMPARE_R_TO_TEXTURE_ARB
  GL_COMPATIBLE_SUBROUTINES
  GL_COMPILE
  GL_COMPILE_AND_EXECUTE
  GL_COMPILE_STATUS
  GL_COMPLETION_STATUS_ARB
  GL_COMPLETION_STATUS_KHR
  GL_COMPLEX_BYTE_SGI
  GL_COMPLEX_FLOAT_SGI
  GL_COMPLEX_INT_SGI
  GL_COMPLEX_SHORT_SGI
  GL_COMPLEX_UNSIGNED_BYTE_SGI
  GL_COMPLEX_UNSIGNED_INT_SGI
  GL_COMPLEX_UNSIGNED_SHORT_SGI
  GL_COMPRESSED_ALPHA
  GL_COMPRESSED_ALPHA_ARB
  GL_COMPRESSED_INTENSITY
  GL_COMPRESSED_INTENSITY_ARB
  GL_COMPRESSED_LUMINANCE
  GL_COMPRESSED_LUMINANCE_ALPHA
  GL_COMPRESSED_LUMINANCE_ALPHA_3DC_ATI
  GL_COMPRESSED_LUMINANCE_ALPHA_ARB
  GL_COMPRESSED_LUMINANCE_ALPHA_LATC2_EXT
  GL_COMPRESSED_LUMINANCE_ALPHA_LATC2_NV
  GL_COMPRESSED_LUMINANCE_ARB
  GL_COMPRESSED_LUMINANCE_LATC1_EXT
  GL_COMPRESSED_LUMINANCE_LATC1_NV
  GL_COMPRESSED_R11_EAC
  GL_COMPRESSED_RED
  GL_COMPRESSED_RED_GREEN_RGTC2_EXT
  GL_COMPRESSED_RED_RGTC1
  GL_COMPRESSED_RED_RGTC1_EXT
  GL_COMPRESSED_RG
  GL_COMPRESSED_RG11_EAC
  GL_COMPRESSED_RGB
  GL_COMPRESSED_RGB8_ETC2
  GL_COMPRESSED_RGB8_PUNCHTHROUGH_ALPHA1_ETC2
  GL_COMPRESSED_RGBA
  GL_COMPRESSED_RGBA8_ETC2_EAC
  GL_COMPRESSED_RGBA_ARB
  GL_COMPRESSED_RGBA_ASTC_10x10_KHR
  GL_COMPRESSED_RGBA_ASTC_10x5_KHR
  GL_COMPRESSED_RGBA_ASTC_10x6_KHR
  GL_COMPRESSED_RGBA_ASTC_10x8_KHR
  GL_COMPRESSED_RGBA_ASTC_12x10_KHR
  GL_COMPRESSED_RGBA_ASTC_12x12_KHR
  GL_COMPRESSED_RGBA_ASTC_3x3x3_OES
  GL_COMPRESSED_RGBA_ASTC_4x3x3_OES
  GL_COMPRESSED_RGBA_ASTC_4x4_KHR
  GL_COMPRESSED_RGBA_ASTC_4x4x3_OES
  GL_COMPRESSED_RGBA_ASTC_4x4x4_OES
  GL_COMPRESSED_RGBA_ASTC_5x4_KHR
  GL_COMPRESSED_RGBA_ASTC_5x4x4_OES
  GL_COMPRESSED_RGBA_ASTC_5x5_KHR
  GL_COMPRESSED_RGBA_ASTC_5x5x4_OES
  GL_COMPRESSED_RGBA_ASTC_5x5x5_OES
  GL_COMPRESSED_RGBA_ASTC_6x5_KHR
  GL_COMPRESSED_RGBA_ASTC_6x5x5_OES
  GL_COMPRESSED_RGBA_ASTC_6x6_KHR
  GL_COMPRESSED_RGBA_ASTC_6x6x5_OES
  GL_COMPRESSED_RGBA_ASTC_6x6x6_OES
  GL_COMPRESSED_RGBA_ASTC_8x5_KHR
  GL_COMPRESSED_RGBA_ASTC_8x6_KHR
  GL_COMPRESSED_RGBA_ASTC_8x8_KHR
  GL_COMPRESSED_RGBA_BPTC_UNORM
  GL_COMPRESSED_RGBA_BPTC_UNORM_ARB
  GL_COMPRESSED_RGBA_BPTC_UNORM_EXT
  GL_COMPRESSED_RGBA_FXT1_3DFX
  GL_COMPRESSED_RGBA_PVRTC_2BPPV1_IMG
  GL_COMPRESSED_RGBA_PVRTC_2BPPV2_IMG
  GL_COMPRESSED_RGBA_PVRTC_4BPPV1_IMG
  GL_COMPRESSED_RGBA_PVRTC_4BPPV2_IMG
  GL_COMPRESSED_RGBA_S3TC_DXT1_ANGLE
  GL_COMPRESSED_RGBA_S3TC_DXT1_EXT
  GL_COMPRESSED_RGBA_S3TC_DXT1_NV
  GL_COMPRESSED_RGBA_S3TC_DXT3_ANGLE
  GL_COMPRESSED_RGBA_S3TC_DXT3_EXT
  GL_COMPRESSED_RGBA_S3TC_DXT3_NV
  GL_COMPRESSED_RGBA_S3TC_DXT5_ANGLE
  GL_COMPRESSED_RGBA_S3TC_DXT5_EXT
  GL_COMPRESSED_RGBA_S3TC_DXT5_NV
  GL_COMPRESSED_RGB_ARB
  GL_COMPRESSED_RGB_BPTC_SIGNED_FLOAT
  GL_COMPRESSED_RGB_BPTC_SIGNED_FLOAT_ARB
  GL_COMPRESSED_RGB_BPTC_SIGNED_FLOAT_EXT
  GL_COMPRESSED_RGB_BPTC_UNSIGNED_FLOAT
  GL_COMPRESSED_RGB_BPTC_UNSIGNED_FLOAT_ARB
  GL_COMPRESSED_RGB_BPTC_UNSIGNED_FLOAT_EXT
  GL_COMPRESSED_RGB_FXT1_3DFX
  GL_COMPRESSED_RGB_PVRTC_2BPPV1_IMG
  GL_COMPRESSED_RGB_PVRTC_4BPPV1_IMG
  GL_COMPRESSED_RGB_S3TC_DXT1_ANGLE
  GL_COMPRESSED_RGB_S3TC_DXT1_EXT
  GL_COMPRESSED_RGB_S3TC_DXT1_NV
  GL_COMPRESSED_RG_RGTC2
  GL_COMPRESSED_SIGNED_LUMINANCE_ALPHA_LATC2_EXT
  GL_COMPRESSED_SIGNED_LUMINANCE_ALPHA_LATC2_NV
  GL_COMPRESSED_SIGNED_LUMINANCE_LATC1_EXT
  GL_COMPRESSED_SIGNED_LUMINANCE_LATC1_NV
  GL_COMPRESSED_SIGNED_R11_EAC
  GL_COMPRESSED_SIGNED_RED_GREEN_RGTC2_EXT
  GL_COMPRESSED_SIGNED_RED_RGTC1
  GL_COMPRESSED_SIGNED_RED_RGTC1_EXT
  GL_COMPRESSED_SIGNED_RG11_EAC
  GL_COMPRESSED_SIGNED_RG_RGTC2
  GL_COMPRESSED_SLUMINANCE
  GL_COMPRESSED_SLUMINANCE_ALPHA
  GL_COMPRESSED_SLUMINANCE_ALPHA_EXT
  GL_COMPRESSED_SLUMINANCE_EXT
  GL_COMPRESSED_SRGB
  GL_COMPRESSED_SRGB8_ALPHA8_ASTC_10x10_KHR
  GL_COMPRESSED_SRGB8_ALPHA8_ASTC_10x5_KHR
  GL_COMPRESSED_SRGB8_ALPHA8_ASTC_10x6_KHR
  GL_COMPRESSED_SRGB8_ALPHA8_ASTC_10x8_KHR
  GL_COMPRESSED_SRGB8_ALPHA8_ASTC_12x10_KHR
  GL_COMPRESSED_SRGB8_ALPHA8_ASTC_12x12_KHR
  GL_COMPRESSED_SRGB8_ALPHA8_ASTC_3x3x3_OES
  GL_COMPRESSED_SRGB8_ALPHA8_ASTC_4x3x3_OES
  GL_COMPRESSED_SRGB8_ALPHA8_ASTC_4x4_KHR
  GL_COMPRESSED_SRGB8_ALPHA8_ASTC_4x4x3_OES
  GL_COMPRESSED_SRGB8_ALPHA8_ASTC_4x4x4_OES
  GL_COMPRESSED_SRGB8_ALPHA8_ASTC_5x4_KHR
  GL_COMPRESSED_SRGB8_ALPHA8_ASTC_5x4x4_OES
  GL_COMPRESSED_SRGB8_ALPHA8_ASTC_5x5_KHR
  GL_COMPRESSED_SRGB8_ALPHA8_ASTC_5x5x4_OES
  GL_COMPRESSED_SRGB8_ALPHA8_ASTC_5x5x5_OES
  GL_COMPRESSED_SRGB8_ALPHA8_ASTC_6x5_KHR
  GL_COMPRESSED_SRGB8_ALPHA8_ASTC_6x5x5_OES
  GL_COMPRESSED_SRGB8_ALPHA8_ASTC_6x6_KHR
  GL_COMPRESSED_SRGB8_ALPHA8_ASTC_6x6x5_OES
  GL_COMPRESSED_SRGB8_ALPHA8_ASTC_6x6x6_OES
  GL_COMPRESSED_SRGB8_ALPHA8_ASTC_8x5_KHR
  GL_COMPRESSED_SRGB8_ALPHA8_ASTC_8x6_KHR
  GL_COMPRESSED_SRGB8_ALPHA8_ASTC_8x8_KHR
  GL_COMPRESSED_SRGB8_ALPHA8_ETC2_EAC
  GL_COMPRESSED_SRGB8_ETC2
  GL_COMPRESSED_SRGB8_PUNCHTHROUGH_ALPHA1_ETC2
  GL_COMPRESSED_SRGB_ALPHA
  GL_COMPRESSED_SRGB_ALPHA_BPTC_UNORM
  GL_COMPRESSED_SRGB_ALPHA_BPTC_UNORM_ARB
  GL_COMPRESSED_SRGB_ALPHA_BPTC_UNORM_EXT
  GL_COMPRESSED_SRGB_ALPHA_EXT
  GL_COMPRESSED_SRGB_ALPHA_PVRTC_2BPPV1_EXT
  GL_COMPRESSED_SRGB_ALPHA_PVRTC_4BPPV1_EXT
  GL_COMPRESSED_SRGB_ALPHA_S3TC_DXT1_EXT
  GL_COMPRESSED_SRGB_ALPHA_S3TC_DXT1_NV
  GL_COMPRESSED_SRGB_ALPHA_S3TC_DXT3_EXT
  GL_COMPRESSED_SRGB_ALPHA_S3TC_DXT3_NV
  GL_COMPRESSED_SRGB_ALPHA_S3TC_DXT5_EXT
  GL_COMPRESSED_SRGB_ALPHA_S3TC_DXT5_NV
  GL_COMPRESSED_SRGB_EXT
  GL_COMPRESSED_SRGB_PVRTC_2BPPV1_EXT
  GL_COMPRESSED_SRGB_PVRTC_4BPPV1_EXT
  GL_COMPRESSED_SRGB_S3TC_DXT1_EXT
  GL_COMPRESSED_SRGB_S3TC_DXT1_NV
  GL_COMPRESSED_TEXTURE_FORMATS
  GL_COMPRESSED_TEXTURE_FORMATS_ARB
  GL_COMPUTE_PROGRAM_NV
  GL_COMPUTE_PROGRAM_PARAMETER_BUFFER_NV
  GL_COMPUTE_SHADER
  GL_COMPUTE_SHADER_BIT
  GL_COMPUTE_SHADER_INVOCATIONS
  GL_COMPUTE_SHADER_INVOCATIONS_ARB
  GL_COMPUTE_SUBROUTINE
  GL_COMPUTE_SUBROUTINE_UNIFORM
  GL_COMPUTE_TEXTURE
  GL_COMPUTE_WORK_GROUP_SIZE
  GL_COMP_BIT_ATI
  GL_CONDITION_SATISFIED
  GL_CONDITION_SATISFIED_APPLE
  GL_CONFORMANT_NV
  GL_CONIC_CURVE_TO_NV
  GL_CONJOINT_NV
  GL_CONSERVATIVE_RASTERIZATION_INTEL
  GL_CONSERVATIVE_RASTERIZATION_NV
  GL_CONSERVATIVE_RASTER_DILATE_GRANULARITY_NV
  GL_CONSERVATIVE_RASTER_DILATE_NV
  GL_CONSERVATIVE_RASTER_DILATE_RANGE_NV
  GL_CONSERVATIVE_RASTER_MODE_NV
  GL_CONSERVATIVE_RASTER_MODE_POST_SNAP_NV
  GL_CONSERVATIVE_RASTER_MODE_PRE_SNAP_NV
  GL_CONSERVATIVE_RASTER_MODE_PRE_SNAP_TRIANGLES_NV
  GL_CONSERVE_MEMORY_HINT_PGI
  GL_CONSTANT
  GL_CONSTANT_ALPHA
  GL_CONSTANT_ALPHA_EXT
  GL_CONSTANT_ARB
  GL_CONSTANT_ATTENUATION
  GL_CONSTANT_BORDER
  GL_CONSTANT_COLOR
  GL_CONSTANT_COLOR0_NV
  GL_CONSTANT_COLOR1_NV
  GL_CONSTANT_COLOR_EXT
  GL_CONSTANT_EXT
  GL_CONST_BW_TILING_MESA
  GL_CONST_EYE_NV
  GL_CONTEXT_COMPATIBILITY_PROFILE_BIT
  GL_CONTEXT_CORE_PROFILE_BIT
  GL_CONTEXT_FLAGS
  GL_CONTEXT_FLAG_DEBUG_BIT
  GL_CONTEXT_FLAG_FORWARD_COMPATIBLE_BIT
  GL_CONTEXT_FLAG_NO_ERROR_BIT
  GL_CONTEXT_FLAG_NO_ERROR_BIT_KHR
  GL_CONTEXT_FLAG_PROTECTED_CONTENT_BIT_EXT
  GL_CONTEXT_FLAG_ROBUST_ACCESS_BIT
  GL_CONTEXT_FLAG_ROBUST_ACCESS_BIT_ARB
  GL_CONTEXT_LOST
  GL_CONTEXT_PROFILE_MASK
  GL_CONTEXT_RELEASE_BEHAVIOR
  GL_CONTEXT_RELEASE_BEHAVIOR_FLUSH
  GL_CONTEXT_ROBUST_ACCESS
  GL_CONTEXT_ROBUST_ACCESS_EXT
  GL_CONTINUOUS_AMD
  GL_CONTRAST_NV
  GL_CONVEX_HULL_NV
  GL_CONVOLUTION_1D
  GL_CONVOLUTION_1D_EXT
  GL_CONVOLUTION_2D
  GL_CONVOLUTION_2D_EXT
  GL_CONVOLUTION_BORDER_COLOR
  GL_CONVOLUTION_BORDER_MODE
  GL_CONVOLUTION_BORDER_MODE_EXT
  GL_CONVOLUTION_FILTER_BIAS
  GL_CONVOLUTION_FILTER_BIAS_EXT
  GL_CONVOLUTION_FILTER_SCALE
  GL_CONVOLUTION_FILTER_SCALE_EXT
  GL_CONVOLUTION_FORMAT
  GL_CONVOLUTION_FORMAT_EXT
  GL_CONVOLUTION_HEIGHT
  GL_CONVOLUTION_HEIGHT_EXT
  GL_CONVOLUTION_HINT_SGIX
  GL_CONVOLUTION_SGI
  GL_CONVOLUTION_WIDTH
  GL_CONVOLUTION_WIDTH_EXT
  GL_CON_0_ATI
  GL_CON_1_ATI
  GL_CON_2_ATI
  GL_CON_3_ATI
  GL_CON_4_ATI
  GL_CON_5_ATI
  GL_CON_6_ATI
  GL_CON_7_ATI
  GL_COORD_REPLACE
  GL_COORD_REPLACE_ARB
  GL_COORD_REPLACE_NV
  GL_COORD_REPLACE_OES
  GL_COPY
  GL_COPY_INVERTED
  GL_COPY_PIXEL_TOKEN
  GL_COPY_READ_BUFFER
  GL_COPY_READ_BUFFER_BINDING
  GL_COPY_READ_BUFFER_NV
  GL_COPY_WRITE_BUFFER
  GL_COPY_WRITE_BUFFER_BINDING
  GL_COPY_WRITE_BUFFER_NV
  GL_COUNTER_RANGE_AMD
  GL_COUNTER_TYPE_AMD
  GL_COUNT_DOWN_NV
  GL_COUNT_UP_NV
  GL_COVERAGE_MODULATION_NV
  GL_COVERAGE_MODULATION_TABLE_NV
  GL_COVERAGE_MODULATION_TABLE_SIZE_NV
  GL_CPU_OPTIMIZED_QCOM
  GL_CUBE_MAP_BINDING_SGIX
  GL_CUBE_MAP_SGIX
  GL_CUBE_MAP_XN_SGIX
  GL_CUBE_MAP_XP_SGIX
  GL_CUBE_MAP_YN_SGIX
  GL_CUBE_MAP_YP_SGIX
  GL_CUBE_MAP_ZN_SGIX
  GL_CUBE_MAP_ZP_SGIX
  GL_CUBIC_CURVE_TO_NV
  GL_CUBIC_EXT
  GL_CUBIC_IMG
  GL_CUBIC_MIPMAP_LINEAR_IMG
  GL_CUBIC_MIPMAP_NEAREST_IMG
  GL_CULL_FACE
  GL_CULL_FACE_MODE
  GL_CULL_FRAGMENT_NV
  GL_CULL_MODES_NV
  GL_CULL_VERTEX_EXT
  GL_CULL_VERTEX_EYE_POSITION_EXT
  GL_CULL_VERTEX_IBM
  GL_CULL_VERTEX_OBJECT_POSITION_EXT
  GL_CURRENT_ATTRIB_NV
  GL_CURRENT_BINORMAL_EXT
  GL_CURRENT_BIT
  GL_CURRENT_COLOR
  GL_CURRENT_FOG_COORD
  GL_CURRENT_FOG_COORDINATE
  GL_CURRENT_FOG_COORDINATE_EXT
  GL_CURRENT_INDEX
  GL_CURRENT_MATRIX_ARB
  GL_CURRENT_MATRIX_INDEX_ARB
  GL_CURRENT_MATRIX_NV
  GL_CURRENT_MATRIX_STACK_DEPTH_ARB
  GL_CURRENT_MATRIX_STACK_DEPTH_NV
  GL_CURRENT_NORMAL
  GL_CURRENT_OCCLUSION_QUERY_ID_NV
  GL_CURRENT_PALETTE_MATRIX_ARB
  GL_CURRENT_PALETTE_MATRIX_OES
  GL_CURRENT_PROGRAM
  GL_CURRENT_QUERY
  GL_CURRENT_QUERY_ANGLE
  GL_CURRENT_QUERY_ARB
  GL_CURRENT_QUERY_EXT
  GL_CURRENT_RASTER_COLOR
  GL_CURRENT_RASTER_DISTANCE
  GL_CURRENT_RASTER_INDEX
  GL_CURRENT_RASTER_NORMAL_EXT
  GL_CURRENT_RASTER_POSITION
  GL_CURRENT_RASTER_POSITION_VALID
  GL_CURRENT_RASTER_SECONDARY_COLOR
  GL_CURRENT_RASTER_TEXTURE_COORDS
  GL_CURRENT_SAMPLE_COUNT_QUERY_NV
  GL_CURRENT_SECONDARY_COLOR
  GL_CURRENT_SECONDARY_COLOR_EXT
  GL_CURRENT_TANGENT_EXT
  GL_CURRENT_TEXTURE_COORDS
  GL_CURRENT_TIME_NV
  GL_CURRENT_VERTEX_ATTRIB
  GL_CURRENT_VERTEX_ATTRIB_ARB
  GL_CURRENT_VERTEX_EXT
  GL_CURRENT_VERTEX_WEIGHT_EXT
  GL_CURRENT_WEIGHT_ARB
  GL_CW
  GL_D3D12_FENCE_VALUE_EXT
  GL_DARKEN_KHR
  GL_DARKEN_NV
  GL_DATA_BUFFER_AMD
  GL_DEBUG_CALLBACK_FUNCTION
  GL_DEBUG_CALLBACK_FUNCTION_ARB
  GL_DEBUG_CALLBACK_USER_PARAM
  GL_DEBUG_CALLBACK_USER_PARAM_ARB
  GL_DEBUG_CATEGORY_API_ERROR_AMD
  GL_DEBUG_CATEGORY_APPLICATION_AMD
  GL_DEBUG_CATEGORY_DEPRECATION_AMD
  GL_DEBUG_CATEGORY_OTHER_AMD
  GL_DEBUG_CATEGORY_PERFORMANCE_AMD
  GL_DEBUG_CATEGORY_SHADER_COMPILER_AMD
  GL_DEBUG_CATEGORY_UNDEFINED_BEHAVIOR_AMD
  GL_DEBUG_CATEGORY_WINDOW_SYSTEM_AMD
  GL_DEBUG_GROUP_STACK_DEPTH
  GL_DEBUG_LOGGED_MESSAGES
  GL_DEBUG_LOGGED_MESSAGES_AMD
  GL_DEBUG_LOGGED_MESSAGES_ARB
  GL_DEBUG_NEXT_LOGGED_MESSAGE_LENGTH
  GL_DEBUG_NEXT_LOGGED_MESSAGE_LENGTH_ARB
  GL_DEBUG_OUTPUT
  GL_DEBUG_OUTPUT_SYNCHRONOUS
  GL_DEBUG_OUTPUT_SYNCHRONOUS_ARB
  GL_DEBUG_REGAL
  GL_DEBUG_SEVERITY_HIGH
  GL_DEBUG_SEVERITY_HIGH_AMD
  GL_DEBUG_SEVERITY_HIGH_ARB
  GL_DEBUG_SEVERITY_LOW
  GL_DEBUG_SEVERITY_LOW_AMD
  GL_DEBUG_SEVERITY_LOW_ARB
  GL_DEBUG_SEVERITY_MEDIUM
  GL_DEBUG_SEVERITY_MEDIUM_AMD
  GL_DEBUG_SEVERITY_MEDIUM_ARB
  GL_DEBUG_SEVERITY_NOTIFICATION
  GL_DEBUG_SOURCE_API
  GL_DEBUG_SOURCE_API_ARB
  GL_DEBUG_SOURCE_APPLICATION
  GL_DEBUG_SOURCE_APPLICATION_ARB
  GL_DEBUG_SOURCE_OTHER
  GL_DEBUG_SOURCE_OTHER_ARB
  GL_DEBUG_SOURCE_SHADER_COMPILER
  GL_DEBUG_SOURCE_SHADER_COMPILER_ARB
  GL_DEBUG_SOURCE_THIRD_PARTY
  GL_DEBUG_SOURCE_THIRD_PARTY_ARB
  GL_DEBUG_SOURCE_WINDOW_SYSTEM
  GL_DEBUG_SOURCE_WINDOW_SYSTEM_ARB
  GL_DEBUG_TYPE_DEPRECATED_BEHAVIOR
  GL_DEBUG_TYPE_DEPRECATED_BEHAVIOR_ARB
  GL_DEBUG_TYPE_ERROR
  GL_DEBUG_TYPE_ERROR_ARB
  GL_DEBUG_TYPE_MARKER
  GL_DEBUG_TYPE_OTHER
  GL_DEBUG_TYPE_OTHER_ARB
  GL_DEBUG_TYPE_PERFORMANCE
  GL_DEBUG_TYPE_PERFORMANCE_ARB
  GL_DEBUG_TYPE_POP_GROUP
  GL_DEBUG_TYPE_PORTABILITY
  GL_DEBUG_TYPE_PORTABILITY_ARB
  GL_DEBUG_TYPE_PUSH_GROUP
  GL_DEBUG_TYPE_UNDEFINED_BEHAVIOR
  GL_DEBUG_TYPE_UNDEFINED_BEHAVIOR_ARB
  GL_DECAL
  GL_DECODE_EXT
  GL_DECR
  GL_DECR_WRAP
  GL_DECR_WRAP_EXT
  GL_DEDICATED_MEMORY_OBJECT_EXT
  GL_DELETE_STATUS
  GL_DEPENDENT_AR_TEXTURE_2D_NV
  GL_DEPENDENT_GB_TEXTURE_2D_NV
  GL_DEPENDENT_HILO_TEXTURE_2D_NV
  GL_DEPENDENT_RGB_TEXTURE_3D_NV
  GL_DEPENDENT_RGB_TEXTURE_CUBE_MAP_NV
  GL_DEPTH
  GL_DEPTH24_STENCIL8
  GL_DEPTH24_STENCIL8_EXT
  GL_DEPTH24_STENCIL8_OES
  GL_DEPTH32F_STENCIL8
  GL_DEPTH32F_STENCIL8_NV
  GL_DEPTH_ATTACHMENT
  GL_DEPTH_ATTACHMENT_EXT
  GL_DEPTH_ATTACHMENT_OES
  GL_DEPTH_BIAS
  GL_DEPTH_BITS
  GL_DEPTH_BOUNDS_EXT
  GL_DEPTH_BOUNDS_TEST_EXT
  GL_DEPTH_BUFFER
  GL_DEPTH_BUFFER_BIT
  GL_DEPTH_BUFFER_BIT0_QCOM
  GL_DEPTH_BUFFER_BIT1_QCOM
  GL_DEPTH_BUFFER_BIT2_QCOM
  GL_DEPTH_BUFFER_BIT3_QCOM
  GL_DEPTH_BUFFER_BIT4_QCOM
  GL_DEPTH_BUFFER_BIT5_QCOM
  GL_DEPTH_BUFFER_BIT6_QCOM
  GL_DEPTH_BUFFER_BIT7_QCOM
  GL_DEPTH_BUFFER_FLOAT_MODE_NV
  GL_DEPTH_CLAMP
  GL_DEPTH_CLAMP_EXT
  GL_DEPTH_CLAMP_FAR_AMD
  GL_DEPTH_CLAMP_NEAR_AMD
  GL_DEPTH_CLAMP_NV
  GL_DEPTH_CLEAR_VALUE
  GL_DEPTH_COMPONENT
  GL_DEPTH_COMPONENT16
  GL_DEPTH_COMPONENT16_ARB
  GL_DEPTH_COMPONENT16_NONLINEAR_NV
  GL_DEPTH_COMPONENT16_OES
  GL_DEPTH_COMPONENT16_SGIX
  GL_DEPTH_COMPONENT24
  GL_DEPTH_COMPONENT24_ARB
  GL_DEPTH_COMPONENT24_OES
  GL_DEPTH_COMPONENT24_SGIX
  GL_DEPTH_COMPONENT32
  GL_DEPTH_COMPONENT32F
  GL_DEPTH_COMPONENT32F_NV
  GL_DEPTH_COMPONENT32_ARB
  GL_DEPTH_COMPONENT32_OES
  GL_DEPTH_COMPONENT32_SGIX
  GL_DEPTH_COMPONENTS
  GL_DEPTH_EXT
  GL_DEPTH_FUNC
  GL_DEPTH_PASS_INSTRUMENT_COUNTERS_SGIX
  GL_DEPTH_PASS_INSTRUMENT_MAX_SGIX
  GL_DEPTH_PASS_INSTRUMENT_SGIX
  GL_DEPTH_RANGE
  GL_DEPTH_RENDERABLE
  GL_DEPTH_SAMPLES_NV
  GL_DEPTH_SCALE
  GL_DEPTH_STENCIL
  GL_DEPTH_STENCIL_ATTACHMENT
  GL_DEPTH_STENCIL_EXT
  GL_DEPTH_STENCIL_NV
  GL_DEPTH_STENCIL_OES
  GL_DEPTH_STENCIL_TEXTURE_MODE
  GL_DEPTH_STENCIL_TO_BGRA_NV
  GL_DEPTH_STENCIL_TO_RGBA_NV
  GL_DEPTH_TEST
  GL_DEPTH_TEXTURE_MODE
  GL_DEPTH_TEXTURE_MODE_ARB
  GL_DEPTH_WRITEMASK
  GL_DETACHED_BUFFERS_NV
  GL_DETACHED_MEMORY_INCARNATION_NV
  GL_DETACHED_TEXTURES_NV
  GL_DEVICE_LUID_EXT
  GL_DEVICE_NODE_MASK_EXT
  GL_DEVICE_UUID_EXT
  GL_DIFFERENCE_KHR
  GL_DIFFERENCE_NV
  GL_DIFFUSE
  GL_DISCARD_ATI
  GL_DISCARD_NV
  GL_DISCRETE_AMD
  GL_DISJOINT_NV
  GL_DISPATCH_INDIRECT_BUFFER
  GL_DISPATCH_INDIRECT_BUFFER_BINDING
  GL_DISPLAY_LIST
  GL_DISTANCE_ATTENUATION_EXT
  GL_DITHER
  GL_DMP_PROGRAM_BINARY_DMP
  GL_DOMAIN
  GL_DONT_CARE
  GL_DOT2_ADD_ATI
  GL_DOT3_ATI
  GL_DOT3_RGB
  GL_DOT3_RGBA
  GL_DOT3_RGBA_ARB
  GL_DOT3_RGBA_EXT
  GL_DOT3_RGBA_IMG
  GL_DOT3_RGB_ARB
  GL_DOT3_RGB_EXT
  GL_DOT4_ATI
  GL_DOT_PRODUCT_AFFINE_DEPTH_REPLACE_NV
  GL_DOT_PRODUCT_CONST_EYE_REFLECT_CUBE_MAP_NV
  GL_DOT_PRODUCT_DEPTH_REPLACE_NV
  GL_DOT_PRODUCT_DIFFUSE_CUBE_MAP_NV
  GL_DOT_PRODUCT_NV
  GL_DOT_PRODUCT_PASS_THROUGH_NV
  GL_DOT_PRODUCT_REFLECT_CUBE_MAP_NV
  GL_DOT_PRODUCT_TEXTURE_1D_NV
  GL_DOT_PRODUCT_TEXTURE_2D_NV
  GL_DOT_PRODUCT_TEXTURE_3D_NV
  GL_DOT_PRODUCT_TEXTURE_CUBE_MAP_NV
  GL_DOT_PRODUCT_TEXTURE_RECTANGLE_NV
  GL_DOUBLE
  GL_DOUBLEBUFFER
  GL_DOUBLE_EXT
  GL_DOUBLE_MAT2
  GL_DOUBLE_MAT2_EXT
  GL_DOUBLE_MAT2x3
  GL_DOUBLE_MAT2x3_EXT
  GL_DOUBLE_MAT2x4
  GL_DOUBLE_MAT2x4_EXT
  GL_DOUBLE_MAT3
  GL_DOUBLE_MAT3_EXT
  GL_DOUBLE_MAT3x2
  GL_DOUBLE_MAT3x2_EXT
  GL_DOUBLE_MAT3x4
  GL_DOUBLE_MAT3x4_EXT
  GL_DOUBLE_MAT4
  GL_DOUBLE_MAT4_EXT
  GL_DOUBLE_MAT4x2
  GL_DOUBLE_MAT4x2_EXT
  GL_DOUBLE_MAT4x3
  GL_DOUBLE_MAT4x3_EXT
  GL_DOUBLE_VEC2
  GL_DOUBLE_VEC2_EXT
  GL_DOUBLE_VEC3
  GL_DOUBLE_VEC3_EXT
  GL_DOUBLE_VEC4
  GL_DOUBLE_VEC4_EXT
  GL_DOWNSAMPLE_SCALES_IMG
  GL_DRAW_ARRAYS_COMMAND_NV
  GL_DRAW_ARRAYS_INSTANCED_COMMAND_NV
  GL_DRAW_ARRAYS_STRIP_COMMAND_NV
  GL_DRAW_BUFFER
  GL_DRAW_BUFFER0
  GL_DRAW_BUFFER0_ARB
  GL_DRAW_BUFFER0_ATI
  GL_DRAW_BUFFER0_EXT
  GL_DRAW_BUFFER0_NV
  GL_DRAW_BUFFER1
  GL_DRAW_BUFFER10
  GL_DRAW_BUFFER10_ARB
  GL_DRAW_BUFFER10_ATI
  GL_DRAW_BUFFER10_EXT
  GL_DRAW_BUFFER10_NV
  GL_DRAW_BUFFER11
  GL_DRAW_BUFFER11_ARB
  GL_DRAW_BUFFER11_ATI
  GL_DRAW_BUFFER11_EXT
  GL_DRAW_BUFFER11_NV
  GL_DRAW_BUFFER12
  GL_DRAW_BUFFER12_ARB
  GL_DRAW_BUFFER12_ATI
  GL_DRAW_BUFFER12_EXT
  GL_DRAW_BUFFER12_NV
  GL_DRAW_BUFFER13
  GL_DRAW_BUFFER13_ARB
  GL_DRAW_BUFFER13_ATI
  GL_DRAW_BUFFER13_EXT
  GL_DRAW_BUFFER13_NV
  GL_DRAW_BUFFER14
  GL_DRAW_BUFFER14_ARB
  GL_DRAW_BUFFER14_ATI
  GL_DRAW_BUFFER14_EXT
  GL_DRAW_BUFFER14_NV
  GL_DRAW_BUFFER15
  GL_DRAW_BUFFER15_ARB
  GL_DRAW_BUFFER15_ATI
  GL_DRAW_BUFFER15_EXT
  GL_DRAW_BUFFER15_NV
  GL_DRAW_BUFFER1_ARB
  GL_DRAW_BUFFER1_ATI
  GL_DRAW_BUFFER1_EXT
  GL_DRAW_BUFFER1_NV
  GL_DRAW_BUFFER2
  GL_DRAW_BUFFER2_ARB
  GL_DRAW_BUFFER2_ATI
  GL_DRAW_BUFFER2_EXT
  GL_DRAW_BUFFER2_NV
  GL_DRAW_BUFFER3
  GL_DRAW_BUFFER3_ARB
  GL_DRAW_BUFFER3_ATI
  GL_DRAW_BUFFER3_EXT
  GL_DRAW_BUFFER3_NV
  GL_DRAW_BUFFER4
  GL_DRAW_BUFFER4_ARB
  GL_DRAW_BUFFER4_ATI
  GL_DRAW_BUFFER4_EXT
  GL_DRAW_BUFFER4_NV
  GL_DRAW_BUFFER5
  GL_DRAW_BUFFER5_ARB
  GL_DRAW_BUFFER5_ATI
  GL_DRAW_BUFFER5_EXT
  GL_DRAW_BUFFER5_NV
  GL_DRAW_BUFFER6
  GL_DRAW_BUFFER6_ARB
  GL_DRAW_BUFFER6_ATI
  GL_DRAW_BUFFER6_EXT
  GL_DRAW_BUFFER6_NV
  GL_DRAW_BUFFER7
  GL_DRAW_BUFFER7_ARB
  GL_DRAW_BUFFER7_ATI
  GL_DRAW_BUFFER7_EXT
  GL_DRAW_BUFFER7_NV
  GL_DRAW_BUFFER8
  GL_DRAW_BUFFER8_ARB
  GL_DRAW_BUFFER8_ATI
  GL_DRAW_BUFFER8_EXT
  GL_DRAW_BUFFER8_NV
  GL_DRAW_BUFFER9
  GL_DRAW_BUFFER9_ARB
  GL_DRAW_BUFFER9_ATI
  GL_DRAW_BUFFER9_EXT
  GL_DRAW_BUFFER9_NV
  GL_DRAW_BUFFER_EXT
  GL_DRAW_ELEMENTS_COMMAND_NV
  GL_DRAW_ELEMENTS_INSTANCED_COMMAND_NV
  GL_DRAW_ELEMENTS_STRIP_COMMAND_NV
  GL_DRAW_FRAMEBUFFER
  GL_DRAW_FRAMEBUFFER_ANGLE
  GL_DRAW_FRAMEBUFFER_APPLE
  GL_DRAW_FRAMEBUFFER_BINDING
  GL_DRAW_FRAMEBUFFER_BINDING_ANGLE
  GL_DRAW_FRAMEBUFFER_BINDING_APPLE
  GL_DRAW_FRAMEBUFFER_BINDING_EXT
  GL_DRAW_FRAMEBUFFER_BINDING_NV
  GL_DRAW_FRAMEBUFFER_EXT
  GL_DRAW_FRAMEBUFFER_NV
  GL_DRAW_INDIRECT_ADDRESS_NV
  GL_DRAW_INDIRECT_BUFFER
  GL_DRAW_INDIRECT_BUFFER_BINDING
  GL_DRAW_INDIRECT_LENGTH_NV
  GL_DRAW_INDIRECT_UNIFIED_NV
  GL_DRAW_PIXELS_APPLE
  GL_DRAW_PIXEL_TOKEN
  GL_DRIVER_REGAL
  GL_DRIVER_UUID_EXT
  GL_DSDT8_MAG8_INTENSITY8_NV
  GL_DSDT8_MAG8_NV
  GL_DSDT8_NV
  GL_DSDT_MAG_INTENSITY_NV
  GL_DSDT_MAG_NV
  GL_DSDT_MAG_VIB_NV
  GL_DSDT_NV
  GL_DST_ALPHA
  GL_DST_ATOP_NV
  GL_DST_COLOR
  GL_DST_IN_NV
  GL_DST_NV
  GL_DST_OUT_NV
  GL_DST_OVER_NV
  GL_DS_BIAS_NV
  GL_DS_SCALE_NV
  GL_DT_BIAS_NV
  GL_DT_SCALE_NV
  GL_DU8DV8_ATI
  GL_DUDV_ATI
  GL_DUP_FIRST_CUBIC_CURVE_TO_NV
  GL_DUP_LAST_CUBIC_CURVE_TO_NV
  GL_DYNAMIC_ATI
  GL_DYNAMIC_COPY
  GL_DYNAMIC_COPY_ARB
  GL_DYNAMIC_DRAW
  GL_DYNAMIC_DRAW_ARB
  GL_DYNAMIC_READ
  GL_DYNAMIC_READ_ARB
  GL_DYNAMIC_STORAGE_BIT
  GL_DYNAMIC_STORAGE_BIT_EXT
  GL_EDGEFLAG_BIT_PGI
  GL_EDGE_FLAG
  GL_EDGE_FLAG_ARRAY
  GL_EDGE_FLAG_ARRAY_ADDRESS_NV
  GL_EDGE_FLAG_ARRAY_BUFFER_BINDING
  GL_EDGE_FLAG_ARRAY_BUFFER_BINDING_ARB
  GL_EDGE_FLAG_ARRAY_COUNT_EXT
  GL_EDGE_FLAG_ARRAY_EXT
  GL_EDGE_FLAG_ARRAY_LENGTH_NV
  GL_EDGE_FLAG_ARRAY_LIST_IBM
  GL_EDGE_FLAG_ARRAY_LIST_STRIDE_IBM
  GL_EDGE_FLAG_ARRAY_POINTER
  GL_EDGE_FLAG_ARRAY_POINTER_EXT
  GL_EDGE_FLAG_ARRAY_STRIDE
  GL_EDGE_FLAG_ARRAY_STRIDE_EXT
  GL_EFFECTIVE_RASTER_SAMPLES_EXT
  GL_EIGHTH_BIT_ATI
  GL_ELEMENT_ADDRESS_COMMAND_NV
  GL_ELEMENT_ARRAY_ADDRESS_NV
  GL_ELEMENT_ARRAY_APPLE
  GL_ELEMENT_ARRAY_ATI
  GL_ELEMENT_ARRAY_BARRIER_BIT
  GL_ELEMENT_ARRAY_BARRIER_BIT_EXT
  GL_ELEMENT_ARRAY_BUFFER
  GL_ELEMENT_ARRAY_BUFFER_ARB
  GL_ELEMENT_ARRAY_BUFFER_BINDING
  GL_ELEMENT_ARRAY_BUFFER_BINDING_ARB
  GL_ELEMENT_ARRAY_LENGTH_NV
  GL_ELEMENT_ARRAY_POINTER_APPLE
  GL_ELEMENT_ARRAY_POINTER_ATI
  GL_ELEMENT_ARRAY_TYPE_APPLE
  GL_ELEMENT_ARRAY_TYPE_ATI
  GL_ELEMENT_ARRAY_UNIFIED_NV
  GL_EMBOSS_CONSTANT_NV
  GL_EMBOSS_LIGHT_NV
  GL_EMBOSS_MAP_NV
  GL_EMISSION
  GL_EMULATION_REGAL
  GL_ENABLE_BIT
  GL_ENV_MAP_SGIX
  GL_EQUAL
  GL_EQUIV
  GL_ERROR_REGAL
  GL_ETC1_RGB8_OES
  GL_ETC1_SRGB8_NV
  GL_EVAL_2D_NV
  GL_EVAL_BIT
  GL_EVAL_FRACTIONAL_TESSELLATION_NV
  GL_EVAL_TRIANGULAR_2D_NV
  GL_EVAL_VERTEX_ATTRIB0_NV
  GL_EVAL_VERTEX_ATTRIB10_NV
  GL_EVAL_VERTEX_ATTRIB11_NV
  GL_EVAL_VERTEX_ATTRIB12_NV
  GL_EVAL_VERTEX_ATTRIB13_NV
  GL_EVAL_VERTEX_ATTRIB14_NV
  GL_EVAL_VERTEX_ATTRIB15_NV
  GL_EVAL_VERTEX_ATTRIB1_NV
  GL_EVAL_VERTEX_ATTRIB2_NV
  GL_EVAL_VERTEX_ATTRIB3_NV
  GL_EVAL_VERTEX_ATTRIB4_NV
  GL_EVAL_VERTEX_ATTRIB5_NV
  GL_EVAL_VERTEX_ATTRIB6_NV
  GL_EVAL_VERTEX_ATTRIB7_NV
  GL_EVAL_VERTEX_ATTRIB8_NV
  GL_EVAL_VERTEX_ATTRIB9_NV
  GL_EXCLUSION_KHR
  GL_EXCLUSION_NV
  GL_EXCLUSIVE_EXT
  GL_EXP
  GL_EXP2
  GL_EXPAND_NEGATE_NV
  GL_EXPAND_NORMAL_NV
  GL_EXTENDED_RANGE_SGIS
  GL_EXTENSIONS
  GL_EXTERNAL_VIRTUAL_MEMORY_BUFFER_AMD
  GL_EYE_DISTANCE_TO_LINE_SGIS
  GL_EYE_DISTANCE_TO_POINT_SGIS
  GL_EYE_LINEAR
  GL_EYE_LINE_SGIS
  GL_EYE_PLANE
  GL_EYE_PLANE_ABSOLUTE_NV
  GL_EYE_POINT_SGIS
  GL_EYE_RADIAL_NV
  GL_EYE_SPACE_SGIX
  GL_E_TIMES_F_NV
  GL_FACTOR_ALPHA_MODULATE_IMG
  GL_FACTOR_MAX_AMD
  GL_FACTOR_MIN_AMD
  GL_FAILURE_NV
  GL_FALSE
  GL_FASTEST
  GL_FEEDBACK
  GL_FEEDBACK_BUFFER_POINTER
  GL_FEEDBACK_BUFFER_SIZE
  GL_FEEDBACK_BUFFER_TYPE
  GL_FENCE_APPLE
  GL_FENCE_CONDITION_NV
  GL_FENCE_STATUS_NV
  GL_FETCH_PER_SAMPLE_ARM
  GL_FFT_1D_SGI
  GL_FIELDS_NV
  GL_FIELD_LOWER_NV
  GL_FIELD_UPPER_NV
  GL_FILE_NAME_NV
  GL_FILL
  GL_FILL_NV
  GL_FILL_RECTANGLE_NV
  GL_FILTER
  GL_FIRST_TO_REST_NV
  GL_FIRST_VERTEX_CONVENTION
  GL_FIRST_VERTEX_CONVENTION_EXT
  GL_FIRST_VERTEX_CONVENTION_OES
  GL_FIXED
  GL_FIXED_ONLY
  GL_FIXED_ONLY_ARB
  GL_FLAT
  GL_FLOAT
  GL_FLOAT16_IMAGE_1D_AMD
  GL_FLOAT16_IMAGE_1D_ARRAY_AMD
  GL_FLOAT16_IMAGE_2D_AMD
  GL_FLOAT16_IMAGE_2D_ARRAY_AMD
  GL_FLOAT16_IMAGE_2D_MULTISAMPLE_AMD
  GL_FLOAT16_IMAGE_2D_MULTISAMPLE_ARRAY_AMD
  GL_FLOAT16_IMAGE_2D_RECT_AMD
  GL_FLOAT16_IMAGE_3D_AMD
  GL_FLOAT16_IMAGE_BUFFER_AMD
  GL_FLOAT16_IMAGE_CUBE_AMD
  GL_FLOAT16_IMAGE_CUBE_MAP_ARRAY_AMD
  GL_FLOAT16_MAT2_AMD
  GL_FLOAT16_MAT2x3_AMD
  GL_FLOAT16_MAT2x4_AMD
  GL_FLOAT16_MAT3_AMD
  GL_FLOAT16_MAT3x2_AMD
  GL_FLOAT16_MAT3x4_AMD
  GL_FLOAT16_MAT4_AMD
  GL_FLOAT16_MAT4x2_AMD
  GL_FLOAT16_MAT4x3_AMD
  GL_FLOAT16_NV
  GL_FLOAT16_SAMPLER_1D_AMD
  GL_FLOAT16_SAMPLER_1D_ARRAY_AMD
  GL_FLOAT16_SAMPLER_1D_ARRAY_SHADOW_AMD
  GL_FLOAT16_SAMPLER_1D_SHADOW_AMD
  GL_FLOAT16_SAMPLER_2D_AMD
  GL_FLOAT16_SAMPLER_2D_ARRAY_AMD
  GL_FLOAT16_SAMPLER_2D_ARRAY_SHADOW_AMD
  GL_FLOAT16_SAMPLER_2D_MULTISAMPLE_AMD
  GL_FLOAT16_SAMPLER_2D_MULTISAMPLE_ARRAY_AMD
  GL_FLOAT16_SAMPLER_2D_RECT_AMD
  GL_FLOAT16_SAMPLER_2D_RECT_SHADOW_AMD
  GL_FLOAT16_SAMPLER_2D_SHADOW_AMD
  GL_FLOAT16_SAMPLER_3D_AMD
  GL_FLOAT16_SAMPLER_BUFFER_AMD
  GL_FLOAT16_SAMPLER_CUBE_AMD
  GL_FLOAT16_SAMPLER_CUBE_MAP_ARRAY_AMD
  GL_FLOAT16_SAMPLER_CUBE_MAP_ARRAY_SHADOW_AMD
  GL_FLOAT16_SAMPLER_CUBE_SHADOW_AMD
  GL_FLOAT16_VEC2_NV
  GL_FLOAT16_VEC3_NV
  GL_FLOAT16_VEC4_NV
  GL_FLOAT_32_UNSIGNED_INT_24_8_REV
  GL_FLOAT_32_UNSIGNED_INT_24_8_REV_NV
  GL_FLOAT_CLEAR_COLOR_VALUE_NV
  GL_FLOAT_MAT2
  GL_FLOAT_MAT2_ARB
  GL_FLOAT_MAT2x3
  GL_FLOAT_MAT2x3_NV
  GL_FLOAT_MAT2x4
  GL_FLOAT_MAT2x4_NV
  GL_FLOAT_MAT3
  GL_FLOAT_MAT3_ARB
  GL_FLOAT_MAT3x2
  GL_FLOAT_MAT3x2_NV
  GL_FLOAT_MAT3x4
  GL_FLOAT_MAT3x4_NV
  GL_FLOAT_MAT4
  GL_FLOAT_MAT4_ARB
  GL_FLOAT_MAT4x2
  GL_FLOAT_MAT4x2_NV
  GL_FLOAT_MAT4x3
  GL_FLOAT_MAT4x3_NV
  GL_FLOAT_R16_NV
  GL_FLOAT_R32_NV
  GL_FLOAT_RG16_NV
  GL_FLOAT_RG32_NV
  GL_FLOAT_RGB16_NV
  GL_FLOAT_RGB32_NV
  GL_FLOAT_RGBA16_NV
  GL_FLOAT_RGBA32_NV
  GL_FLOAT_RGBA_MODE_NV
  GL_FLOAT_RGBA_NV
  GL_FLOAT_RGB_NV
  GL_FLOAT_RG_NV
  GL_FLOAT_R_NV
  GL_FLOAT_VEC2
  GL_FLOAT_VEC2_ARB
  GL_FLOAT_VEC3
  GL_FLOAT_VEC3_ARB
  GL_FLOAT_VEC4
  GL_FLOAT_VEC4_ARB
  GL_FOG
  GL_FOG_BIT
  GL_FOG_BLEND_ALPHA_SGIX
  GL_FOG_BLEND_COLOR_SGIX
  GL_FOG_COLOR
  GL_FOG_COORD
  GL_FOG_COORDINATE
  GL_FOG_COORDINATE_ARRAY
  GL_FOG_COORDINATE_ARRAY_BUFFER_BINDING
  GL_FOG_COORDINATE_ARRAY_BUFFER_BINDING_ARB
  GL_FOG_COORDINATE_ARRAY_EXT
  GL_FOG_COORDINATE_ARRAY_LIST_IBM
  GL_FOG_COORDINATE_ARRAY_LIST_STRIDE_IBM
  GL_FOG_COORDINATE_ARRAY_POINTER
  GL_FOG_COORDINATE_ARRAY_POINTER_EXT
  GL_FOG_COORDINATE_ARRAY_STRIDE
  GL_FOG_COORDINATE_ARRAY_STRIDE_EXT
  GL_FOG_COORDINATE_ARRAY_TYPE
  GL_FOG_COORDINATE_ARRAY_TYPE_EXT
  GL_FOG_COORDINATE_EXT
  GL_FOG_COORDINATE_SOURCE
  GL_FOG_COORDINATE_SOURCE_EXT
  GL_FOG_COORD_ARRAY
  GL_FOG_COORD_ARRAY_ADDRESS_NV
  GL_FOG_COORD_ARRAY_BUFFER_BINDING
  GL_FOG_COORD_ARRAY_LENGTH_NV
  GL_FOG_COORD_ARRAY_POINTER
  GL_FOG_COORD_ARRAY_STRIDE
  GL_FOG_COORD_ARRAY_TYPE
  GL_FOG_COORD_SRC
  GL_FOG_DENSITY
  GL_FOG_DISTANCE_MODE_NV
  GL_FOG_END
  GL_FOG_GROUND_PLANE_SGIX
  GL_FOG_HINT
  GL_FOG_INDEX
  GL_FOG_LAYERS_POINTS_SGIX
  GL_FOG_MODE
  GL_FOG_OFFSET_SGIX
  GL_FOG_OFFSET_VALUE_SGIX
  GL_FOG_SCALE_SGIX
  GL_FOG_SCALE_VALUE_SGIX
  GL_FOG_SPECULAR_TEXTURE_WIN
  GL_FOG_START
  GL_FOG_TYPE_SGIX
  GL_FONT_ASCENDER_BIT_NV
  GL_FONT_DESCENDER_BIT_NV
  GL_FONT_GLYPHS_AVAILABLE_NV
  GL_FONT_HAS_KERNING_BIT_NV
  GL_FONT_HEIGHT_BIT_NV
  GL_FONT_MAX_ADVANCE_HEIGHT_BIT_NV
  GL_FONT_MAX_ADVANCE_WIDTH_BIT_NV
  GL_FONT_NUM_GLYPH_INDICES_BIT_NV
  GL_FONT_TARGET_UNAVAILABLE_NV
  GL_FONT_UNAVAILABLE_NV
  GL_FONT_UNDERLINE_POSITION_BIT_NV
  GL_FONT_UNDERLINE_THICKNESS_BIT_NV
  GL_FONT_UNINTELLIGIBLE_NV
  GL_FONT_UNITS_PER_EM_BIT_NV
  GL_FONT_X_MAX_BOUNDS_BIT_NV
  GL_FONT_X_MIN_BOUNDS_BIT_NV
  GL_FONT_Y_MAX_BOUNDS_BIT_NV
  GL_FONT_Y_MIN_BOUNDS_BIT_NV
  GL_FORCE_BLUE_TO_ONE_NV
  GL_FORMAT_SUBSAMPLE_244_244_OML
  GL_FORMAT_SUBSAMPLE_24_24_OML
  GL_FOVEATION_ENABLE_BIT_QCOM
  GL_FOVEATION_SCALED_BIN_METHOD_BIT_QCOM
  GL_FOVEATION_SUBSAMPLED_LAYOUT_METHOD_BIT_QCOM
  GL_FRACTIONAL_EVEN
  GL_FRACTIONAL_EVEN_EXT
  GL_FRACTIONAL_EVEN_OES
  GL_FRACTIONAL_ODD
  GL_FRACTIONAL_ODD_EXT
  GL_FRACTIONAL_ODD_OES
  GL_FRAGMENTS_INSTRUMENT_COUNTERS_SGIX
  GL_FRAGMENTS_INSTRUMENT_MAX_SGIX
  GL_FRAGMENTS_INSTRUMENT_SGIX
  GL_FRAGMENT_ALPHA_MODULATE_IMG
  GL_FRAGMENT_COLOR_EXT
  GL_FRAGMENT_COLOR_MATERIAL_EXT
  GL_FRAGMENT_COLOR_MATERIAL_FACE_EXT
  GL_FRAGMENT_COLOR_MATERIAL_PARAMETER_EXT
  GL_FRAGMENT_COVERAGE_COLOR_NV
  GL_FRAGMENT_COVERAGE_TO_COLOR_NV
  GL_FRAGMENT_DEPTH
  GL_FRAGMENT_DEPTH_EXT
  GL_FRAGMENT_INPUT_NV
  GL_FRAGMENT_INTERPOLATION_OFFSET_BITS
  GL_FRAGMENT_INTERPOLATION_OFFSET_BITS_OES
  GL_FRAGMENT_LIGHT0_EXT
  GL_FRAGMENT_LIGHT7_EXT
  GL_FRAGMENT_LIGHTING_EXT
  GL_FRAGMENT_LIGHT_MODEL_AMBIENT_EXT
  GL_FRAGMENT_LIGHT_MODEL_LOCAL_VIEWER_EXT
  GL_FRAGMENT_LIGHT_MODEL_NORMAL_INTERPOLATION_EXT
  GL_FRAGMENT_LIGHT_MODEL_TWO_SIDE_EXT
  GL_FRAGMENT_LIGHT_SPACE_SGIX
  GL_FRAGMENT_MATERIAL_EXT
  GL_FRAGMENT_NORMAL_EXT
  GL_FRAGMENT_PROGRAM_ARB
  GL_FRAGMENT_PROGRAM_BINDING_NV
  GL_FRAGMENT_PROGRAM_INTERPOLATION_OFFSET_BITS_NV
  GL_FRAGMENT_PROGRAM_NV
  GL_FRAGMENT_PROGRAM_PARAMETER_BUFFER_NV
  GL_FRAGMENT_SHADER
  GL_FRAGMENT_SHADER_ARB
  GL_FRAGMENT_SHADER_ATI
  GL_FRAGMENT_SHADER_BIT
  GL_FRAGMENT_SHADER_DERIVATIVE_HINT
  GL_FRAGMENT_SHADER_DERIVATIVE_HINT_ARB
  GL_FRAGMENT_SHADER_DERIVATIVE_HINT_OES
  GL_FRAGMENT_SHADER_DISCARDS_SAMPLES_EXT
  GL_FRAGMENT_SHADER_FRAMEBUFFER_FETCH_MRT_ARM
  GL_FRAGMENT_SHADER_INVOCATIONS
  GL_FRAGMENT_SHADER_INVOCATIONS_ARB
  GL_FRAGMENT_SHADING_RATE_ATTACHMENT_WITH_DEFAULT_FRAMEBUFFER_SUPPORTED_EXT
  GL_FRAGMENT_SHADING_RATE_COMBINER_OP_KEEP_EXT
  GL_FRAGMENT_SHADING_RATE_COMBINER_OP_MAX_EXT
  GL_FRAGMENT_SHADING_RATE_COMBINER_OP_MIN_EXT
  GL_FRAGMENT_SHADING_RATE_COMBINER_OP_MUL_EXT
  GL_FRAGMENT_SHADING_RATE_COMBINER_OP_REPLACE_EXT
  GL_FRAGMENT_SHADING_RATE_NON_TRIVIAL_COMBINERS_SUPPORTED_EXT
  GL_FRAGMENT_SHADING_RATE_PRIMITIVE_RATE_WITH_MULTI_VIEWPORT_SUPPORTED_EXT
  GL_FRAGMENT_SHADING_RATE_WITH_SAMPLE_MASK_SUPPORTED_EXT
  GL_FRAGMENT_SHADING_RATE_WITH_SHADER_DEPTH_STENCIL_WRITES_SUPPORTED_EXT
  GL_FRAGMENT_SUBROUTINE
  GL_FRAGMENT_SUBROUTINE_UNIFORM
  GL_FRAGMENT_TEXTURE
  GL_FRAMEBUFFER
  GL_FRAMEBUFFER_ATTACHMENT_ALPHA_SIZE
  GL_FRAMEBUFFER_ATTACHMENT_ANGLE
  GL_FRAMEBUFFER_ATTACHMENT_BLUE_SIZE
  GL_FRAMEBUFFER_ATTACHMENT_COLOR_ENCODING
  GL_FRAMEBUFFER_ATTACHMENT_COLOR_ENCODING_EXT
  GL_FRAMEBUFFER_ATTACHMENT_COMPONENT_TYPE
  GL_FRAMEBUFFER_ATTACHMENT_COMPONENT_TYPE_EXT
  GL_FRAMEBUFFER_ATTACHMENT_DEPTH_SIZE
  GL_FRAMEBUFFER_ATTACHMENT_GREEN_SIZE
  GL_FRAMEBUFFER_ATTACHMENT_LAYERED
  GL_FRAMEBUFFER_ATTACHMENT_LAYERED_ARB
  GL_FRAMEBUFFER_ATTACHMENT_LAYERED_EXT
  GL_FRAMEBUFFER_ATTACHMENT_LAYERED_OES
  GL_FRAMEBUFFER_ATTACHMENT_OBJECT_NAME
  GL_FRAMEBUFFER_ATTACHMENT_OBJECT_NAME_EXT
  GL_FRAMEBUFFER_ATTACHMENT_OBJECT_NAME_OES
  GL_FRAMEBUFFER_ATTACHMENT_OBJECT_TYPE
  GL_FRAMEBUFFER_ATTACHMENT_OBJECT_TYPE_EXT
  GL_FRAMEBUFFER_ATTACHMENT_OBJECT_TYPE_OES
  GL_FRAMEBUFFER_ATTACHMENT_RED_SIZE
  GL_FRAMEBUFFER_ATTACHMENT_STENCIL_SIZE
  GL_FRAMEBUFFER_ATTACHMENT_TEXTURE_3D_ZOFFSET_EXT
  GL_FRAMEBUFFER_ATTACHMENT_TEXTURE_3D_ZOFFSET_OES
  GL_FRAMEBUFFER_ATTACHMENT_TEXTURE_BASE_VIEW_INDEX_OVR
  GL_FRAMEBUFFER_ATTACHMENT_TEXTURE_CUBE_MAP_FACE
  GL_FRAMEBUFFER_ATTACHMENT_TEXTURE_CUBE_MAP_FACE_EXT
  GL_FRAMEBUFFER_ATTACHMENT_TEXTURE_CUBE_MAP_FACE_OES
  GL_FRAMEBUFFER_ATTACHMENT_TEXTURE_LAYER
  GL_FRAMEBUFFER_ATTACHMENT_TEXTURE_LAYER_EXT
  GL_FRAMEBUFFER_ATTACHMENT_TEXTURE_LAYER_NV
  GL_FRAMEBUFFER_ATTACHMENT_TEXTURE_LEVEL
  GL_FRAMEBUFFER_ATTACHMENT_TEXTURE_LEVEL_EXT
  GL_FRAMEBUFFER_ATTACHMENT_TEXTURE_LEVEL_OES
  GL_FRAMEBUFFER_ATTACHMENT_TEXTURE_NUM_VIEWS_OVR
  GL_FRAMEBUFFER_ATTACHMENT_TEXTURE_SAMPLES_EXT
  GL_FRAMEBUFFER_ATTACHMENT_TEXTURE_SCALE_IMG
  GL_FRAMEBUFFER_BARRIER_BIT
  GL_FRAMEBUFFER_BARRIER_BIT_EXT
  GL_FRAMEBUFFER_BINDING
  GL_FRAMEBUFFER_BINDING_EXT
  GL_FRAMEBUFFER_BINDING_OES
  GL_FRAMEBUFFER_BLEND
  GL_FRAMEBUFFER_COMPLETE
  GL_FRAMEBUFFER_COMPLETE_EXT
  GL_FRAMEBUFFER_COMPLETE_OES
  GL_FRAMEBUFFER_DEFAULT
  GL_FRAMEBUFFER_DEFAULT_FIXED_SAMPLE_LOCATIONS
  GL_FRAMEBUFFER_DEFAULT_HEIGHT
  GL_FRAMEBUFFER_DEFAULT_LAYERS
  GL_FRAMEBUFFER_DEFAULT_LAYERS_EXT
  GL_FRAMEBUFFER_DEFAULT_LAYERS_OES
  GL_FRAMEBUFFER_DEFAULT_SAMPLES
  GL_FRAMEBUFFER_DEFAULT_WIDTH
  GL_FRAMEBUFFER_EXT
  GL_FRAMEBUFFER_FETCH_NONCOHERENT_QCOM
  GL_FRAMEBUFFER_FLIP_X_MESA
  GL_FRAMEBUFFER_FLIP_Y_MESA
  GL_FRAMEBUFFER_INCOMPLETE_ATTACHMENT
  GL_FRAMEBUFFER_INCOMPLETE_ATTACHMENT_EXT
  GL_FRAMEBUFFER_INCOMPLETE_ATTACHMENT_OES
  GL_FRAMEBUFFER_INCOMPLETE_DIMENSIONS_EXT
  GL_FRAMEBUFFER_INCOMPLETE_DIMENSIONS_OES
  GL_FRAMEBUFFER_INCOMPLETE_DRAW_BUFFER
  GL_FRAMEBUFFER_INCOMPLETE_DRAW_BUFFER_EXT
  GL_FRAMEBUFFER_INCOMPLETE_DRAW_BUFFER_OES
  GL_FRAMEBUFFER_INCOMPLETE_FORMATS_EXT
  GL_FRAMEBUFFER_INCOMPLETE_FORMATS_OES
  GL_FRAMEBUFFER_INCOMPLETE_FOVEATION_QCOM
  GL_FRAMEBUFFER_INCOMPLETE_INSUFFICIENT_SHADER_COMBINED_LOCAL_STORAGE_EXT
  GL_FRAMEBUFFER_INCOMPLETE_LAYER_COUNT_ARB
  GL_FRAMEBUFFER_INCOMPLETE_LAYER_COUNT_EXT
  GL_FRAMEBUFFER_INCOMPLETE_LAYER_TARGETS
  GL_FRAMEBUFFER_INCOMPLETE_LAYER_TARGETS_ARB
  GL_FRAMEBUFFER_INCOMPLETE_LAYER_TARGETS_EXT
  GL_FRAMEBUFFER_INCOMPLETE_LAYER_TARGETS_OES
  GL_FRAMEBUFFER_INCOMPLETE_MISSING_ATTACHMENT
  GL_FRAMEBUFFER_INCOMPLETE_MISSING_ATTACHMENT_EXT
  GL_FRAMEBUFFER_INCOMPLETE_MISSING_ATTACHMENT_OES
  GL_FRAMEBUFFER_INCOMPLETE_MULTISAMPLE
  GL_FRAMEBUFFER_INCOMPLETE_MULTISAMPLE_AND_DOWNSAMPLE_IMG
  GL_FRAMEBUFFER_INCOMPLETE_MULTISAMPLE_ANGLE
  GL_FRAMEBUFFER_INCOMPLETE_MULTISAMPLE_APPLE
  GL_FRAMEBUFFER_INCOMPLETE_MULTISAMPLE_EXT
  GL_FRAMEBUFFER_INCOMPLETE_MULTISAMPLE_IMG
  GL_FRAMEBUFFER_INCOMPLETE_MULTISAMPLE_NV
  GL_FRAMEBUFFER_INCOMPLETE_READ_BUFFER
  GL_FRAMEBUFFER_INCOMPLETE_READ_BUFFER_EXT
  GL_FRAMEBUFFER_INCOMPLETE_READ_BUFFER_OES
  GL_FRAMEBUFFER_INCOMPLETE_VIEW_TARGETS_OVR
  GL_FRAMEBUFFER_OES
  GL_FRAMEBUFFER_PROGRAMMABLE_SAMPLE_LOCATIONS_ARB
  GL_FRAMEBUFFER_PROGRAMMABLE_SAMPLE_LOCATIONS_NV
  GL_FRAMEBUFFER_RENDERABLE
  GL_FRAMEBUFFER_RENDERABLE_LAYERED
  GL_FRAMEBUFFER_SAMPLE_LOCATION_PIXEL_GRID_ARB
  GL_FRAMEBUFFER_SAMPLE_LOCATION_PIXEL_GRID_NV
  GL_FRAMEBUFFER_SRGB
  GL_FRAMEBUFFER_SRGB_CAPABLE_EXT
  GL_FRAMEBUFFER_SRGB_EXT
  GL_FRAMEBUFFER_SWAP_XY_MESA
  GL_FRAMEBUFFER_UNDEFINED
  GL_FRAMEBUFFER_UNDEFINED_OES
  GL_FRAMEBUFFER_UNSUPPORTED
  GL_FRAMEBUFFER_UNSUPPORTED_EXT
  GL_FRAMEBUFFER_UNSUPPORTED_OES
  GL_FRAME_NV
  GL_FRONT
  GL_FRONT_AND_BACK
  GL_FRONT_FACE
  GL_FRONT_FACE_COMMAND_NV
  GL_FRONT_LEFT
  GL_FRONT_RIGHT
  GL_FULL_RANGE_EXT
  GL_FULL_STIPPLE_HINT_PGI
  GL_FULL_SUPPORT
  GL_FUNC_ADD
  GL_FUNC_ADD_EXT
  GL_FUNC_ADD_OES
  GL_FUNC_COMPLEX_ADD_EXT
  GL_FUNC_COMPLEX_MULTIPLY_EXT
  GL_FUNC_REVERSE_SUBTRACT
  GL_FUNC_REVERSE_SUBTRACT_EXT
  GL_FUNC_REVERSE_SUBTRACT_OES
  GL_FUNC_SUBTRACT
  GL_FUNC_SUBTRACT_EXT
  GL_FUNC_SUBTRACT_OES
  GL_GCCSO_SHADER_BINARY_FJ
  GL_GENERATE_MIPMAP
  GL_GENERATE_MIPMAP_HINT
  GL_GENERATE_MIPMAP_HINT_SGIS
  GL_GENERATE_MIPMAP_SGIS
  GL_GENERIC_ATTRIB_NV
  GL_GEOMETRY_BIT
  GL_GEOMETRY_DEFORMATION_BIT_SGIX
  GL_GEOMETRY_INPUT_TYPE
  GL_GEOMETRY_INPUT_TYPE_ARB
  GL_GEOMETRY_INPUT_TYPE_EXT
  GL_GEOMETRY_LINKED_INPUT_TYPE_EXT
  GL_GEOMETRY_LINKED_INPUT_TYPE_OES
  GL_GEOMETRY_LINKED_OUTPUT_TYPE_EXT
  GL_GEOMETRY_LINKED_OUTPUT_TYPE_OES
  GL_GEOMETRY_LINKED_VERTICES_OUT_EXT
  GL_GEOMETRY_LINKED_VERTICES_OUT_OES
  GL_GEOMETRY_OUTPUT_TYPE
  GL_GEOMETRY_OUTPUT_TYPE_ARB
  GL_GEOMETRY_OUTPUT_TYPE_EXT
  GL_GEOMETRY_PROGRAM_NV
  GL_GEOMETRY_PROGRAM_PARAMETER_BUFFER_NV
  GL_GEOMETRY_SHADER
  GL_GEOMETRY_SHADER_ARB
  GL_GEOMETRY_SHADER_BIT
  GL_GEOMETRY_SHADER_BIT_EXT
  GL_GEOMETRY_SHADER_BIT_OES
  GL_GEOMETRY_SHADER_EXT
  GL_GEOMETRY_SHADER_INVOCATIONS
  GL_GEOMETRY_SHADER_INVOCATIONS_EXT
  GL_GEOMETRY_SHADER_INVOCATIONS_OES
  GL_GEOMETRY_SHADER_OES
  GL_GEOMETRY_SHADER_PRIMITIVES_EMITTED
  GL_GEOMETRY_SHADER_PRIMITIVES_EMITTED_ARB
  GL_GEOMETRY_SUBROUTINE
  GL_GEOMETRY_SUBROUTINE_UNIFORM
  GL_GEOMETRY_TEXTURE
  GL_GEOMETRY_VERTICES_OUT
  GL_GEOMETRY_VERTICES_OUT_ARB
  GL_GEOMETRY_VERTICES_OUT_EXT
  GL_GEQUAL
  GL_GET_TEXTURE_IMAGE_FORMAT
  GL_GET_TEXTURE_IMAGE_TYPE
  GL_GLOBAL_ALPHA_FACTOR_SUN
  GL_GLOBAL_ALPHA_SUN
  GL_GLYPH_HAS_KERNING_BIT_NV
  GL_GLYPH_HEIGHT_BIT_NV
  GL_GLYPH_HORIZONTAL_BEARING_ADVANCE_BIT_NV
  GL_GLYPH_HORIZONTAL_BEARING_X_BIT_NV
  GL_GLYPH_HORIZONTAL_BEARING_Y_BIT_NV
  GL_GLYPH_VERTICAL_BEARING_ADVANCE_BIT_NV
  GL_GLYPH_VERTICAL_BEARING_X_BIT_NV
  GL_GLYPH_VERTICAL_BEARING_Y_BIT_NV
  GL_GLYPH_WIDTH_BIT_NV
  GL_GPU_ADDRESS_NV
  GL_GPU_DISJOINT_EXT
  GL_GPU_MEMORY_INFO_CURRENT_AVAILABLE_VIDMEM_NVX
  GL_GPU_MEMORY_INFO_DEDICATED_VIDMEM_NVX
  GL_GPU_MEMORY_INFO_EVICTED_MEMORY_NVX
  GL_GPU_MEMORY_INFO_EVICTION_COUNT_NVX
  GL_GPU_MEMORY_INFO_TOTAL_AVAILABLE_MEMORY_NVX
  GL_GPU_OPTIMIZED_QCOM
  GL_GREATER
  GL_GREEN
  GL_GREEN_BIAS
  GL_GREEN_BITS
  GL_GREEN_BIT_ATI
  GL_GREEN_INTEGER
  GL_GREEN_INTEGER_EXT
  GL_GREEN_MAX_CLAMP_INGR
  GL_GREEN_MIN_CLAMP_INGR
  GL_GREEN_NV
  GL_GREEN_SCALE
  GL_GUILTY_CONTEXT_RESET
  GL_GUILTY_CONTEXT_RESET_ARB
  GL_GUILTY_CONTEXT_RESET_EXT
  GL_HALF_APPLE
  GL_HALF_BIAS_NEGATE_NV
  GL_HALF_BIAS_NORMAL_NV
  GL_HALF_BIT_ATI
  GL_HALF_FLOAT
  GL_HALF_FLOAT_ARB
  GL_HALF_FLOAT_NV
  GL_HALF_FLOAT_OES
  GL_HANDLE_TYPE_D3D11_IMAGE_EXT
  GL_HANDLE_TYPE_D3D11_IMAGE_KMT_EXT
  GL_HANDLE_TYPE_D3D12_FENCE_EXT
  GL_HANDLE_TYPE_D3D12_RESOURCE_EXT
  GL_HANDLE_TYPE_D3D12_TILEPOOL_EXT
  GL_HANDLE_TYPE_OPAQUE_FD_EXT
  GL_HANDLE_TYPE_OPAQUE_WIN32_EXT
  GL_HANDLE_TYPE_OPAQUE_WIN32_KMT_EXT
  GL_HARDLIGHT_KHR
  GL_HARDLIGHT_NV
  GL_HARDMIX_NV
  GL_HIGH_FLOAT
  GL_HIGH_INT
  GL_HILO16_NV
  GL_HILO8_NV
  GL_HILO_NV
  GL_HINT_BIT
  GL_HISTOGRAM
  GL_HISTOGRAM_ALPHA_SIZE
  GL_HISTOGRAM_ALPHA_SIZE_EXT
  GL_HISTOGRAM_BLUE_SIZE
  GL_HISTOGRAM_BLUE_SIZE_EXT
  GL_HISTOGRAM_EXT
  GL_HISTOGRAM_FORMAT
  GL_HISTOGRAM_FORMAT_EXT
  GL_HISTOGRAM_GREEN_SIZE
  GL_HISTOGRAM_GREEN_SIZE_EXT
  GL_HISTOGRAM_LUMINANCE_SIZE
  GL_HISTOGRAM_LUMINANCE_SIZE_EXT
  GL_HISTOGRAM_RED_SIZE
  GL_HISTOGRAM_RED_SIZE_EXT
  GL_HISTOGRAM_SINK
  GL_HISTOGRAM_SINK_EXT
  GL_HISTOGRAM_WIDTH
  GL_HISTOGRAM_WIDTH_EXT
  GL_HI_BIAS_NV
  GL_HI_SCALE_NV
  GL_HORIZONTAL_LINE_TO_NV
  GL_HSL_COLOR_KHR
  GL_HSL_COLOR_NV
  GL_HSL_HUE_KHR
  GL_HSL_HUE_NV
  GL_HSL_LUMINOSITY_KHR
  GL_HSL_LUMINOSITY_NV
  GL_HSL_SATURATION_KHR
  GL_HSL_SATURATION_NV
  GL_HUAWEI_PROGRAM_BINARY
  GL_HUAWEI_SHADER_BINARY
  GL_IDENTITY_NV
  GL_IGLOO_COLORNORMAL_SGIX
  GL_IGLOO_FULLSCREEN_SGIX
  GL_IGLOO_IRISGL_MODE_SGIX
  GL_IGLOO_LMC_COLOR_SGIX
  GL_IGLOO_SWAPTMESH_SGIX
  GL_IGLOO_TMESHMODE_SGIX
  GL_IGLOO_VIEWPORT_OFFSET_SGIX
  GL_IGNORE_BORDER
  GL_IMAGE_1D
  GL_IMAGE_1D_ARRAY
  GL_IMAGE_1D_ARRAY_EXT
  GL_IMAGE_1D_EXT
  GL_IMAGE_2D
  GL_IMAGE_2D_ARRAY
  GL_IMAGE_2D_ARRAY_EXT
  GL_IMAGE_2D_EXT
  GL_IMAGE_2D_MULTISAMPLE
  GL_IMAGE_2D_MULTISAMPLE_ARRAY
  GL_IMAGE_2D_MULTISAMPLE_ARRAY_EXT
  GL_IMAGE_2D_MULTISAMPLE_EXT
  GL_IMAGE_2D_RECT
  GL_IMAGE_2D_RECT_EXT
  GL_IMAGE_3D
  GL_IMAGE_3D_EXT
  GL_IMAGE_BINDING_ACCESS
  GL_IMAGE_BINDING_ACCESS_EXT
  GL_IMAGE_BINDING_FORMAT
  GL_IMAGE_BINDING_FORMAT_EXT
  GL_IMAGE_BINDING_LAYER
  GL_IMAGE_BINDING_LAYERED
  GL_IMAGE_BINDING_LAYERED_EXT
  GL_IMAGE_BINDING_LAYER_EXT
  GL_IMAGE_BINDING_LEVEL
  GL_IMAGE_BINDING_LEVEL_EXT
  GL_IMAGE_BINDING_NAME
  GL_IMAGE_BINDING_NAME_EXT
  GL_IMAGE_BIT
  GL_IMAGE_BUFFER
  GL_IMAGE_BUFFER_EXT
  GL_IMAGE_BUFFER_OES
  GL_IMAGE_CLASS_10_10_10_2
  GL_IMAGE_CLASS_11_11_10
  GL_IMAGE_CLASS_1_X_16
  GL_IMAGE_CLASS_1_X_32
  GL_IMAGE_CLASS_1_X_8
  GL_IMAGE_CLASS_2_X_16
  GL_IMAGE_CLASS_2_X_32
  GL_IMAGE_CLASS_2_X_8
  GL_IMAGE_CLASS_4_X_16
  GL_IMAGE_CLASS_4_X_32
  GL_IMAGE_CLASS_4_X_8
  GL_IMAGE_COMPATIBILITY_CLASS
  GL_IMAGE_CUBE
  GL_IMAGE_CUBE_EXT
  GL_IMAGE_CUBE_MAP_ARRAY
  GL_IMAGE_CUBE_MAP_ARRAY_EXT
  GL_IMAGE_CUBE_MAP_ARRAY_OES
  GL_IMAGE_FORMAT_COMPATIBILITY_BY_CLASS
  GL_IMAGE_FORMAT_COMPATIBILITY_BY_SIZE
  GL_IMAGE_FORMAT_COMPATIBILITY_TYPE
  GL_IMAGE_PIXEL_FORMAT
  GL_IMAGE_PIXEL_TYPE
  GL_IMAGE_TEXEL_SIZE
  GL_IMPLEMENTATION_COLOR_READ_FORMAT
  GL_IMPLEMENTATION_COLOR_READ_FORMAT_OES
  GL_IMPLEMENTATION_COLOR_READ_TYPE
  GL_IMPLEMENTATION_COLOR_READ_TYPE_OES
  GL_INCLUSIVE_EXT
  GL_INCR
  GL_INCR_WRAP
  GL_INCR_WRAP_EXT
  GL_INDEX
  GL_INDEX_ARRAY
  GL_INDEX_ARRAY_ADDRESS_NV
  GL_INDEX_ARRAY_BUFFER_BINDING
  GL_INDEX_ARRAY_BUFFER_BINDING_ARB
  GL_INDEX_ARRAY_COUNT_EXT
  GL_INDEX_ARRAY_EXT
  GL_INDEX_ARRAY_LENGTH_NV
  GL_INDEX_ARRAY_LIST_IBM
  GL_INDEX_ARRAY_LIST_STRIDE_IBM
  GL_INDEX_ARRAY_POINTER
  GL_INDEX_ARRAY_POINTER_EXT
  GL_INDEX_ARRAY_STRIDE
  GL_INDEX_ARRAY_STRIDE_EXT
  GL_INDEX_ARRAY_TYPE
  GL_INDEX_ARRAY_TYPE_EXT
  GL_INDEX_BITS
  GL_INDEX_BIT_PGI
  GL_INDEX_CLEAR_VALUE
  GL_INDEX_LOGIC_OP
  GL_INDEX_MODE
  GL_INDEX_OFFSET
  GL_INDEX_SHIFT
  GL_INDEX_WRITEMASK
  GL_INFO_LOG_LENGTH
  GL_INNOCENT_CONTEXT_RESET
  GL_INNOCENT_CONTEXT_RESET_ARB
  GL_INNOCENT_CONTEXT_RESET_EXT
  GL_INT
  GL_INT16_NV
  GL_INT16_VEC2_NV
  GL_INT16_VEC3_NV
  GL_INT16_VEC4_NV
  GL_INT64_ARB
  GL_INT64_NV
  GL_INT64_VEC2_ARB
  GL_INT64_VEC2_NV
  GL_INT64_VEC3_ARB
  GL_INT64_VEC3_NV
  GL_INT64_VEC4_ARB
  GL_INT64_VEC4_NV
  GL_INT8_NV
  GL_INT8_VEC2_NV
  GL_INT8_VEC3_NV
  GL_INT8_VEC4_NV
  GL_INTENSITY
  GL_INTENSITY12
  GL_INTENSITY12_EXT
  GL_INTENSITY16
  GL_INTENSITY16F_ARB
  GL_INTENSITY16I_EXT
  GL_INTENSITY16UI_EXT
  GL_INTENSITY16_EXT
  GL_INTENSITY16_EXTENDED_RANGE_SGIX
  GL_INTENSITY16_ICC_SGIX
  GL_INTENSITY16_SIGNED_SGIX
  GL_INTENSITY16_SNORM
  GL_INTENSITY32F_ARB
  GL_INTENSITY32I_EXT
  GL_INTENSITY32UI_EXT
  GL_INTENSITY4
  GL_INTENSITY4_EXT
  GL_INTENSITY8
  GL_INTENSITY8I_EXT
  GL_INTENSITY8UI_EXT
  GL_INTENSITY8_EXT
  GL_INTENSITY8_SNORM
  GL_INTENSITY_EXT
  GL_INTENSITY_EXTENDED_RANGE_SGIX
  GL_INTENSITY_FLOAT16_APPLE
  GL_INTENSITY_FLOAT16_ATI
  GL_INTENSITY_FLOAT32_APPLE
  GL_INTENSITY_FLOAT32_ATI
  GL_INTENSITY_ICC_SGIX
  GL_INTENSITY_SIGNED_SGIX
  GL_INTENSITY_SNORM
  GL_INTERLACE_OML
  GL_INTERLACE_READ_INGR
  GL_INTERLACE_READ_OML
  GL_INTERLACE_SGIX
  GL_INTERLEAVED_ATTRIBS
  GL_INTERLEAVED_ATTRIBS_EXT
  GL_INTERLEAVED_ATTRIBS_NV
  GL_INTERNALFORMAT_ALPHA_SIZE
  GL_INTERNALFORMAT_ALPHA_TYPE
  GL_INTERNALFORMAT_BLUE_SIZE
  GL_INTERNALFORMAT_BLUE_TYPE
  GL_INTERNALFORMAT_DEPTH_SIZE
  GL_INTERNALFORMAT_DEPTH_TYPE
  GL_INTERNALFORMAT_GREEN_SIZE
  GL_INTERNALFORMAT_GREEN_TYPE
  GL_INTERNALFORMAT_PREFERRED
  GL_INTERNALFORMAT_RED_SIZE
  GL_INTERNALFORMAT_RED_TYPE
  GL_INTERNALFORMAT_SHARED_SIZE
  GL_INTERNALFORMAT_STENCIL_SIZE
  GL_INTERNALFORMAT_STENCIL_TYPE
  GL_INTERNALFORMAT_SUPPORTED
  GL_INTERPOLATE
  GL_INTERPOLATE_ARB
  GL_INTERPOLATE_EXT
  GL_INT_10_10_10_2_OES
  GL_INT_2_10_10_10_REV
  GL_INT_IMAGE_1D
  GL_INT_IMAGE_1D_ARRAY
  GL_INT_IMAGE_1D_ARRAY_EXT
  GL_INT_IMAGE_1D_EXT
  GL_INT_IMAGE_2D
  GL_INT_IMAGE_2D_ARRAY
  GL_INT_IMAGE_2D_ARRAY_EXT
  GL_INT_IMAGE_2D_EXT
  GL_INT_IMAGE_2D_MULTISAMPLE
  GL_INT_IMAGE_2D_MULTISAMPLE_ARRAY
  GL_INT_IMAGE_2D_MULTISAMPLE_ARRAY_EXT
  GL_INT_IMAGE_2D_MULTISAMPLE_EXT
  GL_INT_IMAGE_2D_RECT
  GL_INT_IMAGE_2D_RECT_EXT
  GL_INT_IMAGE_3D
  GL_INT_IMAGE_3D_EXT
  GL_INT_IMAGE_BUFFER
  GL_INT_IMAGE_BUFFER_EXT
  GL_INT_IMAGE_BUFFER_OES
  GL_INT_IMAGE_CUBE
  GL_INT_IMAGE_CUBE_EXT
  GL_INT_IMAGE_CUBE_MAP_ARRAY
  GL_INT_IMAGE_CUBE_MAP_ARRAY_EXT
  GL_INT_IMAGE_CUBE_MAP_ARRAY_OES
  GL_INT_SAMPLER_1D
  GL_INT_SAMPLER_1D_ARRAY
  GL_INT_SAMPLER_1D_ARRAY_EXT
  GL_INT_SAMPLER_1D_EXT
  GL_INT_SAMPLER_2D
  GL_INT_SAMPLER_2D_ARRAY
  GL_INT_SAMPLER_2D_ARRAY_EXT
  GL_INT_SAMPLER_2D_EXT
  GL_INT_SAMPLER_2D_MULTISAMPLE
  GL_INT_SAMPLER_2D_MULTISAMPLE_ARRAY
  GL_INT_SAMPLER_2D_MULTISAMPLE_ARRAY_OES
  GL_INT_SAMPLER_2D_RECT
  GL_INT_SAMPLER_2D_RECT_EXT
  GL_INT_SAMPLER_3D
  GL_INT_SAMPLER_3D_EXT
  GL_INT_SAMPLER_BUFFER
  GL_INT_SAMPLER_BUFFER_AMD
  GL_INT_SAMPLER_BUFFER_EXT
  GL_INT_SAMPLER_BUFFER_OES
  GL_INT_SAMPLER_CUBE
  GL_INT_SAMPLER_CUBE_EXT
  GL_INT_SAMPLER_CUBE_MAP_ARRAY
  GL_INT_SAMPLER_CUBE_MAP_ARRAY_ARB
  GL_INT_SAMPLER_CUBE_MAP_ARRAY_EXT
  GL_INT_SAMPLER_CUBE_MAP_ARRAY_OES
  GL_INT_SAMPLER_RENDERBUFFER_NV
  GL_INT_VEC2
  GL_INT_VEC2_ARB
  GL_INT_VEC3
  GL_INT_VEC3_ARB
  GL_INT_VEC4
  GL_INT_VEC4_ARB
  GL_INVALID_ENUM
  GL_INVALID_FRAMEBUFFER_OPERATION
  GL_INVALID_FRAMEBUFFER_OPERATION_EXT
  GL_INVALID_FRAMEBUFFER_OPERATION_OES
  GL_INVALID_INDEX
  GL_INVALID_OPERATION
  GL_INVALID_VALUE
  GL_INVARIANT_DATATYPE_EXT
  GL_INVARIANT_EXT
  GL_INVARIANT_VALUE_EXT
  GL_INVERSE_NV
  GL_INVERSE_TRANSPOSE_NV
  GL_INVERT
  GL_INVERTED_SCREEN_W_REND
  GL_INVERT_OVG_NV
  GL_INVERT_RGB_NV
  GL_ISOLINES
  GL_ISOLINES_EXT
  GL_ISOLINES_OES
  GL_IS_PER_PATCH
  GL_IS_PER_PATCH_EXT
  GL_IS_PER_PATCH_OES
  GL_IS_ROW_MAJOR
  GL_ITALIC_BIT_NV
  GL_KEEP
  GL_KTX_BACK_REGION
  GL_KTX_FRONT_REGION
  GL_KTX_STENCIL_REGION
  GL_KTX_Z_REGION
  GL_LARGE_CCW_ARC_TO_NV
  GL_LARGE_CW_ARC_TO_NV
  GL_LAST_VERTEX_CONVENTION
  GL_LAST_VERTEX_CONVENTION_EXT
  GL_LAST_VERTEX_CONVENTION_OES
  GL_LAST_VIDEO_CAPTURE_STATUS_NV
  GL_LAYERED_SGIX
  GL_LAYER_PROVOKING_VERTEX
  GL_LAYER_PROVOKING_VERTEX_EXT
  GL_LAYER_PROVOKING_VERTEX_OES
  GL_LAYOUT_COLOR_ATTACHMENT_EXT
  GL_LAYOUT_DEFAULT_INTEL
  GL_LAYOUT_DEPTH_ATTACHMENT_STENCIL_READ_ONLY_EXT
  GL_LAYOUT_DEPTH_READ_ONLY_STENCIL_ATTACHMENT_EXT
  GL_LAYOUT_DEPTH_STENCIL_ATTACHMENT_EXT
  GL_LAYOUT_DEPTH_STENCIL_READ_ONLY_EXT
  GL_LAYOUT_GENERAL_EXT
  GL_LAYOUT_LINEAR_CPU_CACHED_INTEL
  GL_LAYOUT_SHADER_READ_ONLY_EXT
  GL_LAYOUT_TRANSFER_DST_EXT
  GL_LAYOUT_TRANSFER_SRC_EXT
  GL_LEFT
  GL_LEQUAL
  GL_LERP_ATI
  GL_LESS
  GL_LGPU_SEPARATE_STORAGE_BIT_NVX
  GL_LIGHT0
  GL_LIGHT1
  GL_LIGHT2
  GL_LIGHT3
  GL_LIGHT31
  GL_LIGHT4
  GL_LIGHT5
  GL_LIGHT6
  GL_LIGHT7
  GL_LIGHTEN_KHR
  GL_LIGHTEN_NV
  GL_LIGHTING
  GL_LIGHTING_BIT
  GL_LIGHT_ENV_MODE_EXT
  GL_LIGHT_MODEL_AMBIENT
  GL_LIGHT_MODEL_COLOR_CONTROL
  GL_LIGHT_MODEL_COLOR_CONTROL_EXT
  GL_LIGHT_MODEL_LOCAL_VIEWER
  GL_LIGHT_MODEL_SPECULAR_VECTOR_APPLE
  GL_LIGHT_MODEL_TWO_SIDE
  GL_LINE
  GL_LINEAR
  GL_LINEARBURN_NV
  GL_LINEARDODGE_NV
  GL_LINEARLIGHT_NV
  GL_LINEAR_ATTENUATION
  GL_LINEAR_MIPMAP_LINEAR
  GL_LINEAR_MIPMAP_NEAREST
  GL_LINEAR_TILING_EXT
  GL_LINES
  GL_LINES_ADJACENCY
  GL_LINES_ADJACENCY_ARB
  GL_LINES_ADJACENCY_EXT
  GL_LINES_ADJACENCY_OES
  GL_LINE_BIT
  GL_LINE_LOOP
  GL_LINE_NV
  GL_LINE_QUALITY_HINT_SGIX
  GL_LINE_RESET_TOKEN
  GL_LINE_SMOOTH
  GL_LINE_SMOOTH_HINT
  GL_LINE_STIPPLE
  GL_LINE_STIPPLE_PATTERN
  GL_LINE_STIPPLE_REPEAT
  GL_LINE_STRIP
  GL_LINE_STRIP_ADJACENCY
  GL_LINE_STRIP_ADJACENCY_ARB
  GL_LINE_STRIP_ADJACENCY_EXT
  GL_LINE_STRIP_ADJACENCY_OES
  GL_LINE_TOKEN
  GL_LINE_TO_NV
  GL_LINE_WIDTH
  GL_LINE_WIDTH_COMMAND_NV
  GL_LINE_WIDTH_GRANULARITY
  GL_LINE_WIDTH_RANGE
  GL_LINK_STATUS
  GL_LIST_BASE
  GL_LIST_BIT
  GL_LIST_INDEX
  GL_LIST_MODE
  GL_LOAD
  GL_LOCAL_CONSTANT_DATATYPE_EXT
  GL_LOCAL_CONSTANT_EXT
  GL_LOCAL_CONSTANT_VALUE_EXT
  GL_LOCAL_EXT
  GL_LOCATION
  GL_LOCATION_COMPONENT
  GL_LOCATION_INDEX
  GL_LOCATION_INDEX_EXT
  GL_LOGIC_OP
  GL_LOGIC_OP_MODE
  GL_LOG_APP_REGAL
  GL_LOG_DEBUG_REGAL
  GL_LOG_DRIVER_REGAL
  GL_LOG_ERROR_REGAL
  GL_LOG_HTTP_REGAL
  GL_LOG_INFO_REGAL
  GL_LOG_INTERNAL_REGAL
  GL_LOG_REGAL
  GL_LOG_STATUS_REGAL
  GL_LOG_WARNING_REGAL
  GL_LOSE_CONTEXT_ON_RESET
  GL_LOSE_CONTEXT_ON_RESET_ARB
  GL_LOSE_CONTEXT_ON_RESET_EXT
  GL_LOWER_LEFT
  GL_LOWER_LEFT_EXT
  GL_LOW_FLOAT
  GL_LOW_INT
  GL_LO_BIAS_NV
  GL_LO_SCALE_NV
  GL_LUID_SIZE_EXT
  GL_LUMINANCE
  GL_LUMINANCE12
  GL_LUMINANCE12_ALPHA12
  GL_LUMINANCE12_ALPHA12_EXT
  GL_LUMINANCE12_ALPHA4
  GL_LUMINANCE12_ALPHA4_EXT
  GL_LUMINANCE12_EXT
  GL_LUMINANCE16
  GL_LUMINANCE16F_ARB
  GL_LUMINANCE16F_EXT
  GL_LUMINANCE16I_EXT
  GL_LUMINANCE16UI_EXT
  GL_LUMINANCE16_ALPHA16
  GL_LUMINANCE16_ALPHA16_EXT
  GL_LUMINANCE16_ALPHA16_EXTENDED_RANGE_SGIX
  GL_LUMINANCE16_ALPHA16_SIGNED_SGIX
  GL_LUMINANCE16_ALPHA16_SNORM
  GL_LUMINANCE16_ALPHA8_ICC_SGIX
  GL_LUMINANCE16_EXT
  GL_LUMINANCE16_EXTENDED_RANGE_SGIX
  GL_LUMINANCE16_ICC_SGIX
  GL_LUMINANCE16_SIGNED_SGIX
  GL_LUMINANCE16_SNORM
  GL_LUMINANCE32F_ARB
  GL_LUMINANCE32F_EXT
  GL_LUMINANCE32I_EXT
  GL_LUMINANCE32UI_EXT
  GL_LUMINANCE4
  GL_LUMINANCE4_ALPHA4
  GL_LUMINANCE4_ALPHA4_EXT
  GL_LUMINANCE4_ALPHA4_OES
  GL_LUMINANCE4_EXT
  GL_LUMINANCE6_ALPHA2
  GL_LUMINANCE6_ALPHA2_EXT
  GL_LUMINANCE8
  GL_LUMINANCE8I_EXT
  GL_LUMINANCE8UI_EXT
  GL_LUMINANCE8_ALPHA8
  GL_LUMINANCE8_ALPHA8_EXT
  GL_LUMINANCE8_ALPHA8_OES
  GL_LUMINANCE8_ALPHA8_SNORM
  GL_LUMINANCE8_EXT
  GL_LUMINANCE8_OES
  GL_LUMINANCE8_SNORM
  GL_LUMINANCE_ALPHA
  GL_LUMINANCE_ALPHA16F_ARB
  GL_LUMINANCE_ALPHA16F_EXT
  GL_LUMINANCE_ALPHA16I_EXT
  GL_LUMINANCE_ALPHA16UI_EXT
  GL_LUMINANCE_ALPHA32F_ARB
  GL_LUMINANCE_ALPHA32F_EXT
  GL_LUMINANCE_ALPHA32I_EXT
  GL_LUMINANCE_ALPHA32UI_EXT
  GL_LUMINANCE_ALPHA8I_EXT
  GL_LUMINANCE_ALPHA8UI_EXT
  GL_LUMINANCE_ALPHA_EXTENDED_RANGE_SGIX
  GL_LUMINANCE_ALPHA_FLOAT16_APPLE
  GL_LUMINANCE_ALPHA_FLOAT16_ATI
  GL_LUMINANCE_ALPHA_FLOAT32_APPLE
  GL_LUMINANCE_ALPHA_FLOAT32_ATI
  GL_LUMINANCE_ALPHA_ICC_SGIX
  GL_LUMINANCE_ALPHA_INTEGER_EXT
  GL_LUMINANCE_ALPHA_SIGNED_SGIX
  GL_LUMINANCE_ALPHA_SNORM
  GL_LUMINANCE_EXTENDED_RANGE_SGIX
  GL_LUMINANCE_FLOAT16_APPLE
  GL_LUMINANCE_FLOAT16_ATI
  GL_LUMINANCE_FLOAT32_APPLE
  GL_LUMINANCE_FLOAT32_ATI
  GL_LUMINANCE_ICC_SGIX
  GL_LUMINANCE_INTEGER_EXT
  GL_LUMINANCE_SIGNED_SGIX
  GL_LUMINANCE_SNORM
  GL_MAD_ATI
  GL_MAGNITUDE_BIAS_NV
  GL_MAGNITUDE_SCALE_NV
  GL_MAJOR_VERSION
  GL_MALI_PROGRAM_BINARY_ARM
  GL_MALI_SHADER_BINARY_ARM
  GL_MANUAL_GENERATE_MIPMAP
  GL_MAP1_BINORMAL_EXT
  GL_MAP1_COLOR_4
  GL_MAP1_COLOR_4_NURBS_SGIX
  GL_MAP1_GRID_DOMAIN
  GL_MAP1_GRID_SEGMENTS
  GL_MAP1_INDEX
  GL_MAP1_INDEX_NURBS_SGIX
  GL_MAP1_NORMAL
  GL_MAP1_NORMAL_NURBS_SGIX
  GL_MAP1_TANGENT_EXT
  GL_MAP1_TEXTURE_COORD_1
  GL_MAP1_TEXTURE_COORD_1_NURBS_SGIX
  GL_MAP1_TEXTURE_COORD_2
  GL_MAP1_TEXTURE_COORD_2_NURBS_SGIX
  GL_MAP1_TEXTURE_COORD_3
  GL_MAP1_TEXTURE_COORD_3_NURBS_SGIX
  GL_MAP1_TEXTURE_COORD_4
  GL_MAP1_TEXTURE_COORD_4_NURBS_SGIX
  GL_MAP1_VERTEX_3
  GL_MAP1_VERTEX_3_NURBS_SGIX
  GL_MAP1_VERTEX_4
  GL_MAP1_VERTEX_4_NURBS_SGIX
  GL_MAP1_VERTEX_ATTRIB0_4_NV
  GL_MAP1_VERTEX_ATTRIB10_4_NV
  GL_MAP1_VERTEX_ATTRIB11_4_NV
  GL_MAP1_VERTEX_ATTRIB12_4_NV
  GL_MAP1_VERTEX_ATTRIB13_4_NV
  GL_MAP1_VERTEX_ATTRIB14_4_NV
  GL_MAP1_VERTEX_ATTRIB15_4_NV
  GL_MAP1_VERTEX_ATTRIB1_4_NV
  GL_MAP1_VERTEX_ATTRIB2_4_NV
  GL_MAP1_VERTEX_ATTRIB3_4_NV
  GL_MAP1_VERTEX_ATTRIB4_4_NV
  GL_MAP1_VERTEX_ATTRIB5_4_NV
  GL_MAP1_VERTEX_ATTRIB6_4_NV
  GL_MAP1_VERTEX_ATTRIB7_4_NV
  GL_MAP1_VERTEX_ATTRIB8_4_NV
  GL_MAP1_VERTEX_ATTRIB9_4_NV
  GL_MAP2_BINORMAL_EXT
  GL_MAP2_COLOR_4
  GL_MAP2_COLOR_4_NURBS_SGIX
  GL_MAP2_GRID_DOMAIN
  GL_MAP2_GRID_SEGMENTS
  GL_MAP2_INDEX
  GL_MAP2_INDEX_NURBS_SGIX
  GL_MAP2_NORMAL
  GL_MAP2_NORMAL_NURBS_SGIX
  GL_MAP2_TANGENT_EXT
  GL_MAP2_TEXTURE_COORD_1
  GL_MAP2_TEXTURE_COORD_1_NURBS_SGIX
  GL_MAP2_TEXTURE_COORD_2
  GL_MAP2_TEXTURE_COORD_2_NURBS_SGIX
  GL_MAP2_TEXTURE_COORD_3
  GL_MAP2_TEXTURE_COORD_3_NURBS_SGIX
  GL_MAP2_TEXTURE_COORD_4
  GL_MAP2_TEXTURE_COORD_4_NURBS_SGIX
  GL_MAP2_VERTEX_3
  GL_MAP2_VERTEX_3_NURBS_SGIX
  GL_MAP2_VERTEX_4
  GL_MAP2_VERTEX_4_NURBS_SGIX
  GL_MAP2_VERTEX_ATTRIB0_4_NV
  GL_MAP2_VERTEX_ATTRIB10_4_NV
  GL_MAP2_VERTEX_ATTRIB11_4_NV
  GL_MAP2_VERTEX_ATTRIB12_4_NV
  GL_MAP2_VERTEX_ATTRIB13_4_NV
  GL_MAP2_VERTEX_ATTRIB14_4_NV
  GL_MAP2_VERTEX_ATTRIB15_4_NV
  GL_MAP2_VERTEX_ATTRIB1_4_NV
  GL_MAP2_VERTEX_ATTRIB2_4_NV
  GL_MAP2_VERTEX_ATTRIB3_4_NV
  GL_MAP2_VERTEX_ATTRIB4_4_NV
  GL_MAP2_VERTEX_ATTRIB5_4_NV
  GL_MAP2_VERTEX_ATTRIB6_4_NV
  GL_MAP2_VERTEX_ATTRIB7_4_NV
  GL_MAP2_VERTEX_ATTRIB8_4_NV
  GL_MAP2_VERTEX_ATTRIB9_4_NV
  GL_MAP_ATTRIB_U_ORDER_NV
  GL_MAP_ATTRIB_V_ORDER_NV
  GL_MAP_COHERENT_BIT
  GL_MAP_COHERENT_BIT_EXT
  GL_MAP_COLOR
  GL_MAP_FLUSH_EXPLICIT_BIT
  GL_MAP_FLUSH_EXPLICIT_BIT_EXT
  GL_MAP_INVALIDATE_BUFFER_BIT
  GL_MAP_INVALIDATE_BUFFER_BIT_EXT
  GL_MAP_INVALIDATE_RANGE_BIT
  GL_MAP_INVALIDATE_RANGE_BIT_EXT
  GL_MAP_PERSISTENT_BIT
  GL_MAP_PERSISTENT_BIT_EXT
  GL_MAP_READ_BIT
  GL_MAP_READ_BIT_EXT
  GL_MAP_STENCIL
  GL_MAP_TESSELLATION_NV
  GL_MAP_UNSYNCHRONIZED_BIT
  GL_MAP_UNSYNCHRONIZED_BIT_EXT
  GL_MAP_WRITE_BIT
  GL_MAP_WRITE_BIT_EXT
  GL_MATERIAL_SIDE_HINT_PGI
  GL_MATRIX0_ARB
  GL_MATRIX0_NV
  GL_MATRIX10_ARB
  GL_MATRIX11_ARB
  GL_MATRIX12_ARB
  GL_MATRIX13_ARB
  GL_MATRIX14_ARB
  GL_MATRIX15_ARB
  GL_MATRIX16_ARB
  GL_MATRIX17_ARB
  GL_MATRIX18_ARB
  GL_MATRIX19_ARB
  GL_MATRIX1_ARB
  GL_MATRIX1_NV
  GL_MATRIX20_ARB
  GL_MATRIX21_ARB
  GL_MATRIX22_ARB
  GL_MATRIX23_ARB
  GL_MATRIX24_ARB
  GL_MATRIX25_ARB
  GL_MATRIX26_ARB
  GL_MATRIX27_ARB
  GL_MATRIX28_ARB
  GL_MATRIX29_ARB
  GL_MATRIX2_ARB
  GL_MATRIX2_NV
  GL_MATRIX30_ARB
  GL_MATRIX31_ARB
  GL_MATRIX3_ARB
  GL_MATRIX3_NV
  GL_MATRIX4_ARB
  GL_MATRIX4_NV
  GL_MATRIX5_ARB
  GL_MATRIX5_NV
  GL_MATRIX6_ARB
  GL_MATRIX6_NV
  GL_MATRIX7_ARB
  GL_MATRIX7_NV
  GL_MATRIX8_ARB
  GL_MATRIX9_ARB
  GL_MATRIX_EXT
  GL_MATRIX_INDEX_ARRAY_ARB
  GL_MATRIX_INDEX_ARRAY_BUFFER_BINDING_OES
  GL_MATRIX_INDEX_ARRAY_OES
  GL_MATRIX_INDEX_ARRAY_POINTER_ARB
  GL_MATRIX_INDEX_ARRAY_POINTER_OES
  GL_MATRIX_INDEX_ARRAY_SIZE_ARB
  GL_MATRIX_INDEX_ARRAY_SIZE_OES
  GL_MATRIX_INDEX_ARRAY_STRIDE_ARB
  GL_MATRIX_INDEX_ARRAY_STRIDE_OES
  GL_MATRIX_INDEX_ARRAY_TYPE_ARB
  GL_MATRIX_INDEX_ARRAY_TYPE_OES
  GL_MATRIX_MODE
  GL_MATRIX_PALETTE_ARB
  GL_MATRIX_PALETTE_OES
  GL_MATRIX_STRIDE
  GL_MAT_AMBIENT_AND_DIFFUSE_BIT_PGI
  GL_MAT_AMBIENT_BIT_PGI
  GL_MAT_COLOR_INDEXES_BIT_PGI
  GL_MAT_DIFFUSE_BIT_PGI
  GL_MAT_EMISSION_BIT_PGI
  GL_MAT_SHININESS_BIT_PGI
  GL_MAT_SPECULAR_BIT_PGI
  GL_MAX
  GL_MAX_3D_TEXTURE_SIZE
  GL_MAX_3D_TEXTURE_SIZE_EXT
  GL_MAX_3D_TEXTURE_SIZE_OES
  GL_MAX_ACTIVE_LIGHTS_EXT
  GL_MAX_ALPHA_SGIS
  GL_MAX_ARRAY_TEXTURE_LAYERS
  GL_MAX_ARRAY_TEXTURE_LAYERS_EXT
  GL_MAX_ARRAY_TEXTURE_LAYERS_NV
  GL_MAX_ASYNC_DRAW_PIXELS_SGIX
  GL_MAX_ASYNC_HISTOGRAM_SGIX
  GL_MAX_ASYNC_READ_PIXELS_SGIX
  GL_MAX_ASYNC_TEX_IMAGE_SGIX
  GL_MAX_ATOMIC_COUNTER_BUFFER_BINDINGS
  GL_MAX_ATOMIC_COUNTER_BUFFER_SIZE
  GL_MAX_ATTRIB_STACK_DEPTH
  GL_MAX_BINDABLE_UNIFORM_SIZE_EXT
  GL_MAX_BLUE_SGIS
  GL_MAX_CLIENT_ATTRIB_STACK_DEPTH
  GL_MAX_CLIP_DISTANCES
  GL_MAX_CLIP_DISTANCES_APPLE
  GL_MAX_CLIP_DISTANCES_EXT
  GL_MAX_CLIP_PLANES
  GL_MAX_COARSE_FRAGMENT_SAMPLES_NV
  GL_MAX_COLOR_ATTACHMENTS
  GL_MAX_COLOR_ATTACHMENTS_EXT
  GL_MAX_COLOR_ATTACHMENTS_NV
  GL_MAX_COLOR_FRAMEBUFFER_SAMPLES_AMD
  GL_MAX_COLOR_FRAMEBUFFER_STORAGE_SAMPLES_AMD
  GL_MAX_COLOR_MATRIX_STACK_DEPTH
  GL_MAX_COLOR_MATRIX_STACK_DEPTH_SGI
  GL_MAX_COLOR_TEXTURE_SAMPLES
  GL_MAX_COMBINED_ATOMIC_COUNTERS
  GL_MAX_COMBINED_ATOMIC_COUNTER_BUFFERS
  GL_MAX_COMBINED_CLIP_AND_CULL_DISTANCES
  GL_MAX_COMBINED_CLIP_AND_CULL_DISTANCES_EXT
  GL_MAX_COMBINED_COMPUTE_UNIFORM_COMPONENTS
  GL_MAX_COMBINED_DIMENSIONS
  GL_MAX_COMBINED_FRAGMENT_UNIFORM_COMPONENTS
  GL_MAX_COMBINED_GEOMETRY_UNIFORM_COMPONENTS
  GL_MAX_COMBINED_GEOMETRY_UNIFORM_COMPONENTS_EXT
  GL_MAX_COMBINED_GEOMETRY_UNIFORM_COMPONENTS_OES
  GL_MAX_COMBINED_IMAGE_UNIFORMS
  GL_MAX_COMBINED_IMAGE_UNITS_AND_FRAGMENT_OUTPUTS
  GL_MAX_COMBINED_IMAGE_UNITS_AND_FRAGMENT_OUTPUTS_EXT
  GL_MAX_COMBINED_MESH_UNIFORM_COMPONENTS_EXT
  GL_MAX_COMBINED_MESH_UNIFORM_COMPONENTS_NV
  GL_MAX_COMBINED_SHADER_OUTPUT_RESOURCES
  GL_MAX_COMBINED_SHADER_STORAGE_BLOCKS
  GL_MAX_COMBINED_TASK_UNIFORM_COMPONENTS_EXT
  GL_MAX_COMBINED_TASK_UNIFORM_COMPONENTS_NV
  GL_MAX_COMBINED_TESS_CONTROL_UNIFORM_COMPONENTS
  GL_MAX_COMBINED_TESS_CONTROL_UNIFORM_COMPONENTS_EXT
  GL_MAX_COMBINED_TESS_CONTROL_UNIFORM_COMPONENTS_OES
  GL_MAX_COMBINED_TESS_EVALUATION_UNIFORM_COMPONENTS
  GL_MAX_COMBINED_TESS_EVALUATION_UNIFORM_COMPONENTS_EXT
  GL_MAX_COMBINED_TESS_EVALUATION_UNIFORM_COMPONENTS_OES
  GL_MAX_COMBINED_TEXTURE_IMAGE_UNITS
  GL_MAX_COMBINED_TEXTURE_IMAGE_UNITS_ARB
  GL_MAX_COMBINED_UNIFORM_BLOCKS
  GL_MAX_COMBINED_VERTEX_UNIFORM_COMPONENTS
  GL_MAX_COMPUTE_ATOMIC_COUNTERS
  GL_MAX_COMPUTE_ATOMIC_COUNTER_BUFFERS
  GL_MAX_COMPUTE_FIXED_GROUP_INVOCATIONS_ARB
  GL_MAX_COMPUTE_FIXED_GROUP_SIZE_ARB
  GL_MAX_COMPUTE_IMAGE_UNIFORMS
  GL_MAX_COMPUTE_SHADER_STORAGE_BLOCKS
  GL_MAX_COMPUTE_SHARED_MEMORY_SIZE
  GL_MAX_COMPUTE_TEXTURE_IMAGE_UNITS
  GL_MAX_COMPUTE_UNIFORM_BLOCKS
  GL_MAX_COMPUTE_UNIFORM_COMPONENTS
  GL_MAX_COMPUTE_VARIABLE_GROUP_INVOCATIONS_ARB
  GL_MAX_COMPUTE_VARIABLE_GROUP_SIZE_ARB
  GL_MAX_COMPUTE_WORK_GROUP_COUNT
  GL_MAX_COMPUTE_WORK_GROUP_INVOCATIONS
  GL_MAX_COMPUTE_WORK_GROUP_SIZE
  GL_MAX_CONVOLUTION_HEIGHT
  GL_MAX_CONVOLUTION_HEIGHT_EXT
  GL_MAX_CONVOLUTION_WIDTH
  GL_MAX_CONVOLUTION_WIDTH_EXT
  GL_MAX_CUBE_MAP_TEXTURE_SIZE
  GL_MAX_CUBE_MAP_TEXTURE_SIZE_ARB
  GL_MAX_CUBE_MAP_TEXTURE_SIZE_EXT
  GL_MAX_CUBE_MAP_TEXTURE_SIZE_OES
  GL_MAX_CULL_DISTANCES
  GL_MAX_CULL_DISTANCES_EXT
  GL_MAX_DEBUG_GROUP_STACK_DEPTH
  GL_MAX_DEBUG_LOGGED_MESSAGES
  GL_MAX_DEBUG_LOGGED_MESSAGES_AMD
  GL_MAX_DEBUG_LOGGED_MESSAGES_ARB
  GL_MAX_DEBUG_MESSAGE_LENGTH
  GL_MAX_DEBUG_MESSAGE_LENGTH_AMD
  GL_MAX_DEBUG_MESSAGE_LENGTH_ARB
  GL_MAX_DEEP_3D_TEXTURE_DEPTH_NV
  GL_MAX_DEEP_3D_TEXTURE_WIDTH_HEIGHT_NV
  GL_MAX_DEPTH
  GL_MAX_DEPTH_STENCIL_FRAMEBUFFER_SAMPLES_AMD
  GL_MAX_DEPTH_TEXTURE_SAMPLES
  GL_MAX_DETACHED_BUFFERS_NV
  GL_MAX_DETACHED_TEXTURES_NV
  GL_MAX_DRAW_BUFFERS
  GL_MAX_DRAW_BUFFERS_ARB
  GL_MAX_DRAW_BUFFERS_ATI
  GL_MAX_DRAW_BUFFERS_EXT
  GL_MAX_DRAW_BUFFERS_NV
  GL_MAX_DRAW_MESH_TASKS_COUNT_NV
  GL_MAX_DUAL_SOURCE_DRAW_BUFFERS
  GL_MAX_DUAL_SOURCE_DRAW_BUFFERS_EXT
  GL_MAX_ELEMENTS_INDICES
  GL_MAX_ELEMENTS_INDICES_EXT
  GL_MAX_ELEMENTS_VERTICES
  GL_MAX_ELEMENTS_VERTICES_EXT
  GL_MAX_ELEMENT_INDEX
  GL_MAX_EVAL_ORDER
  GL_MAX_EXT
  GL_MAX_FFT_WIDTH_SGI
  GL_MAX_FOG_LAYERS_POINTS_SGIX
  GL_MAX_FRAGMENT_ATOMIC_COUNTERS
  GL_MAX_FRAGMENT_ATOMIC_COUNTER_BUFFERS
  GL_MAX_FRAGMENT_BINDABLE_UNIFORMS_EXT
  GL_MAX_FRAGMENT_IMAGE_UNIFORMS
  GL_MAX_FRAGMENT_INPUT_COMPONENTS
  GL_MAX_FRAGMENT_INTERPOLATION_OFFSET
  GL_MAX_FRAGMENT_INTERPOLATION_OFFSET_NV
  GL_MAX_FRAGMENT_INTERPOLATION_OFFSET_OES
  GL_MAX_FRAGMENT_LIGHTS_EXT
  GL_MAX_FRAGMENT_PROGRAM_LOCAL_PARAMETERS_NV
  GL_MAX_FRAGMENT_SHADER_STORAGE_BLOCKS
  GL_MAX_FRAGMENT_SHADING_RATE_ATTACHMENT_LAYERS_EXT
  GL_MAX_FRAGMENT_SHADING_RATE_ATTACHMENT_TEXEL_ASPECT_RATIO_EXT
  GL_MAX_FRAGMENT_SHADING_RATE_ATTACHMENT_TEXEL_HEIGHT_EXT
  GL_MAX_FRAGMENT_SHADING_RATE_ATTACHMENT_TEXEL_WIDTH_EXT
  GL_MAX_FRAGMENT_UNIFORM_BLOCKS
  GL_MAX_FRAGMENT_UNIFORM_COMPONENTS
  GL_MAX_FRAGMENT_UNIFORM_COMPONENTS_ARB
  GL_MAX_FRAGMENT_UNIFORM_VECTORS
  GL_MAX_FRAMEBUFFER_HEIGHT
  GL_MAX_FRAMEBUFFER_LAYERS
  GL_MAX_FRAMEBUFFER_LAYERS_EXT
  GL_MAX_FRAMEBUFFER_LAYERS_OES
  GL_MAX_FRAMEBUFFER_SAMPLES
  GL_MAX_FRAMEBUFFER_WIDTH
  GL_MAX_GENERAL_COMBINERS_NV
  GL_MAX_GEOMETRY_ATOMIC_COUNTERS
  GL_MAX_GEOMETRY_ATOMIC_COUNTERS_EXT
  GL_MAX_GEOMETRY_ATOMIC_COUNTERS_OES
  GL_MAX_GEOMETRY_ATOMIC_COUNTER_BUFFERS
  GL_MAX_GEOMETRY_ATOMIC_COUNTER_BUFFERS_EXT
  GL_MAX_GEOMETRY_ATOMIC_COUNTER_BUFFERS_OES
  GL_MAX_GEOMETRY_BINDABLE_UNIFORMS_EXT
  GL_MAX_GEOMETRY_IMAGE_UNIFORMS
  GL_MAX_GEOMETRY_IMAGE_UNIFORMS_EXT
  GL_MAX_GEOMETRY_IMAGE_UNIFORMS_OES
  GL_MAX_GEOMETRY_INPUT_COMPONENTS
  GL_MAX_GEOMETRY_INPUT_COMPONENTS_EXT
  GL_MAX_GEOMETRY_INPUT_COMPONENTS_OES
  GL_MAX_GEOMETRY_OUTPUT_COMPONENTS
  GL_MAX_GEOMETRY_OUTPUT_COMPONENTS_EXT
  GL_MAX_GEOMETRY_OUTPUT_COMPONENTS_OES
  GL_MAX_GEOMETRY_OUTPUT_VERTICES
  GL_MAX_GEOMETRY_OUTPUT_VERTICES_ARB
  GL_MAX_GEOMETRY_OUTPUT_VERTICES_EXT
  GL_MAX_GEOMETRY_OUTPUT_VERTICES_OES
  GL_MAX_GEOMETRY_PROGRAM_INVOCATIONS_NV
  GL_MAX_GEOMETRY_SHADER_INVOCATIONS
  GL_MAX_GEOMETRY_SHADER_INVOCATIONS_EXT
  GL_MAX_GEOMETRY_SHADER_INVOCATIONS_OES
  GL_MAX_GEOMETRY_SHADER_STORAGE_BLOCKS
  GL_MAX_GEOMETRY_SHADER_STORAGE_BLOCKS_EXT
  GL_MAX_GEOMETRY_SHADER_STORAGE_BLOCKS_OES
  GL_MAX_GEOMETRY_TEXTURE_IMAGE_UNITS
  GL_MAX_GEOMETRY_TEXTURE_IMAGE_UNITS_ARB
  GL_MAX_GEOMETRY_TEXTURE_IMAGE_UNITS_EXT
  GL_MAX_GEOMETRY_TEXTURE_IMAGE_UNITS_OES
  GL_MAX_GEOMETRY_TOTAL_OUTPUT_COMPONENTS
  GL_MAX_GEOMETRY_TOTAL_OUTPUT_COMPONENTS_ARB
  GL_MAX_GEOMETRY_TOTAL_OUTPUT_COMPONENTS_EXT
  GL_MAX_GEOMETRY_TOTAL_OUTPUT_COMPONENTS_OES
  GL_MAX_GEOMETRY_UNIFORM_BLOCKS
  GL_MAX_GEOMETRY_UNIFORM_BLOCKS_EXT
  GL_MAX_GEOMETRY_UNIFORM_BLOCKS_OES
  GL_MAX_GEOMETRY_UNIFORM_COMPONENTS
  GL_MAX_GEOMETRY_UNIFORM_COMPONENTS_ARB
  GL_MAX_GEOMETRY_UNIFORM_COMPONENTS_EXT
  GL_MAX_GEOMETRY_UNIFORM_COMPONENTS_OES
  GL_MAX_GEOMETRY_VARYING_COMPONENTS_ARB
  GL_MAX_GEOMETRY_VARYING_COMPONENTS_EXT
  GL_MAX_GREEN_SGIS
  GL_MAX_HEIGHT
  GL_MAX_IMAGE_SAMPLES
  GL_MAX_IMAGE_SAMPLES_EXT
  GL_MAX_IMAGE_UNITS
  GL_MAX_IMAGE_UNITS_EXT
  GL_MAX_INTEGER_SAMPLES
  GL_MAX_INTENSITY_SGIS
  GL_MAX_LABEL_LENGTH
  GL_MAX_LAYERS
  GL_MAX_LGPU_GPUS_NVX
  GL_MAX_LIGHTS
  GL_MAX_LIST_NESTING
  GL_MAX_LUMINANCE_SGIS
  GL_MAX_MAP_TESSELLATION_NV
  GL_MAX_MATRIX_PALETTE_STACK_DEPTH_ARB
  GL_MAX_MESH_ATOMIC_COUNTERS_EXT
  GL_MAX_MESH_ATOMIC_COUNTERS_NV
  GL_MAX_MESH_ATOMIC_COUNTER_BUFFERS_EXT
  GL_MAX_MESH_ATOMIC_COUNTER_BUFFERS_NV
  GL_MAX_MESH_IMAGE_UNIFORMS_EXT
  GL_MAX_MESH_IMAGE_UNIFORMS_NV
  GL_MAX_MESH_MULTIVIEW_VIEW_COUNT_EXT
  GL_MAX_MESH_OUTPUT_COMPONENTS_EXT
  GL_MAX_MESH_OUTPUT_LAYERS_EXT
  GL_MAX_MESH_OUTPUT_MEMORY_SIZE_EXT
  GL_MAX_MESH_OUTPUT_PRIMITIVES_EXT
  GL_MAX_MESH_OUTPUT_PRIMITIVES_NV
  GL_MAX_MESH_OUTPUT_VERTICES_EXT
  GL_MAX_MESH_OUTPUT_VERTICES_NV
  GL_MAX_MESH_PAYLOAD_AND_OUTPUT_MEMORY_SIZE_EXT
  GL_MAX_MESH_PAYLOAD_AND_SHARED_MEMORY_SIZE_EXT
  GL_MAX_MESH_SHADER_STORAGE_BLOCKS_EXT
  GL_MAX_MESH_SHADER_STORAGE_BLOCKS_NV
  GL_MAX_MESH_SHARED_MEMORY_SIZE_EXT
  GL_MAX_MESH_TEXTURE_IMAGE_UNITS_EXT
  GL_MAX_MESH_TEXTURE_IMAGE_UNITS_NV
  GL_MAX_MESH_TOTAL_MEMORY_SIZE_NV
  GL_MAX_MESH_UNIFORM_BLOCKS_EXT
  GL_MAX_MESH_UNIFORM_BLOCKS_NV
  GL_MAX_MESH_UNIFORM_COMPONENTS_EXT
  GL_MAX_MESH_UNIFORM_COMPONENTS_NV
  GL_MAX_MESH_VIEWS_NV
  GL_MAX_MESH_WORK_GROUP_COUNT_EXT
  GL_MAX_MESH_WORK_GROUP_INVOCATIONS_EXT
  GL_MAX_MESH_WORK_GROUP_INVOCATIONS_NV
  GL_MAX_MESH_WORK_GROUP_SIZE_EXT
  GL_MAX_MESH_WORK_GROUP_SIZE_NV
  GL_MAX_MESH_WORK_GROUP_TOTAL_COUNT_EXT
  GL_MAX_MIPMAP_ANISOTROPY_SGIX
  GL_MAX_MODELVIEW_STACK_DEPTH
  GL_MAX_MULTISAMPLE_COVERAGE_MODES_NV
  GL_MAX_MULTIVIEW_BUFFERS_EXT
  GL_MAX_NAME_LENGTH
  GL_MAX_NAME_STACK_DEPTH
  GL_MAX_NUM_ACTIVE_VARIABLES
  GL_MAX_NUM_COMPATIBLE_SUBROUTINES
  GL_MAX_OPTIMIZED_VERTEX_SHADER_INSTRUCTIONS_EXT
  GL_MAX_OPTIMIZED_VERTEX_SHADER_INVARIANTS_EXT
  GL_MAX_OPTIMIZED_VERTEX_SHADER_LOCALS_EXT
  GL_MAX_OPTIMIZED_VERTEX_SHADER_LOCAL_CONSTANTS_EXT
  GL_MAX_OPTIMIZED_VERTEX_SHADER_VARIANTS_EXT
  GL_MAX_PALETTE_MATRICES_ARB
  GL_MAX_PALETTE_MATRICES_OES
  GL_MAX_PATCH_VERTICES
  GL_MAX_PATCH_VERTICES_EXT
  GL_MAX_PATCH_VERTICES_OES
  GL_MAX_PIXEL_MAP_TABLE
  GL_MAX_PIXEL_TRANSFORM_2D_STACK_DEPTH_EXT
  GL_MAX_PN_TRIANGLES_TESSELATION_LEVEL_ATI
  GL_MAX_PREFERRED_MESH_WORK_GROUP_INVOCATIONS_EXT
  GL_MAX_PREFERRED_TASK_WORK_GROUP_INVOCATIONS_EXT
  GL_MAX_PROGRAM_ADDRESS_REGISTERS_ARB
  GL_MAX_PROGRAM_ALU_INSTRUCTIONS_ARB
  GL_MAX_PROGRAM_ATTRIBS_ARB
  GL_MAX_PROGRAM_ATTRIB_COMPONENTS_NV
  GL_MAX_PROGRAM_CALL_DEPTH_NV
  GL_MAX_PROGRAM_ENV_PARAMETERS_ARB
  GL_MAX_PROGRAM_EXEC_INSTRUCTIONS_NV
  GL_MAX_PROGRAM_GENERIC_ATTRIBS_NV
  GL_MAX_PROGRAM_GENERIC_RESULTS_NV
  GL_MAX_PROGRAM_IF_DEPTH_NV
  GL_MAX_PROGRAM_INSTRUCTIONS_ARB
  GL_MAX_PROGRAM_LOCAL_PARAMETERS_ARB
  GL_MAX_PROGRAM_LOOP_COUNT_NV
  GL_MAX_PROGRAM_LOOP_DEPTH_NV
  GL_MAX_PROGRAM_MATRICES_ARB
  GL_MAX_PROGRAM_MATRIX_STACK_DEPTH_ARB
  GL_MAX_PROGRAM_NATIVE_ADDRESS_REGISTERS_ARB
  GL_MAX_PROGRAM_NATIVE_ALU_INSTRUCTIONS_ARB
  GL_MAX_PROGRAM_NATIVE_ATTRIBS_ARB
  GL_MAX_PROGRAM_NATIVE_INSTRUCTIONS_ARB
  GL_MAX_PROGRAM_NATIVE_PARAMETERS_ARB
  GL_MAX_PROGRAM_NATIVE_TEMPORARIES_ARB
  GL_MAX_PROGRAM_NATIVE_TEX_INDIRECTIONS_ARB
  GL_MAX_PROGRAM_NATIVE_TEX_INSTRUCTIONS_ARB
  GL_MAX_PROGRAM_OUTPUT_VERTICES_NV
  GL_MAX_PROGRAM_PARAMETERS_ARB
  GL_MAX_PROGRAM_PARAMETER_BUFFER_BINDINGS_NV
  GL_MAX_PROGRAM_PARAMETER_BUFFER_SIZE_NV
  GL_MAX_PROGRAM_PATCH_ATTRIBS_NV
  GL_MAX_PROGRAM_RESULT_COMPONENTS_NV
  GL_MAX_PROGRAM_TEMPORARIES_ARB
  GL_MAX_PROGRAM_TEXEL_OFFSET
  GL_MAX_PROGRAM_TEXEL_OFFSET_NV
  GL_MAX_PROGRAM_TEXTURE_GATHER_COMPONENTS
  GL_MAX_PROGRAM_TEXTURE_GATHER_COMPONENTS_ARB
  GL_MAX_PROGRAM_TEXTURE_GATHER_OFFSET
  GL_MAX_PROGRAM_TEXTURE_GATHER_OFFSET_ARB
  GL_MAX_PROGRAM_TEXTURE_GATHER_OFFSET_NV
  GL_MAX_PROGRAM_TEX_INDIRECTIONS_ARB
  GL_MAX_PROGRAM_TEX_INSTRUCTIONS_ARB
  GL_MAX_PROGRAM_TOTAL_OUTPUT_COMPONENTS_NV
  GL_MAX_PROJECTION_STACK_DEPTH
  GL_MAX_RASTER_SAMPLES_EXT
  GL_MAX_RATIONAL_EVAL_ORDER_NV
  GL_MAX_RECTANGLE_TEXTURE_SIZE
  GL_MAX_RECTANGLE_TEXTURE_SIZE_ARB
  GL_MAX_RECTANGLE_TEXTURE_SIZE_EXT
  GL_MAX_RECTANGLE_TEXTURE_SIZE_NV
  GL_MAX_RED_SGIS
  GL_MAX_RENDERBUFFER_SIZE
  GL_MAX_RENDERBUFFER_SIZE_EXT
  GL_MAX_RENDERBUFFER_SIZE_OES
  GL_MAX_SAMPLES
  GL_MAX_SAMPLES_ANGLE
  GL_MAX_SAMPLES_APPLE
  GL_MAX_SAMPLES_EXT
  GL_MAX_SAMPLES_IMG
  GL_MAX_SAMPLES_NV
  GL_MAX_SAMPLE_MASK_WORDS
  GL_MAX_SAMPLE_MASK_WORDS_NV
  GL_MAX_SERVER_WAIT_TIMEOUT
  GL_MAX_SERVER_WAIT_TIMEOUT_APPLE
  GL_MAX_SHADER_BUFFER_ADDRESS_NV
  GL_MAX_SHADER_COMBINED_LOCAL_STORAGE_FAST_SIZE_EXT
  GL_MAX_SHADER_COMBINED_LOCAL_STORAGE_SIZE_EXT
  GL_MAX_SHADER_COMPILER_THREADS_ARB
  GL_MAX_SHADER_COMPILER_THREADS_KHR
  GL_MAX_SHADER_PIXEL_LOCAL_STORAGE_FAST_SIZE_EXT
  GL_MAX_SHADER_PIXEL_LOCAL_STORAGE_SIZE_EXT
  GL_MAX_SHADER_STORAGE_BLOCK_SIZE
  GL_MAX_SHADER_STORAGE_BUFFER_BINDINGS
  GL_MAX_SHADER_SUBSAMPLED_IMAGE_UNITS_QCOM
  GL_MAX_SHININESS_NV
  GL_MAX_SPARSE_3D_TEXTURE_SIZE_AMD
  GL_MAX_SPARSE_3D_TEXTURE_SIZE_ARB
  GL_MAX_SPARSE_3D_TEXTURE_SIZE_EXT
  GL_MAX_SPARSE_ARRAY_TEXTURE_LAYERS
  GL_MAX_SPARSE_ARRAY_TEXTURE_LAYERS_ARB
  GL_MAX_SPARSE_ARRAY_TEXTURE_LAYERS_EXT
  GL_MAX_SPARSE_TEXTURE_SIZE_AMD
  GL_MAX_SPARSE_TEXTURE_SIZE_ARB
  GL_MAX_SPARSE_TEXTURE_SIZE_EXT
  GL_MAX_SPOT_EXPONENT_NV
  GL_MAX_SUBPIXEL_PRECISION_BIAS_BITS_NV
  GL_MAX_SUBROUTINES
  GL_MAX_SUBROUTINE_UNIFORM_LOCATIONS
  GL_MAX_TASK_ATOMIC_COUNTERS_EXT
  GL_MAX_TASK_ATOMIC_COUNTERS_NV
  GL_MAX_TASK_ATOMIC_COUNTER_BUFFERS_EXT
  GL_MAX_TASK_ATOMIC_COUNTER_BUFFERS_NV
  GL_MAX_TASK_IMAGE_UNIFORMS_EXT
  GL_MAX_TASK_IMAGE_UNIFORMS_NV
  GL_MAX_TASK_OUTPUT_COUNT_NV
  GL_MAX_TASK_PAYLOAD_AND_SHARED_MEMORY_SIZE_EXT
  GL_MAX_TASK_PAYLOAD_SIZE_EXT
  GL_MAX_TASK_SHADER_STORAGE_BLOCKS_EXT
  GL_MAX_TASK_SHADER_STORAGE_BLOCKS_NV
  GL_MAX_TASK_SHARED_MEMORY_SIZE_EXT
  GL_MAX_TASK_TEXTURE_IMAGE_UNITS_EXT
  GL_MAX_TASK_TEXTURE_IMAGE_UNITS_NV
  GL_MAX_TASK_TOTAL_MEMORY_SIZE_NV
  GL_MAX_TASK_UNIFORM_BLOCKS_EXT
  GL_MAX_TASK_UNIFORM_BLOCKS_NV
  GL_MAX_TASK_UNIFORM_COMPONENTS_EXT
  GL_MAX_TASK_UNIFORM_COMPONENTS_NV
  GL_MAX_TASK_WORK_GROUP_COUNT_EXT
  GL_MAX_TASK_WORK_GROUP_INVOCATIONS_EXT
  GL_MAX_TASK_WORK_GROUP_INVOCATIONS_NV
  GL_MAX_TASK_WORK_GROUP_SIZE_EXT
  GL_MAX_TASK_WORK_GROUP_SIZE_NV
  GL_MAX_TASK_WORK_GROUP_TOTAL_COUNT_EXT
  GL_MAX_TESS_CONTROL_ATOMIC_COUNTERS
  GL_MAX_TESS_CONTROL_ATOMIC_COUNTERS_EXT
  GL_MAX_TESS_CONTROL_ATOMIC_COUNTERS_OES
  GL_MAX_TESS_CONTROL_ATOMIC_COUNTER_BUFFERS
  GL_MAX_TESS_CONTROL_ATOMIC_COUNTER_BUFFERS_EXT
  GL_MAX_TESS_CONTROL_ATOMIC_COUNTER_BUFFERS_OES
  GL_MAX_TESS_CONTROL_IMAGE_UNIFORMS
  GL_MAX_TESS_CONTROL_IMAGE_UNIFORMS_EXT
  GL_MAX_TESS_CONTROL_IMAGE_UNIFORMS_OES
  GL_MAX_TESS_CONTROL_INPUT_COMPONENTS
  GL_MAX_TESS_CONTROL_INPUT_COMPONENTS_EXT
  GL_MAX_TESS_CONTROL_INPUT_COMPONENTS_OES
  GL_MAX_TESS_CONTROL_OUTPUT_COMPONENTS
  GL_MAX_TESS_CONTROL_OUTPUT_COMPONENTS_EXT
  GL_MAX_TESS_CONTROL_OUTPUT_COMPONENTS_OES
  GL_MAX_TESS_CONTROL_SHADER_STORAGE_BLOCKS
  GL_MAX_TESS_CONTROL_SHADER_STORAGE_BLOCKS_EXT
  GL_MAX_TESS_CONTROL_SHADER_STORAGE_BLOCKS_OES
  GL_MAX_TESS_CONTROL_TEXTURE_IMAGE_UNITS
  GL_MAX_TESS_CONTROL_TEXTURE_IMAGE_UNITS_EXT
  GL_MAX_TESS_CONTROL_TEXTURE_IMAGE_UNITS_OES
  GL_MAX_TESS_CONTROL_TOTAL_OUTPUT_COMPONENTS
  GL_MAX_TESS_CONTROL_TOTAL_OUTPUT_COMPONENTS_EXT
  GL_MAX_TESS_CONTROL_TOTAL_OUTPUT_COMPONENTS_OES
  GL_MAX_TESS_CONTROL_UNIFORM_BLOCKS
  GL_MAX_TESS_CONTROL_UNIFORM_BLOCKS_EXT
  GL_MAX_TESS_CONTROL_UNIFORM_BLOCKS_OES
  GL_MAX_TESS_CONTROL_UNIFORM_COMPONENTS
  GL_MAX_TESS_CONTROL_UNIFORM_COMPONENTS_EXT
  GL_MAX_TESS_CONTROL_UNIFORM_COMPONENTS_OES
  GL_MAX_TESS_EVALUATION_ATOMIC_COUNTERS
  GL_MAX_TESS_EVALUATION_ATOMIC_COUNTERS_EXT
  GL_MAX_TESS_EVALUATION_ATOMIC_COUNTERS_OES
  GL_MAX_TESS_EVALUATION_ATOMIC_COUNTER_BUFFERS
  GL_MAX_TESS_EVALUATION_ATOMIC_COUNTER_BUFFERS_EXT
  GL_MAX_TESS_EVALUATION_ATOMIC_COUNTER_BUFFERS_OES
  GL_MAX_TESS_EVALUATION_IMAGE_UNIFORMS
  GL_MAX_TESS_EVALUATION_IMAGE_UNIFORMS_EXT
  GL_MAX_TESS_EVALUATION_IMAGE_UNIFORMS_OES
  GL_MAX_TESS_EVALUATION_INPUT_COMPONENTS
  GL_MAX_TESS_EVALUATION_INPUT_COMPONENTS_EXT
  GL_MAX_TESS_EVALUATION_INPUT_COMPONENTS_OES
  GL_MAX_TESS_EVALUATION_OUTPUT_COMPONENTS
  GL_MAX_TESS_EVALUATION_OUTPUT_COMPONENTS_EXT
  GL_MAX_TESS_EVALUATION_OUTPUT_COMPONENTS_OES
  GL_MAX_TESS_EVALUATION_SHADER_STORAGE_BLOCKS
  GL_MAX_TESS_EVALUATION_SHADER_STORAGE_BLOCKS_EXT
  GL_MAX_TESS_EVALUATION_SHADER_STORAGE_BLOCKS_OES
  GL_MAX_TESS_EVALUATION_TEXTURE_IMAGE_UNITS
  GL_MAX_TESS_EVALUATION_TEXTURE_IMAGE_UNITS_EXT
  GL_MAX_TESS_EVALUATION_TEXTURE_IMAGE_UNITS_OES
  GL_MAX_TESS_EVALUATION_UNIFORM_BLOCKS
  GL_MAX_TESS_EVALUATION_UNIFORM_BLOCKS_EXT
  GL_MAX_TESS_EVALUATION_UNIFORM_BLOCKS_OES
  GL_MAX_TESS_EVALUATION_UNIFORM_COMPONENTS
  GL_MAX_TESS_EVALUATION_UNIFORM_COMPONENTS_EXT
  GL_MAX_TESS_EVALUATION_UNIFORM_COMPONENTS_OES
  GL_MAX_TESS_GEN_LEVEL
  GL_MAX_TESS_GEN_LEVEL_EXT
  GL_MAX_TESS_GEN_LEVEL_OES
  GL_MAX_TESS_PATCH_COMPONENTS
  GL_MAX_TESS_PATCH_COMPONENTS_EXT
  GL_MAX_TESS_PATCH_COMPONENTS_OES
  GL_MAX_TEXTURES_SGIS
  GL_MAX_TEXTURE_BUFFER_SIZE
  GL_MAX_TEXTURE_BUFFER_SIZE_ARB
  GL_MAX_TEXTURE_BUFFER_SIZE_EXT
  GL_MAX_TEXTURE_BUFFER_SIZE_OES
  GL_MAX_TEXTURE_COORDS
  GL_MAX_TEXTURE_COORDS_ARB
  GL_MAX_TEXTURE_COORDS_NV
  GL_MAX_TEXTURE_COORD_SETS_SGIS
  GL_MAX_TEXTURE_IMAGE_UNITS
  GL_MAX_TEXTURE_IMAGE_UNITS_ARB
  GL_MAX_TEXTURE_IMAGE_UNITS_NV
  GL_MAX_TEXTURE_LOD_BIAS
  GL_MAX_TEXTURE_LOD_BIAS_EXT
  GL_MAX_TEXTURE_MAX_ANISOTROPY
  GL_MAX_TEXTURE_MAX_ANISOTROPY_EXT
  GL_MAX_TEXTURE_SIZE
  GL_MAX_TEXTURE_STACK_DEPTH
  GL_MAX_TEXTURE_UNITS
  GL_MAX_TEXTURE_UNITS_ARB
  GL_MAX_TIMELINE_SEMAPHORE_VALUE_DIFFERENCE_NV
  GL_MAX_TRACK_MATRICES_NV
  GL_MAX_TRACK_MATRIX_STACK_DEPTH_NV
  GL_MAX_TRANSFORM_FEEDBACK_BUFFERS
  GL_MAX_TRANSFORM_FEEDBACK_INTERLEAVED_COMPONENTS
  GL_MAX_TRANSFORM_FEEDBACK_INTERLEAVED_COMPONENTS_EXT
  GL_MAX_TRANSFORM_FEEDBACK_INTERLEAVED_COMPONENTS_NV
  GL_MAX_TRANSFORM_FEEDBACK_SEPARATE_ATTRIBS
  GL_MAX_TRANSFORM_FEEDBACK_SEPARATE_ATTRIBS_EXT
  GL_MAX_TRANSFORM_FEEDBACK_SEPARATE_ATTRIBS_NV
  GL_MAX_TRANSFORM_FEEDBACK_SEPARATE_COMPONENTS
  GL_MAX_TRANSFORM_FEEDBACK_SEPARATE_COMPONENTS_EXT
  GL_MAX_TRANSFORM_FEEDBACK_SEPARATE_COMPONENTS_NV
  GL_MAX_UNIFORM_BLOCK_SIZE
  GL_MAX_UNIFORM_BUFFER_BINDINGS
  GL_MAX_UNIFORM_LOCATIONS
  GL_MAX_VARYING_COMPONENTS
  GL_MAX_VARYING_COMPONENTS_EXT
  GL_MAX_VARYING_FLOATS
  GL_MAX_VARYING_FLOATS_ARB
  GL_MAX_VARYING_VECTORS
  GL_MAX_VERTEX_ARRAY_RANGE_ELEMENT_APPLE
  GL_MAX_VERTEX_ARRAY_RANGE_ELEMENT_NV
  GL_MAX_VERTEX_ATOMIC_COUNTERS
  GL_MAX_VERTEX_ATOMIC_COUNTER_BUFFERS
  GL_MAX_VERTEX_ATTRIBS
  GL_MAX_VERTEX_ATTRIBS_ARB
  GL_MAX_VERTEX_ATTRIB_BINDINGS
  GL_MAX_VERTEX_ATTRIB_RELATIVE_OFFSET
  GL_MAX_VERTEX_ATTRIB_STRIDE
  GL_MAX_VERTEX_BINDABLE_UNIFORMS_EXT
  GL_MAX_VERTEX_HINT_PGI
  GL_MAX_VERTEX_IMAGE_UNIFORMS
  GL_MAX_VERTEX_OUTPUT_COMPONENTS
  GL_MAX_VERTEX_SHADER_INSTRUCTIONS_EXT
  GL_MAX_VERTEX_SHADER_INVARIANTS_EXT
  GL_MAX_VERTEX_SHADER_LOCALS_EXT
  GL_MAX_VERTEX_SHADER_LOCAL_CONSTANTS_EXT
  GL_MAX_VERTEX_SHADER_STORAGE_BLOCKS
  GL_MAX_VERTEX_SHADER_VARIANTS_EXT
  GL_MAX_VERTEX_STREAMS
  GL_MAX_VERTEX_STREAMS_ATI
  GL_MAX_VERTEX_TEXTURE_IMAGE_UNITS
  GL_MAX_VERTEX_TEXTURE_IMAGE_UNITS_ARB
  GL_MAX_VERTEX_UNIFORM_BLOCKS
  GL_MAX_VERTEX_UNIFORM_COMPONENTS
  GL_MAX_VERTEX_UNIFORM_COMPONENTS_ARB
  GL_MAX_VERTEX_UNIFORM_VECTORS
  GL_MAX_VERTEX_UNITS_ARB
  GL_MAX_VERTEX_UNITS_OES
  GL_MAX_VERTEX_VARYING_COMPONENTS_ARB
  GL_MAX_VERTEX_VARYING_COMPONENTS_EXT
  GL_MAX_VIEWPORTS
  GL_MAX_VIEWPORTS_NV
  GL_MAX_VIEWPORT_DIMS
  GL_MAX_VIEWS_OVR
  GL_MAX_WIDTH
  GL_MAX_WINDOW_RECTANGLES_EXT
  GL_MEDIUM_FLOAT
  GL_MEDIUM_INT
  GL_MEMORY_ATTACHABLE_ALIGNMENT_NV
  GL_MEMORY_ATTACHABLE_NV
  GL_MEMORY_ATTACHABLE_SIZE_NV
  GL_MESH_OUTPUT_PER_PRIMITIVE_GRANULARITY_EXT
  GL_MESH_OUTPUT_PER_PRIMITIVE_GRANULARITY_NV
  GL_MESH_OUTPUT_PER_VERTEX_GRANULARITY_EXT
  GL_MESH_OUTPUT_PER_VERTEX_GRANULARITY_NV
  GL_MESH_OUTPUT_TYPE_EXT
  GL_MESH_OUTPUT_TYPE_NV
  GL_MESH_PREFERS_COMPACT_PRIMITIVE_OUTPUT_EXT
  GL_MESH_PREFERS_COMPACT_VERTEX_OUTPUT_EXT
  GL_MESH_PREFERS_LOCAL_INVOCATION_PRIMITIVE_OUTPUT_EXT
  GL_MESH_PREFERS_LOCAL_INVOCATION_VERTEX_OUTPUT_EXT
  GL_MESH_PRIMITIVES_GENERATED_EXT
  GL_MESH_PRIMITIVES_OUT_EXT
  GL_MESH_PRIMITIVES_OUT_NV
  GL_MESH_SHADER_BIT_EXT
  GL_MESH_SHADER_BIT_NV
  GL_MESH_SHADER_EXT
  GL_MESH_SHADER_INVOCATIONS_EXT
  GL_MESH_SHADER_NV
  GL_MESH_SUBROUTINE_EXT
  GL_MESH_SUBROUTINE_NV
  GL_MESH_SUBROUTINE_UNIFORM_EXT
  GL_MESH_SUBROUTINE_UNIFORM_NV
  GL_MESH_VERTICES_OUT_EXT
  GL_MESH_VERTICES_OUT_NV
  GL_MESH_WORK_GROUP_SIZE_EXT
  GL_MESH_WORK_GROUP_SIZE_NV
  GL_MIN
  GL_MINMAX
  GL_MINMAX_EXT
  GL_MINMAX_FORMAT
  GL_MINMAX_FORMAT_EXT
  GL_MINMAX_SINK
  GL_MINMAX_SINK_EXT
  GL_MINOR_VERSION
  GL_MINUS_CLAMPED_NV
  GL_MINUS_NV
  GL_MIN_ALPHA_SGIS
  GL_MIN_BLUE_SGIS
  GL_MIN_EXT
  GL_MIN_FRAGMENT_INTERPOLATION_OFFSET
  GL_MIN_FRAGMENT_INTERPOLATION_OFFSET_NV
  GL_MIN_FRAGMENT_INTERPOLATION_OFFSET_OES
  GL_MIN_FRAGMENT_SHADING_RATE_ATTACHMENT_TEXEL_HEIGHT_EXT
  GL_MIN_FRAGMENT_SHADING_RATE_ATTACHMENT_TEXEL_WIDTH_EXT
  GL_MIN_GREEN_SGIS
  GL_MIN_INTENSITY_SGIS
  GL_MIN_LOD_WARNING_AMD
  GL_MIN_LUMINANCE_SGIS
  GL_MIN_MAP_BUFFER_ALIGNMENT
  GL_MIN_PBUFFER_VIEWPORT_DIMS_APPLE
  GL_MIN_PROGRAM_TEXEL_OFFSET
  GL_MIN_PROGRAM_TEXEL_OFFSET_NV
  GL_MIN_PROGRAM_TEXTURE_GATHER_OFFSET
  GL_MIN_PROGRAM_TEXTURE_GATHER_OFFSET_ARB
  GL_MIN_PROGRAM_TEXTURE_GATHER_OFFSET_NV
  GL_MIN_RED_SGIS
  GL_MIN_SAMPLE_SHADING_VALUE
  GL_MIN_SAMPLE_SHADING_VALUE_ARB
  GL_MIN_SAMPLE_SHADING_VALUE_OES
  GL_MIN_SPARSE_LEVEL_AMD
  GL_MIPMAP
  GL_MIRRORED_REPEAT
  GL_MIRRORED_REPEAT_ARB
  GL_MIRRORED_REPEAT_IBM
  GL_MIRROR_CLAMP_ATI
  GL_MIRROR_CLAMP_EXT
  GL_MIRROR_CLAMP_TO_BORDER_EXT
  GL_MIRROR_CLAMP_TO_EDGE
  GL_MIRROR_CLAMP_TO_EDGE_ATI
  GL_MIRROR_CLAMP_TO_EDGE_EXT
  GL_MISSING_REGAL
  GL_MITER_REVERT_NV
  GL_MITER_TRUNCATE_NV
  GL_MIXED_DEPTH_SAMPLES_SUPPORTED_NV
  GL_MIXED_STENCIL_SAMPLES_SUPPORTED_NV
  GL_MODELVIEW
  GL_MODELVIEW0_ARB
  GL_MODELVIEW0_EXT
  GL_MODELVIEW0_MATRIX_EXT
  GL_MODELVIEW0_STACK_DEPTH_EXT
  GL_MODELVIEW10_ARB
  GL_MODELVIEW11_ARB
  GL_MODELVIEW12_ARB
  GL_MODELVIEW13_ARB
  GL_MODELVIEW14_ARB
  GL_MODELVIEW15_ARB
  GL_MODELVIEW16_ARB
  GL_MODELVIEW17_ARB
  GL_MODELVIEW18_ARB
  GL_MODELVIEW19_ARB
  GL_MODELVIEW1_ARB
  GL_MODELVIEW1_EXT
  GL_MODELVIEW1_MATRIX_EXT
  GL_MODELVIEW1_STACK_DEPTH_EXT
  GL_MODELVIEW20_ARB
  GL_MODELVIEW21_ARB
  GL_MODELVIEW22_ARB
  GL_MODELVIEW23_ARB
  GL_MODELVIEW24_ARB
  GL_MODELVIEW25_ARB
  GL_MODELVIEW26_ARB
  GL_MODELVIEW27_ARB
  GL_MODELVIEW28_ARB
  GL_MODELVIEW29_ARB
  GL_MODELVIEW2_ARB
  GL_MODELVIEW30_ARB
  GL_MODELVIEW31_ARB
  GL_MODELVIEW3_ARB
  GL_MODELVIEW4_ARB
  GL_MODELVIEW5_ARB
  GL_MODELVIEW6_ARB
  GL_MODELVIEW7_ARB
  GL_MODELVIEW8_ARB
  GL_MODELVIEW9_ARB
  GL_MODELVIEW_MATRIX
  GL_MODELVIEW_MATRIX_FLOAT_AS_INT_BITS_OES
  GL_MODELVIEW_PROJECTION_NV
  GL_MODELVIEW_STACK_DEPTH
  GL_MODULATE
  GL_MODULATE_ADD_ATI
  GL_MODULATE_ADD_ATIX
  GL_MODULATE_COLOR_IMG
  GL_MODULATE_SIGNED_ADD_ATI
  GL_MODULATE_SIGNED_ADD_ATIX
  GL_MODULATE_SUBTRACT_ATI
  GL_MODULATE_SUBTRACT_ATIX
  GL_MOTION_ESTIMATION_SEARCH_BLOCK_X_QCOM
  GL_MOTION_ESTIMATION_SEARCH_BLOCK_Y_QCOM
  GL_MOVE_TO_CONTINUES_NV
  GL_MOVE_TO_NV
  GL_MOVE_TO_RESETS_NV
  GL_MOV_ATI
  GL_MULT
  GL_MULTICAST_GPUS_NV
  GL_MULTICAST_PROGRAMMABLE_SAMPLE_LOCATION_NV
  GL_MULTIPLY_KHR
  GL_MULTIPLY_NV
  GL_MULTISAMPLE
  GL_MULTISAMPLES_NV
  GL_MULTISAMPLE_3DFX
  GL_MULTISAMPLE_ARB
  GL_MULTISAMPLE_BIT
  GL_MULTISAMPLE_BIT_3DFX
  GL_MULTISAMPLE_BIT_ARB
  GL_MULTISAMPLE_BIT_EXT
  GL_MULTISAMPLE_BUFFER_BIT0_QCOM
  GL_MULTISAMPLE_BUFFER_BIT1_QCOM
  GL_MULTISAMPLE_BUFFER_BIT2_QCOM
  GL_MULTISAMPLE_BUFFER_BIT3_QCOM
  GL_MULTISAMPLE_BUFFER_BIT4_QCOM
  GL_MULTISAMPLE_BUFFER_BIT5_QCOM
  GL_MULTISAMPLE_BUFFER_BIT6_QCOM
  GL_MULTISAMPLE_BUFFER_BIT7_QCOM
  GL_MULTISAMPLE_COVERAGE_MODES_NV
  GL_MULTISAMPLE_EXT
  GL_MULTISAMPLE_FILTER_HINT_NV
  GL_MULTISAMPLE_LINE_WIDTH_GRANULARITY_ARB
  GL_MULTISAMPLE_LINE_WIDTH_RANGE_ARB
  GL_MULTISAMPLE_RASTERIZATION_ALLOWED_EXT
  GL_MULTISAMPLE_SGIS
  GL_MULTIVIEW_EXT
  GL_MUL_ATI
  GL_MVP_MATRIX_EXT
  GL_N3F_V3F
  GL_NAMED_STRING_LENGTH_ARB
  GL_NAMED_STRING_TYPE_ARB
  GL_NAME_LENGTH
  GL_NAME_STACK_DEPTH
  GL_NAND
  GL_NATIVE_GRAPHICS_BEGIN_HINT_PGI
  GL_NATIVE_GRAPHICS_END_HINT_PGI
  GL_NATIVE_GRAPHICS_HANDLE_PGI
  GL_NEAREST
  GL_NEAREST_MIPMAP_LINEAR
  GL_NEAREST_MIPMAP_NEAREST
  GL_NEGATE_BIT_ATI
  GL_NEGATIVE_ONE_EXT
  GL_NEGATIVE_ONE_TO_ONE
  GL_NEGATIVE_ONE_TO_ONE_EXT
  GL_NEGATIVE_W_EXT
  GL_NEGATIVE_X_EXT
  GL_NEGATIVE_Y_EXT
  GL_NEGATIVE_Z_EXT
  GL_NEVER
  GL_NEXT_VIDEO_CAPTURE_BUFFER_STATUS_NV
  GL_NICEST
  GL_NONE
  GL_NONE_OES
  GL_NOOP
  GL_NOP_COMMAND_NV
  GL_NOR
  GL_NORMALIZE
  GL_NORMALIZED_RANGE_EXT
  GL_NORMAL_ARRAY
  GL_NORMAL_ARRAY_ADDRESS_NV
  GL_NORMAL_ARRAY_BUFFER_BINDING
  GL_NORMAL_ARRAY_BUFFER_BINDING_ARB
  GL_NORMAL_ARRAY_COUNT_EXT
  GL_NORMAL_ARRAY_EXT
  GL_NORMAL_ARRAY_LENGTH_NV
  GL_NORMAL_ARRAY_LIST_IBM
  GL_NORMAL_ARRAY_LIST_STRIDE_IBM
  GL_NORMAL_ARRAY_PARALLEL_POINTERS_INTEL
  GL_NORMAL_ARRAY_POINTER
  GL_NORMAL_ARRAY_POINTER_EXT
  GL_NORMAL_ARRAY_STRIDE
  GL_NORMAL_ARRAY_STRIDE_EXT
  GL_NORMAL_ARRAY_TYPE
  GL_NORMAL_ARRAY_TYPE_EXT
  GL_NORMAL_BIT_PGI
  GL_NORMAL_MAP
  GL_NORMAL_MAP_ARB
  GL_NORMAL_MAP_EXT
  GL_NORMAL_MAP_NV
  GL_NORMAL_MAP_OES
  GL_NOTEQUAL
  GL_NO_ERROR
  GL_NO_RESET_NOTIFICATION
  GL_NO_RESET_NOTIFICATION_ARB
  GL_NO_RESET_NOTIFICATION_EXT
  GL_NUM_ACTIVE_VARIABLES
  GL_NUM_COMPATIBLE_SUBROUTINES
  GL_NUM_COMPRESSED_TEXTURE_FORMATS
  GL_NUM_COMPRESSED_TEXTURE_FORMATS_ARB
  GL_NUM_DEVICE_UUIDS_EXT
  GL_NUM_DOWNSAMPLE_SCALES_IMG
  GL_NUM_EXTENSIONS
  GL_NUM_FILL_STREAMS_NV
  GL_NUM_FRAGMENT_CONSTANTS_ATI
  GL_NUM_FRAGMENT_REGISTERS_ATI
  GL_NUM_GENERAL_COMBINERS_NV
  GL_NUM_INPUT_INTERPOLATOR_COMPONENTS_ATI
  GL_NUM_INSTRUCTIONS_PER_PASS_ATI
  GL_NUM_INSTRUCTIONS_TOTAL_ATI
  GL_NUM_LOOPBACK_COMPONENTS_ATI
  GL_NUM_PASSES_ATI
  GL_NUM_PROGRAM_BINARY_FORMATS
  GL_NUM_PROGRAM_BINARY_FORMATS_OES
  GL_NUM_SAMPLE_COUNTS
  GL_NUM_SHADER_BINARY_FORMATS
  GL_NUM_SHADING_LANGUAGE_VERSIONS
  GL_NUM_SPARSE_LEVELS_ARB
  GL_NUM_SPARSE_LEVELS_EXT
  GL_NUM_SPIR_V_EXTENSIONS
  GL_NUM_SUPPORTED_MULTISAMPLE_MODES_AMD
  GL_NUM_SURFACE_COMPRESSION_FIXED_RATES_EXT
  GL_NUM_TILING_TYPES_EXT
  GL_NUM_VIDEO_CAPTURE_STREAMS_NV
  GL_NUM_VIRTUAL_PAGE_SIZES_ARB
  GL_NUM_VIRTUAL_PAGE_SIZES_EXT
  GL_NUM_WINDOW_RECTANGLES_EXT
  GL_NURBS_KNOT_COUNT_SGIX
  GL_NURBS_KNOT_VECTOR_SGIX
  GL_NVIDIA_PLATFORM_BINARY_NV
  GL_OBJECT_ACTIVE_ATTRIBUTES_ARB
  GL_OBJECT_ACTIVE_ATTRIBUTE_MAX_LENGTH_ARB
  GL_OBJECT_ACTIVE_UNIFORMS_ARB
  GL_OBJECT_ACTIVE_UNIFORM_MAX_LENGTH_ARB
  GL_OBJECT_ATTACHED_OBJECTS_ARB
  GL_OBJECT_BUFFER_SIZE_ATI
  GL_OBJECT_BUFFER_USAGE_ATI
  GL_OBJECT_COMPILE_STATUS_ARB
  GL_OBJECT_DELETE_STATUS_ARB
  GL_OBJECT_DISTANCE_TO_LINE_SGIS
  GL_OBJECT_DISTANCE_TO_POINT_SGIS
  GL_OBJECT_INFO_LOG_LENGTH_ARB
  GL_OBJECT_LINEAR
  GL_OBJECT_LINE_SGIS
  GL_OBJECT_LINK_STATUS_ARB
  GL_OBJECT_PLANE
  GL_OBJECT_POINT_SGIS
  GL_OBJECT_SHADER_SOURCE_LENGTH_ARB
  GL_OBJECT_SPACE_SGIX
  GL_OBJECT_SUBTYPE_ARB
  GL_OBJECT_TYPE
  GL_OBJECT_TYPE_APPLE
  GL_OBJECT_TYPE_ARB
  GL_OBJECT_VALIDATE_STATUS_ARB
  GL_OCCLUSION_INSTRUMENT_SGIX
  GL_OCCLUSION_QUERY_EVENT_MASK_AMD
  GL_OFFSET
  GL_OFFSET_HILO_PROJECTIVE_TEXTURE_2D_NV
  GL_OFFSET_HILO_PROJECTIVE_TEXTURE_RECTANGLE_NV
  GL_OFFSET_HILO_TEXTURE_2D_NV
  GL_OFFSET_HILO_TEXTURE_RECTANGLE_NV
  GL_OFFSET_PROJECTIVE_TEXTURE_2D_NV
  GL_OFFSET_PROJECTIVE_TEXTURE_2D_SCALE_NV
  GL_OFFSET_PROJECTIVE_TEXTURE_RECTANGLE_NV
  GL_OFFSET_PROJECTIVE_TEXTURE_RECTANGLE_SCALE_NV
  GL_OFFSET_TEXTURE_2D_BIAS_NV
  GL_OFFSET_TEXTURE_2D_MATRIX_NV
  GL_OFFSET_TEXTURE_2D_NV
  GL_OFFSET_TEXTURE_2D_SCALE_NV
  GL_OFFSET_TEXTURE_BIAS_NV
  GL_OFFSET_TEXTURE_MATRIX_NV
  GL_OFFSET_TEXTURE_RECTANGLE_NV
  GL_OFFSET_TEXTURE_RECTANGLE_SCALE_NV
  GL_OFFSET_TEXTURE_SCALE_NV
  GL_ONE
  GL_ONE_EXT
  GL_ONE_MINUS_CONSTANT_ALPHA
  GL_ONE_MINUS_CONSTANT_ALPHA_EXT
  GL_ONE_MINUS_CONSTANT_COLOR
  GL_ONE_MINUS_CONSTANT_COLOR_EXT
  GL_ONE_MINUS_DST_ALPHA
  GL_ONE_MINUS_DST_COLOR
  GL_ONE_MINUS_SRC1_ALPHA
  GL_ONE_MINUS_SRC1_ALPHA_EXT
  GL_ONE_MINUS_SRC1_COLOR
  GL_ONE_MINUS_SRC1_COLOR_EXT
  GL_ONE_MINUS_SRC_ALPHA
  GL_ONE_MINUS_SRC_COLOR
  GL_OPERAND0_ALPHA
  GL_OPERAND0_ALPHA_ARB
  GL_OPERAND0_ALPHA_EXT
  GL_OPERAND0_RGB
  GL_OPERAND0_RGB_ARB
  GL_OPERAND0_RGB_EXT
  GL_OPERAND1_ALPHA
  GL_OPERAND1_ALPHA_ARB
  GL_OPERAND1_ALPHA_EXT
  GL_OPERAND1_RGB
  GL_OPERAND1_RGB_ARB
  GL_OPERAND1_RGB_EXT
  GL_OPERAND2_ALPHA
  GL_OPERAND2_ALPHA_ARB
  GL_OPERAND2_ALPHA_EXT
  GL_OPERAND2_RGB
  GL_OPERAND2_RGB_ARB
  GL_OPERAND2_RGB_EXT
  GL_OPERAND3_ALPHA_NV
  GL_OPERAND3_RGB_NV
  GL_OPTIMAL_TILING_EXT
  GL_OP_ADD_EXT
  GL_OP_CLAMP_EXT
  GL_OP_CROSS_PRODUCT_EXT
  GL_OP_DOT3_EXT
  GL_OP_DOT4_EXT
  GL_OP_EXP_BASE_2_EXT
  GL_OP_FLOOR_EXT
  GL_OP_FRAC_EXT
  GL_OP_INDEX_EXT
  GL_OP_LOG_BASE_2_EXT
  GL_OP_MADD_EXT
  GL_OP_MAX_EXT
  GL_OP_MIN_EXT
  GL_OP_MOV_EXT
  GL_OP_MULTIPLY_MATRIX_EXT
  GL_OP_MUL_EXT
  GL_OP_NEGATE_EXT
  GL_OP_POWER_EXT
  GL_OP_RECIP_EXT
  GL_OP_RECIP_SQRT_EXT
  GL_OP_ROUND_EXT
  GL_OP_SET_GE_EXT
  GL_OP_SET_LT_EXT
  GL_OP_SUB_EXT
  GL_OR
  GL_ORDER
  GL_OR_INVERTED
  GL_OR_REVERSE
  GL_OUTPUT_COLOR0_EXT
  GL_OUTPUT_COLOR1_EXT
  GL_OUTPUT_FOG_EXT
  GL_OUTPUT_POINT_SIZE_ATIX
  GL_OUTPUT_TEXTURE_COORD0_EXT
  GL_OUTPUT_TEXTURE_COORD10_EXT
  GL_OUTPUT_TEXTURE_COORD11_EXT
  GL_OUTPUT_TEXTURE_COORD12_EXT
  GL_OUTPUT_TEXTURE_COORD13_EXT
  GL_OUTPUT_TEXTURE_COORD14_EXT
  GL_OUTPUT_TEXTURE_COORD15_EXT
  GL_OUTPUT_TEXTURE_COORD16_EXT
  GL_OUTPUT_TEXTURE_COORD17_EXT
  GL_OUTPUT_TEXTURE_COORD18_EXT
  GL_OUTPUT_TEXTURE_COORD19_EXT
  GL_OUTPUT_TEXTURE_COORD1_EXT
  GL_OUTPUT_TEXTURE_COORD20_EXT
  GL_OUTPUT_TEXTURE_COORD21_EXT
  GL_OUTPUT_TEXTURE_COORD22_EXT
  GL_OUTPUT_TEXTURE_COORD23_EXT
  GL_OUTPUT_TEXTURE_COORD24_EXT
  GL_OUTPUT_TEXTURE_COORD25_EXT
  GL_OUTPUT_TEXTURE_COORD26_EXT
  GL_OUTPUT_TEXTURE_COORD27_EXT
  GL_OUTPUT_TEXTURE_COORD28_EXT
  GL_OUTPUT_TEXTURE_COORD29_EXT
  GL_OUTPUT_TEXTURE_COORD2_EXT
  GL_OUTPUT_TEXTURE_COORD30_EXT
  GL_OUTPUT_TEXTURE_COORD31_EXT
  GL_OUTPUT_TEXTURE_COORD3_EXT
  GL_OUTPUT_TEXTURE_COORD4_EXT
  GL_OUTPUT_TEXTURE_COORD5_EXT
  GL_OUTPUT_TEXTURE_COORD6_EXT
  GL_OUTPUT_TEXTURE_COORD7_EXT
  GL_OUTPUT_TEXTURE_COORD8_EXT
  GL_OUTPUT_TEXTURE_COORD9_EXT
  GL_OUTPUT_VERTEX_EXT
  GL_OUT_OF_MEMORY
  GL_OVERLAY_KHR
  GL_OVERLAY_NV
  GL_PACK_ALIGNMENT
  GL_PACK_CMYK_HINT_EXT
  GL_PACK_COMPRESSED_BLOCK_DEPTH
  GL_PACK_COMPRESSED_BLOCK_HEIGHT
  GL_PACK_COMPRESSED_BLOCK_SIZE
  GL_PACK_COMPRESSED_BLOCK_WIDTH
  GL_PACK_IMAGE_HEIGHT
  GL_PACK_IMAGE_HEIGHT_EXT
  GL_PACK_INVERT_MESA
  GL_PACK_LSB_FIRST
  GL_PACK_MAX_COMPRESSED_SIZE_SGIX
  GL_PACK_RESAMPLE_OML
  GL_PACK_RESAMPLE_SGIX
  GL_PACK_REVERSE_ROW_ORDER_ANGLE
  GL_PACK_ROW_BYTES_APPLE
  GL_PACK_ROW_LENGTH
  GL_PACK_ROW_LENGTH_NV
  GL_PACK_SKIP_IMAGES
  GL_PACK_SKIP_IMAGES_EXT
  GL_PACK_SKIP_PIXELS
  GL_PACK_SKIP_PIXELS_NV
  GL_PACK_SKIP_ROWS
  GL_PACK_SKIP_ROWS_NV
  GL_PACK_SUBSAMPLE_RATE_SGIX
  GL_PACK_SWAP_BYTES
  GL_PALETTE4_R5_G6_B5_OES
  GL_PALETTE4_RGB5_A1_OES
  GL_PALETTE4_RGB8_OES
  GL_PALETTE4_RGBA4_OES
  GL_PALETTE4_RGBA8_OES
  GL_PALETTE8_R5_G6_B5_OES
  GL_PALETTE8_RGB5_A1_OES
  GL_PALETTE8_RGB8_OES
  GL_PALETTE8_RGBA4_OES
  GL_PALETTE8_RGBA8_OES
  GL_PARALLEL_ARRAYS_INTEL
  GL_PARAMETER_BUFFER
  GL_PARAMETER_BUFFER_ARB
  GL_PARAMETER_BUFFER_BINDING
  GL_PARAMETER_BUFFER_BINDING_ARB
  GL_PARTIAL_SUCCESS_NV
  GL_PASS_THROUGH_NV
  GL_PASS_THROUGH_TOKEN
  GL_PATCHES
  GL_PATCHES_EXT
  GL_PATCHES_OES
  GL_PATCH_DEFAULT_INNER_LEVEL
  GL_PATCH_DEFAULT_OUTER_LEVEL
  GL_PATCH_VERTICES
  GL_PATCH_VERTICES_EXT
  GL_PATCH_VERTICES_OES
  GL_PATH_CLIENT_LENGTH_NV
  GL_PATH_COMMAND_COUNT_NV
  GL_PATH_COMPUTED_LENGTH_NV
  GL_PATH_COORD_COUNT_NV
  GL_PATH_COVER_DEPTH_FUNC_NV
  GL_PATH_DASH_ARRAY_COUNT_NV
  GL_PATH_DASH_CAPS_NV
  GL_PATH_DASH_OFFSET_NV
  GL_PATH_DASH_OFFSET_RESET_NV
  GL_PATH_END_CAPS_NV
  GL_PATH_ERROR_POSITION_NV
  GL_PATH_FILL_BOUNDING_BOX_NV
  GL_PATH_FILL_COVER_MODE_NV
  GL_PATH_FILL_MASK_NV
  GL_PATH_FILL_MODE_NV
  GL_PATH_FOG_GEN_MODE_NV
  GL_PATH_FORMAT_PS_NV
  GL_PATH_FORMAT_SVG_NV
  GL_PATH_GEN_COEFF_NV
  GL_PATH_GEN_COLOR_FORMAT_NV
  GL_PATH_GEN_COMPONENTS_NV
  GL_PATH_GEN_MODE_NV
  GL_PATH_INITIAL_DASH_CAP_NV
  GL_PATH_INITIAL_END_CAP_NV
  GL_PATH_JOIN_STYLE_NV
  GL_PATH_MITER_LIMIT_NV
  GL_PATH_OBJECT_BOUNDING_BOX_NV
  GL_PATH_STENCIL_DEPTH_OFFSET_FACTOR_NV
  GL_PATH_STENCIL_DEPTH_OFFSET_UNITS_NV
  GL_PATH_STENCIL_FUNC_NV
  GL_PATH_STENCIL_REF_NV
  GL_PATH_STENCIL_VALUE_MASK_NV
  GL_PATH_STROKE_BOUNDING_BOX_NV
  GL_PATH_STROKE_BOUND_NV
  GL_PATH_STROKE_COVER_MODE_NV
  GL_PATH_STROKE_MASK_NV
  GL_PATH_STROKE_WIDTH_NV
  GL_PATH_TERMINAL_DASH_CAP_NV
  GL_PATH_TERMINAL_END_CAP_NV
  GL_PERCENTAGE_AMD
  GL_PERFMON_GLOBAL_MODE_QCOM
  GL_PERFMON_RESULT_AMD
  GL_PERFMON_RESULT_AVAILABLE_AMD
  GL_PERFMON_RESULT_SIZE_AMD
  GL_PERFORMANCE_MONITOR_AMD
  GL_PERFQUERY_COUNTER_DATA_BOOL32_INTEL
  GL_PERFQUERY_COUNTER_DATA_DOUBLE_INTEL
  GL_PERFQUERY_COUNTER_DATA_FLOAT_INTEL
  GL_PERFQUERY_COUNTER_DATA_UINT32_INTEL
  GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL
  GL_PERFQUERY_COUNTER_DESC_LENGTH_MAX_INTEL
  GL_PERFQUERY_COUNTER_DURATION_NORM_INTEL
  GL_PERFQUERY_COUNTER_DURATION_RAW_INTEL
  GL_PERFQUERY_COUNTER_EVENT_INTEL
  GL_PERFQUERY_COUNTER_NAME_LENGTH_MAX_INTEL
  GL_PERFQUERY_COUNTER_RAW_INTEL
  GL_PERFQUERY_COUNTER_THROUGHPUT_INTEL
  GL_PERFQUERY_COUNTER_TIMESTAMP_INTEL
  GL_PERFQUERY_DONOT_FLUSH_INTEL
  GL_PERFQUERY_FLUSH_INTEL
  GL_PERFQUERY_GLOBAL_CONTEXT_INTEL
  GL_PERFQUERY_GPA_EXTENDED_COUNTERS_INTEL
  GL_PERFQUERY_QUERY_NAME_LENGTH_MAX_INTEL
  GL_PERFQUERY_SINGLE_CONTEXT_INTEL
  GL_PERFQUERY_WAIT_INTEL
  GL_PERSPECTIVE_CORRECTION_HINT
  GL_PERTURB_EXT
  GL_PER_GPU_STORAGE_BIT_NV
  GL_PER_GPU_STORAGE_NV
  GL_PER_STAGE_CONSTANTS_NV
  GL_PHASE_SGIX
  GL_PHONG_HINT_WIN
  GL_PHONG_WIN
  GL_PINLIGHT_NV
  GL_PIXELS_PER_SAMPLE_PATTERN_X_AMD
  GL_PIXELS_PER_SAMPLE_PATTERN_Y_AMD
  GL_PIXEL_BUFFER_BARRIER_BIT
  GL_PIXEL_BUFFER_BARRIER_BIT_EXT
  GL_PIXEL_COUNTER_BITS_NV
  GL_PIXEL_COUNT_AVAILABLE_NV
  GL_PIXEL_COUNT_NV
  GL_PIXEL_CUBIC_WEIGHT_EXT
  GL_PIXEL_MAG_FILTER_EXT
  GL_PIXEL_MAP_A_TO_A
  GL_PIXEL_MAP_A_TO_A_SIZE
  GL_PIXEL_MAP_B_TO_B
  GL_PIXEL_MAP_B_TO_B_SIZE
  GL_PIXEL_MAP_G_TO_G
  GL_PIXEL_MAP_G_TO_G_SIZE
  GL_PIXEL_MAP_I_TO_A
  GL_PIXEL_MAP_I_TO_A_SIZE
  GL_PIXEL_MAP_I_TO_B
  GL_PIXEL_MAP_I_TO_B_SIZE
  GL_PIXEL_MAP_I_TO_G
  GL_PIXEL_MAP_I_TO_G_SIZE
  GL_PIXEL_MAP_I_TO_I
  GL_PIXEL_MAP_I_TO_I_SIZE
  GL_PIXEL_MAP_I_TO_R
  GL_PIXEL_MAP_I_TO_R_SIZE
  GL_PIXEL_MAP_R_TO_R
  GL_PIXEL_MAP_R_TO_R_SIZE
  GL_PIXEL_MAP_S_TO_S
  GL_PIXEL_MAP_S_TO_S_SIZE
  GL_PIXEL_MIN_FILTER_EXT
  GL_PIXEL_MODE_BIT
  GL_PIXEL_PACK_BUFFER
  GL_PIXEL_PACK_BUFFER_ARB
  GL_PIXEL_PACK_BUFFER_BINDING
  GL_PIXEL_PACK_BUFFER_BINDING_ARB
  GL_PIXEL_PACK_BUFFER_BINDING_EXT
  GL_PIXEL_PACK_BUFFER_BINDING_NV
  GL_PIXEL_PACK_BUFFER_EXT
  GL_PIXEL_PACK_BUFFER_NV
  GL_PIXEL_SUBSAMPLE_2424_SGIX
  GL_PIXEL_SUBSAMPLE_4242_SGIX
  GL_PIXEL_SUBSAMPLE_4444_SGIX
  GL_PIXEL_TRANSFORM_2D_EXT
  GL_PIXEL_TRANSFORM_2D_MATRIX_EXT
  GL_PIXEL_TRANSFORM_2D_STACK_DEPTH_EXT
  GL_PIXEL_TRANSFORM_OPERATOR_SGI
  GL_PIXEL_TRANSFORM_SGI
  GL_PIXEL_UNPACK_BUFFER
  GL_PIXEL_UNPACK_BUFFER_ARB
  GL_PIXEL_UNPACK_BUFFER_BINDING
  GL_PIXEL_UNPACK_BUFFER_BINDING_ARB
  GL_PIXEL_UNPACK_BUFFER_BINDING_EXT
  GL_PIXEL_UNPACK_BUFFER_BINDING_NV
  GL_PIXEL_UNPACK_BUFFER_EXT
  GL_PIXEL_UNPACK_BUFFER_NV
  GL_PLUS_CLAMPED_ALPHA_NV
  GL_PLUS_CLAMPED_NV
  GL_PLUS_DARKER_NV
  GL_PLUS_NV
  GL_PN_TRIANGLES_ATI
  GL_PN_TRIANGLES_NORMAL_MODE_ATI
  GL_PN_TRIANGLES_NORMAL_MODE_LINEAR_ATI
  GL_PN_TRIANGLES_NORMAL_MODE_QUADRATIC_ATI
  GL_PN_TRIANGLES_POINT_MODE_ATI
  GL_PN_TRIANGLES_POINT_MODE_CUBIC_ATI
  GL_PN_TRIANGLES_POINT_MODE_LINEAR_ATI
  GL_PN_TRIANGLES_TESSELATION_LEVEL_ATI
  GL_POINT
  GL_POINTS
  GL_POINT_BIT
  GL_POINT_DISTANCE_ATTENUATION
  GL_POINT_DISTANCE_ATTENUATION_ARB
  GL_POINT_FADE_THRESHOLD_SIZE
  GL_POINT_FADE_THRESHOLD_SIZE_ARB
  GL_POINT_FADE_THRESHOLD_SIZE_EXT
  GL_POINT_NV
  GL_POINT_SIZE
  GL_POINT_SIZE_ARRAY_BUFFER_BINDING_OES
  GL_POINT_SIZE_ARRAY_OES
  GL_POINT_SIZE_ARRAY_POINTER_OES
  GL_POINT_SIZE_ARRAY_STRIDE_OES
  GL_POINT_SIZE_ARRAY_TYPE_OES
  GL_POINT_SIZE_GRANULARITY
  GL_POINT_SIZE_MAX
  GL_POINT_SIZE_MAX_ARB
  GL_POINT_SIZE_MAX_EXT
  GL_POINT_SIZE_MIN
  GL_POINT_SIZE_MIN_ARB
  GL_POINT_SIZE_MIN_EXT
  GL_POINT_SIZE_RANGE
  GL_POINT_SMOOTH
  GL_POINT_SMOOTH_HINT
  GL_POINT_SPRITE
  GL_POINT_SPRITE_ARB
  GL_POINT_SPRITE_COORD_ORIGIN
  GL_POINT_SPRITE_CULL_CENTER_ATIX
  GL_POINT_SPRITE_CULL_CLIP_ATIX
  GL_POINT_SPRITE_CULL_MODE_ATIX
  GL_POINT_SPRITE_NV
  GL_POINT_SPRITE_OES
  GL_POINT_SPRITE_R_MODE_NV
  GL_POINT_TOKEN
  GL_POLYGON
  GL_POLYGON_BIT
  GL_POLYGON_MODE
  GL_POLYGON_MODE_NV
  GL_POLYGON_OFFSET_BIAS_EXT
  GL_POLYGON_OFFSET_CLAMP
  GL_POLYGON_OFFSET_CLAMP_EXT
  GL_POLYGON_OFFSET_COMMAND_NV
  GL_POLYGON_OFFSET_EXT
  GL_POLYGON_OFFSET_FACTOR
  GL_POLYGON_OFFSET_FACTOR_EXT
  GL_POLYGON_OFFSET_FILL
  GL_POLYGON_OFFSET_LINE
  GL_POLYGON_OFFSET_LINE_NV
  GL_POLYGON_OFFSET_POINT
  GL_POLYGON_OFFSET_POINT_NV
  GL_POLYGON_OFFSET_UNITS
  GL_POLYGON_SMOOTH
  GL_POLYGON_SMOOTH_HINT
  GL_POLYGON_STIPPLE
  GL_POLYGON_STIPPLE_BIT
  GL_POLYGON_TOKEN
  GL_POSITION
  GL_POST_COLOR_MATRIX_ALPHA_BIAS
  GL_POST_COLOR_MATRIX_ALPHA_BIAS_SGI
  GL_POST_COLOR_MATRIX_ALPHA_SCALE
  GL_POST_COLOR_MATRIX_ALPHA_SCALE_SGI
  GL_POST_COLOR_MATRIX_BLUE_BIAS
  GL_POST_COLOR_MATRIX_BLUE_BIAS_SGI
  GL_POST_COLOR_MATRIX_BLUE_SCALE
  GL_POST_COLOR_MATRIX_BLUE_SCALE_SGI
  GL_POST_COLOR_MATRIX_COLOR_TABLE
  GL_POST_COLOR_MATRIX_COLOR_TABLE_SGI
  GL_POST_COLOR_MATRIX_GREEN_BIAS
  GL_POST_COLOR_MATRIX_GREEN_BIAS_SGI
  GL_POST_COLOR_MATRIX_GREEN_SCALE
  GL_POST_COLOR_MATRIX_GREEN_SCALE_SGI
  GL_POST_COLOR_MATRIX_RED_BIAS
  GL_POST_COLOR_MATRIX_RED_BIAS_SGI
  GL_POST_COLOR_MATRIX_RED_SCALE
  GL_POST_COLOR_MATRIX_RED_SCALE_SGI
  GL_POST_CONVOLUTION_ALPHA_BIAS
  GL_POST_CONVOLUTION_ALPHA_BIAS_EXT
  GL_POST_CONVOLUTION_ALPHA_SCALE
  GL_POST_CONVOLUTION_ALPHA_SCALE_EXT
  GL_POST_CONVOLUTION_BLUE_BIAS
  GL_POST_CONVOLUTION_BLUE_BIAS_EXT
  GL_POST_CONVOLUTION_BLUE_SCALE
  GL_POST_CONVOLUTION_BLUE_SCALE_EXT
  GL_POST_CONVOLUTION_COLOR_TABLE
  GL_POST_CONVOLUTION_COLOR_TABLE_SGI
  GL_POST_CONVOLUTION_GREEN_BIAS
  GL_POST_CONVOLUTION_GREEN_BIAS_EXT
  GL_POST_CONVOLUTION_GREEN_SCALE
  GL_POST_CONVOLUTION_GREEN_SCALE_EXT
  GL_POST_CONVOLUTION_RED_BIAS
  GL_POST_CONVOLUTION_RED_BIAS_EXT
  GL_POST_CONVOLUTION_RED_SCALE
  GL_POST_CONVOLUTION_RED_SCALE_EXT
  GL_POST_TEXTURE_FILTER_BIAS_RANGE_SGIX
  GL_POST_TEXTURE_FILTER_BIAS_SGIX
  GL_POST_TEXTURE_FILTER_SCALE_RANGE_SGIX
  GL_POST_TEXTURE_FILTER_SCALE_SGIX
  GL_PREFER_DOUBLEBUFFER_HINT_PGI
  GL_PRESENT_DURATION_NV
  GL_PRESENT_TIME_NV
  GL_PRESERVE_ATI
  GL_PREVIOUS
  GL_PREVIOUS_ARB
  GL_PREVIOUS_EXT
  GL_PREVIOUS_TEXTURE_INPUT_NV
  GL_PRIMARY_COLOR
  GL_PRIMARY_COLOR_ARB
  GL_PRIMARY_COLOR_EXT
  GL_PRIMARY_COLOR_NV
  GL_PRIMITIVES_GENERATED
  GL_PRIMITIVES_GENERATED_EXT
  GL_PRIMITIVES_GENERATED_NV
  GL_PRIMITIVES_GENERATED_OES
  GL_PRIMITIVES_SUBMITTED
  GL_PRIMITIVES_SUBMITTED_ARB
  GL_PRIMITIVE_BOUNDING_BOX_ARB
  GL_PRIMITIVE_BOUNDING_BOX_EXT
  GL_PRIMITIVE_ID_NV
  GL_PRIMITIVE_RESTART
  GL_PRIMITIVE_RESTART_FIXED_INDEX
  GL_PRIMITIVE_RESTART_FOR_PATCHES_SUPPORTED
  GL_PRIMITIVE_RESTART_FOR_PATCHES_SUPPORTED_OES
  GL_PRIMITIVE_RESTART_INDEX
  GL_PRIMITIVE_RESTART_INDEX_NV
  GL_PRIMITIVE_RESTART_NV
  GL_PROGRAM
  GL_PROGRAMMABLE_SAMPLE_LOCATION_ARB
  GL_PROGRAMMABLE_SAMPLE_LOCATION_NV
  GL_PROGRAMMABLE_SAMPLE_LOCATION_TABLE_SIZE_ARB
  GL_PROGRAMMABLE_SAMPLE_LOCATION_TABLE_SIZE_NV
  GL_PROGRAM_ADDRESS_REGISTERS_ARB
  GL_PROGRAM_ALU_INSTRUCTIONS_ARB
  GL_PROGRAM_ATTRIBS_ARB
  GL_PROGRAM_ATTRIB_COMPONENTS_NV
  GL_PROGRAM_BINARY_ANGLE
  GL_PROGRAM_BINARY_FORMATS
  GL_PROGRAM_BINARY_FORMATS_OES
  GL_PROGRAM_BINARY_FORMAT_MESA
  GL_PROGRAM_BINARY_LENGTH
  GL_PROGRAM_BINARY_LENGTH_OES
  GL_PROGRAM_BINARY_RETRIEVABLE_HINT
  GL_PROGRAM_BINDING_ARB
  GL_PROGRAM_ERROR_POSITION_ARB
  GL_PROGRAM_ERROR_POSITION_NV
  GL_PROGRAM_ERROR_STRING_ARB
  GL_PROGRAM_ERROR_STRING_NV
  GL_PROGRAM_FORMAT_ARB
  GL_PROGRAM_FORMAT_ASCII_ARB
  GL_PROGRAM_INPUT
  GL_PROGRAM_INSTRUCTIONS_ARB
  GL_PROGRAM_LENGTH_ARB
  GL_PROGRAM_LENGTH_NV
  GL_PROGRAM_MATRIX_EXT
  GL_PROGRAM_MATRIX_STACK_DEPTH_EXT
  GL_PROGRAM_NATIVE_ADDRESS_REGISTERS_ARB
  GL_PROGRAM_NATIVE_ALU_INSTRUCTIONS_ARB
  GL_PROGRAM_NATIVE_ATTRIBS_ARB
  GL_PROGRAM_NATIVE_INSTRUCTIONS_ARB
  GL_PROGRAM_NATIVE_PARAMETERS_ARB
  GL_PROGRAM_NATIVE_TEMPORARIES_ARB
  GL_PROGRAM_NATIVE_TEX_INDIRECTIONS_ARB
  GL_PROGRAM_NATIVE_TEX_INSTRUCTIONS_ARB
  GL_PROGRAM_OBJECT_ARB
  GL_PROGRAM_OBJECT_EXT
  GL_PROGRAM_OUTPUT
  GL_PROGRAM_PARAMETERS_ARB
  GL_PROGRAM_PARAMETER_NV
  GL_PROGRAM_PIPELINE
  GL_PROGRAM_PIPELINE_BINDING
  GL_PROGRAM_PIPELINE_OBJECT_EXT
  GL_PROGRAM_POINT_SIZE
  GL_PROGRAM_POINT_SIZE_ARB
  GL_PROGRAM_POINT_SIZE_EXT
  GL_PROGRAM_RESIDENT_NV
  GL_PROGRAM_RESULT_COMPONENTS_NV
  GL_PROGRAM_SEPARABLE
  GL_PROGRAM_STRING_ARB
  GL_PROGRAM_STRING_NV
  GL_PROGRAM_TARGET_NV
  GL_PROGRAM_TEMPORARIES_ARB
  GL_PROGRAM_TEX_INDIRECTIONS_ARB
  GL_PROGRAM_TEX_INSTRUCTIONS_ARB
  GL_PROGRAM_UNDER_NATIVE_LIMITS_ARB
  GL_PROJECTION
  GL_PROJECTION_MATRIX
  GL_PROJECTION_MATRIX_FLOAT_AS_INT_BITS_OES
  GL_PROJECTION_STACK_DEPTH
  GL_PROTECTED_MEMORY_OBJECT_EXT
  GL_PROVOKING_VERTEX
  GL_PROVOKING_VERTEX_EXT
  GL_PROXY_COLOR_TABLE
  GL_PROXY_COLOR_TABLE_SGI
  GL_PROXY_HISTOGRAM
  GL_PROXY_HISTOGRAM_EXT
  GL_PROXY_POST_COLOR_MATRIX_COLOR_TABLE
  GL_PROXY_POST_COLOR_MATRIX_COLOR_TABLE_SGI
  GL_PROXY_POST_CONVOLUTION_COLOR_TABLE
  GL_PROXY_POST_CONVOLUTION_COLOR_TABLE_SGI
  GL_PROXY_TEXTURE_1D
  GL_PROXY_TEXTURE_1D_ARRAY
  GL_PROXY_TEXTURE_1D_ARRAY_EXT
  GL_PROXY_TEXTURE_1D_EXT
  GL_PROXY_TEXTURE_1D_STACK_MESAX
  GL_PROXY_TEXTURE_2D
  GL_PROXY_TEXTURE_2D_ARRAY
  GL_PROXY_TEXTURE_2D_ARRAY_EXT
  GL_PROXY_TEXTURE_2D_EXT
  GL_PROXY_TEXTURE_2D_MULTISAMPLE
  GL_PROXY_TEXTURE_2D_MULTISAMPLE_ARRAY
  GL_PROXY_TEXTURE_2D_STACK_MESAX
  GL_PROXY_TEXTURE_3D
  GL_PROXY_TEXTURE_3D_EXT
  GL_PROXY_TEXTURE_COLOR_TABLE_SGI
  GL_PROXY_TEXTURE_CUBE_MAP
  GL_PROXY_TEXTURE_CUBE_MAP_ARB
  GL_PROXY_TEXTURE_CUBE_MAP_ARRAY
  GL_PROXY_TEXTURE_CUBE_MAP_ARRAY_ARB
  GL_PROXY_TEXTURE_CUBE_MAP_EXT
  GL_PROXY_TEXTURE_RECTANGLE
  GL_PROXY_TEXTURE_RECTANGLE_ARB
  GL_PROXY_TEXTURE_RECTANGLE_EXT
  GL_PROXY_TEXTURE_RECTANGLE_NV
  GL_PURGEABLE_APPLE
  GL_PURGED_CONTEXT_RESET_NV
  GL_PVRIC_SIGNATURE_MISMATCH_IMG
  GL_Q
  GL_QUADRATIC_ATTENUATION
  GL_QUADRATIC_CURVE_TO_NV
  GL_QUADS
  GL_QUADS_EXT
  GL_QUADS_FOLLOW_PROVOKING_VERTEX_CONVENTION
  GL_QUADS_FOLLOW_PROVOKING_VERTEX_CONVENTION_EXT
  GL_QUADS_OES
  GL_QUAD_MESH_SUN
  GL_QUAD_STRIP
  GL_QUARTER_BIT_ATI
  GL_QUERY
  GL_QUERY_ALL_EVENT_BITS_AMD
  GL_QUERY_BUFFER
  GL_QUERY_BUFFER_AMD
  GL_QUERY_BUFFER_BARRIER_BIT
  GL_QUERY_BUFFER_BINDING
  GL_QUERY_BUFFER_BINDING_AMD
  GL_QUERY_BY_REGION_NO_WAIT
  GL_QUERY_BY_REGION_NO_WAIT_INVERTED
  GL_QUERY_BY_REGION_NO_WAIT_NV
  GL_QUERY_BY_REGION_WAIT
  GL_QUERY_BY_REGION_WAIT_INVERTED
  GL_QUERY_BY_REGION_WAIT_NV
  GL_QUERY_COUNTER_BITS
  GL_QUERY_COUNTER_BITS_ANGLE
  GL_QUERY_COUNTER_BITS_ARB
  GL_QUERY_COUNTER_BITS_EXT
  GL_QUERY_DEPTH_BOUNDS_FAIL_EVENT_BIT_AMD
  GL_QUERY_DEPTH_FAIL_EVENT_BIT_AMD
  GL_QUERY_DEPTH_PASS_EVENT_BIT_AMD
  GL_QUERY_NO_WAIT
  GL_QUERY_NO_WAIT_INVERTED
  GL_QUERY_NO_WAIT_NV
  GL_QUERY_OBJECT_AMD
  GL_QUERY_OBJECT_EXT
  GL_QUERY_RESULT
  GL_QUERY_RESULT_ANGLE
  GL_QUERY_RESULT_ARB
  GL_QUERY_RESULT_AVAILABLE
  GL_QUERY_RESULT_AVAILABLE_ANGLE
  GL_QUERY_RESULT_AVAILABLE_ARB
  GL_QUERY_RESULT_AVAILABLE_EXT
  GL_QUERY_RESULT_AVAILABLE_NV
  GL_QUERY_RESULT_EXT
  GL_QUERY_RESULT_NO_WAIT
  GL_QUERY_RESULT_NO_WAIT_AMD
  GL_QUERY_RESULT_NV
  GL_QUERY_STENCIL_FAIL_EVENT_BIT_AMD
  GL_QUERY_TARGET
  GL_QUERY_WAIT
  GL_QUERY_WAIT_INVERTED
  GL_QUERY_WAIT_NV
  GL_R
  GL_R11F_G11F_B10F
  GL_R11F_G11F_B10F_APPLE
  GL_R11F_G11F_B10F_EXT
  GL_R11F_G11F_B10F_NV
  GL_R16
  GL_R16F
  GL_R16F_EXT
  GL_R16I
  GL_R16UI
  GL_R16_EXT
  GL_R16_SNORM
  GL_R16_SNORM_EXT
  GL_R1UI_C3F_V3F_SUN
  GL_R1UI_C4F_N3F_V3F_SUN
  GL_R1UI_C4UB_V3F_SUN
  GL_R1UI_N3F_V3F_SUN
  GL_R1UI_T2F_C4F_N3F_V3F_SUN
  GL_R1UI_T2F_N3F_V3F_SUN
  GL_R1UI_T2F_V3F_SUN
  GL_R1UI_V3F_SUN
  GL_R32F
  GL_R32F_EXT
  GL_R32I
  GL_R32UI
  GL_R3_G3_B2
  GL_R5_G6_B5_A8_ICC_SGIX
  GL_R5_G6_B5_ICC_SGIX
  GL_R8
  GL_R8I
  GL_R8UI
  GL_R8_EXT
  GL_R8_SNORM
  GL_RASTERIZER_DISCARD
  GL_RASTERIZER_DISCARD_EXT
  GL_RASTERIZER_DISCARD_NV
  GL_RASTER_FIXED_SAMPLE_LOCATIONS_EXT
  GL_RASTER_MULTISAMPLE_EXT
  GL_RASTER_POSITION_UNCLIPPED_IBM
  GL_RASTER_SAMPLES_EXT
  GL_READ_BUFFER
  GL_READ_BUFFER_EXT
  GL_READ_BUFFER_NV
  GL_READ_FRAMEBUFFER
  GL_READ_FRAMEBUFFER_ANGLE
  GL_READ_FRAMEBUFFER_APPLE
  GL_READ_FRAMEBUFFER_BINDING
  GL_READ_FRAMEBUFFER_BINDING_ANGLE
  GL_READ_FRAMEBUFFER_BINDING_APPLE
  GL_READ_FRAMEBUFFER_BINDING_EXT
  GL_READ_FRAMEBUFFER_BINDING_NV
  GL_READ_FRAMEBUFFER_EXT
  GL_READ_FRAMEBUFFER_NV
  GL_READ_ONLY
  GL_READ_ONLY_ARB
  GL_READ_PIXELS
  GL_READ_PIXELS_FORMAT
  GL_READ_PIXELS_TYPE
  GL_READ_PIXEL_DATA_RANGE_LENGTH_NV
  GL_READ_PIXEL_DATA_RANGE_NV
  GL_READ_PIXEL_DATA_RANGE_POINTER_NV
  GL_READ_WRITE
  GL_READ_WRITE_ARB
  GL_RECIP_ADD_SIGNED_ALPHA_IMG
  GL_RECLAIM_MEMORY_HINT_PGI
  GL_RECT_NV
  GL_RED
  GL_REDUCE
  GL_REDUCE_EXT
  GL_RED_BIAS
  GL_RED_BITS
  GL_RED_BIT_ATI
  GL_RED_EXT
  GL_RED_INTEGER
  GL_RED_INTEGER_EXT
  GL_RED_MAX_CLAMP_INGR
  GL_RED_MIN_CLAMP_INGR
  GL_RED_NV
  GL_RED_SCALE
  GL_RED_SNORM
  GL_REFERENCED_BY_COMPUTE_SHADER
  GL_REFERENCED_BY_FRAGMENT_SHADER
  GL_REFERENCED_BY_GEOMETRY_SHADER
  GL_REFERENCED_BY_GEOMETRY_SHADER_EXT
  GL_REFERENCED_BY_GEOMETRY_SHADER_OES
  GL_REFERENCED_BY_MESH_SHADER_EXT
  GL_REFERENCED_BY_MESH_SHADER_NV
  GL_REFERENCED_BY_TASK_SHADER_EXT
  GL_REFERENCED_BY_TASK_SHADER_NV
  GL_REFERENCED_BY_TESS_CONTROL_SHADER
  GL_REFERENCED_BY_TESS_CONTROL_SHADER_EXT
  GL_REFERENCED_BY_TESS_CONTROL_SHADER_OES
  GL_REFERENCED_BY_TESS_EVALUATION_SHADER
  GL_REFERENCED_BY_TESS_EVALUATION_SHADER_EXT
  GL_REFERENCED_BY_TESS_EVALUATION_SHADER_OES
  GL_REFERENCED_BY_VERTEX_SHADER
  GL_REFLECTION_MAP
  GL_REFLECTION_MAP_ARB
  GL_REFLECTION_MAP_EXT
  GL_REFLECTION_MAP_NV
  GL_REFLECTION_MAP_OES
  GL_REGISTER_COMBINERS_NV
  GL_REG_0_ATI
  GL_REG_1_ATI
  GL_REG_2_ATI
  GL_REG_3_ATI
  GL_REG_4_ATI
  GL_REG_5_ATI
  GL_RELATIVE_ARC_TO_NV
  GL_RELATIVE_CONIC_CURVE_TO_NV
  GL_RELATIVE_CUBIC_CURVE_TO_NV
  GL_RELATIVE_HORIZONTAL_LINE_TO_NV
  GL_RELATIVE_LARGE_CCW_ARC_TO_NV
  GL_RELATIVE_LARGE_CW_ARC_TO_NV
  GL_RELATIVE_LINE_TO_NV
  GL_RELATIVE_MOVE_TO_NV
  GL_RELATIVE_QUADRATIC_CURVE_TO_NV
  GL_RELATIVE_RECT_NV
  GL_RELATIVE_ROUNDED_RECT2_NV
  GL_RELATIVE_ROUNDED_RECT4_NV
  GL_RELATIVE_ROUNDED_RECT8_NV
  GL_RELATIVE_ROUNDED_RECT_NV
  GL_RELATIVE_SMALL_CCW_ARC_TO_NV
  GL_RELATIVE_SMALL_CW_ARC_TO_NV
  GL_RELATIVE_SMOOTH_CUBIC_CURVE_TO_NV
  GL_RELATIVE_SMOOTH_QUADRATIC_CURVE_TO_NV
  GL_RELATIVE_VERTICAL_LINE_TO_NV
  GL_RELEASED_APPLE
  GL_RENDER
  GL_RENDERBUFFER
  GL_RENDERBUFFER_ALPHA_SIZE
  GL_RENDERBUFFER_ALPHA_SIZE_EXT
  GL_RENDERBUFFER_ALPHA_SIZE_OES
  GL_RENDERBUFFER_BINDING
  GL_RENDERBUFFER_BINDING_EXT
  GL_RENDERBUFFER_BINDING_OES
  GL_RENDERBUFFER_BLUE_SIZE
  GL_RENDERBUFFER_BLUE_SIZE_EXT
  GL_RENDERBUFFER_BLUE_SIZE_OES
  GL_RENDERBUFFER_COLOR_SAMPLES_NV
  GL_RENDERBUFFER_COVERAGE_SAMPLES_NV
  GL_RENDERBUFFER_DEPTH_SIZE
  GL_RENDERBUFFER_DEPTH_SIZE_EXT
  GL_RENDERBUFFER_DEPTH_SIZE_OES
  GL_RENDERBUFFER_EXT
  GL_RENDERBUFFER_FREE_MEMORY_ATI
  GL_RENDERBUFFER_GREEN_SIZE
  GL_RENDERBUFFER_GREEN_SIZE_EXT
  GL_RENDERBUFFER_GREEN_SIZE_OES
  GL_RENDERBUFFER_HEIGHT
  GL_RENDERBUFFER_HEIGHT_EXT
  GL_RENDERBUFFER_HEIGHT_OES
  GL_RENDERBUFFER_INTERNAL_FORMAT
  GL_RENDERBUFFER_INTERNAL_FORMAT_EXT
  GL_RENDERBUFFER_INTERNAL_FORMAT_OES
  GL_RENDERBUFFER_OES
  GL_RENDERBUFFER_RED_SIZE
  GL_RENDERBUFFER_RED_SIZE_EXT
  GL_RENDERBUFFER_RED_SIZE_OES
  GL_RENDERBUFFER_SAMPLES
  GL_RENDERBUFFER_SAMPLES_ANGLE
  GL_RENDERBUFFER_SAMPLES_APPLE
  GL_RENDERBUFFER_SAMPLES_EXT
  GL_RENDERBUFFER_SAMPLES_IMG
  GL_RENDERBUFFER_SAMPLES_NV
  GL_RENDERBUFFER_STENCIL_SIZE
  GL_RENDERBUFFER_STENCIL_SIZE_EXT
  GL_RENDERBUFFER_STENCIL_SIZE_OES
  GL_RENDERBUFFER_STORAGE_SAMPLES_AMD
  GL_RENDERBUFFER_WIDTH
  GL_RENDERBUFFER_WIDTH_EXT
  GL_RENDERBUFFER_WIDTH_OES
  GL_RENDERER
  GL_RENDER_DIRECT_TO_FRAMEBUFFER_QCOM
  GL_RENDER_GPU_MASK_NV
  GL_RENDER_MODE
  GL_REPEAT
  GL_REPLACE
  GL_REPLACEMENT_CODE_ARRAY_POINTER_SUN
  GL_REPLACEMENT_CODE_ARRAY_STRIDE_SUN
  GL_REPLACEMENT_CODE_ARRAY_SUN
  GL_REPLACEMENT_CODE_ARRAY_TYPE_SUN
  GL_REPLACEMENT_CODE_SUN
  GL_REPLACE_EXT
  GL_REPLACE_MIDDLE_SUN
  GL_REPLACE_OLDEST_SUN
  GL_REPLACE_VALUE_AMD
  GL_REPLICATE_BORDER
  GL_REPRESENTATIVE_FRAGMENT_TEST_NV
  GL_REQUIRED_TEXTURE_IMAGE_UNITS_OES
  GL_RESAMPLE_AVERAGE_OML
  GL_RESAMPLE_DECIMATE_OML
  GL_RESAMPLE_DECIMATE_SGIX
  GL_RESAMPLE_REPLICATE_OML
  GL_RESAMPLE_REPLICATE_SGIX
  GL_RESAMPLE_ZERO_FILL_OML
  GL_RESAMPLE_ZERO_FILL_SGIX
  GL_RESCALE_NORMAL
  GL_RESCALE_NORMAL_EXT
  GL_RESET_NOTIFICATION_STRATEGY
  GL_RESET_NOTIFICATION_STRATEGY_ARB
  GL_RESET_NOTIFICATION_STRATEGY_EXT
  GL_RESTART_PATH_NV
  GL_RESTART_SUN
  GL_RETAINED_APPLE
  GL_RETURN
  GL_RG
  GL_RG16
  GL_RG16F
  GL_RG16F_EXT
  GL_RG16I
  GL_RG16UI
  GL_RG16_EXT
  GL_RG16_SNORM
  GL_RG16_SNORM_EXT
  GL_RG32F
  GL_RG32F_EXT
  GL_RG32I
  GL_RG32UI
  GL_RG8
  GL_RG8I
  GL_RG8UI
  GL_RG8_EXT
  GL_RG8_SNORM
  GL_RGB
  GL_RGB10
  GL_RGB10_A2
  GL_RGB10_A2UI
  GL_RGB10_A2_EXT
  GL_RGB10_EXT
  GL_RGB12
  GL_RGB12_EXT
  GL_RGB16
  GL_RGB16F
  GL_RGB16F_ARB
  GL_RGB16F_EXT
  GL_RGB16I
  GL_RGB16I_EXT
  GL_RGB16UI
  GL_RGB16UI_EXT
  GL_RGB16_EXT
  GL_RGB16_EXTENDED_RANGE_SGIX
  GL_RGB16_SIGNED_SGIX
  GL_RGB16_SNORM
  GL_RGB16_SNORM_EXT
  GL_RGB2_EXT
  GL_RGB32F
  GL_RGB32F_ARB
  GL_RGB32F_EXT
  GL_RGB32I
  GL_RGB32I_EXT
  GL_RGB32UI
  GL_RGB32UI_EXT
  GL_RGB4
  GL_RGB4_EXT
  GL_RGB4_S3TC
  GL_RGB5
  GL_RGB565
  GL_RGB565_OES
  GL_RGB5_A1
  GL_RGB5_A1_EXT
  GL_RGB5_A1_OES
  GL_RGB5_EXT
  GL_RGB8
  GL_RGB8I
  GL_RGB8I_EXT
  GL_RGB8UI
  GL_RGB8UI_EXT
  GL_RGB8_EXT
  GL_RGB8_OES
  GL_RGB8_SNORM
  GL_RGB9_E5
  GL_RGB9_E5_APPLE
  GL_RGB9_E5_EXT
  GL_RGBA
  GL_RGBA12
  GL_RGBA12_EXT
  GL_RGBA16
  GL_RGBA16F
  GL_RGBA16F_ARB
  GL_RGBA16F_EXT
  GL_RGBA16I
  GL_RGBA16I_EXT
  GL_RGBA16UI
  GL_RGBA16UI_EXT
  GL_RGBA16_EXT
  GL_RGBA16_EXTENDED_RANGE_SGIX
  GL_RGBA16_SIGNED_SGIX
  GL_RGBA16_SNORM
  GL_RGBA16_SNORM_EXT
  GL_RGBA2
  GL_RGBA2_EXT
  GL_RGBA32F
  GL_RGBA32F_ARB
  GL_RGBA32F_EXT
  GL_RGBA32I
  GL_RGBA32I_EXT
  GL_RGBA32UI
  GL_RGBA32UI_EXT
  GL_RGBA4
  GL_RGBA4_DXT5_S3TC
  GL_RGBA4_EXT
  GL_RGBA4_OES
  GL_RGBA4_S3TC
  GL_RGBA8
  GL_RGBA8I
  GL_RGBA8I_EXT
  GL_RGBA8UI
  GL_RGBA8UI_EXT
  GL_RGBA8_EXT
  GL_RGBA8_OES
  GL_RGBA8_SNORM
  GL_RGBA_DXT5_S3TC
  GL_RGBA_EXTENDED_RANGE_SGIX
  GL_RGBA_FLOAT16_APPLE
  GL_RGBA_FLOAT16_ATI
  GL_RGBA_FLOAT32_APPLE
  GL_RGBA_FLOAT32_ATI
  GL_RGBA_FLOAT_MODE_ARB
  GL_RGBA_ICC_SGIX
  GL_RGBA_INTEGER
  GL_RGBA_INTEGER_EXT
  GL_RGBA_INTEGER_MODE_EXT
  GL_RGBA_MODE
  GL_RGBA_S3TC
  GL_RGBA_SIGNED_COMPONENTS_EXT
  GL_RGBA_SIGNED_SGIX
  GL_RGBA_SNORM
  GL_RGBA_UNSIGNED_DOT_PRODUCT_MAPPING_NV
  GL_RGB_422_APPLE
  GL_RGB_EXTENDED_RANGE_SGIX
  GL_RGB_FLOAT16_APPLE
  GL_RGB_FLOAT16_ATI
  GL_RGB_FLOAT32_APPLE
  GL_RGB_FLOAT32_ATI
  GL_RGB_ICC_SGIX
  GL_RGB_INTEGER
  GL_RGB_INTEGER_EXT
  GL_RGB_RAW_422_APPLE
  GL_RGB_S3TC
  GL_RGB_SCALE
  GL_RGB_SCALE_ARB
  GL_RGB_SCALE_EXT
  GL_RGB_SIGNED_SGIX
  GL_RGB_SNORM
  GL_RG_EXT
  GL_RG_INTEGER
  GL_RG_SNORM
  GL_RIGHT
  GL_ROUNDED_RECT2_NV
  GL_ROUNDED_RECT4_NV
  GL_ROUNDED_RECT8_NV
  GL_ROUNDED_RECT_NV
  GL_ROUND_NV
  GL_S
  GL_SAMPLER
  GL_SAMPLER_1D
  GL_SAMPLER_1D_ARB
  GL_SAMPLER_1D_ARRAY
  GL_SAMPLER_1D_ARRAY_EXT
  GL_SAMPLER_1D_ARRAY_SHADOW
  GL_SAMPLER_1D_ARRAY_SHADOW_EXT
  GL_SAMPLER_1D_SHADOW
  GL_SAMPLER_1D_SHADOW_ARB
  GL_SAMPLER_2D
  GL_SAMPLER_2D_ARB
  GL_SAMPLER_2D_ARRAY
  GL_SAMPLER_2D_ARRAY_EXT
  GL_SAMPLER_2D_ARRAY_NV
  GL_SAMPLER_2D_ARRAY_SHADOW
  GL_SAMPLER_2D_ARRAY_SHADOW_EXT
  GL_SAMPLER_2D_ARRAY_SHADOW_NV
  GL_SAMPLER_2D_MULTISAMPLE
  GL_SAMPLER_2D_MULTISAMPLE_ARRAY
  GL_SAMPLER_2D_MULTISAMPLE_ARRAY_OES
  GL_SAMPLER_2D_RECT
  GL_SAMPLER_2D_RECT_ARB
  GL_SAMPLER_2D_RECT_SHADOW
  GL_SAMPLER_2D_RECT_SHADOW_ARB
  GL_SAMPLER_2D_SHADOW
  GL_SAMPLER_2D_SHADOW_ARB
  GL_SAMPLER_2D_SHADOW_EXT
  GL_SAMPLER_3D
  GL_SAMPLER_3D_ARB
  GL_SAMPLER_BINDING
  GL_SAMPLER_BUFFER
  GL_SAMPLER_BUFFER_AMD
  GL_SAMPLER_BUFFER_EXT
  GL_SAMPLER_BUFFER_OES
  GL_SAMPLER_CUBE
  GL_SAMPLER_CUBE_ARB
  GL_SAMPLER_CUBE_MAP_ARRAY
  GL_SAMPLER_CUBE_MAP_ARRAY_ARB
  GL_SAMPLER_CUBE_MAP_ARRAY_EXT
  GL_SAMPLER_CUBE_MAP_ARRAY_OES
  GL_SAMPLER_CUBE_MAP_ARRAY_SHADOW
  GL_SAMPLER_CUBE_MAP_ARRAY_SHADOW_ARB
  GL_SAMPLER_CUBE_MAP_ARRAY_SHADOW_EXT
  GL_SAMPLER_CUBE_MAP_ARRAY_SHADOW_OES
  GL_SAMPLER_CUBE_SHADOW
  GL_SAMPLER_CUBE_SHADOW_EXT
  GL_SAMPLER_CUBE_SHADOW_NV
  GL_SAMPLER_EXTERNAL_2D_Y2Y_EXT
  GL_SAMPLER_EXTERNAL_OES
  GL_SAMPLER_OBJECT_AMD
  GL_SAMPLER_RENDERBUFFER_NV
  GL_SAMPLES
  GL_SAMPLES_3DFX
  GL_SAMPLES_ARB
  GL_SAMPLES_EXT
  GL_SAMPLES_PASSED
  GL_SAMPLES_PASSED_ARB
  GL_SAMPLES_SGIS
  GL_SAMPLE_ALPHA_TO_COVERAGE
  GL_SAMPLE_ALPHA_TO_COVERAGE_ARB
  GL_SAMPLE_ALPHA_TO_MASK_EXT
  GL_SAMPLE_ALPHA_TO_MASK_SGIS
  GL_SAMPLE_ALPHA_TO_ONE
  GL_SAMPLE_ALPHA_TO_ONE_ARB
  GL_SAMPLE_ALPHA_TO_ONE_EXT
  GL_SAMPLE_ALPHA_TO_ONE_SGIS
  GL_SAMPLE_BUFFERS
  GL_SAMPLE_BUFFERS_3DFX
  GL_SAMPLE_BUFFERS_ARB
  GL_SAMPLE_BUFFERS_EXT
  GL_SAMPLE_BUFFERS_SGIS
  GL_SAMPLE_COUNT_BITS_NV
  GL_SAMPLE_COUNT_NV
  GL_SAMPLE_COVERAGE
  GL_SAMPLE_COVERAGE_ARB
  GL_SAMPLE_COVERAGE_INVERT
  GL_SAMPLE_COVERAGE_INVERT_ARB
  GL_SAMPLE_COVERAGE_VALUE
  GL_SAMPLE_COVERAGE_VALUE_ARB
  GL_SAMPLE_LOCATION_ARB
  GL_SAMPLE_LOCATION_NV
  GL_SAMPLE_LOCATION_PIXEL_GRID_HEIGHT_ARB
  GL_SAMPLE_LOCATION_PIXEL_GRID_HEIGHT_NV
  GL_SAMPLE_LOCATION_PIXEL_GRID_WIDTH_ARB
  GL_SAMPLE_LOCATION_PIXEL_GRID_WIDTH_NV
  GL_SAMPLE_LOCATION_SUBPIXEL_BITS_ARB
  GL_SAMPLE_LOCATION_SUBPIXEL_BITS_NV
  GL_SAMPLE_MASK
  GL_SAMPLE_MASK_EXT
  GL_SAMPLE_MASK_INVERT_EXT
  GL_SAMPLE_MASK_INVERT_SGIS
  GL_SAMPLE_MASK_NV
  GL_SAMPLE_MASK_SGIS
  GL_SAMPLE_MASK_VALUE
  GL_SAMPLE_MASK_VALUE_EXT
  GL_SAMPLE_MASK_VALUE_NV
  GL_SAMPLE_MASK_VALUE_SGIS
  GL_SAMPLE_PATTERN_EXT
  GL_SAMPLE_PATTERN_SGIS
  GL_SAMPLE_POSITION
  GL_SAMPLE_POSITION_NV
  GL_SAMPLE_SHADING
  GL_SAMPLE_SHADING_ARB
  GL_SAMPLE_SHADING_OES
  GL_SATURATE_BIT_ATI
  GL_SCALAR_EXT
  GL_SCALEBIAS_HINT_SGIX
  GL_SCALED_RESOLVE_FASTEST_EXT
  GL_SCALED_RESOLVE_NICEST_EXT
  GL_SCALE_BY_FOUR_NV
  GL_SCALE_BY_ONE_HALF_NV
  GL_SCALE_BY_TWO_NV
  GL_SCISSOR_BIT
  GL_SCISSOR_BOX
  GL_SCISSOR_BOX_EXCLUSIVE_NV
  GL_SCISSOR_COMMAND_NV
  GL_SCISSOR_TEST
  GL_SCISSOR_TEST_EXCLUSIVE_NV
  GL_SCREEN_COORDINATES_REND
  GL_SCREEN_KHR
  GL_SCREEN_NV
  GL_SECONDARY_COLOR_ARRAY
  GL_SECONDARY_COLOR_ARRAY_ADDRESS_NV
  GL_SECONDARY_COLOR_ARRAY_BUFFER_BINDING
  GL_SECONDARY_COLOR_ARRAY_BUFFER_BINDING_ARB
  GL_SECONDARY_COLOR_ARRAY_EXT
  GL_SECONDARY_COLOR_ARRAY_LENGTH_NV
  GL_SECONDARY_COLOR_ARRAY_LIST_IBM
  GL_SECONDARY_COLOR_ARRAY_LIST_STRIDE_IBM
  GL_SECONDARY_COLOR_ARRAY_POINTER
  GL_SECONDARY_COLOR_ARRAY_POINTER_EXT
  GL_SECONDARY_COLOR_ARRAY_SIZE
  GL_SECONDARY_COLOR_ARRAY_SIZE_EXT
  GL_SECONDARY_COLOR_ARRAY_STRIDE
  GL_SECONDARY_COLOR_ARRAY_STRIDE_EXT
  GL_SECONDARY_COLOR_ARRAY_TYPE
  GL_SECONDARY_COLOR_ARRAY_TYPE_EXT
  GL_SECONDARY_COLOR_ATIX
  GL_SECONDARY_COLOR_NV
  GL_SECONDARY_INTERPOLATOR_ATI
  GL_SELECT
  GL_SELECTED_TEXTURE_COORD_SET_SGIS
  GL_SELECTED_TEXTURE_SGIS
  GL_SELECTED_TEXTURE_TRANSFORM_SGIS
  GL_SELECTION_BUFFER_POINTER
  GL_SELECTION_BUFFER_SIZE
  GL_SEMAPHORE_TYPE_BINARY_NV
  GL_SEMAPHORE_TYPE_NV
  GL_SEMAPHORE_TYPE_TIMELINE_NV
  GL_SEPARABLE_2D
  GL_SEPARABLE_2D_EXT
  GL_SEPARATE_ATTRIBS
  GL_SEPARATE_ATTRIBS_EXT
  GL_SEPARATE_ATTRIBS_NV
  GL_SEPARATE_SPECULAR_COLOR
  GL_SEPARATE_SPECULAR_COLOR_EXT
  GL_SET
  GL_SET_AMD
  GL_SGX_BINARY_IMG
  GL_SGX_PROGRAM_BINARY_IMG
  GL_SHADER
  GL_SHADER_BINARY_DMP
  GL_SHADER_BINARY_FORMATS
  GL_SHADER_BINARY_FORMAT_SPIR_V
  GL_SHADER_BINARY_FORMAT_SPIR_V_ARB
  GL_SHADER_BINARY_VIV
  GL_SHADER_COMPILER
  GL_SHADER_CONSISTENT_NV
  GL_SHADER_CORE_ACTIVE_COUNT_ARM
  GL_SHADER_CORE_COUNT_ARM
  GL_SHADER_CORE_FMA_RATE_ARM
  GL_SHADER_CORE_MAX_WARP_COUNT_ARM
  GL_SHADER_CORE_PIXEL_RATE_ARM
  GL_SHADER_CORE_PRESENT_MASK_ARM
  GL_SHADER_CORE_TEXEL_RATE_ARM
  GL_SHADER_IMAGE_ACCESS_BARRIER_BIT
  GL_SHADER_IMAGE_ACCESS_BARRIER_BIT_EXT
  GL_SHADER_IMAGE_ATOMIC
  GL_SHADER_IMAGE_LOAD
  GL_SHADER_IMAGE_STORE
  GL_SHADER_INCLUDE_ARB
  GL_SHADER_OBJECT_ARB
  GL_SHADER_OBJECT_EXT
  GL_SHADER_OPERATION_NV
  GL_SHADER_PIXEL_LOCAL_STORAGE_EXT
  GL_SHADER_SOURCE_LENGTH
  GL_SHADER_STORAGE_BARRIER_BIT
  GL_SHADER_STORAGE_BLOCK
  GL_SHADER_STORAGE_BUFFER
  GL_SHADER_STORAGE_BUFFER_BINDING
  GL_SHADER_STORAGE_BUFFER_OFFSET_ALIGNMENT
  GL_SHADER_STORAGE_BUFFER_SIZE
  GL_SHADER_STORAGE_BUFFER_START
  GL_SHADER_TYPE
  GL_SHADE_MODEL
  GL_SHADING_LANGUAGE_VERSION
  GL_SHADING_LANGUAGE_VERSION_ARB
  GL_SHADING_RATE_16_INVOCATIONS_PER_PIXEL_NV
  GL_SHADING_RATE_1X1_PIXELS_EXT
  GL_SHADING_RATE_1X1_PIXELS_QCOM
  GL_SHADING_RATE_1X2_PIXELS_EXT
  GL_SHADING_RATE_1X2_PIXELS_QCOM
  GL_SHADING_RATE_1X4_PIXELS_EXT
  GL_SHADING_RATE_1_INVOCATION_PER_1X2_PIXELS_NV
  GL_SHADING_RATE_1_INVOCATION_PER_2X1_PIXELS_NV
  GL_SHADING_RATE_1_INVOCATION_PER_2X2_PIXELS_NV
  GL_SHADING_RATE_1_INVOCATION_PER_2X4_PIXELS_NV
  GL_SHADING_RATE_1_INVOCATION_PER_4X2_PIXELS_NV
  GL_SHADING_RATE_1_INVOCATION_PER_4X4_PIXELS_NV
  GL_SHADING_RATE_1_INVOCATION_PER_PIXEL_NV
  GL_SHADING_RATE_2X1_PIXELS_EXT
  GL_SHADING_RATE_2X1_PIXELS_QCOM
  GL_SHADING_RATE_2X2_PIXELS_EXT
  GL_SHADING_RATE_2X2_PIXELS_QCOM
  GL_SHADING_RATE_2X4_PIXELS_EXT
  GL_SHADING_RATE_2_INVOCATIONS_PER_PIXEL_NV
  GL_SHADING_RATE_4X1_PIXELS_EXT
  GL_SHADING_RATE_4X2_PIXELS_EXT
  GL_SHADING_RATE_4X2_PIXELS_QCOM
  GL_SHADING_RATE_4X4_PIXELS_EXT
  GL_SHADING_RATE_4X4_PIXELS_QCOM
  GL_SHADING_RATE_4_INVOCATIONS_PER_PIXEL_NV
  GL_SHADING_RATE_8_INVOCATIONS_PER_PIXEL_NV
  GL_SHADING_RATE_ATTACHMENT_EXT
  GL_SHADING_RATE_EXT
  GL_SHADING_RATE_IMAGE_BINDING_NV
  GL_SHADING_RATE_IMAGE_NV
  GL_SHADING_RATE_IMAGE_PALETTE_COUNT_NV
  GL_SHADING_RATE_IMAGE_PALETTE_SIZE_NV
  GL_SHADING_RATE_IMAGE_PER_PRIMITIVE_NV
  GL_SHADING_RATE_IMAGE_TEXEL_HEIGHT_NV
  GL_SHADING_RATE_IMAGE_TEXEL_WIDTH_NV
  GL_SHADING_RATE_NO_INVOCATIONS_NV
  GL_SHADING_RATE_PRESERVE_ASPECT_RATIO_QCOM
  GL_SHADING_RATE_QCOM
  GL_SHADING_RATE_SAMPLE_ORDER_DEFAULT_NV
  GL_SHADING_RATE_SAMPLE_ORDER_PIXEL_MAJOR_NV
  GL_SHADING_RATE_SAMPLE_ORDER_SAMPLE_MAJOR_NV
  GL_SHADOW_AMBIENT_SGIX
  GL_SHADOW_ATTENUATION_EXT
  GL_SHARED_EDGE_NV
  GL_SHARED_TEXTURE_PALETTE_EXT
  GL_SHININESS
  GL_SHORT
  GL_SIGNALED
  GL_SIGNALED_APPLE
  GL_SIGNED_ALPHA8_NV
  GL_SIGNED_ALPHA_NV
  GL_SIGNED_HILO16_NV
  GL_SIGNED_HILO8_NV
  GL_SIGNED_HILO_NV
  GL_SIGNED_IDENTITY_NV
  GL_SIGNED_INTENSITY8_NV
  GL_SIGNED_INTENSITY_NV
  GL_SIGNED_LUMINANCE8_ALPHA8_NV
  GL_SIGNED_LUMINANCE8_NV
  GL_SIGNED_LUMINANCE_ALPHA_NV
  GL_SIGNED_LUMINANCE_NV
  GL_SIGNED_NEGATE_NV
  GL_SIGNED_NORMALIZED
  GL_SIGNED_RGB8_NV
  GL_SIGNED_RGB8_UNSIGNED_ALPHA8_NV
  GL_SIGNED_RGBA8_NV
  GL_SIGNED_RGBA_NV
  GL_SIGNED_RGB_NV
  GL_SIGNED_RGB_UNSIGNED_ALPHA_NV
  GL_SIMULTANEOUS_TEXTURE_AND_DEPTH_TEST
  GL_SIMULTANEOUS_TEXTURE_AND_DEPTH_WRITE
  GL_SIMULTANEOUS_TEXTURE_AND_STENCIL_TEST
  GL_SIMULTANEOUS_TEXTURE_AND_STENCIL_WRITE
  GL_SINGLE_COLOR
  GL_SINGLE_COLOR_EXT
  GL_SKIP_DECODE_EXT
  GL_SKIP_MISSING_GLYPH_NV
  GL_SLICE_ACCUM_SUN
  GL_SLIM10U_SGIX
  GL_SLIM12S_SGIX
  GL_SLIM8U_SGIX
  GL_SLUMINANCE
  GL_SLUMINANCE8
  GL_SLUMINANCE8_ALPHA8
  GL_SLUMINANCE8_ALPHA8_EXT
  GL_SLUMINANCE8_ALPHA8_NV
  GL_SLUMINANCE8_EXT
  GL_SLUMINANCE8_NV
  GL_SLUMINANCE_ALPHA
  GL_SLUMINANCE_ALPHA_EXT
  GL_SLUMINANCE_ALPHA_NV
  GL_SLUMINANCE_EXT
  GL_SLUMINANCE_NV
  GL_SMALL_CCW_ARC_TO_NV
  GL_SMALL_CW_ARC_TO_NV
  GL_SMAPHS30_PROGRAM_BINARY_DMP
  GL_SMAPHS_PROGRAM_BINARY_DMP
  GL_SMOOTH
  GL_SMOOTH_CUBIC_CURVE_TO_NV
  GL_SMOOTH_LINE_WIDTH_GRANULARITY
  GL_SMOOTH_LINE_WIDTH_RANGE
  GL_SMOOTH_POINT_SIZE_GRANULARITY
  GL_SMOOTH_POINT_SIZE_RANGE
  GL_SMOOTH_QUADRATIC_CURVE_TO_NV
  GL_SM_COUNT_NV
  GL_SOFTLIGHT_KHR
  GL_SOFTLIGHT_NV
  GL_SOURCE0_ALPHA
  GL_SOURCE0_ALPHA_ARB
  GL_SOURCE0_ALPHA_EXT
  GL_SOURCE0_RGB
  GL_SOURCE0_RGB_ARB
  GL_SOURCE0_RGB_EXT
  GL_SOURCE1_ALPHA
  GL_SOURCE1_ALPHA_ARB
  GL_SOURCE1_ALPHA_EXT
  GL_SOURCE1_RGB
  GL_SOURCE1_RGB_ARB
  GL_SOURCE1_RGB_EXT
  GL_SOURCE2_ALPHA
  GL_SOURCE2_ALPHA_ARB
  GL_SOURCE2_ALPHA_EXT
  GL_SOURCE2_RGB
  GL_SOURCE2_RGB_ARB
  GL_SOURCE2_RGB_EXT
  GL_SOURCE3_ALPHA_NV
  GL_SOURCE3_RGB_NV
  GL_SPARE0_NV
  GL_SPARE0_PLUS_SECONDARY_COLOR_NV
  GL_SPARE1_NV
  GL_SPARSE_BUFFER_PAGE_SIZE_ARB
  GL_SPARSE_STORAGE_BIT_ARB
  GL_SPARSE_TEXTURE_FULL_ARRAY_CUBE_MIPMAPS_ARB
  GL_SPARSE_TEXTURE_FULL_ARRAY_CUBE_MIPMAPS_EXT
  GL_SPECULAR
  GL_SPHERE_MAP
  GL_SPIR_V_BINARY
  GL_SPIR_V_BINARY_ARB
  GL_SPIR_V_EXTENSIONS
  GL_SPOT_CUTOFF
  GL_SPOT_CUTOFF_DELTA_SGIX
  GL_SPOT_DIRECTION
  GL_SPOT_EXPONENT
  GL_SQUARE_NV
  GL_SR8_EXT
  GL_SRC0_ALPHA
  GL_SRC0_RGB
  GL_SRC1_ALPHA
  GL_SRC1_ALPHA_EXT
  GL_SRC1_COLOR
  GL_SRC1_COLOR_EXT
  GL_SRC1_RGB
  GL_SRC2_ALPHA
  GL_SRC2_RGB
  GL_SRC_ALPHA
  GL_SRC_ALPHA_SATURATE
  GL_SRC_ALPHA_SATURATE_EXT
  GL_SRC_ATOP_NV
  GL_SRC_COLOR
  GL_SRC_IN_NV
  GL_SRC_NV
  GL_SRC_OUT_NV
  GL_SRC_OVER_NV
  GL_SRG8_EXT
  GL_SRGB
  GL_SRGB8
  GL_SRGB8_ALPHA8
  GL_SRGB8_ALPHA8_EXT
  GL_SRGB8_EXT
  GL_SRGB8_NV
  GL_SRGB_ALPHA
  GL_SRGB_ALPHA_EXT
  GL_SRGB_DECODE_ARB
  GL_SRGB_EXT
  GL_SRGB_READ
  GL_SRGB_WRITE
  GL_STACK_OVERFLOW
  GL_STACK_UNDERFLOW
  GL_STANDARD_FONT_FORMAT_NV
  GL_STANDARD_FONT_NAME_NV
  GL_STATE_RESTORE
  GL_STATIC_ATI
  GL_STATIC_COPY
  GL_STATIC_COPY_ARB
  GL_STATIC_DRAW
  GL_STATIC_DRAW_ARB
  GL_STATIC_READ
  GL_STATIC_READ_ARB
  GL_STATIC_VERTEX_ARRAY_IBM
  GL_STATISTICS_REGAL
  GL_STENCIL
  GL_STENCIL_ATTACHMENT
  GL_STENCIL_ATTACHMENT_EXT
  GL_STENCIL_ATTACHMENT_OES
  GL_STENCIL_BACK_FAIL
  GL_STENCIL_BACK_FAIL_ATI
  GL_STENCIL_BACK_FUNC
  GL_STENCIL_BACK_FUNC_ATI
  GL_STENCIL_BACK_OP_VALUE_AMD
  GL_STENCIL_BACK_PASS_DEPTH_FAIL
  GL_STENCIL_BACK_PASS_DEPTH_FAIL_ATI
  GL_STENCIL_BACK_PASS_DEPTH_PASS
  GL_STENCIL_BACK_PASS_DEPTH_PASS_ATI
  GL_STENCIL_BACK_REF
  GL_STENCIL_BACK_VALUE_MASK
  GL_STENCIL_BACK_WRITEMASK
  GL_STENCIL_BITS
  GL_STENCIL_BUFFER
  GL_STENCIL_BUFFER_BIT
  GL_STENCIL_BUFFER_BIT0_QCOM
  GL_STENCIL_BUFFER_BIT1_QCOM
  GL_STENCIL_BUFFER_BIT2_QCOM
  GL_STENCIL_BUFFER_BIT3_QCOM
  GL_STENCIL_BUFFER_BIT4_QCOM
  GL_STENCIL_BUFFER_BIT5_QCOM
  GL_STENCIL_BUFFER_BIT6_QCOM
  GL_STENCIL_BUFFER_BIT7_QCOM
  GL_STENCIL_CLEAR_TAG_VALUE_EXT
  GL_STENCIL_CLEAR_VALUE
  GL_STENCIL_COMPONENTS
  GL_STENCIL_EXT
  GL_STENCIL_FAIL
  GL_STENCIL_FUNC
  GL_STENCIL_INDEX
  GL_STENCIL_INDEX1
  GL_STENCIL_INDEX16
  GL_STENCIL_INDEX16_EXT
  GL_STENCIL_INDEX1_EXT
  GL_STENCIL_INDEX1_OES
  GL_STENCIL_INDEX4
  GL_STENCIL_INDEX4_EXT
  GL_STENCIL_INDEX4_OES
  GL_STENCIL_INDEX8
  GL_STENCIL_INDEX8_EXT
  GL_STENCIL_INDEX8_OES
  GL_STENCIL_OP_VALUE_AMD
  GL_STENCIL_PASS_DEPTH_FAIL
  GL_STENCIL_PASS_DEPTH_PASS
  GL_STENCIL_REF
  GL_STENCIL_REF_COMMAND_NV
  GL_STENCIL_RENDERABLE
  GL_STENCIL_SAMPLES_NV
  GL_STENCIL_TAG_BITS_EXT
  GL_STENCIL_TEST
  GL_STENCIL_TEST_TWO_SIDE_EXT
  GL_STENCIL_VALUE_MASK
  GL_STENCIL_WRITEMASK
  GL_STEREO
  GL_STEREO_CONVERGENCE_NV
  GL_STEREO_CUTOFF_NV
  GL_STEREO_PROJECTION_NV
  GL_STEREO_PROJECTION_ORTHO_NV
  GL_STEREO_PROJECTION_PERSPECTIVE_NV
  GL_STEREO_SEPARATION_NV
  GL_STORAGE_CACHED_APPLE
  GL_STORAGE_CLIENT_APPLE
  GL_STORAGE_PRIVATE_APPLE
  GL_STORAGE_SHARED_APPLE
  GL_STREAM_COPY
  GL_STREAM_COPY_ARB
  GL_STREAM_DRAW
  GL_STREAM_DRAW_ARB
  GL_STREAM_RASTERIZATION_AMD
  GL_STREAM_READ
  GL_STREAM_READ_ARB
  GL_STRICT_DEPTHFUNC_HINT_PGI
  GL_STRICT_LIGHTING_HINT_PGI
  GL_STRICT_SCISSOR_HINT_PGI
  GL_SUBGROUP_FEATURE_ARITHMETIC_BIT_KHR
  GL_SUBGROUP_FEATURE_BALLOT_BIT_KHR
  GL_SUBGROUP_FEATURE_BASIC_BIT_KHR
  GL_SUBGROUP_FEATURE_CLUSTERED_BIT_KHR
  GL_SUBGROUP_FEATURE_PARTITIONED_BIT_NV
  GL_SUBGROUP_FEATURE_QUAD_BIT_KHR
  GL_SUBGROUP_FEATURE_SHUFFLE_BIT_KHR
  GL_SUBGROUP_FEATURE_SHUFFLE_RELATIVE_BIT_KHR
  GL_SUBGROUP_FEATURE_VOTE_BIT_KHR
  GL_SUBGROUP_QUAD_ALL_STAGES_KHR
  GL_SUBGROUP_SIZE_KHR
  GL_SUBGROUP_SUPPORTED_FEATURES_KHR
  GL_SUBGROUP_SUPPORTED_STAGES_KHR
  GL_SUBPIXEL_BITS
  GL_SUBPIXEL_PRECISION_BIAS_X_BITS_NV
  GL_SUBPIXEL_PRECISION_BIAS_Y_BITS_NV
  GL_SUBSAMPLE_DISTANCE_AMD
  GL_SUBTRACT
  GL_SUBTRACT_ARB
  GL_SUB_ATI
  GL_SUCCESS_NV
  GL_SUPERSAMPLE_SCALE_X_NV
  GL_SUPERSAMPLE_SCALE_Y_NV
  GL_SUPPORTED_MULTISAMPLE_MODES_AMD
  GL_SURFACE_COMPRESSION_EXT
  GL_SURFACE_COMPRESSION_FIXED_RATE_10BPC_EXT
  GL_SURFACE_COMPRESSION_FIXED_RATE_11BPC_EXT
  GL_SURFACE_COMPRESSION_FIXED_RATE_12BPC_EXT
  GL_SURFACE_COMPRESSION_FIXED_RATE_1BPC_EXT
  GL_SURFACE_COMPRESSION_FIXED_RATE_2BPC_EXT
  GL_SURFACE_COMPRESSION_FIXED_RATE_3BPC_EXT
  GL_SURFACE_COMPRESSION_FIXED_RATE_4BPC_EXT
  GL_SURFACE_COMPRESSION_FIXED_RATE_5BPC_EXT
  GL_SURFACE_COMPRESSION_FIXED_RATE_6BPC_EXT
  GL_SURFACE_COMPRESSION_FIXED_RATE_7BPC_EXT
  GL_SURFACE_COMPRESSION_FIXED_RATE_8BPC_EXT
  GL_SURFACE_COMPRESSION_FIXED_RATE_9BPC_EXT
  GL_SURFACE_COMPRESSION_FIXED_RATE_DEFAULT_EXT
  GL_SURFACE_COMPRESSION_FIXED_RATE_NONE_EXT
  GL_SURFACE_MAPPED_NV
  GL_SURFACE_REGISTERED_NV
  GL_SURFACE_STATE_NV
  GL_SWIZZLE_STQ_ATI
  GL_SWIZZLE_STQ_DQ_ATI
  GL_SWIZZLE_STRQ_ATI
  GL_SWIZZLE_STRQ_DQ_ATI
  GL_SWIZZLE_STR_ATI
  GL_SWIZZLE_STR_DR_ATI
  GL_SYNC_CL_EVENT_ARB
  GL_SYNC_CL_EVENT_COMPLETE_ARB
  GL_SYNC_CONDITION
  GL_SYNC_CONDITION_APPLE
  GL_SYNC_FENCE
  GL_SYNC_FENCE_APPLE
  GL_SYNC_FLAGS
  GL_SYNC_FLAGS_APPLE
  GL_SYNC_FLUSH_COMMANDS_BIT
  GL_SYNC_FLUSH_COMMANDS_BIT_APPLE
  GL_SYNC_GPU_COMMANDS_COMPLETE
  GL_SYNC_GPU_COMMANDS_COMPLETE_APPLE
  GL_SYNC_OBJECT_APPLE
  GL_SYNC_STATUS
  GL_SYNC_STATUS_APPLE
  GL_SYNC_X11_FENCE_EXT
  GL_SYSTEM_FONT_NAME_NV
  GL_T
  GL_T2F_C3F_V3F
  GL_T2F_C4F_N3F_V3F
  GL_T2F_C4UB_V3F
  GL_T2F_N3F_V3F
  GL_T2F_V3F
  GL_T4F_C4F_N3F_V4F
  GL_T4F_V4F
  GL_TABLE_TOO_LARGE
  GL_TANGENT_ARRAY_EXT
  GL_TANGENT_ARRAY_POINTER_EXT
  GL_TANGENT_ARRAY_STRIDE_EXT
  GL_TANGENT_ARRAY_TYPE_EXT
  GL_TANGENT_SPACE_SGIX
  GL_TASK_SHADER_BIT_EXT
  GL_TASK_SHADER_BIT_NV
  GL_TASK_SHADER_EXT
  GL_TASK_SHADER_INVOCATIONS_EXT
  GL_TASK_SHADER_NV
  GL_TASK_SUBROUTINE_EXT
  GL_TASK_SUBROUTINE_NV
  GL_TASK_SUBROUTINE_UNIFORM_EXT
  GL_TASK_SUBROUTINE_UNIFORM_NV
  GL_TASK_WORK_GROUP_SIZE_EXT
  GL_TASK_WORK_GROUP_SIZE_NV
  GL_TERMINATE_SEQUENCE_COMMAND_NV
  GL_TESSELLATION_FACTOR_AMD
  GL_TESSELLATION_MODE_AMD
  GL_TESS_CONTROL_OUTPUT_VERTICES
  GL_TESS_CONTROL_OUTPUT_VERTICES_EXT
  GL_TESS_CONTROL_OUTPUT_VERTICES_OES
  GL_TESS_CONTROL_PROGRAM_NV
  GL_TESS_CONTROL_PROGRAM_PARAMETER_BUFFER_NV
  GL_TESS_CONTROL_SHADER
  GL_TESS_CONTROL_SHADER_BIT
  GL_TESS_CONTROL_SHADER_BIT_EXT
  GL_TESS_CONTROL_SHADER_BIT_OES
  GL_TESS_CONTROL_SHADER_EXT
  GL_TESS_CONTROL_SHADER_OES
  GL_TESS_CONTROL_SHADER_PATCHES
  GL_TESS_CONTROL_SHADER_PATCHES_ARB
  GL_TESS_CONTROL_SUBROUTINE
  GL_TESS_CONTROL_SUBROUTINE_UNIFORM
  GL_TESS_CONTROL_TEXTURE
  GL_TESS_EVALUATION_PROGRAM_NV
  GL_TESS_EVALUATION_PROGRAM_PARAMETER_BUFFER_NV
  GL_TESS_EVALUATION_SHADER
  GL_TESS_EVALUATION_SHADER_BIT
  GL_TESS_EVALUATION_SHADER_BIT_EXT
  GL_TESS_EVALUATION_SHADER_BIT_OES
  GL_TESS_EVALUATION_SHADER_EXT
  GL_TESS_EVALUATION_SHADER_INVOCATIONS
  GL_TESS_EVALUATION_SHADER_INVOCATIONS_ARB
  GL_TESS_EVALUATION_SHADER_OES
  GL_TESS_EVALUATION_SUBROUTINE
  GL_TESS_EVALUATION_SUBROUTINE_UNIFORM
  GL_TESS_EVALUATION_TEXTURE
  GL_TESS_GEN_MODE
  GL_TESS_GEN_MODE_EXT
  GL_TESS_GEN_MODE_OES
  GL_TESS_GEN_POINT_MODE
  GL_TESS_GEN_POINT_MODE_EXT
  GL_TESS_GEN_POINT_MODE_OES
  GL_TESS_GEN_SPACING
  GL_TESS_GEN_SPACING_EXT
  GL_TESS_GEN_SPACING_OES
  GL_TESS_GEN_VERTEX_ORDER
  GL_TESS_GEN_VERTEX_ORDER_EXT
  GL_TESS_GEN_VERTEX_ORDER_OES
  GL_TEXCOORD1_BIT_PGI
  GL_TEXCOORD2_BIT_PGI
  GL_TEXCOORD3_BIT_PGI
  GL_TEXCOORD4_BIT_PGI
  GL_TEXTURE
  GL_TEXTURE0
  GL_TEXTURE0_ARB
  GL_TEXTURE0_SGIS
  GL_TEXTURE1
  GL_TEXTURE10
  GL_TEXTURE10_ARB
  GL_TEXTURE11
  GL_TEXTURE11_ARB
  GL_TEXTURE12
  GL_TEXTURE12_ARB
  GL_TEXTURE13
  GL_TEXTURE13_ARB
  GL_TEXTURE14
  GL_TEXTURE14_ARB
  GL_TEXTURE15
  GL_TEXTURE15_ARB
  GL_TEXTURE16
  GL_TEXTURE16_ARB
  GL_TEXTURE17
  GL_TEXTURE17_ARB
  GL_TEXTURE18
  GL_TEXTURE18_ARB
  GL_TEXTURE19
  GL_TEXTURE19_ARB
  GL_TEXTURE1_ARB
  GL_TEXTURE1_SGIS
  GL_TEXTURE2
  GL_TEXTURE20
  GL_TEXTURE20_ARB
  GL_TEXTURE21
  GL_TEXTURE21_ARB
  GL_TEXTURE22
  GL_TEXTURE22_ARB
  GL_TEXTURE23
  GL_TEXTURE23_ARB
  GL_TEXTURE24
  GL_TEXTURE24_ARB
  GL_TEXTURE25
  GL_TEXTURE25_ARB
  GL_TEXTURE26
  GL_TEXTURE26_ARB
  GL_TEXTURE27
  GL_TEXTURE27_ARB
  GL_TEXTURE28
  GL_TEXTURE28_ARB
  GL_TEXTURE29
  GL_TEXTURE29_ARB
  GL_TEXTURE2_ARB
  GL_TEXTURE2_SGIS
  GL_TEXTURE3
  GL_TEXTURE30
  GL_TEXTURE30_ARB
  GL_TEXTURE31
  GL_TEXTURE31_ARB
  GL_TEXTURE3_ARB
  GL_TEXTURE3_SGIS
  GL_TEXTURE4
  GL_TEXTURE4_ARB
  GL_TEXTURE5
  GL_TEXTURE5_ARB
  GL_TEXTURE6
  GL_TEXTURE6_ARB
  GL_TEXTURE7
  GL_TEXTURE7_ARB
  GL_TEXTURE8
  GL_TEXTURE8_ARB
  GL_TEXTURE9
  GL_TEXTURE9_ARB
  GL_TEXTURE_1D
  GL_TEXTURE_1D_ARRAY
  GL_TEXTURE_1D_ARRAY_EXT
  GL_TEXTURE_1D_BINDING_EXT
  GL_TEXTURE_1D_STACK_BINDING_MESAX
  GL_TEXTURE_1D_STACK_MESAX
  GL_TEXTURE_2D
  GL_TEXTURE_2D_ARRAY
  GL_TEXTURE_2D_ARRAY_EXT
  GL_TEXTURE_2D_ARRAY_NV
  GL_TEXTURE_2D_BINDING_EXT
  GL_TEXTURE_2D_MULTISAMPLE
  GL_TEXTURE_2D_MULTISAMPLE_ARRAY
  GL_TEXTURE_2D_MULTISAMPLE_ARRAY_OES
  GL_TEXTURE_2D_STACK_BINDING_MESAX
  GL_TEXTURE_2D_STACK_MESAX
  GL_TEXTURE_3D
  GL_TEXTURE_3D_BINDING_EXT
  GL_TEXTURE_3D_EXT
  GL_TEXTURE_3D_OES
  GL_TEXTURE_ALPHA_MODULATE_IMG
  GL_TEXTURE_ALPHA_SIZE
  GL_TEXTURE_ALPHA_SIZE_EXT
  GL_TEXTURE_ALPHA_TYPE
  GL_TEXTURE_ALPHA_TYPE_ARB
  GL_TEXTURE_APPLICATION_MODE_EXT
  GL_TEXTURE_ASTC_DECODE_PRECISION_EXT
  GL_TEXTURE_BASE_LEVEL
  GL_TEXTURE_BASE_LEVEL_SGIS
  GL_TEXTURE_BINDING_1D
  GL_TEXTURE_BINDING_1D_ARRAY
  GL_TEXTURE_BINDING_1D_ARRAY_EXT
  GL_TEXTURE_BINDING_2D
  GL_TEXTURE_BINDING_2D_ARRAY
  GL_TEXTURE_BINDING_2D_ARRAY_EXT
  GL_TEXTURE_BINDING_2D_ARRAY_NV
  GL_TEXTURE_BINDING_2D_MULTISAMPLE
  GL_TEXTURE_BINDING_2D_MULTISAMPLE_ARRAY
  GL_TEXTURE_BINDING_2D_MULTISAMPLE_ARRAY_OES
  GL_TEXTURE_BINDING_3D
  GL_TEXTURE_BINDING_3D_OES
  GL_TEXTURE_BINDING_BUFFER
  GL_TEXTURE_BINDING_BUFFER_ARB
  GL_TEXTURE_BINDING_BUFFER_EXT
  GL_TEXTURE_BINDING_BUFFER_OES
  GL_TEXTURE_BINDING_CUBE_MAP
  GL_TEXTURE_BINDING_CUBE_MAP_ARB
  GL_TEXTURE_BINDING_CUBE_MAP_ARRAY
  GL_TEXTURE_BINDING_CUBE_MAP_ARRAY_ARB
  GL_TEXTURE_BINDING_CUBE_MAP_ARRAY_EXT
  GL_TEXTURE_BINDING_CUBE_MAP_ARRAY_OES
  GL_TEXTURE_BINDING_CUBE_MAP_EXT
  GL_TEXTURE_BINDING_CUBE_MAP_OES
  GL_TEXTURE_BINDING_EXTERNAL_OES
  GL_TEXTURE_BINDING_RECTANGLE
  GL_TEXTURE_BINDING_RECTANGLE_ARB
  GL_TEXTURE_BINDING_RECTANGLE_EXT
  GL_TEXTURE_BINDING_RECTANGLE_NV
  GL_TEXTURE_BINDING_RENDERBUFFER_NV
  GL_TEXTURE_BIT
  GL_TEXTURE_BLUE_SIZE
  GL_TEXTURE_BLUE_SIZE_EXT
  GL_TEXTURE_BLUE_TYPE
  GL_TEXTURE_BLUE_TYPE_ARB
  GL_TEXTURE_BORDER
  GL_TEXTURE_BORDER_COLOR
  GL_TEXTURE_BORDER_COLOR_EXT
  GL_TEXTURE_BORDER_COLOR_NV
  GL_TEXTURE_BORDER_COLOR_OES
  GL_TEXTURE_BORDER_VALUES_NV
  GL_TEXTURE_BUFFER
  GL_TEXTURE_BUFFER_ARB
  GL_TEXTURE_BUFFER_BINDING
  GL_TEXTURE_BUFFER_BINDING_EXT
  GL_TEXTURE_BUFFER_BINDING_OES
  GL_TEXTURE_BUFFER_DATA_STORE_BINDING
  GL_TEXTURE_BUFFER_DATA_STORE_BINDING_ARB
  GL_TEXTURE_BUFFER_DATA_STORE_BINDING_EXT
  GL_TEXTURE_BUFFER_DATA_STORE_BINDING_OES
  GL_TEXTURE_BUFFER_EXT
  GL_TEXTURE_BUFFER_FORMAT
  GL_TEXTURE_BUFFER_FORMAT_ARB
  GL_TEXTURE_BUFFER_FORMAT_EXT
  GL_TEXTURE_BUFFER_OES
  GL_TEXTURE_BUFFER_OFFSET
  GL_TEXTURE_BUFFER_OFFSET_ALIGNMENT
  GL_TEXTURE_BUFFER_OFFSET_ALIGNMENT_EXT
  GL_TEXTURE_BUFFER_OFFSET_ALIGNMENT_OES
  GL_TEXTURE_BUFFER_OFFSET_EXT
  GL_TEXTURE_BUFFER_OFFSET_OES
  GL_TEXTURE_BUFFER_SIZE
  GL_TEXTURE_BUFFER_SIZE_EXT
  GL_TEXTURE_BUFFER_SIZE_OES
  GL_TEXTURE_CBCR_DEGAMMA_QCOM
  GL_TEXTURE_COLOR_SAMPLES_NV
  GL_TEXTURE_COLOR_TABLE_SGI
  GL_TEXTURE_COMPARE_FAIL_VALUE_ARB
  GL_TEXTURE_COMPARE_FUNC
  GL_TEXTURE_COMPARE_FUNC_ARB
  GL_TEXTURE_COMPARE_FUNC_EXT
  GL_TEXTURE_COMPARE_MODE
  GL_TEXTURE_COMPARE_MODE_ARB
  GL_TEXTURE_COMPARE_MODE_EXT
  GL_TEXTURE_COMPARE_OPERATOR_SGIX
  GL_TEXTURE_COMPARE_SGIX
  GL_TEXTURE_COMPONENTS
  GL_TEXTURE_COMPRESSED
  GL_TEXTURE_COMPRESSED_ARB
  GL_TEXTURE_COMPRESSED_BLOCK_HEIGHT
  GL_TEXTURE_COMPRESSED_BLOCK_SIZE
  GL_TEXTURE_COMPRESSED_BLOCK_WIDTH
  GL_TEXTURE_COMPRESSED_IMAGE_SIZE
  GL_TEXTURE_COMPRESSED_IMAGE_SIZE_ARB
  GL_TEXTURE_COMPRESSION_HINT
  GL_TEXTURE_COMPRESSION_HINT_ARB
  GL_TEXTURE_CONSTANT_DATA_SUNX
  GL_TEXTURE_COORD_ARRAY
  GL_TEXTURE_COORD_ARRAY_ADDRESS_NV
  GL_TEXTURE_COORD_ARRAY_BUFFER_BINDING
  GL_TEXTURE_COORD_ARRAY_BUFFER_BINDING_ARB
  GL_TEXTURE_COORD_ARRAY_COUNT_EXT
  GL_TEXTURE_COORD_ARRAY_EXT
  GL_TEXTURE_COORD_ARRAY_LENGTH_NV
  GL_TEXTURE_COORD_ARRAY_LIST_IBM
  GL_TEXTURE_COORD_ARRAY_LIST_STRIDE_IBM
  GL_TEXTURE_COORD_ARRAY_PARALLEL_POINTERS_INTEL
  GL_TEXTURE_COORD_ARRAY_POINTER
  GL_TEXTURE_COORD_ARRAY_POINTER_EXT
  GL_TEXTURE_COORD_ARRAY_SIZE
  GL_TEXTURE_COORD_ARRAY_SIZE_EXT
  GL_TEXTURE_COORD_ARRAY_STRIDE
  GL_TEXTURE_COORD_ARRAY_STRIDE_EXT
  GL_TEXTURE_COORD_ARRAY_TYPE
  GL_TEXTURE_COORD_ARRAY_TYPE_EXT
  GL_TEXTURE_COORD_NV
  GL_TEXTURE_COORD_SET_INTERLEAVE_FACTOR_SGIS
  GL_TEXTURE_COVERAGE_SAMPLES_NV
  GL_TEXTURE_CROP_RECT_OES
  GL_TEXTURE_CUBE_MAP
  GL_TEXTURE_CUBE_MAP_ARB
  GL_TEXTURE_CUBE_MAP_ARRAY
  GL_TEXTURE_CUBE_MAP_ARRAY_ARB
  GL_TEXTURE_CUBE_MAP_ARRAY_EXT
  GL_TEXTURE_CUBE_MAP_ARRAY_OES
  GL_TEXTURE_CUBE_MAP_EXT
  GL_TEXTURE_CUBE_MAP_NEGATIVE_X
  GL_TEXTURE_CUBE_MAP_NEGATIVE_X_ARB
  GL_TEXTURE_CUBE_MAP_NEGATIVE_X_EXT
  GL_TEXTURE_CUBE_MAP_NEGATIVE_X_OES
  GL_TEXTURE_CUBE_MAP_NEGATIVE_Y
  GL_TEXTURE_CUBE_MAP_NEGATIVE_Y_ARB
  GL_TEXTURE_CUBE_MAP_NEGATIVE_Y_EXT
  GL_TEXTURE_CUBE_MAP_NEGATIVE_Y_OES
  GL_TEXTURE_CUBE_MAP_NEGATIVE_Z
  GL_TEXTURE_CUBE_MAP_NEGATIVE_Z_ARB
  GL_TEXTURE_CUBE_MAP_NEGATIVE_Z_EXT
  GL_TEXTURE_CUBE_MAP_NEGATIVE_Z_OES
  GL_TEXTURE_CUBE_MAP_OES
  GL_TEXTURE_CUBE_MAP_POSITIVE_X
  GL_TEXTURE_CUBE_MAP_POSITIVE_X_ARB
  GL_TEXTURE_CUBE_MAP_POSITIVE_X_EXT
  GL_TEXTURE_CUBE_MAP_POSITIVE_X_OES
  GL_TEXTURE_CUBE_MAP_POSITIVE_Y
  GL_TEXTURE_CUBE_MAP_POSITIVE_Y_ARB
  GL_TEXTURE_CUBE_MAP_POSITIVE_Y_EXT
  GL_TEXTURE_CUBE_MAP_POSITIVE_Y_OES
  GL_TEXTURE_CUBE_MAP_POSITIVE_Z
  GL_TEXTURE_CUBE_MAP_POSITIVE_Z_ARB
  GL_TEXTURE_CUBE_MAP_POSITIVE_Z_EXT
  GL_TEXTURE_CUBE_MAP_POSITIVE_Z_OES
  GL_TEXTURE_CUBE_MAP_SEAMLESS
  GL_TEXTURE_DEFORMATION_BIT_SGIX
  GL_TEXTURE_DEPTH
  GL_TEXTURE_DEPTH_EXT
  GL_TEXTURE_DEPTH_QCOM
  GL_TEXTURE_DEPTH_SIZE
  GL_TEXTURE_DEPTH_SIZE_ARB
  GL_TEXTURE_DEPTH_TYPE
  GL_TEXTURE_DEPTH_TYPE_ARB
  GL_TEXTURE_DS_SIZE_NV
  GL_TEXTURE_DT_SIZE_NV
  GL_TEXTURE_ENV
  GL_TEXTURE_ENV_COLOR
  GL_TEXTURE_ENV_COORD_SET_SGIS
  GL_TEXTURE_ENV_MODE
  GL_TEXTURE_EXTERNAL_OES
  GL_TEXTURE_FETCH_BARRIER_BIT
  GL_TEXTURE_FETCH_BARRIER_BIT_EXT
  GL_TEXTURE_FILTER_CONTROL
  GL_TEXTURE_FILTER_CONTROL_EXT
  GL_TEXTURE_FIXED_SAMPLE_LOCATIONS
  GL_TEXTURE_FLOAT_COMPONENTS_NV
  GL_TEXTURE_FORMAT_QCOM
  GL_TEXTURE_FORMAT_SRGB_OVERRIDE_EXT
  GL_TEXTURE_FOVEATED_CUTOFF_DENSITY_QCOM
  GL_TEXTURE_FOVEATED_FEATURE_BITS_QCOM
  GL_TEXTURE_FOVEATED_FEATURE_QUERY_QCOM
  GL_TEXTURE_FOVEATED_MIN_PIXEL_DENSITY_QCOM
  GL_TEXTURE_FOVEATED_NUM_FOCAL_POINTS_QUERY_QCOM
  GL_TEXTURE_FREE_MEMORY_ATI
  GL_TEXTURE_GATHER
  GL_TEXTURE_GATHER_SHADOW
  GL_TEXTURE_GEN_MODE
  GL_TEXTURE_GEN_MODE_OES
  GL_TEXTURE_GEN_Q
  GL_TEXTURE_GEN_R
  GL_TEXTURE_GEN_S
  GL_TEXTURE_GEN_STR_OES
  GL_TEXTURE_GEN_T
  GL_TEXTURE_GEQUAL_R_SGIX
  GL_TEXTURE_GREEN_SIZE
  GL_TEXTURE_GREEN_SIZE_EXT
  GL_TEXTURE_GREEN_TYPE
  GL_TEXTURE_GREEN_TYPE_ARB
  GL_TEXTURE_HEIGHT
  GL_TEXTURE_HEIGHT_QCOM
  GL_TEXTURE_HI_SIZE_NV
  GL_TEXTURE_IMAGE_FORMAT
  GL_TEXTURE_IMAGE_TYPE
  GL_TEXTURE_IMAGE_VALID_QCOM
  GL_TEXTURE_IMMUTABLE_FORMAT
  GL_TEXTURE_IMMUTABLE_FORMAT_EXT
  GL_TEXTURE_IMMUTABLE_LEVELS
  GL_TEXTURE_INDEX_SIZE_EXT
  GL_TEXTURE_INTENSITY_SIZE
  GL_TEXTURE_INTENSITY_SIZE_EXT
  GL_TEXTURE_INTENSITY_TYPE
  GL_TEXTURE_INTENSITY_TYPE_ARB
  GL_TEXTURE_INTERNAL_FORMAT
  GL_TEXTURE_INTERNAL_FORMAT_QCOM
  GL_TEXTURE_LEQUAL_R_SGIX
  GL_TEXTURE_LIGHT_EXT
  GL_TEXTURE_LOD_BIAS
  GL_TEXTURE_LOD_BIAS_EXT
  GL_TEXTURE_LOD_BIAS_QCOM
  GL_TEXTURE_LO_SIZE_NV
  GL_TEXTURE_LUMINANCE_SIZE
  GL_TEXTURE_LUMINANCE_SIZE_EXT
  GL_TEXTURE_LUMINANCE_TYPE
  GL_TEXTURE_LUMINANCE_TYPE_ARB
  GL_TEXTURE_MAG_FILTER
  GL_TEXTURE_MAG_SIZE_NV
  GL_TEXTURE_MATERIAL_FACE_EXT
  GL_TEXTURE_MATERIAL_PARAMETER_EXT
  GL_TEXTURE_MATRIX
  GL_TEXTURE_MATRIX_FLOAT_AS_INT_BITS_OES
  GL_TEXTURE_MAX_ANISOTROPY
  GL_TEXTURE_MAX_ANISOTROPY_EXT
  GL_TEXTURE_MAX_CLAMP_R_SGIX
  GL_TEXTURE_MAX_CLAMP_S_SGIX
  GL_TEXTURE_MAX_CLAMP_T_SGIX
  GL_TEXTURE_MAX_LEVEL
  GL_TEXTURE_MAX_LEVEL_APPLE
  GL_TEXTURE_MAX_LEVEL_SGIS
  GL_TEXTURE_MAX_LOD
  GL_TEXTURE_MAX_LOD_SGIS
  GL_TEXTURE_MEMORY_LAYOUT_INTEL
  GL_TEXTURE_MIN_FILTER
  GL_TEXTURE_MIN_LOD
  GL_TEXTURE_MIN_LOD_SGIS
  GL_TEXTURE_MIPMAP_ANISOTROPY_SGIX
  GL_TEXTURE_MULTI_BUFFER_HINT_SGIX
  GL_TEXTURE_NORMAL_EXT
  GL_TEXTURE_NUM_LEVELS_QCOM
  GL_TEXTURE_OBJECT_VALID_QCOM
  GL_TEXTURE_OUTPUT_ALPHA_ATIX
  GL_TEXTURE_OUTPUT_RGB_ATIX
  GL_TEXTURE_POINT_MODE_ATIX
  GL_TEXTURE_POINT_ONE_COORD_ATIX
  GL_TEXTURE_POINT_SPRITE_ATIX
  GL_TEXTURE_PRIORITY
  GL_TEXTURE_PRIORITY_EXT
  GL_TEXTURE_PROTECTED_EXT
  GL_TEXTURE_RANGE_LENGTH_APPLE
  GL_TEXTURE_RANGE_POINTER_APPLE
  GL_TEXTURE_RECTANGLE
  GL_TEXTURE_RECTANGLE_ARB
  GL_TEXTURE_RECTANGLE_EXT
  GL_TEXTURE_RECTANGLE_NV
  GL_TEXTURE_REDUCTION_MODE_ARB
  GL_TEXTURE_REDUCTION_MODE_EXT
  GL_TEXTURE_RED_SIZE
  GL_TEXTURE_RED_SIZE_EXT
  GL_TEXTURE_RED_TYPE
  GL_TEXTURE_RED_TYPE_ARB
  GL_TEXTURE_RENDERBUFFER_DATA_STORE_BINDING_NV
  GL_TEXTURE_RENDERBUFFER_NV
  GL_TEXTURE_RESIDENT
  GL_TEXTURE_RESIDENT_EXT
  GL_TEXTURE_SAMPLES
  GL_TEXTURE_SAMPLES_IMG
  GL_TEXTURE_SHADER_NV
  GL_TEXTURE_SHADOW
  GL_TEXTURE_SHARED_SIZE
  GL_TEXTURE_SHARED_SIZE_EXT
  GL_TEXTURE_SPARSE_ARB
  GL_TEXTURE_SPARSE_EXT
  GL_TEXTURE_SRGB_DECODE_EXT
  GL_TEXTURE_STACK_DEPTH
  GL_TEXTURE_STENCIL_SIZE
  GL_TEXTURE_STENCIL_SIZE_EXT
  GL_TEXTURE_STORAGE_HINT_APPLE
  GL_TEXTURE_STORAGE_SPARSE_BIT_AMD
  GL_TEXTURE_SWIZZLE_A
  GL_TEXTURE_SWIZZLE_A_EXT
  GL_TEXTURE_SWIZZLE_B
  GL_TEXTURE_SWIZZLE_B_EXT
  GL_TEXTURE_SWIZZLE_G
  GL_TEXTURE_SWIZZLE_G_EXT
  GL_TEXTURE_SWIZZLE_R
  GL_TEXTURE_SWIZZLE_RGBA
  GL_TEXTURE_SWIZZLE_RGBA_EXT
  GL_TEXTURE_SWIZZLE_R_EXT
  GL_TEXTURE_TARGET
  GL_TEXTURE_TARGET_QCOM
  GL_TEXTURE_TILING_EXT
  GL_TEXTURE_TYPE_QCOM
  GL_TEXTURE_UNNORMALIZED_COORDINATES_ARM
  GL_TEXTURE_UNSIGNED_REMAP_MODE_NV
  GL_TEXTURE_UPDATE_BARRIER_BIT
  GL_TEXTURE_UPDATE_BARRIER_BIT_EXT
  GL_TEXTURE_USAGE_ANGLE
  GL_TEXTURE_VIEW
  GL_TEXTURE_VIEW_MIN_LAYER
  GL_TEXTURE_VIEW_MIN_LAYER_EXT
  GL_TEXTURE_VIEW_MIN_LAYER_OES
  GL_TEXTURE_VIEW_MIN_LEVEL
  GL_TEXTURE_VIEW_MIN_LEVEL_EXT
  GL_TEXTURE_VIEW_MIN_LEVEL_OES
  GL_TEXTURE_VIEW_NUM_LAYERS
  GL_TEXTURE_VIEW_NUM_LAYERS_EXT
  GL_TEXTURE_VIEW_NUM_LAYERS_OES
  GL_TEXTURE_VIEW_NUM_LEVELS
  GL_TEXTURE_VIEW_NUM_LEVELS_EXT
  GL_TEXTURE_VIEW_NUM_LEVELS_OES
  GL_TEXTURE_WIDTH
  GL_TEXTURE_WIDTH_QCOM
  GL_TEXTURE_WRAP_R
  GL_TEXTURE_WRAP_R_EXT
  GL_TEXTURE_WRAP_R_OES
  GL_TEXTURE_WRAP_S
  GL_TEXTURE_WRAP_T
  GL_TEXTURE_Y_DEGAMMA_QCOM
  GL_TEXT_FRAGMENT_SHADER_ATI
  GL_TILING_TYPES_EXT
  GL_TIMELINE_SEMAPHORE_VALUE_NV
  GL_TIMEOUT_EXPIRED
  GL_TIMEOUT_EXPIRED_APPLE
  GL_TIMEOUT_IGNORED
  GL_TIMEOUT_IGNORED_APPLE
  GL_TIMESTAMP
  GL_TIMESTAMP_ANGLE
  GL_TIMESTAMP_EXT
  GL_TIME_ELAPSED
  GL_TIME_ELAPSED_ANGLE
  GL_TIME_ELAPSED_EXT
  GL_TOP_LEVEL_ARRAY_SIZE
  GL_TOP_LEVEL_ARRAY_STRIDE
  GL_TRACE_REGAL
  GL_TRACK_MATRIX_NV
  GL_TRACK_MATRIX_TRANSFORM_NV
  GL_TRANSFORM_BIT
  GL_TRANSFORM_FEEDBACK
  GL_TRANSFORM_FEEDBACK_ACTIVE
  GL_TRANSFORM_FEEDBACK_ATTRIBS_NV
  GL_TRANSFORM_FEEDBACK_BARRIER_BIT
  GL_TRANSFORM_FEEDBACK_BARRIER_BIT_EXT
  GL_TRANSFORM_FEEDBACK_BINDING
  GL_TRANSFORM_FEEDBACK_BINDING_NV
  GL_TRANSFORM_FEEDBACK_BUFFER
  GL_TRANSFORM_FEEDBACK_BUFFER_ACTIVE
  GL_TRANSFORM_FEEDBACK_BUFFER_ACTIVE_NV
  GL_TRANSFORM_FEEDBACK_BUFFER_BINDING
  GL_TRANSFORM_FEEDBACK_BUFFER_BINDING_EXT
  GL_TRANSFORM_FEEDBACK_BUFFER_BINDING_NV
  GL_TRANSFORM_FEEDBACK_BUFFER_EXT
  GL_TRANSFORM_FEEDBACK_BUFFER_INDEX
  GL_TRANSFORM_FEEDBACK_BUFFER_MODE
  GL_TRANSFORM_FEEDBACK_BUFFER_MODE_EXT
  GL_TRANSFORM_FEEDBACK_BUFFER_MODE_NV
  GL_TRANSFORM_FEEDBACK_BUFFER_NV
  GL_TRANSFORM_FEEDBACK_BUFFER_PAUSED
  GL_TRANSFORM_FEEDBACK_BUFFER_PAUSED_NV
  GL_TRANSFORM_FEEDBACK_BUFFER_SIZE
  GL_TRANSFORM_FEEDBACK_BUFFER_SIZE_EXT
  GL_TRANSFORM_FEEDBACK_BUFFER_SIZE_NV
  GL_TRANSFORM_FEEDBACK_BUFFER_START
  GL_TRANSFORM_FEEDBACK_BUFFER_START_EXT
  GL_TRANSFORM_FEEDBACK_BUFFER_START_NV
  GL_TRANSFORM_FEEDBACK_BUFFER_STRIDE
  GL_TRANSFORM_FEEDBACK_NV
  GL_TRANSFORM_FEEDBACK_OVERFLOW
  GL_TRANSFORM_FEEDBACK_OVERFLOW_ARB
  GL_TRANSFORM_FEEDBACK_PAUSED
  GL_TRANSFORM_FEEDBACK_PRIMITIVES_WRITTEN
  GL_TRANSFORM_FEEDBACK_PRIMITIVES_WRITTEN_EXT
  GL_TRANSFORM_FEEDBACK_PRIMITIVES_WRITTEN_NV
  GL_TRANSFORM_FEEDBACK_RECORD_NV
  GL_TRANSFORM_FEEDBACK_STREAM_OVERFLOW
  GL_TRANSFORM_FEEDBACK_STREAM_OVERFLOW_ARB
  GL_TRANSFORM_FEEDBACK_VARYING
  GL_TRANSFORM_FEEDBACK_VARYINGS
  GL_TRANSFORM_FEEDBACK_VARYINGS_EXT
  GL_TRANSFORM_FEEDBACK_VARYINGS_NV
  GL_TRANSFORM_FEEDBACK_VARYING_MAX_LENGTH
  GL_TRANSFORM_FEEDBACK_VARYING_MAX_LENGTH_EXT
  GL_TRANSFORM_HINT_APPLE
  GL_TRANSLATED_SHADER_SOURCE_LENGTH_ANGLE
  GL_TRANSLATE_2D_NV
  GL_TRANSLATE_3D_NV
  GL_TRANSLATE_X_NV
  GL_TRANSLATE_Y_NV
  GL_TRANSPOSE_AFFINE_2D_NV
  GL_TRANSPOSE_AFFINE_3D_NV
  GL_TRANSPOSE_COLOR_MATRIX
  GL_TRANSPOSE_COLOR_MATRIX_ARB
  GL_TRANSPOSE_CURRENT_MATRIX_ARB
  GL_TRANSPOSE_MODELVIEW_MATRIX
  GL_TRANSPOSE_MODELVIEW_MATRIX_ARB
  GL_TRANSPOSE_NV
  GL_TRANSPOSE_PROGRAM_MATRIX_EXT
  GL_TRANSPOSE_PROJECTION_MATRIX
  GL_TRANSPOSE_PROJECTION_MATRIX_ARB
  GL_TRANSPOSE_TEXTURE_MATRIX
  GL_TRANSPOSE_TEXTURE_MATRIX_ARB
  GL_TRIANGLES
  GL_TRIANGLES_ADJACENCY
  GL_TRIANGLES_ADJACENCY_ARB
  GL_TRIANGLES_ADJACENCY_EXT
  GL_TRIANGLES_ADJACENCY_OES
  GL_TRIANGLE_FAN
  GL_TRIANGLE_LIST_SUN
  GL_TRIANGLE_MESH_SUN
  GL_TRIANGLE_STRIP
  GL_TRIANGLE_STRIP_ADJACENCY
  GL_TRIANGLE_STRIP_ADJACENCY_ARB
  GL_TRIANGLE_STRIP_ADJACENCY_EXT
  GL_TRIANGLE_STRIP_ADJACENCY_OES
  GL_TRIANGULAR_NV
  GL_TRP_ERROR_CONTEXT_RESET_IMG
  GL_TRP_IMG
  GL_TRP_UNSUPPORTED_CONTEXT_IMG
  GL_TRUE
  GL_TYPE
  GL_UNCORRELATED_NV
  GL_UNDEFINED_APPLE
  GL_UNDEFINED_VERTEX
  GL_UNDEFINED_VERTEX_EXT
  GL_UNDEFINED_VERTEX_OES
  GL_UNIFORM
  GL_UNIFORM_ADDRESS_COMMAND_NV
  GL_UNIFORM_ARRAY_STRIDE
  GL_UNIFORM_ATOMIC_COUNTER_BUFFER_INDEX
  GL_UNIFORM_BARRIER_BIT
  GL_UNIFORM_BARRIER_BIT_EXT
  GL_UNIFORM_BLOCK
  GL_UNIFORM_BLOCK_ACTIVE_UNIFORMS
  GL_UNIFORM_BLOCK_ACTIVE_UNIFORM_INDICES
  GL_UNIFORM_BLOCK_BINDING
  GL_UNIFORM_BLOCK_DATA_SIZE
  GL_UNIFORM_BLOCK_INDEX
  GL_UNIFORM_BLOCK_NAME_LENGTH
  GL_UNIFORM_BLOCK_REFERENCED_BY_COMPUTE_SHADER
  GL_UNIFORM_BLOCK_REFERENCED_BY_FRAGMENT_SHADER
  GL_UNIFORM_BLOCK_REFERENCED_BY_GEOMETRY_SHADER
  GL_UNIFORM_BLOCK_REFERENCED_BY_MESH_SHADER_EXT
  GL_UNIFORM_BLOCK_REFERENCED_BY_MESH_SHADER_NV
  GL_UNIFORM_BLOCK_REFERENCED_BY_TASK_SHADER_EXT
  GL_UNIFORM_BLOCK_REFERENCED_BY_TASK_SHADER_NV
  GL_UNIFORM_BLOCK_REFERENCED_BY_TESS_CONTROL_SHADER
  GL_UNIFORM_BLOCK_REFERENCED_BY_TESS_EVALUATION_SHADER
  GL_UNIFORM_BLOCK_REFERENCED_BY_VERTEX_SHADER
  GL_UNIFORM_BUFFER
  GL_UNIFORM_BUFFER_ADDRESS_NV
  GL_UNIFORM_BUFFER_BINDING
  GL_UNIFORM_BUFFER_BINDING_EXT
  GL_UNIFORM_BUFFER_EXT
  GL_UNIFORM_BUFFER_LENGTH_NV
  GL_UNIFORM_BUFFER_OFFSET_ALIGNMENT
  GL_UNIFORM_BUFFER_SIZE
  GL_UNIFORM_BUFFER_START
  GL_UNIFORM_BUFFER_UNIFIED_NV
  GL_UNIFORM_IS_ROW_MAJOR
  GL_UNIFORM_MATRIX_STRIDE
  GL_UNIFORM_NAME_LENGTH
  GL_UNIFORM_OFFSET
  GL_UNIFORM_SGIX
  GL_UNIFORM_SIZE
  GL_UNIFORM_TYPE
  GL_UNKNOWN_CONTEXT_RESET
  GL_UNKNOWN_CONTEXT_RESET_ARB
  GL_UNKNOWN_CONTEXT_RESET_EXT
  GL_UNPACK_ALIGNMENT
  GL_UNPACK_CLIENT_STORAGE_APPLE
  GL_UNPACK_CMYK_HINT_EXT
  GL_UNPACK_COMPRESSED_BLOCK_DEPTH
  GL_UNPACK_COMPRESSED_BLOCK_HEIGHT
  GL_UNPACK_COMPRESSED_BLOCK_SIZE
  GL_UNPACK_COMPRESSED_BLOCK_WIDTH
  GL_UNPACK_CONSTANT_DATA_SUNX
  GL_UNPACK_IMAGE_HEIGHT
  GL_UNPACK_IMAGE_HEIGHT_EXT
  GL_UNPACK_IMAGE_HEIGHT_NV
  GL_UNPACK_LSB_FIRST
  GL_UNPACK_RESAMPLE_OML
  GL_UNPACK_RESAMPLE_SGIX
  GL_UNPACK_ROW_BYTES_APPLE
  GL_UNPACK_ROW_LENGTH
  GL_UNPACK_ROW_LENGTH_EXT
  GL_UNPACK_SKIP_IMAGES
  GL_UNPACK_SKIP_IMAGES_EXT
  GL_UNPACK_SKIP_IMAGES_NV
  GL_UNPACK_SKIP_PIXELS
  GL_UNPACK_SKIP_PIXELS_EXT
  GL_UNPACK_SKIP_ROWS
  GL_UNPACK_SKIP_ROWS_EXT
  GL_UNPACK_SUBSAMPLE_RATE_SGIX
  GL_UNPACK_SWAP_BYTES
  GL_UNSIGNALED
  GL_UNSIGNALED_APPLE
  GL_UNSIGNED_BYTE
  GL_UNSIGNED_BYTE_2_3_3_REV
  GL_UNSIGNED_BYTE_3_3_2
  GL_UNSIGNED_BYTE_3_3_2_EXT
  GL_UNSIGNED_IDENTITY_NV
  GL_UNSIGNED_INT
  GL_UNSIGNED_INT16_NV
  GL_UNSIGNED_INT16_VEC2_NV
  GL_UNSIGNED_INT16_VEC3_NV
  GL_UNSIGNED_INT16_VEC4_NV
  GL_UNSIGNED_INT64_AMD
  GL_UNSIGNED_INT64_ARB
  GL_UNSIGNED_INT64_NV
  GL_UNSIGNED_INT64_VEC2_ARB
  GL_UNSIGNED_INT64_VEC2_NV
  GL_UNSIGNED_INT64_VEC3_ARB
  GL_UNSIGNED_INT64_VEC3_NV
  GL_UNSIGNED_INT64_VEC4_ARB
  GL_UNSIGNED_INT64_VEC4_NV
  GL_UNSIGNED_INT8_NV
  GL_UNSIGNED_INT8_VEC2_NV
  GL_UNSIGNED_INT8_VEC3_NV
  GL_UNSIGNED_INT8_VEC4_NV
  GL_UNSIGNED_INT_10F_11F_11F_REV
  GL_UNSIGNED_INT_10F_11F_11F_REV_APPLE
  GL_UNSIGNED_INT_10F_11F_11F_REV_EXT
  GL_UNSIGNED_INT_10F_11F_11F_REV_NV
  GL_UNSIGNED_INT_10_10_10_2
  GL_UNSIGNED_INT_10_10_10_2_EXT
  GL_UNSIGNED_INT_10_10_10_2_OES
  GL_UNSIGNED_INT_24_8
  GL_UNSIGNED_INT_24_8_EXT
  GL_UNSIGNED_INT_24_8_NV
  GL_UNSIGNED_INT_24_8_OES
  GL_UNSIGNED_INT_2_10_10_10_REV
  GL_UNSIGNED_INT_2_10_10_10_REV_EXT
  GL_UNSIGNED_INT_5_9_9_9_REV
  GL_UNSIGNED_INT_5_9_9_9_REV_APPLE
  GL_UNSIGNED_INT_5_9_9_9_REV_EXT
  GL_UNSIGNED_INT_8_8_8_8
  GL_UNSIGNED_INT_8_8_8_8_EXT
  GL_UNSIGNED_INT_8_8_8_8_REV
  GL_UNSIGNED_INT_8_8_S8_S8_REV_NV
  GL_UNSIGNED_INT_ATOMIC_COUNTER
  GL_UNSIGNED_INT_IMAGE_1D
  GL_UNSIGNED_INT_IMAGE_1D_ARRAY
  GL_UNSIGNED_INT_IMAGE_1D_ARRAY_EXT
  GL_UNSIGNED_INT_IMAGE_1D_EXT
  GL_UNSIGNED_INT_IMAGE_2D
  GL_UNSIGNED_INT_IMAGE_2D_ARRAY
  GL_UNSIGNED_INT_IMAGE_2D_ARRAY_EXT
  GL_UNSIGNED_INT_IMAGE_2D_EXT
  GL_UNSIGNED_INT_IMAGE_2D_MULTISAMPLE
  GL_UNSIGNED_INT_IMAGE_2D_MULTISAMPLE_ARRAY
  GL_UNSIGNED_INT_IMAGE_2D_MULTISAMPLE_ARRAY_EXT
  GL_UNSIGNED_INT_IMAGE_2D_MULTISAMPLE_EXT
  GL_UNSIGNED_INT_IMAGE_2D_RECT
  GL_UNSIGNED_INT_IMAGE_2D_RECT_EXT
  GL_UNSIGNED_INT_IMAGE_3D
  GL_UNSIGNED_INT_IMAGE_3D_EXT
  GL_UNSIGNED_INT_IMAGE_BUFFER
  GL_UNSIGNED_INT_IMAGE_BUFFER_EXT
  GL_UNSIGNED_INT_IMAGE_BUFFER_OES
  GL_UNSIGNED_INT_IMAGE_CUBE
  GL_UNSIGNED_INT_IMAGE_CUBE_EXT
  GL_UNSIGNED_INT_IMAGE_CUBE_MAP_ARRAY
  GL_UNSIGNED_INT_IMAGE_CUBE_MAP_ARRAY_EXT
  GL_UNSIGNED_INT_IMAGE_CUBE_MAP_ARRAY_OES
  GL_UNSIGNED_INT_S8_S8_8_8_NV
  GL_UNSIGNED_INT_SAMPLER_1D
  GL_UNSIGNED_INT_SAMPLER_1D_ARRAY
  GL_UNSIGNED_INT_SAMPLER_1D_ARRAY_EXT
  GL_UNSIGNED_INT_SAMPLER_1D_EXT
  GL_UNSIGNED_INT_SAMPLER_2D
  GL_UNSIGNED_INT_SAMPLER_2D_ARRAY
  GL_UNSIGNED_INT_SAMPLER_2D_ARRAY_EXT
  GL_UNSIGNED_INT_SAMPLER_2D_EXT
  GL_UNSIGNED_INT_SAMPLER_2D_MULTISAMPLE
  GL_UNSIGNED_INT_SAMPLER_2D_MULTISAMPLE_ARRAY
  GL_UNSIGNED_INT_SAMPLER_2D_MULTISAMPLE_ARRAY_OES
  GL_UNSIGNED_INT_SAMPLER_2D_RECT
  GL_UNSIGNED_INT_SAMPLER_2D_RECT_EXT
  GL_UNSIGNED_INT_SAMPLER_3D
  GL_UNSIGNED_INT_SAMPLER_3D_EXT
  GL_UNSIGNED_INT_SAMPLER_BUFFER
  GL_UNSIGNED_INT_SAMPLER_BUFFER_AMD
  GL_UNSIGNED_INT_SAMPLER_BUFFER_EXT
  GL_UNSIGNED_INT_SAMPLER_BUFFER_OES
  GL_UNSIGNED_INT_SAMPLER_CUBE
  GL_UNSIGNED_INT_SAMPLER_CUBE_EXT
  GL_UNSIGNED_INT_SAMPLER_CUBE_MAP_ARRAY
  GL_UNSIGNED_INT_SAMPLER_CUBE_MAP_ARRAY_ARB
  GL_UNSIGNED_INT_SAMPLER_CUBE_MAP_ARRAY_EXT
  GL_UNSIGNED_INT_SAMPLER_CUBE_MAP_ARRAY_OES
  GL_UNSIGNED_INT_SAMPLER_RENDERBUFFER_NV
  GL_UNSIGNED_INT_VEC2
  GL_UNSIGNED_INT_VEC2_EXT
  GL_UNSIGNED_INT_VEC3
  GL_UNSIGNED_INT_VEC3_EXT
  GL_UNSIGNED_INT_VEC4
  GL_UNSIGNED_INT_VEC4_EXT
  GL_UNSIGNED_INVERT_NV
  GL_UNSIGNED_NORMALIZED
  GL_UNSIGNED_NORMALIZED_ARB
  GL_UNSIGNED_NORMALIZED_EXT
  GL_UNSIGNED_SHORT
  GL_UNSIGNED_SHORT_1_5_5_5_REV
  GL_UNSIGNED_SHORT_1_5_5_5_REV_EXT
  GL_UNSIGNED_SHORT_4_4_4_4
  GL_UNSIGNED_SHORT_4_4_4_4_EXT
  GL_UNSIGNED_SHORT_4_4_4_4_REV
  GL_UNSIGNED_SHORT_4_4_4_4_REV_EXT
  GL_UNSIGNED_SHORT_4_4_4_4_REV_IMG
  GL_UNSIGNED_SHORT_5_5_5_1
  GL_UNSIGNED_SHORT_5_5_5_1_EXT
  GL_UNSIGNED_SHORT_5_6_5
  GL_UNSIGNED_SHORT_5_6_5_REV
  GL_UNSIGNED_SHORT_8_8_APPLE
  GL_UNSIGNED_SHORT_8_8_MESA
  GL_UNSIGNED_SHORT_8_8_REV_APPLE
  GL_UNSIGNED_SHORT_8_8_REV_MESA
  GL_UPLOAD_GPU_MASK_NVX
  GL_UPPER_LEFT
  GL_UPPER_LEFT_EXT
  GL_USE_MISSING_GLYPH_NV
  GL_UTF16_NV
  GL_UTF8_NV
  GL_UUID_SIZE_EXT
  GL_V2F
  GL_V3F
  GL_VALIDATE_STATUS
  GL_VARIABLE_A_NV
  GL_VARIABLE_B_NV
  GL_VARIABLE_C_NV
  GL_VARIABLE_D_NV
  GL_VARIABLE_E_NV
  GL_VARIABLE_F_NV
  GL_VARIABLE_G_NV
  GL_VARIANT_ARRAY_EXT
  GL_VARIANT_ARRAY_POINTER_EXT
  GL_VARIANT_ARRAY_STRIDE_EXT
  GL_VARIANT_ARRAY_TYPE_EXT
  GL_VARIANT_DATATYPE_EXT
  GL_VARIANT_EXT
  GL_VARIANT_VALUE_EXT
  GL_VBO_FREE_MEMORY_ATI
  GL_VECTOR_EXT
  GL_VENDOR
  GL_VERSION
  GL_VERTEX23_BIT_PGI
  GL_VERTEX4_BIT_PGI
  GL_VERTEX_ARRAY
  GL_VERTEX_ARRAY_ADDRESS_NV
  GL_VERTEX_ARRAY_BINDING
  GL_VERTEX_ARRAY_BINDING_APPLE
  GL_VERTEX_ARRAY_BINDING_OES
  GL_VERTEX_ARRAY_BUFFER_BINDING
  GL_VERTEX_ARRAY_BUFFER_BINDING_ARB
  GL_VERTEX_ARRAY_COUNT_EXT
  GL_VERTEX_ARRAY_EXT
  GL_VERTEX_ARRAY_LENGTH_NV
  GL_VERTEX_ARRAY_LIST_IBM
  GL_VERTEX_ARRAY_LIST_STRIDE_IBM
  GL_VERTEX_ARRAY_OBJECT_AMD
  GL_VERTEX_ARRAY_OBJECT_EXT
  GL_VERTEX_ARRAY_PARALLEL_POINTERS_INTEL
  GL_VERTEX_ARRAY_POINTER
  GL_VERTEX_ARRAY_POINTER_EXT
  GL_VERTEX_ARRAY_RANGE_APPLE
  GL_VERTEX_ARRAY_RANGE_LENGTH_APPLE
  GL_VERTEX_ARRAY_RANGE_LENGTH_NV
  GL_VERTEX_ARRAY_RANGE_NV
  GL_VERTEX_ARRAY_RANGE_POINTER_APPLE
  GL_VERTEX_ARRAY_RANGE_POINTER_NV
  GL_VERTEX_ARRAY_RANGE_VALID_NV
  GL_VERTEX_ARRAY_RANGE_WITHOUT_FLUSH_NV
  GL_VERTEX_ARRAY_SIZE
  GL_VERTEX_ARRAY_SIZE_EXT
  GL_VERTEX_ARRAY_STORAGE_HINT_APPLE
  GL_VERTEX_ARRAY_STRIDE
  GL_VERTEX_ARRAY_STRIDE_EXT
  GL_VERTEX_ARRAY_TYPE
  GL_VERTEX_ARRAY_TYPE_EXT
  GL_VERTEX_ATTRIB_ARRAY0_NV
  GL_VERTEX_ATTRIB_ARRAY10_NV
  GL_VERTEX_ATTRIB_ARRAY11_NV
  GL_VERTEX_ATTRIB_ARRAY12_NV
  GL_VERTEX_ATTRIB_ARRAY13_NV
  GL_VERTEX_ATTRIB_ARRAY14_NV
  GL_VERTEX_ATTRIB_ARRAY15_NV
  GL_VERTEX_ATTRIB_ARRAY1_NV
  GL_VERTEX_ATTRIB_ARRAY2_NV
  GL_VERTEX_ATTRIB_ARRAY3_NV
  GL_VERTEX_ATTRIB_ARRAY4_NV
  GL_VERTEX_ATTRIB_ARRAY5_NV
  GL_VERTEX_ATTRIB_ARRAY6_NV
  GL_VERTEX_ATTRIB_ARRAY7_NV
  GL_VERTEX_ATTRIB_ARRAY8_NV
  GL_VERTEX_ATTRIB_ARRAY9_NV
  GL_VERTEX_ATTRIB_ARRAY_ADDRESS_NV
  GL_VERTEX_ATTRIB_ARRAY_BARRIER_BIT
  GL_VERTEX_ATTRIB_ARRAY_BARRIER_BIT_EXT
  GL_VERTEX_ATTRIB_ARRAY_BUFFER_BINDING
  GL_VERTEX_ATTRIB_ARRAY_BUFFER_BINDING_ARB
  GL_VERTEX_ATTRIB_ARRAY_DIVISOR
  GL_VERTEX_ATTRIB_ARRAY_DIVISOR_ANGLE
  GL_VERTEX_ATTRIB_ARRAY_DIVISOR_ARB
  GL_VERTEX_ATTRIB_ARRAY_DIVISOR_EXT
  GL_VERTEX_ATTRIB_ARRAY_DIVISOR_NV
  GL_VERTEX_ATTRIB_ARRAY_ENABLED
  GL_VERTEX_ATTRIB_ARRAY_ENABLED_ARB
  GL_VERTEX_ATTRIB_ARRAY_INTEGER
  GL_VERTEX_ATTRIB_ARRAY_INTEGER_EXT
  GL_VERTEX_ATTRIB_ARRAY_INTEGER_NV
  GL_VERTEX_ATTRIB_ARRAY_LENGTH_NV
  GL_VERTEX_ATTRIB_ARRAY_LONG
  GL_VERTEX_ATTRIB_ARRAY_NORMALIZED
  GL_VERTEX_ATTRIB_ARRAY_NORMALIZED_ARB
  GL_VERTEX_ATTRIB_ARRAY_POINTER
  GL_VERTEX_ATTRIB_ARRAY_POINTER_ARB
  GL_VERTEX_ATTRIB_ARRAY_SIZE
  GL_VERTEX_ATTRIB_ARRAY_SIZE_ARB
  GL_VERTEX_ATTRIB_ARRAY_STRIDE
  GL_VERTEX_ATTRIB_ARRAY_STRIDE_ARB
  GL_VERTEX_ATTRIB_ARRAY_TYPE
  GL_VERTEX_ATTRIB_ARRAY_TYPE_ARB
  GL_VERTEX_ATTRIB_ARRAY_UNIFIED_NV
  GL_VERTEX_ATTRIB_BINDING
  GL_VERTEX_ATTRIB_MAP1_APPLE
  GL_VERTEX_ATTRIB_MAP1_COEFF_APPLE
  GL_VERTEX_ATTRIB_MAP1_DOMAIN_APPLE
  GL_VERTEX_ATTRIB_MAP1_ORDER_APPLE
  GL_VERTEX_ATTRIB_MAP1_SIZE_APPLE
  GL_VERTEX_ATTRIB_MAP2_APPLE
  GL_VERTEX_ATTRIB_MAP2_COEFF_APPLE
  GL_VERTEX_ATTRIB_MAP2_DOMAIN_APPLE
  GL_VERTEX_ATTRIB_MAP2_ORDER_APPLE
  GL_VERTEX_ATTRIB_MAP2_SIZE_APPLE
  GL_VERTEX_ATTRIB_RELATIVE_OFFSET
  GL_VERTEX_BINDING_BUFFER
  GL_VERTEX_BINDING_DIVISOR
  GL_VERTEX_BINDING_OFFSET
  GL_VERTEX_BINDING_STRIDE
  GL_VERTEX_BLEND_ARB
  GL_VERTEX_CONSISTENT_HINT_PGI
  GL_VERTEX_DATA_HINT_PGI
  GL_VERTEX_ELEMENT_SWIZZLE_AMD
  GL_VERTEX_ID_NV
  GL_VERTEX_ID_SWIZZLE_AMD
  GL_VERTEX_PRECLIP_HINT_SGIX
  GL_VERTEX_PRECLIP_SGIX
  GL_VERTEX_PROGRAM_ARB
  GL_VERTEX_PROGRAM_BINDING_NV
  GL_VERTEX_PROGRAM_NV
  GL_VERTEX_PROGRAM_PARAMETER_BUFFER_NV
  GL_VERTEX_PROGRAM_POINT_SIZE
  GL_VERTEX_PROGRAM_POINT_SIZE_ARB
  GL_VERTEX_PROGRAM_POINT_SIZE_NV
  GL_VERTEX_PROGRAM_TWO_SIDE
  GL_VERTEX_PROGRAM_TWO_SIDE_ARB
  GL_VERTEX_PROGRAM_TWO_SIDE_NV
  GL_VERTEX_SHADER
  GL_VERTEX_SHADER_ARB
  GL_VERTEX_SHADER_BINDING_EXT
  GL_VERTEX_SHADER_BIT
  GL_VERTEX_SHADER_EXT
  GL_VERTEX_SHADER_INSTRUCTIONS_EXT
  GL_VERTEX_SHADER_INVARIANTS_EXT
  GL_VERTEX_SHADER_INVOCATIONS
  GL_VERTEX_SHADER_INVOCATIONS_ARB
  GL_VERTEX_SHADER_LOCALS_EXT
  GL_VERTEX_SHADER_LOCAL_CONSTANTS_EXT
  GL_VERTEX_SHADER_OPTIMIZED_EXT
  GL_VERTEX_SHADER_VARIANTS_EXT
  GL_VERTEX_SOURCE_ATI
  GL_VERTEX_STATE_PROGRAM_NV
  GL_VERTEX_STREAM0_ATI
  GL_VERTEX_STREAM1_ATI
  GL_VERTEX_STREAM2_ATI
  GL_VERTEX_STREAM3_ATI
  GL_VERTEX_STREAM4_ATI
  GL_VERTEX_STREAM5_ATI
  GL_VERTEX_STREAM6_ATI
  GL_VERTEX_STREAM7_ATI
  GL_VERTEX_SUBROUTINE
  GL_VERTEX_SUBROUTINE_UNIFORM
  GL_VERTEX_TEXTURE
  GL_VERTEX_WEIGHTING_EXT
  GL_VERTEX_WEIGHT_ARRAY_EXT
  GL_VERTEX_WEIGHT_ARRAY_POINTER_EXT
  GL_VERTEX_WEIGHT_ARRAY_SIZE_EXT
  GL_VERTEX_WEIGHT_ARRAY_STRIDE_EXT
  GL_VERTEX_WEIGHT_ARRAY_TYPE_EXT
  GL_VERTICAL_LINE_TO_NV
  GL_VERTICES_SUBMITTED
  GL_VERTICES_SUBMITTED_ARB
  GL_VIBRANCE_BIAS_NV
  GL_VIBRANCE_SCALE_NV
  GL_VIDEO_BUFFER_BINDING_NV
  GL_VIDEO_BUFFER_INTERNAL_FORMAT_NV
  GL_VIDEO_BUFFER_NV
  GL_VIDEO_BUFFER_PITCH_NV
  GL_VIDEO_CAPTURE_FIELD_LOWER_HEIGHT_NV
  GL_VIDEO_CAPTURE_FIELD_UPPER_HEIGHT_NV
  GL_VIDEO_CAPTURE_FRAME_HEIGHT_NV
  GL_VIDEO_CAPTURE_FRAME_WIDTH_NV
  GL_VIDEO_CAPTURE_SURFACE_ORIGIN_NV
  GL_VIDEO_CAPTURE_TO_422_SUPPORTED_NV
  GL_VIDEO_COLOR_CONVERSION_MATRIX_NV
  GL_VIDEO_COLOR_CONVERSION_MAX_NV
  GL_VIDEO_COLOR_CONVERSION_MIN_NV
  GL_VIDEO_COLOR_CONVERSION_OFFSET_NV
  GL_VIEWPORT
  GL_VIEWPORT_BIT
  GL_VIEWPORT_BOUNDS_RANGE
  GL_VIEWPORT_BOUNDS_RANGE_NV
  GL_VIEWPORT_COMMAND_NV
  GL_VIEWPORT_INDEX_PROVOKING_VERTEX
  GL_VIEWPORT_INDEX_PROVOKING_VERTEX_NV
  GL_VIEWPORT_POSITION_W_SCALE_NV
  GL_VIEWPORT_POSITION_W_SCALE_X_COEFF_NV
  GL_VIEWPORT_POSITION_W_SCALE_Y_COEFF_NV
  GL_VIEWPORT_SUBPIXEL_BITS
  GL_VIEWPORT_SUBPIXEL_BITS_NV
  GL_VIEWPORT_SWIZZLE_NEGATIVE_W_NV
  GL_VIEWPORT_SWIZZLE_NEGATIVE_X_NV
  GL_VIEWPORT_SWIZZLE_NEGATIVE_Y_NV
  GL_VIEWPORT_SWIZZLE_NEGATIVE_Z_NV
  GL_VIEWPORT_SWIZZLE_POSITIVE_W_NV
  GL_VIEWPORT_SWIZZLE_POSITIVE_X_NV
  GL_VIEWPORT_SWIZZLE_POSITIVE_Y_NV
  GL_VIEWPORT_SWIZZLE_POSITIVE_Z_NV
  GL_VIEWPORT_SWIZZLE_W_NV
  GL_VIEWPORT_SWIZZLE_X_NV
  GL_VIEWPORT_SWIZZLE_Y_NV
  GL_VIEWPORT_SWIZZLE_Z_NV
  GL_VIEW_CLASS_128_BITS
  GL_VIEW_CLASS_16_BITS
  GL_VIEW_CLASS_24_BITS
  GL_VIEW_CLASS_32_BITS
  GL_VIEW_CLASS_48_BITS
  GL_VIEW_CLASS_64_BITS
  GL_VIEW_CLASS_8_BITS
  GL_VIEW_CLASS_96_BITS
  GL_VIEW_CLASS_BPTC_FLOAT
  GL_VIEW_CLASS_BPTC_UNORM
  GL_VIEW_CLASS_RGTC1_RED
  GL_VIEW_CLASS_RGTC2_RG
  GL_VIEW_CLASS_S3TC_DXT1_RGB
  GL_VIEW_CLASS_S3TC_DXT1_RGBA
  GL_VIEW_CLASS_S3TC_DXT3_RGBA
  GL_VIEW_CLASS_S3TC_DXT5_RGBA
  GL_VIEW_COMPATIBILITY_CLASS
  GL_VIRTUAL_PAGE_SIZE_INDEX_ARB
  GL_VIRTUAL_PAGE_SIZE_INDEX_EXT
  GL_VIRTUAL_PAGE_SIZE_X_AMD
  GL_VIRTUAL_PAGE_SIZE_X_ARB
  GL_VIRTUAL_PAGE_SIZE_X_EXT
  GL_VIRTUAL_PAGE_SIZE_Y_AMD
  GL_VIRTUAL_PAGE_SIZE_Y_ARB
  GL_VIRTUAL_PAGE_SIZE_Y_EXT
  GL_VIRTUAL_PAGE_SIZE_Z_AMD
  GL_VIRTUAL_PAGE_SIZE_Z_ARB
  GL_VIRTUAL_PAGE_SIZE_Z_EXT
  GL_VIVIDLIGHT_NV
  GL_VOLATILE_APPLE
  GL_WAIT_FAILED
  GL_WAIT_FAILED_APPLE
  GL_WARPS_PER_SM_NV
  GL_WARP_SIZE_NV
  GL_WEIGHTED_AVERAGE_ARB
  GL_WEIGHTED_AVERAGE_EXT
  GL_WEIGHT_ARRAY_ARB
  GL_WEIGHT_ARRAY_BUFFER_BINDING
  GL_WEIGHT_ARRAY_BUFFER_BINDING_ARB
  GL_WEIGHT_ARRAY_BUFFER_BINDING_OES
  GL_WEIGHT_ARRAY_OES
  GL_WEIGHT_ARRAY_POINTER_ARB
  GL_WEIGHT_ARRAY_POINTER_OES
  GL_WEIGHT_ARRAY_SIZE_ARB
  GL_WEIGHT_ARRAY_SIZE_OES
  GL_WEIGHT_ARRAY_STRIDE_ARB
  GL_WEIGHT_ARRAY_STRIDE_OES
  GL_WEIGHT_ARRAY_TYPE_ARB
  GL_WEIGHT_ARRAY_TYPE_OES
  GL_WEIGHT_SUM_UNITY_ARB
  GL_WIDE_LINE_HINT_PGI
  GL_WINDOW_RECTANGLE_EXT
  GL_WINDOW_RECTANGLE_MODE_EXT
  GL_WRAP_BORDER
  GL_WRAP_BORDER_SUN
  GL_WRITEONLY_RENDERING_QCOM
  GL_WRITE_DISCARD_NV
  GL_WRITE_ONLY
  GL_WRITE_ONLY_ARB
  GL_WRITE_ONLY_OES
  GL_WRITE_PIXEL_DATA_RANGE_LENGTH_NV
  GL_WRITE_PIXEL_DATA_RANGE_NV
  GL_WRITE_PIXEL_DATA_RANGE_POINTER_NV
  GL_W_EXT
  GL_XOR
  GL_XOR_NV
  GL_X_EXT
  GL_YCBAYCR8A_4224_NV
  GL_YCBCR_422_APPLE
  GL_YCBCR_MESA
  GL_YCBYCR8_422_NV
  GL_YCRCBA_SGIX
  GL_YCRCB_SGIX
  GL_Y_EXT
  GL_Z400_BINARY_AMD
  GL_Z4Y12Z4CB12Z4A12Z4Y12Z4CR12Z4A12_4224_NV
  GL_Z4Y12Z4CB12Z4CR12_444_NV
  GL_Z4Y12Z4CB12Z4Y12Z4CR12_422_NV
  GL_Z6Y10Z6CB10Z6A10Z6Y10Z6CR10Z6A10_4224_NV
  GL_Z6Y10Z6CB10Z6Y10Z6CR10_422_NV
  GL_ZERO
  GL_ZERO_EXT
  GL_ZERO_TO_ONE
  GL_ZERO_TO_ONE_EXT
  GL_ZOOM_X
  GL_ZOOM_Y
  GL_Z_EXT
);

# END code generated by utils/generate-registry.pl
# OGLM INSERT SEPARATOR

our @glew_functions = qw(
  glewCreateContext
  glewGetErrorString
  glewIsSupported
  glewInit
  done_glewInit
  glewDestroyContext
);
our @glp_functions = qw(
  glpSetAutoCheckErrors
  glpCheckErrors
  glpErrorString
);

our %EXPORT_TAGS = (
    %EXPORT_TAGS_GL,
    glewfunctions => \@glew_functions,
    glpfunctions => \@glp_functions,
    glcompat => \@gl_functionscompat,
    glfunctions => [ @gl_functionscompat, @gl_functionsrest ],
    glconstants => \@gl_constants,
    all => [
        @gl_functionscompat,
        @gl_functionsrest,
        @glew_functions,
        @glp_functions,
        @gl_constants,
    ]
);

our @EXPORT_OK = ( @{ $EXPORT_TAGS{'all'} } );

require XSLoader;
XSLoader::load( __PACKAGE__, $XS_VERSION );

sub Inline {
  require OpenGL::Modern::Install::Files;
  goto &OpenGL::Modern::Install::Files::Inline;
}

1;
